# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ClusterPolicyArgs', 'ClusterPolicy']

@pulumi.input_type
class ClusterPolicyArgs:
    def __init__(__self__, *,
                 cluster_arn: pulumi.Input[str],
                 policy: pulumi.Input[str]):
        """
        The set of arguments for constructing a ClusterPolicy resource.
        :param pulumi.Input[str] cluster_arn: The Amazon Resource Name (ARN) that uniquely identifies the cluster.
        :param pulumi.Input[str] policy: Resource policy for cluster.
        """
        pulumi.set(__self__, "cluster_arn", cluster_arn)
        pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter(name="clusterArn")
    def cluster_arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) that uniquely identifies the cluster.
        """
        return pulumi.get(self, "cluster_arn")

    @cluster_arn.setter
    def cluster_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_arn", value)

    @property
    @pulumi.getter
    def policy(self) -> pulumi.Input[str]:
        """
        Resource policy for cluster.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy", value)


@pulumi.input_type
class _ClusterPolicyState:
    def __init__(__self__, *,
                 cluster_arn: Optional[pulumi.Input[str]] = None,
                 current_version: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ClusterPolicy resources.
        :param pulumi.Input[str] cluster_arn: The Amazon Resource Name (ARN) that uniquely identifies the cluster.
        :param pulumi.Input[str] policy: Resource policy for cluster.
        """
        if cluster_arn is not None:
            pulumi.set(__self__, "cluster_arn", cluster_arn)
        if current_version is not None:
            pulumi.set(__self__, "current_version", current_version)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter(name="clusterArn")
    def cluster_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) that uniquely identifies the cluster.
        """
        return pulumi.get(self, "cluster_arn")

    @cluster_arn.setter
    def cluster_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_arn", value)

    @property
    @pulumi.getter(name="currentVersion")
    def current_version(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "current_version")

    @current_version.setter
    def current_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "current_version", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[str]]:
        """
        Resource policy for cluster.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy", value)


class ClusterPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_arn: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Managed Streaming for Kafka Cluster Policy.

        ## Example Usage

        ### Basic Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        current_get_partition = aws.get_partition()
        example = aws.msk.ClusterPolicy("example",
            cluster_arn=example_aws_msk_cluster["arn"],
            policy=json.dumps({
                "version": "2012-10-17",
                "statement": [{
                    "sid": "ExampleMskClusterPolicy",
                    "effect": "Allow",
                    "principal": {
                        "AWS": f"arn:{current_get_partition.partition}:iam::{current.account_id}:root",
                    },
                    "action": [
                        "kafka:Describe*",
                        "kafka:Get*",
                        "kafka:CreateVpcConnection",
                        "kafka:GetBootstrapBrokers",
                    ],
                    "resource": example_aws_msk_cluster["arn"],
                }],
            }))
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Managed Streaming for Kafka Cluster Policy using the `cluster_arn`. For example:

        ```sh
        $ pulumi import aws:msk/clusterPolicy:ClusterPolicy example arn:aws:kafka:us-west-2:123456789012:cluster/example/279c0212-d057-4dba-9aa9-1c4e5a25bfc7-3
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_arn: The Amazon Resource Name (ARN) that uniquely identifies the cluster.
        :param pulumi.Input[str] policy: Resource policy for cluster.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Managed Streaming for Kafka Cluster Policy.

        ## Example Usage

        ### Basic Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        current_get_partition = aws.get_partition()
        example = aws.msk.ClusterPolicy("example",
            cluster_arn=example_aws_msk_cluster["arn"],
            policy=json.dumps({
                "version": "2012-10-17",
                "statement": [{
                    "sid": "ExampleMskClusterPolicy",
                    "effect": "Allow",
                    "principal": {
                        "AWS": f"arn:{current_get_partition.partition}:iam::{current.account_id}:root",
                    },
                    "action": [
                        "kafka:Describe*",
                        "kafka:Get*",
                        "kafka:CreateVpcConnection",
                        "kafka:GetBootstrapBrokers",
                    ],
                    "resource": example_aws_msk_cluster["arn"],
                }],
            }))
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Managed Streaming for Kafka Cluster Policy using the `cluster_arn`. For example:

        ```sh
        $ pulumi import aws:msk/clusterPolicy:ClusterPolicy example arn:aws:kafka:us-west-2:123456789012:cluster/example/279c0212-d057-4dba-9aa9-1c4e5a25bfc7-3
        ```

        :param str resource_name: The name of the resource.
        :param ClusterPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_arn: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterPolicyArgs.__new__(ClusterPolicyArgs)

            if cluster_arn is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_arn'")
            __props__.__dict__["cluster_arn"] = cluster_arn
            if policy is None and not opts.urn:
                raise TypeError("Missing required property 'policy'")
            __props__.__dict__["policy"] = policy
            __props__.__dict__["current_version"] = None
        super(ClusterPolicy, __self__).__init__(
            'aws:msk/clusterPolicy:ClusterPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_arn: Optional[pulumi.Input[str]] = None,
            current_version: Optional[pulumi.Input[str]] = None,
            policy: Optional[pulumi.Input[str]] = None) -> 'ClusterPolicy':
        """
        Get an existing ClusterPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_arn: The Amazon Resource Name (ARN) that uniquely identifies the cluster.
        :param pulumi.Input[str] policy: Resource policy for cluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterPolicyState.__new__(_ClusterPolicyState)

        __props__.__dict__["cluster_arn"] = cluster_arn
        __props__.__dict__["current_version"] = current_version
        __props__.__dict__["policy"] = policy
        return ClusterPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clusterArn")
    def cluster_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) that uniquely identifies the cluster.
        """
        return pulumi.get(self, "cluster_arn")

    @property
    @pulumi.getter(name="currentVersion")
    def current_version(self) -> pulumi.Output[str]:
        return pulumi.get(self, "current_version")

    @property
    @pulumi.getter
    def policy(self) -> pulumi.Output[str]:
        """
        Resource policy for cluster.
        """
        return pulumi.get(self, "policy")

