# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'PipelineBufferOptionsArgs',
    'PipelineEncryptionAtRestOptionsArgs',
    'PipelineLogPublishingOptionsArgs',
    'PipelineLogPublishingOptionsCloudwatchLogDestinationArgs',
    'PipelineTimeoutsArgs',
    'PipelineVpcOptionsArgs',
]

@pulumi.input_type
class PipelineBufferOptionsArgs:
    def __init__(__self__, *,
                 persistent_buffer_enabled: pulumi.Input[bool]):
        """
        :param pulumi.Input[bool] persistent_buffer_enabled: Whether persistent buffering should be enabled.
        """
        pulumi.set(__self__, "persistent_buffer_enabled", persistent_buffer_enabled)

    @property
    @pulumi.getter(name="persistentBufferEnabled")
    def persistent_buffer_enabled(self) -> pulumi.Input[bool]:
        """
        Whether persistent buffering should be enabled.
        """
        return pulumi.get(self, "persistent_buffer_enabled")

    @persistent_buffer_enabled.setter
    def persistent_buffer_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "persistent_buffer_enabled", value)


@pulumi.input_type
class PipelineEncryptionAtRestOptionsArgs:
    def __init__(__self__, *,
                 kms_key_arn: pulumi.Input[str]):
        """
        :param pulumi.Input[str] kms_key_arn: The ARN of the KMS key used to encrypt data-at-rest in OpenSearch Ingestion. By default, data is encrypted using an AWS owned key.
        """
        pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the KMS key used to encrypt data-at-rest in OpenSearch Ingestion. By default, data is encrypted using an AWS owned key.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "kms_key_arn", value)


@pulumi.input_type
class PipelineLogPublishingOptionsArgs:
    def __init__(__self__, *,
                 cloudwatch_log_destination: Optional[pulumi.Input['PipelineLogPublishingOptionsCloudwatchLogDestinationArgs']] = None,
                 is_logging_enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input['PipelineLogPublishingOptionsCloudwatchLogDestinationArgs'] cloudwatch_log_destination: The destination for OpenSearch Ingestion logs sent to Amazon CloudWatch Logs. This parameter is required if IsLoggingEnabled is set to true. See `cloudwatch_log_destination` below.
        :param pulumi.Input[bool] is_logging_enabled: Whether logs should be published.
        """
        if cloudwatch_log_destination is not None:
            pulumi.set(__self__, "cloudwatch_log_destination", cloudwatch_log_destination)
        if is_logging_enabled is not None:
            pulumi.set(__self__, "is_logging_enabled", is_logging_enabled)

    @property
    @pulumi.getter(name="cloudwatchLogDestination")
    def cloudwatch_log_destination(self) -> Optional[pulumi.Input['PipelineLogPublishingOptionsCloudwatchLogDestinationArgs']]:
        """
        The destination for OpenSearch Ingestion logs sent to Amazon CloudWatch Logs. This parameter is required if IsLoggingEnabled is set to true. See `cloudwatch_log_destination` below.
        """
        return pulumi.get(self, "cloudwatch_log_destination")

    @cloudwatch_log_destination.setter
    def cloudwatch_log_destination(self, value: Optional[pulumi.Input['PipelineLogPublishingOptionsCloudwatchLogDestinationArgs']]):
        pulumi.set(self, "cloudwatch_log_destination", value)

    @property
    @pulumi.getter(name="isLoggingEnabled")
    def is_logging_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether logs should be published.
        """
        return pulumi.get(self, "is_logging_enabled")

    @is_logging_enabled.setter
    def is_logging_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_logging_enabled", value)


@pulumi.input_type
class PipelineLogPublishingOptionsCloudwatchLogDestinationArgs:
    def __init__(__self__, *,
                 log_group: pulumi.Input[str]):
        """
        :param pulumi.Input[str] log_group: The name of the CloudWatch Logs group to send pipeline logs to. You can specify an existing log group or create a new one. For example, /aws/OpenSearchService/IngestionService/my-pipeline.
        """
        pulumi.set(__self__, "log_group", log_group)

    @property
    @pulumi.getter(name="logGroup")
    def log_group(self) -> pulumi.Input[str]:
        """
        The name of the CloudWatch Logs group to send pipeline logs to. You can specify an existing log group or create a new one. For example, /aws/OpenSearchService/IngestionService/my-pipeline.
        """
        return pulumi.get(self, "log_group")

    @log_group.setter
    def log_group(self, value: pulumi.Input[str]):
        pulumi.set(self, "log_group", value)


@pulumi.input_type
class PipelineTimeoutsArgs:
    def __init__(__self__, *,
                 create: Optional[pulumi.Input[str]] = None,
                 delete: Optional[pulumi.Input[str]] = None,
                 update: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param pulumi.Input[str] delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param pulumi.Input[str] update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[pulumi.Input[str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @create.setter
    def create(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create", value)

    @property
    @pulumi.getter
    def delete(self) -> Optional[pulumi.Input[str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @delete.setter
    def delete(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delete", value)

    @property
    @pulumi.getter
    def update(self) -> Optional[pulumi.Input[str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")

    @update.setter
    def update(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update", value)


@pulumi.input_type
class PipelineVpcOptionsArgs:
    def __init__(__self__, *,
                 subnet_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: A list of subnet IDs associated with the VPC endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list of security groups associated with the VPC endpoint.
        """
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of subnet IDs associated with the VPC endpoint.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of security groups associated with the VPC endpoint.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)


