# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ApplicationAppSource',
    'ApplicationEnvironment',
    'ApplicationSslConfiguration',
    'CustomLayerCloudwatchConfiguration',
    'CustomLayerCloudwatchConfigurationLogStream',
    'CustomLayerEbsVolume',
    'CustomLayerLoadBasedAutoScaling',
    'CustomLayerLoadBasedAutoScalingDownscaling',
    'CustomLayerLoadBasedAutoScalingUpscaling',
    'EcsClusterLayerCloudwatchConfiguration',
    'EcsClusterLayerCloudwatchConfigurationLogStream',
    'EcsClusterLayerEbsVolume',
    'EcsClusterLayerLoadBasedAutoScaling',
    'EcsClusterLayerLoadBasedAutoScalingDownscaling',
    'EcsClusterLayerLoadBasedAutoScalingUpscaling',
    'GangliaLayerCloudwatchConfiguration',
    'GangliaLayerCloudwatchConfigurationLogStream',
    'GangliaLayerEbsVolume',
    'GangliaLayerLoadBasedAutoScaling',
    'GangliaLayerLoadBasedAutoScalingDownscaling',
    'GangliaLayerLoadBasedAutoScalingUpscaling',
    'HaproxyLayerCloudwatchConfiguration',
    'HaproxyLayerCloudwatchConfigurationLogStream',
    'HaproxyLayerEbsVolume',
    'HaproxyLayerLoadBasedAutoScaling',
    'HaproxyLayerLoadBasedAutoScalingDownscaling',
    'HaproxyLayerLoadBasedAutoScalingUpscaling',
    'InstanceEbsBlockDevice',
    'InstanceEphemeralBlockDevice',
    'InstanceRootBlockDevice',
    'JavaAppLayerCloudwatchConfiguration',
    'JavaAppLayerCloudwatchConfigurationLogStream',
    'JavaAppLayerEbsVolume',
    'JavaAppLayerLoadBasedAutoScaling',
    'JavaAppLayerLoadBasedAutoScalingDownscaling',
    'JavaAppLayerLoadBasedAutoScalingUpscaling',
    'MemcachedLayerCloudwatchConfiguration',
    'MemcachedLayerCloudwatchConfigurationLogStream',
    'MemcachedLayerEbsVolume',
    'MemcachedLayerLoadBasedAutoScaling',
    'MemcachedLayerLoadBasedAutoScalingDownscaling',
    'MemcachedLayerLoadBasedAutoScalingUpscaling',
    'MysqlLayerCloudwatchConfiguration',
    'MysqlLayerCloudwatchConfigurationLogStream',
    'MysqlLayerEbsVolume',
    'MysqlLayerLoadBasedAutoScaling',
    'MysqlLayerLoadBasedAutoScalingDownscaling',
    'MysqlLayerLoadBasedAutoScalingUpscaling',
    'NodejsAppLayerCloudwatchConfiguration',
    'NodejsAppLayerCloudwatchConfigurationLogStream',
    'NodejsAppLayerEbsVolume',
    'NodejsAppLayerLoadBasedAutoScaling',
    'NodejsAppLayerLoadBasedAutoScalingDownscaling',
    'NodejsAppLayerLoadBasedAutoScalingUpscaling',
    'PhpAppLayerCloudwatchConfiguration',
    'PhpAppLayerCloudwatchConfigurationLogStream',
    'PhpAppLayerEbsVolume',
    'PhpAppLayerLoadBasedAutoScaling',
    'PhpAppLayerLoadBasedAutoScalingDownscaling',
    'PhpAppLayerLoadBasedAutoScalingUpscaling',
    'RailsAppLayerCloudwatchConfiguration',
    'RailsAppLayerCloudwatchConfigurationLogStream',
    'RailsAppLayerEbsVolume',
    'RailsAppLayerLoadBasedAutoScaling',
    'RailsAppLayerLoadBasedAutoScalingDownscaling',
    'RailsAppLayerLoadBasedAutoScalingUpscaling',
    'StackCustomCookbooksSource',
    'StaticWebLayerCloudwatchConfiguration',
    'StaticWebLayerCloudwatchConfigurationLogStream',
    'StaticWebLayerEbsVolume',
    'StaticWebLayerLoadBasedAutoScaling',
    'StaticWebLayerLoadBasedAutoScalingDownscaling',
    'StaticWebLayerLoadBasedAutoScalingUpscaling',
]

@pulumi.output_type
class ApplicationAppSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sshKey":
            suggest = "ssh_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationAppSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationAppSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationAppSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 password: Optional[str] = None,
                 revision: Optional[str] = None,
                 ssh_key: Optional[str] = None,
                 url: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str type: The type of source to use. For example, "archive".
        :param str password: Password to use when authenticating to the source. This provider cannot perform drift detection of this configuration.
        :param str revision: For sources that are version-aware, the revision to use.
        :param str ssh_key: SSH key to use when authenticating to the source. This provider cannot perform drift detection of this configuration.
        :param str url: The URL where the app resource can be found.
        :param str username: Username to use when authenticating to the source.
        """
        pulumi.set(__self__, "type", type)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if ssh_key is not None:
            pulumi.set(__self__, "ssh_key", ssh_key)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of source to use. For example, "archive".
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password to use when authenticating to the source. This provider cannot perform drift detection of this configuration.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def revision(self) -> Optional[str]:
        """
        For sources that are version-aware, the revision to use.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> Optional[str]:
        """
        SSH key to use when authenticating to the source. This provider cannot perform drift detection of this configuration.
        """
        return pulumi.get(self, "ssh_key")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        The URL where the app resource can be found.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username to use when authenticating to the source.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ApplicationEnvironment(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str,
                 secure: Optional[bool] = None):
        """
        :param str key: Variable name.
        :param str value: Variable value.
        :param bool secure: Set visibility of the variable value to `true` or `false`.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)
        if secure is not None:
            pulumi.set(__self__, "secure", secure)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Variable name.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Variable value.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def secure(self) -> Optional[bool]:
        """
        Set visibility of the variable value to `true` or `false`.
        """
        return pulumi.get(self, "secure")


@pulumi.output_type
class ApplicationSslConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateKey":
            suggest = "private_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationSslConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationSslConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationSslConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate: str,
                 private_key: str,
                 chain: Optional[str] = None):
        """
        :param str certificate: The contents of the certificate's domain.crt file.
        :param str private_key: The private key; the contents of the certificate's domain.key file.
        :param str chain: Can be used to specify an intermediate certificate authority key or client authentication.
        """
        pulumi.set(__self__, "certificate", certificate)
        pulumi.set(__self__, "private_key", private_key)
        if chain is not None:
            pulumi.set(__self__, "chain", chain)

    @property
    @pulumi.getter
    def certificate(self) -> str:
        """
        The contents of the certificate's domain.crt file.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> str:
        """
        The private key; the contents of the certificate's domain.key file.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter
    def chain(self) -> Optional[str]:
        """
        Can be used to specify an intermediate certificate authority key or client authentication.
        """
        return pulumi.get(self, "chain")


@pulumi.output_type
class CustomLayerCloudwatchConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logStreams":
            suggest = "log_streams"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomLayerCloudwatchConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomLayerCloudwatchConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomLayerCloudwatchConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 log_streams: Optional[Sequence['outputs.CustomLayerCloudwatchConfigurationLogStream']] = None):
        """
        :param Sequence['CustomLayerCloudwatchConfigurationLogStreamArgs'] log_streams: A block the specifies how an opsworks logs look like. See Log Streams.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if log_streams is not None:
            pulumi.set(__self__, "log_streams", log_streams)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="logStreams")
    def log_streams(self) -> Optional[Sequence['outputs.CustomLayerCloudwatchConfigurationLogStream']]:
        """
        A block the specifies how an opsworks logs look like. See Log Streams.
        """
        return pulumi.get(self, "log_streams")


@pulumi.output_type
class CustomLayerCloudwatchConfigurationLogStream(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupName":
            suggest = "log_group_name"
        elif key == "batchCount":
            suggest = "batch_count"
        elif key == "batchSize":
            suggest = "batch_size"
        elif key == "bufferDuration":
            suggest = "buffer_duration"
        elif key == "datetimeFormat":
            suggest = "datetime_format"
        elif key == "fileFingerprintLines":
            suggest = "file_fingerprint_lines"
        elif key == "initialPosition":
            suggest = "initial_position"
        elif key == "multilineStartPattern":
            suggest = "multiline_start_pattern"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomLayerCloudwatchConfigurationLogStream. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomLayerCloudwatchConfigurationLogStream.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomLayerCloudwatchConfigurationLogStream.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file: str,
                 log_group_name: str,
                 batch_count: Optional[int] = None,
                 batch_size: Optional[int] = None,
                 buffer_duration: Optional[int] = None,
                 datetime_format: Optional[str] = None,
                 encoding: Optional[str] = None,
                 file_fingerprint_lines: Optional[str] = None,
                 initial_position: Optional[str] = None,
                 multiline_start_pattern: Optional[str] = None,
                 time_zone: Optional[str] = None):
        """
        :param str file: Specifies log files that you want to push to CloudWatch Logs. File can point to a specific file or multiple files (by using wild card characters such as /var/log/system.log*).
        :param str log_group_name: Specifies the destination log group. A log group is created automatically if it doesn't already exist.
        :param int batch_count: Specifies the max number of log events in a batch, up to `10000`. The default value is `1000`.
        :param int batch_size: Specifies the maximum size of log events in a batch, in bytes, up to `1048576` bytes. The default value is `32768` bytes.
        :param int buffer_duration: Specifies the time duration for the batching of log events. The minimum value is `5000` and default value is `5000`.
        :param str datetime_format: Specifies how the timestamp is extracted from logs. For more information, see the CloudWatch Logs Agent Reference (https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AgentReference.html).
        :param str encoding: Specifies the encoding of the log file so that the file can be read correctly. The default is `utf_8`.
        :param str file_fingerprint_lines: Specifies the range of lines for identifying a file. The valid values are one number, or two dash-delimited numbers, such as `1`, `2-5`. The default value is `1`.
        :param str initial_position: Specifies where to start to read data (`start_of_file` or `end_of_file`). The default is `start_of_file`.
        :param str multiline_start_pattern: Specifies the pattern for identifying the start of a log message.
        :param str time_zone: Specifies the time zone of log event time stamps.
        """
        pulumi.set(__self__, "file", file)
        pulumi.set(__self__, "log_group_name", log_group_name)
        if batch_count is not None:
            pulumi.set(__self__, "batch_count", batch_count)
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if buffer_duration is not None:
            pulumi.set(__self__, "buffer_duration", buffer_duration)
        if datetime_format is not None:
            pulumi.set(__self__, "datetime_format", datetime_format)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if file_fingerprint_lines is not None:
            pulumi.set(__self__, "file_fingerprint_lines", file_fingerprint_lines)
        if initial_position is not None:
            pulumi.set(__self__, "initial_position", initial_position)
        if multiline_start_pattern is not None:
            pulumi.set(__self__, "multiline_start_pattern", multiline_start_pattern)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def file(self) -> str:
        """
        Specifies log files that you want to push to CloudWatch Logs. File can point to a specific file or multiple files (by using wild card characters such as /var/log/system.log*).
        """
        return pulumi.get(self, "file")

    @property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> str:
        """
        Specifies the destination log group. A log group is created automatically if it doesn't already exist.
        """
        return pulumi.get(self, "log_group_name")

    @property
    @pulumi.getter(name="batchCount")
    def batch_count(self) -> Optional[int]:
        """
        Specifies the max number of log events in a batch, up to `10000`. The default value is `1000`.
        """
        return pulumi.get(self, "batch_count")

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[int]:
        """
        Specifies the maximum size of log events in a batch, in bytes, up to `1048576` bytes. The default value is `32768` bytes.
        """
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="bufferDuration")
    def buffer_duration(self) -> Optional[int]:
        """
        Specifies the time duration for the batching of log events. The minimum value is `5000` and default value is `5000`.
        """
        return pulumi.get(self, "buffer_duration")

    @property
    @pulumi.getter(name="datetimeFormat")
    def datetime_format(self) -> Optional[str]:
        """
        Specifies how the timestamp is extracted from logs. For more information, see the CloudWatch Logs Agent Reference (https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AgentReference.html).
        """
        return pulumi.get(self, "datetime_format")

    @property
    @pulumi.getter
    def encoding(self) -> Optional[str]:
        """
        Specifies the encoding of the log file so that the file can be read correctly. The default is `utf_8`.
        """
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter(name="fileFingerprintLines")
    def file_fingerprint_lines(self) -> Optional[str]:
        """
        Specifies the range of lines for identifying a file. The valid values are one number, or two dash-delimited numbers, such as `1`, `2-5`. The default value is `1`.
        """
        return pulumi.get(self, "file_fingerprint_lines")

    @property
    @pulumi.getter(name="initialPosition")
    def initial_position(self) -> Optional[str]:
        """
        Specifies where to start to read data (`start_of_file` or `end_of_file`). The default is `start_of_file`.
        """
        return pulumi.get(self, "initial_position")

    @property
    @pulumi.getter(name="multilineStartPattern")
    def multiline_start_pattern(self) -> Optional[str]:
        """
        Specifies the pattern for identifying the start of a log message.
        """
        return pulumi.get(self, "multiline_start_pattern")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        """
        Specifies the time zone of log event time stamps.
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class CustomLayerEbsVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPoint":
            suggest = "mount_point"
        elif key == "numberOfDisks":
            suggest = "number_of_disks"
        elif key == "raidLevel":
            suggest = "raid_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomLayerEbsVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomLayerEbsVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomLayerEbsVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_point: str,
                 number_of_disks: int,
                 size: int,
                 encrypted: Optional[bool] = None,
                 iops: Optional[int] = None,
                 raid_level: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str mount_point: The path to mount the EBS volume on the layer's instances.
        :param int number_of_disks: The number of disks to use for the EBS volume.
        :param int size: The size of the volume in gigabytes.
        :param bool encrypted: Encrypt the volume.
        :param int iops: For PIOPS volumes, the IOPS per disk.
        :param str raid_level: The RAID level to use for the volume.
        :param str type: The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "number_of_disks", number_of_disks)
        pulumi.set(__self__, "size", size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> str:
        """
        The path to mount the EBS volume on the layer's instances.
        """
        return pulumi.get(self, "mount_point")

    @property
    @pulumi.getter(name="numberOfDisks")
    def number_of_disks(self) -> int:
        """
        The number of disks to use for the EBS volume.
        """
        return pulumi.get(self, "number_of_disks")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of the volume in gigabytes.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        """
        Encrypt the volume.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        For PIOPS volumes, the IOPS per disk.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[str]:
        """
        The RAID level to use for the volume.
        """
        return pulumi.get(self, "raid_level")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class CustomLayerLoadBasedAutoScaling(dict):
    def __init__(__self__, *,
                 downscaling: Optional['outputs.CustomLayerLoadBasedAutoScalingDownscaling'] = None,
                 enable: Optional[bool] = None,
                 upscaling: Optional['outputs.CustomLayerLoadBasedAutoScalingUpscaling'] = None):
        """
        :param 'CustomLayerLoadBasedAutoScalingDownscalingArgs' downscaling: The downscaling settings, as defined below, used for load-based autoscaling
        :param bool enable: Whether load-based auto scaling is enabled for the layer.
        :param 'CustomLayerLoadBasedAutoScalingUpscalingArgs' upscaling: The upscaling settings, as defined below, used for load-based autoscaling
        """
        if downscaling is not None:
            pulumi.set(__self__, "downscaling", downscaling)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if upscaling is not None:
            pulumi.set(__self__, "upscaling", upscaling)

    @property
    @pulumi.getter
    def downscaling(self) -> Optional['outputs.CustomLayerLoadBasedAutoScalingDownscaling']:
        """
        The downscaling settings, as defined below, used for load-based autoscaling
        """
        return pulumi.get(self, "downscaling")

    @property
    @pulumi.getter
    def enable(self) -> Optional[bool]:
        """
        Whether load-based auto scaling is enabled for the layer.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def upscaling(self) -> Optional['outputs.CustomLayerLoadBasedAutoScalingUpscaling']:
        """
        The upscaling settings, as defined below, used for load-based autoscaling
        """
        return pulumi.get(self, "upscaling")


@pulumi.output_type
class CustomLayerLoadBasedAutoScalingDownscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuThreshold":
            suggest = "cpu_threshold"
        elif key == "ignoreMetricsTime":
            suggest = "ignore_metrics_time"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "loadThreshold":
            suggest = "load_threshold"
        elif key == "memoryThreshold":
            suggest = "memory_threshold"
        elif key == "thresholdsWaitTime":
            suggest = "thresholds_wait_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomLayerLoadBasedAutoScalingDownscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomLayerLoadBasedAutoScalingDownscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomLayerLoadBasedAutoScalingDownscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alarms: Optional[Sequence[str]] = None,
                 cpu_threshold: Optional[float] = None,
                 ignore_metrics_time: Optional[int] = None,
                 instance_count: Optional[int] = None,
                 load_threshold: Optional[float] = None,
                 memory_threshold: Optional[float] = None,
                 thresholds_wait_time: Optional[int] = None):
        """
        :param Sequence[str] alarms: Custom Cloudwatch auto scaling alarms, to be used as thresholds. This parameter takes a list of up to five alarm names, which are case sensitive and must be in the same region as the stack.
        :param float cpu_threshold: The CPU utilization threshold, as a percent of the available CPU. A value of -1 disables the threshold.
        :param int ignore_metrics_time: The amount of time (in minutes) after a scaling event occurs that AWS OpsWorks Stacks should ignore metrics and suppress additional scaling events.
        :param int instance_count: The number of instances to add or remove when the load exceeds a threshold.
        :param float load_threshold: The load threshold. A value of -1 disables the threshold.
        :param float memory_threshold: The memory utilization threshold, as a percent of the available memory. A value of -1 disables the threshold.
        :param int thresholds_wait_time: The amount of time, in minutes, that the load must exceed a threshold before more instances are added or removed.
        """
        if alarms is not None:
            pulumi.set(__self__, "alarms", alarms)
        if cpu_threshold is not None:
            pulumi.set(__self__, "cpu_threshold", cpu_threshold)
        if ignore_metrics_time is not None:
            pulumi.set(__self__, "ignore_metrics_time", ignore_metrics_time)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if load_threshold is not None:
            pulumi.set(__self__, "load_threshold", load_threshold)
        if memory_threshold is not None:
            pulumi.set(__self__, "memory_threshold", memory_threshold)
        if thresholds_wait_time is not None:
            pulumi.set(__self__, "thresholds_wait_time", thresholds_wait_time)

    @property
    @pulumi.getter
    def alarms(self) -> Optional[Sequence[str]]:
        """
        Custom Cloudwatch auto scaling alarms, to be used as thresholds. This parameter takes a list of up to five alarm names, which are case sensitive and must be in the same region as the stack.
        """
        return pulumi.get(self, "alarms")

    @property
    @pulumi.getter(name="cpuThreshold")
    def cpu_threshold(self) -> Optional[float]:
        """
        The CPU utilization threshold, as a percent of the available CPU. A value of -1 disables the threshold.
        """
        return pulumi.get(self, "cpu_threshold")

    @property
    @pulumi.getter(name="ignoreMetricsTime")
    def ignore_metrics_time(self) -> Optional[int]:
        """
        The amount of time (in minutes) after a scaling event occurs that AWS OpsWorks Stacks should ignore metrics and suppress additional scaling events.
        """
        return pulumi.get(self, "ignore_metrics_time")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        """
        The number of instances to add or remove when the load exceeds a threshold.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="loadThreshold")
    def load_threshold(self) -> Optional[float]:
        """
        The load threshold. A value of -1 disables the threshold.
        """
        return pulumi.get(self, "load_threshold")

    @property
    @pulumi.getter(name="memoryThreshold")
    def memory_threshold(self) -> Optional[float]:
        """
        The memory utilization threshold, as a percent of the available memory. A value of -1 disables the threshold.
        """
        return pulumi.get(self, "memory_threshold")

    @property
    @pulumi.getter(name="thresholdsWaitTime")
    def thresholds_wait_time(self) -> Optional[int]:
        """
        The amount of time, in minutes, that the load must exceed a threshold before more instances are added or removed.
        """
        return pulumi.get(self, "thresholds_wait_time")


@pulumi.output_type
class CustomLayerLoadBasedAutoScalingUpscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuThreshold":
            suggest = "cpu_threshold"
        elif key == "ignoreMetricsTime":
            suggest = "ignore_metrics_time"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "loadThreshold":
            suggest = "load_threshold"
        elif key == "memoryThreshold":
            suggest = "memory_threshold"
        elif key == "thresholdsWaitTime":
            suggest = "thresholds_wait_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomLayerLoadBasedAutoScalingUpscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomLayerLoadBasedAutoScalingUpscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomLayerLoadBasedAutoScalingUpscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alarms: Optional[Sequence[str]] = None,
                 cpu_threshold: Optional[float] = None,
                 ignore_metrics_time: Optional[int] = None,
                 instance_count: Optional[int] = None,
                 load_threshold: Optional[float] = None,
                 memory_threshold: Optional[float] = None,
                 thresholds_wait_time: Optional[int] = None):
        """
        :param Sequence[str] alarms: Custom Cloudwatch auto scaling alarms, to be used as thresholds. This parameter takes a list of up to five alarm names, which are case sensitive and must be in the same region as the stack.
        :param float cpu_threshold: The CPU utilization threshold, as a percent of the available CPU. A value of -1 disables the threshold.
        :param int ignore_metrics_time: The amount of time (in minutes) after a scaling event occurs that AWS OpsWorks Stacks should ignore metrics and suppress additional scaling events.
        :param int instance_count: The number of instances to add or remove when the load exceeds a threshold.
        :param float load_threshold: The load threshold. A value of -1 disables the threshold.
        :param float memory_threshold: The memory utilization threshold, as a percent of the available memory. A value of -1 disables the threshold.
        :param int thresholds_wait_time: The amount of time, in minutes, that the load must exceed a threshold before more instances are added or removed.
        """
        if alarms is not None:
            pulumi.set(__self__, "alarms", alarms)
        if cpu_threshold is not None:
            pulumi.set(__self__, "cpu_threshold", cpu_threshold)
        if ignore_metrics_time is not None:
            pulumi.set(__self__, "ignore_metrics_time", ignore_metrics_time)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if load_threshold is not None:
            pulumi.set(__self__, "load_threshold", load_threshold)
        if memory_threshold is not None:
            pulumi.set(__self__, "memory_threshold", memory_threshold)
        if thresholds_wait_time is not None:
            pulumi.set(__self__, "thresholds_wait_time", thresholds_wait_time)

    @property
    @pulumi.getter
    def alarms(self) -> Optional[Sequence[str]]:
        """
        Custom Cloudwatch auto scaling alarms, to be used as thresholds. This parameter takes a list of up to five alarm names, which are case sensitive and must be in the same region as the stack.
        """
        return pulumi.get(self, "alarms")

    @property
    @pulumi.getter(name="cpuThreshold")
    def cpu_threshold(self) -> Optional[float]:
        """
        The CPU utilization threshold, as a percent of the available CPU. A value of -1 disables the threshold.
        """
        return pulumi.get(self, "cpu_threshold")

    @property
    @pulumi.getter(name="ignoreMetricsTime")
    def ignore_metrics_time(self) -> Optional[int]:
        """
        The amount of time (in minutes) after a scaling event occurs that AWS OpsWorks Stacks should ignore metrics and suppress additional scaling events.
        """
        return pulumi.get(self, "ignore_metrics_time")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        """
        The number of instances to add or remove when the load exceeds a threshold.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="loadThreshold")
    def load_threshold(self) -> Optional[float]:
        """
        The load threshold. A value of -1 disables the threshold.
        """
        return pulumi.get(self, "load_threshold")

    @property
    @pulumi.getter(name="memoryThreshold")
    def memory_threshold(self) -> Optional[float]:
        """
        The memory utilization threshold, as a percent of the available memory. A value of -1 disables the threshold.
        """
        return pulumi.get(self, "memory_threshold")

    @property
    @pulumi.getter(name="thresholdsWaitTime")
    def thresholds_wait_time(self) -> Optional[int]:
        """
        The amount of time, in minutes, that the load must exceed a threshold before more instances are added or removed.
        """
        return pulumi.get(self, "thresholds_wait_time")


@pulumi.output_type
class EcsClusterLayerCloudwatchConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logStreams":
            suggest = "log_streams"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EcsClusterLayerCloudwatchConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EcsClusterLayerCloudwatchConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EcsClusterLayerCloudwatchConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 log_streams: Optional[Sequence['outputs.EcsClusterLayerCloudwatchConfigurationLogStream']] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if log_streams is not None:
            pulumi.set(__self__, "log_streams", log_streams)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="logStreams")
    def log_streams(self) -> Optional[Sequence['outputs.EcsClusterLayerCloudwatchConfigurationLogStream']]:
        return pulumi.get(self, "log_streams")


@pulumi.output_type
class EcsClusterLayerCloudwatchConfigurationLogStream(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupName":
            suggest = "log_group_name"
        elif key == "batchCount":
            suggest = "batch_count"
        elif key == "batchSize":
            suggest = "batch_size"
        elif key == "bufferDuration":
            suggest = "buffer_duration"
        elif key == "datetimeFormat":
            suggest = "datetime_format"
        elif key == "fileFingerprintLines":
            suggest = "file_fingerprint_lines"
        elif key == "initialPosition":
            suggest = "initial_position"
        elif key == "multilineStartPattern":
            suggest = "multiline_start_pattern"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EcsClusterLayerCloudwatchConfigurationLogStream. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EcsClusterLayerCloudwatchConfigurationLogStream.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EcsClusterLayerCloudwatchConfigurationLogStream.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file: str,
                 log_group_name: str,
                 batch_count: Optional[int] = None,
                 batch_size: Optional[int] = None,
                 buffer_duration: Optional[int] = None,
                 datetime_format: Optional[str] = None,
                 encoding: Optional[str] = None,
                 file_fingerprint_lines: Optional[str] = None,
                 initial_position: Optional[str] = None,
                 multiline_start_pattern: Optional[str] = None,
                 time_zone: Optional[str] = None):
        pulumi.set(__self__, "file", file)
        pulumi.set(__self__, "log_group_name", log_group_name)
        if batch_count is not None:
            pulumi.set(__self__, "batch_count", batch_count)
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if buffer_duration is not None:
            pulumi.set(__self__, "buffer_duration", buffer_duration)
        if datetime_format is not None:
            pulumi.set(__self__, "datetime_format", datetime_format)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if file_fingerprint_lines is not None:
            pulumi.set(__self__, "file_fingerprint_lines", file_fingerprint_lines)
        if initial_position is not None:
            pulumi.set(__self__, "initial_position", initial_position)
        if multiline_start_pattern is not None:
            pulumi.set(__self__, "multiline_start_pattern", multiline_start_pattern)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def file(self) -> str:
        return pulumi.get(self, "file")

    @property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> str:
        return pulumi.get(self, "log_group_name")

    @property
    @pulumi.getter(name="batchCount")
    def batch_count(self) -> Optional[int]:
        return pulumi.get(self, "batch_count")

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[int]:
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="bufferDuration")
    def buffer_duration(self) -> Optional[int]:
        return pulumi.get(self, "buffer_duration")

    @property
    @pulumi.getter(name="datetimeFormat")
    def datetime_format(self) -> Optional[str]:
        return pulumi.get(self, "datetime_format")

    @property
    @pulumi.getter
    def encoding(self) -> Optional[str]:
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter(name="fileFingerprintLines")
    def file_fingerprint_lines(self) -> Optional[str]:
        return pulumi.get(self, "file_fingerprint_lines")

    @property
    @pulumi.getter(name="initialPosition")
    def initial_position(self) -> Optional[str]:
        return pulumi.get(self, "initial_position")

    @property
    @pulumi.getter(name="multilineStartPattern")
    def multiline_start_pattern(self) -> Optional[str]:
        return pulumi.get(self, "multiline_start_pattern")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class EcsClusterLayerEbsVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPoint":
            suggest = "mount_point"
        elif key == "numberOfDisks":
            suggest = "number_of_disks"
        elif key == "raidLevel":
            suggest = "raid_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EcsClusterLayerEbsVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EcsClusterLayerEbsVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EcsClusterLayerEbsVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_point: str,
                 number_of_disks: int,
                 size: int,
                 encrypted: Optional[bool] = None,
                 iops: Optional[int] = None,
                 raid_level: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str mount_point: The path to mount the EBS volume on the layer's instances.
        :param int number_of_disks: The number of disks to use for the EBS volume.
        :param int size: The size of the volume in gigabytes.
        :param int iops: For PIOPS volumes, the IOPS per disk.
        :param str raid_level: The RAID level to use for the volume.
        :param str type: The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "number_of_disks", number_of_disks)
        pulumi.set(__self__, "size", size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> str:
        """
        The path to mount the EBS volume on the layer's instances.
        """
        return pulumi.get(self, "mount_point")

    @property
    @pulumi.getter(name="numberOfDisks")
    def number_of_disks(self) -> int:
        """
        The number of disks to use for the EBS volume.
        """
        return pulumi.get(self, "number_of_disks")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of the volume in gigabytes.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        For PIOPS volumes, the IOPS per disk.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[str]:
        """
        The RAID level to use for the volume.
        """
        return pulumi.get(self, "raid_level")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class EcsClusterLayerLoadBasedAutoScaling(dict):
    def __init__(__self__, *,
                 downscaling: Optional['outputs.EcsClusterLayerLoadBasedAutoScalingDownscaling'] = None,
                 enable: Optional[bool] = None,
                 upscaling: Optional['outputs.EcsClusterLayerLoadBasedAutoScalingUpscaling'] = None):
        if downscaling is not None:
            pulumi.set(__self__, "downscaling", downscaling)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if upscaling is not None:
            pulumi.set(__self__, "upscaling", upscaling)

    @property
    @pulumi.getter
    def downscaling(self) -> Optional['outputs.EcsClusterLayerLoadBasedAutoScalingDownscaling']:
        return pulumi.get(self, "downscaling")

    @property
    @pulumi.getter
    def enable(self) -> Optional[bool]:
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def upscaling(self) -> Optional['outputs.EcsClusterLayerLoadBasedAutoScalingUpscaling']:
        return pulumi.get(self, "upscaling")


@pulumi.output_type
class EcsClusterLayerLoadBasedAutoScalingDownscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuThreshold":
            suggest = "cpu_threshold"
        elif key == "ignoreMetricsTime":
            suggest = "ignore_metrics_time"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "loadThreshold":
            suggest = "load_threshold"
        elif key == "memoryThreshold":
            suggest = "memory_threshold"
        elif key == "thresholdsWaitTime":
            suggest = "thresholds_wait_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EcsClusterLayerLoadBasedAutoScalingDownscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EcsClusterLayerLoadBasedAutoScalingDownscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EcsClusterLayerLoadBasedAutoScalingDownscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alarms: Optional[Sequence[str]] = None,
                 cpu_threshold: Optional[float] = None,
                 ignore_metrics_time: Optional[int] = None,
                 instance_count: Optional[int] = None,
                 load_threshold: Optional[float] = None,
                 memory_threshold: Optional[float] = None,
                 thresholds_wait_time: Optional[int] = None):
        if alarms is not None:
            pulumi.set(__self__, "alarms", alarms)
        if cpu_threshold is not None:
            pulumi.set(__self__, "cpu_threshold", cpu_threshold)
        if ignore_metrics_time is not None:
            pulumi.set(__self__, "ignore_metrics_time", ignore_metrics_time)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if load_threshold is not None:
            pulumi.set(__self__, "load_threshold", load_threshold)
        if memory_threshold is not None:
            pulumi.set(__self__, "memory_threshold", memory_threshold)
        if thresholds_wait_time is not None:
            pulumi.set(__self__, "thresholds_wait_time", thresholds_wait_time)

    @property
    @pulumi.getter
    def alarms(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "alarms")

    @property
    @pulumi.getter(name="cpuThreshold")
    def cpu_threshold(self) -> Optional[float]:
        return pulumi.get(self, "cpu_threshold")

    @property
    @pulumi.getter(name="ignoreMetricsTime")
    def ignore_metrics_time(self) -> Optional[int]:
        return pulumi.get(self, "ignore_metrics_time")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="loadThreshold")
    def load_threshold(self) -> Optional[float]:
        return pulumi.get(self, "load_threshold")

    @property
    @pulumi.getter(name="memoryThreshold")
    def memory_threshold(self) -> Optional[float]:
        return pulumi.get(self, "memory_threshold")

    @property
    @pulumi.getter(name="thresholdsWaitTime")
    def thresholds_wait_time(self) -> Optional[int]:
        return pulumi.get(self, "thresholds_wait_time")


@pulumi.output_type
class EcsClusterLayerLoadBasedAutoScalingUpscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuThreshold":
            suggest = "cpu_threshold"
        elif key == "ignoreMetricsTime":
            suggest = "ignore_metrics_time"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "loadThreshold":
            suggest = "load_threshold"
        elif key == "memoryThreshold":
            suggest = "memory_threshold"
        elif key == "thresholdsWaitTime":
            suggest = "thresholds_wait_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EcsClusterLayerLoadBasedAutoScalingUpscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EcsClusterLayerLoadBasedAutoScalingUpscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EcsClusterLayerLoadBasedAutoScalingUpscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alarms: Optional[Sequence[str]] = None,
                 cpu_threshold: Optional[float] = None,
                 ignore_metrics_time: Optional[int] = None,
                 instance_count: Optional[int] = None,
                 load_threshold: Optional[float] = None,
                 memory_threshold: Optional[float] = None,
                 thresholds_wait_time: Optional[int] = None):
        if alarms is not None:
            pulumi.set(__self__, "alarms", alarms)
        if cpu_threshold is not None:
            pulumi.set(__self__, "cpu_threshold", cpu_threshold)
        if ignore_metrics_time is not None:
            pulumi.set(__self__, "ignore_metrics_time", ignore_metrics_time)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if load_threshold is not None:
            pulumi.set(__self__, "load_threshold", load_threshold)
        if memory_threshold is not None:
            pulumi.set(__self__, "memory_threshold", memory_threshold)
        if thresholds_wait_time is not None:
            pulumi.set(__self__, "thresholds_wait_time", thresholds_wait_time)

    @property
    @pulumi.getter
    def alarms(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "alarms")

    @property
    @pulumi.getter(name="cpuThreshold")
    def cpu_threshold(self) -> Optional[float]:
        return pulumi.get(self, "cpu_threshold")

    @property
    @pulumi.getter(name="ignoreMetricsTime")
    def ignore_metrics_time(self) -> Optional[int]:
        return pulumi.get(self, "ignore_metrics_time")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="loadThreshold")
    def load_threshold(self) -> Optional[float]:
        return pulumi.get(self, "load_threshold")

    @property
    @pulumi.getter(name="memoryThreshold")
    def memory_threshold(self) -> Optional[float]:
        return pulumi.get(self, "memory_threshold")

    @property
    @pulumi.getter(name="thresholdsWaitTime")
    def thresholds_wait_time(self) -> Optional[int]:
        return pulumi.get(self, "thresholds_wait_time")


@pulumi.output_type
class GangliaLayerCloudwatchConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logStreams":
            suggest = "log_streams"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GangliaLayerCloudwatchConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GangliaLayerCloudwatchConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GangliaLayerCloudwatchConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 log_streams: Optional[Sequence['outputs.GangliaLayerCloudwatchConfigurationLogStream']] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if log_streams is not None:
            pulumi.set(__self__, "log_streams", log_streams)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="logStreams")
    def log_streams(self) -> Optional[Sequence['outputs.GangliaLayerCloudwatchConfigurationLogStream']]:
        return pulumi.get(self, "log_streams")


@pulumi.output_type
class GangliaLayerCloudwatchConfigurationLogStream(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupName":
            suggest = "log_group_name"
        elif key == "batchCount":
            suggest = "batch_count"
        elif key == "batchSize":
            suggest = "batch_size"
        elif key == "bufferDuration":
            suggest = "buffer_duration"
        elif key == "datetimeFormat":
            suggest = "datetime_format"
        elif key == "fileFingerprintLines":
            suggest = "file_fingerprint_lines"
        elif key == "initialPosition":
            suggest = "initial_position"
        elif key == "multilineStartPattern":
            suggest = "multiline_start_pattern"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GangliaLayerCloudwatchConfigurationLogStream. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GangliaLayerCloudwatchConfigurationLogStream.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GangliaLayerCloudwatchConfigurationLogStream.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file: str,
                 log_group_name: str,
                 batch_count: Optional[int] = None,
                 batch_size: Optional[int] = None,
                 buffer_duration: Optional[int] = None,
                 datetime_format: Optional[str] = None,
                 encoding: Optional[str] = None,
                 file_fingerprint_lines: Optional[str] = None,
                 initial_position: Optional[str] = None,
                 multiline_start_pattern: Optional[str] = None,
                 time_zone: Optional[str] = None):
        pulumi.set(__self__, "file", file)
        pulumi.set(__self__, "log_group_name", log_group_name)
        if batch_count is not None:
            pulumi.set(__self__, "batch_count", batch_count)
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if buffer_duration is not None:
            pulumi.set(__self__, "buffer_duration", buffer_duration)
        if datetime_format is not None:
            pulumi.set(__self__, "datetime_format", datetime_format)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if file_fingerprint_lines is not None:
            pulumi.set(__self__, "file_fingerprint_lines", file_fingerprint_lines)
        if initial_position is not None:
            pulumi.set(__self__, "initial_position", initial_position)
        if multiline_start_pattern is not None:
            pulumi.set(__self__, "multiline_start_pattern", multiline_start_pattern)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def file(self) -> str:
        return pulumi.get(self, "file")

    @property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> str:
        return pulumi.get(self, "log_group_name")

    @property
    @pulumi.getter(name="batchCount")
    def batch_count(self) -> Optional[int]:
        return pulumi.get(self, "batch_count")

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[int]:
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="bufferDuration")
    def buffer_duration(self) -> Optional[int]:
        return pulumi.get(self, "buffer_duration")

    @property
    @pulumi.getter(name="datetimeFormat")
    def datetime_format(self) -> Optional[str]:
        return pulumi.get(self, "datetime_format")

    @property
    @pulumi.getter
    def encoding(self) -> Optional[str]:
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter(name="fileFingerprintLines")
    def file_fingerprint_lines(self) -> Optional[str]:
        return pulumi.get(self, "file_fingerprint_lines")

    @property
    @pulumi.getter(name="initialPosition")
    def initial_position(self) -> Optional[str]:
        return pulumi.get(self, "initial_position")

    @property
    @pulumi.getter(name="multilineStartPattern")
    def multiline_start_pattern(self) -> Optional[str]:
        return pulumi.get(self, "multiline_start_pattern")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class GangliaLayerEbsVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPoint":
            suggest = "mount_point"
        elif key == "numberOfDisks":
            suggest = "number_of_disks"
        elif key == "raidLevel":
            suggest = "raid_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GangliaLayerEbsVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GangliaLayerEbsVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GangliaLayerEbsVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_point: str,
                 number_of_disks: int,
                 size: int,
                 encrypted: Optional[bool] = None,
                 iops: Optional[int] = None,
                 raid_level: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str mount_point: The path to mount the EBS volume on the layer's instances.
        :param int number_of_disks: The number of disks to use for the EBS volume.
        :param int size: The size of the volume in gigabytes.
        :param int iops: For PIOPS volumes, the IOPS per disk.
        :param str raid_level: The RAID level to use for the volume.
        :param str type: The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "number_of_disks", number_of_disks)
        pulumi.set(__self__, "size", size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> str:
        """
        The path to mount the EBS volume on the layer's instances.
        """
        return pulumi.get(self, "mount_point")

    @property
    @pulumi.getter(name="numberOfDisks")
    def number_of_disks(self) -> int:
        """
        The number of disks to use for the EBS volume.
        """
        return pulumi.get(self, "number_of_disks")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of the volume in gigabytes.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        For PIOPS volumes, the IOPS per disk.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[str]:
        """
        The RAID level to use for the volume.
        """
        return pulumi.get(self, "raid_level")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GangliaLayerLoadBasedAutoScaling(dict):
    def __init__(__self__, *,
                 downscaling: Optional['outputs.GangliaLayerLoadBasedAutoScalingDownscaling'] = None,
                 enable: Optional[bool] = None,
                 upscaling: Optional['outputs.GangliaLayerLoadBasedAutoScalingUpscaling'] = None):
        if downscaling is not None:
            pulumi.set(__self__, "downscaling", downscaling)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if upscaling is not None:
            pulumi.set(__self__, "upscaling", upscaling)

    @property
    @pulumi.getter
    def downscaling(self) -> Optional['outputs.GangliaLayerLoadBasedAutoScalingDownscaling']:
        return pulumi.get(self, "downscaling")

    @property
    @pulumi.getter
    def enable(self) -> Optional[bool]:
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def upscaling(self) -> Optional['outputs.GangliaLayerLoadBasedAutoScalingUpscaling']:
        return pulumi.get(self, "upscaling")


@pulumi.output_type
class GangliaLayerLoadBasedAutoScalingDownscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuThreshold":
            suggest = "cpu_threshold"
        elif key == "ignoreMetricsTime":
            suggest = "ignore_metrics_time"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "loadThreshold":
            suggest = "load_threshold"
        elif key == "memoryThreshold":
            suggest = "memory_threshold"
        elif key == "thresholdsWaitTime":
            suggest = "thresholds_wait_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GangliaLayerLoadBasedAutoScalingDownscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GangliaLayerLoadBasedAutoScalingDownscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GangliaLayerLoadBasedAutoScalingDownscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alarms: Optional[Sequence[str]] = None,
                 cpu_threshold: Optional[float] = None,
                 ignore_metrics_time: Optional[int] = None,
                 instance_count: Optional[int] = None,
                 load_threshold: Optional[float] = None,
                 memory_threshold: Optional[float] = None,
                 thresholds_wait_time: Optional[int] = None):
        if alarms is not None:
            pulumi.set(__self__, "alarms", alarms)
        if cpu_threshold is not None:
            pulumi.set(__self__, "cpu_threshold", cpu_threshold)
        if ignore_metrics_time is not None:
            pulumi.set(__self__, "ignore_metrics_time", ignore_metrics_time)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if load_threshold is not None:
            pulumi.set(__self__, "load_threshold", load_threshold)
        if memory_threshold is not None:
            pulumi.set(__self__, "memory_threshold", memory_threshold)
        if thresholds_wait_time is not None:
            pulumi.set(__self__, "thresholds_wait_time", thresholds_wait_time)

    @property
    @pulumi.getter
    def alarms(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "alarms")

    @property
    @pulumi.getter(name="cpuThreshold")
    def cpu_threshold(self) -> Optional[float]:
        return pulumi.get(self, "cpu_threshold")

    @property
    @pulumi.getter(name="ignoreMetricsTime")
    def ignore_metrics_time(self) -> Optional[int]:
        return pulumi.get(self, "ignore_metrics_time")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="loadThreshold")
    def load_threshold(self) -> Optional[float]:
        return pulumi.get(self, "load_threshold")

    @property
    @pulumi.getter(name="memoryThreshold")
    def memory_threshold(self) -> Optional[float]:
        return pulumi.get(self, "memory_threshold")

    @property
    @pulumi.getter(name="thresholdsWaitTime")
    def thresholds_wait_time(self) -> Optional[int]:
        return pulumi.get(self, "thresholds_wait_time")


@pulumi.output_type
class GangliaLayerLoadBasedAutoScalingUpscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuThreshold":
            suggest = "cpu_threshold"
        elif key == "ignoreMetricsTime":
            suggest = "ignore_metrics_time"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "loadThreshold":
            suggest = "load_threshold"
        elif key == "memoryThreshold":
            suggest = "memory_threshold"
        elif key == "thresholdsWaitTime":
            suggest = "thresholds_wait_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GangliaLayerLoadBasedAutoScalingUpscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GangliaLayerLoadBasedAutoScalingUpscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GangliaLayerLoadBasedAutoScalingUpscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alarms: Optional[Sequence[str]] = None,
                 cpu_threshold: Optional[float] = None,
                 ignore_metrics_time: Optional[int] = None,
                 instance_count: Optional[int] = None,
                 load_threshold: Optional[float] = None,
                 memory_threshold: Optional[float] = None,
                 thresholds_wait_time: Optional[int] = None):
        if alarms is not None:
            pulumi.set(__self__, "alarms", alarms)
        if cpu_threshold is not None:
            pulumi.set(__self__, "cpu_threshold", cpu_threshold)
        if ignore_metrics_time is not None:
            pulumi.set(__self__, "ignore_metrics_time", ignore_metrics_time)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if load_threshold is not None:
            pulumi.set(__self__, "load_threshold", load_threshold)
        if memory_threshold is not None:
            pulumi.set(__self__, "memory_threshold", memory_threshold)
        if thresholds_wait_time is not None:
            pulumi.set(__self__, "thresholds_wait_time", thresholds_wait_time)

    @property
    @pulumi.getter
    def alarms(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "alarms")

    @property
    @pulumi.getter(name="cpuThreshold")
    def cpu_threshold(self) -> Optional[float]:
        return pulumi.get(self, "cpu_threshold")

    @property
    @pulumi.getter(name="ignoreMetricsTime")
    def ignore_metrics_time(self) -> Optional[int]:
        return pulumi.get(self, "ignore_metrics_time")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="loadThreshold")
    def load_threshold(self) -> Optional[float]:
        return pulumi.get(self, "load_threshold")

    @property
    @pulumi.getter(name="memoryThreshold")
    def memory_threshold(self) -> Optional[float]:
        return pulumi.get(self, "memory_threshold")

    @property
    @pulumi.getter(name="thresholdsWaitTime")
    def thresholds_wait_time(self) -> Optional[int]:
        return pulumi.get(self, "thresholds_wait_time")


@pulumi.output_type
class HaproxyLayerCloudwatchConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logStreams":
            suggest = "log_streams"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HaproxyLayerCloudwatchConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HaproxyLayerCloudwatchConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HaproxyLayerCloudwatchConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 log_streams: Optional[Sequence['outputs.HaproxyLayerCloudwatchConfigurationLogStream']] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if log_streams is not None:
            pulumi.set(__self__, "log_streams", log_streams)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="logStreams")
    def log_streams(self) -> Optional[Sequence['outputs.HaproxyLayerCloudwatchConfigurationLogStream']]:
        return pulumi.get(self, "log_streams")


@pulumi.output_type
class HaproxyLayerCloudwatchConfigurationLogStream(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupName":
            suggest = "log_group_name"
        elif key == "batchCount":
            suggest = "batch_count"
        elif key == "batchSize":
            suggest = "batch_size"
        elif key == "bufferDuration":
            suggest = "buffer_duration"
        elif key == "datetimeFormat":
            suggest = "datetime_format"
        elif key == "fileFingerprintLines":
            suggest = "file_fingerprint_lines"
        elif key == "initialPosition":
            suggest = "initial_position"
        elif key == "multilineStartPattern":
            suggest = "multiline_start_pattern"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HaproxyLayerCloudwatchConfigurationLogStream. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HaproxyLayerCloudwatchConfigurationLogStream.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HaproxyLayerCloudwatchConfigurationLogStream.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file: str,
                 log_group_name: str,
                 batch_count: Optional[int] = None,
                 batch_size: Optional[int] = None,
                 buffer_duration: Optional[int] = None,
                 datetime_format: Optional[str] = None,
                 encoding: Optional[str] = None,
                 file_fingerprint_lines: Optional[str] = None,
                 initial_position: Optional[str] = None,
                 multiline_start_pattern: Optional[str] = None,
                 time_zone: Optional[str] = None):
        pulumi.set(__self__, "file", file)
        pulumi.set(__self__, "log_group_name", log_group_name)
        if batch_count is not None:
            pulumi.set(__self__, "batch_count", batch_count)
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if buffer_duration is not None:
            pulumi.set(__self__, "buffer_duration", buffer_duration)
        if datetime_format is not None:
            pulumi.set(__self__, "datetime_format", datetime_format)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if file_fingerprint_lines is not None:
            pulumi.set(__self__, "file_fingerprint_lines", file_fingerprint_lines)
        if initial_position is not None:
            pulumi.set(__self__, "initial_position", initial_position)
        if multiline_start_pattern is not None:
            pulumi.set(__self__, "multiline_start_pattern", multiline_start_pattern)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def file(self) -> str:
        return pulumi.get(self, "file")

    @property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> str:
        return pulumi.get(self, "log_group_name")

    @property
    @pulumi.getter(name="batchCount")
    def batch_count(self) -> Optional[int]:
        return pulumi.get(self, "batch_count")

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[int]:
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="bufferDuration")
    def buffer_duration(self) -> Optional[int]:
        return pulumi.get(self, "buffer_duration")

    @property
    @pulumi.getter(name="datetimeFormat")
    def datetime_format(self) -> Optional[str]:
        return pulumi.get(self, "datetime_format")

    @property
    @pulumi.getter
    def encoding(self) -> Optional[str]:
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter(name="fileFingerprintLines")
    def file_fingerprint_lines(self) -> Optional[str]:
        return pulumi.get(self, "file_fingerprint_lines")

    @property
    @pulumi.getter(name="initialPosition")
    def initial_position(self) -> Optional[str]:
        return pulumi.get(self, "initial_position")

    @property
    @pulumi.getter(name="multilineStartPattern")
    def multiline_start_pattern(self) -> Optional[str]:
        return pulumi.get(self, "multiline_start_pattern")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class HaproxyLayerEbsVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPoint":
            suggest = "mount_point"
        elif key == "numberOfDisks":
            suggest = "number_of_disks"
        elif key == "raidLevel":
            suggest = "raid_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HaproxyLayerEbsVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HaproxyLayerEbsVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HaproxyLayerEbsVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_point: str,
                 number_of_disks: int,
                 size: int,
                 encrypted: Optional[bool] = None,
                 iops: Optional[int] = None,
                 raid_level: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str mount_point: The path to mount the EBS volume on the layer's instances.
        :param int number_of_disks: The number of disks to use for the EBS volume.
        :param int size: The size of the volume in gigabytes.
        :param int iops: For PIOPS volumes, the IOPS per disk.
        :param str raid_level: The RAID level to use for the volume.
        :param str type: The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "number_of_disks", number_of_disks)
        pulumi.set(__self__, "size", size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> str:
        """
        The path to mount the EBS volume on the layer's instances.
        """
        return pulumi.get(self, "mount_point")

    @property
    @pulumi.getter(name="numberOfDisks")
    def number_of_disks(self) -> int:
        """
        The number of disks to use for the EBS volume.
        """
        return pulumi.get(self, "number_of_disks")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of the volume in gigabytes.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        For PIOPS volumes, the IOPS per disk.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[str]:
        """
        The RAID level to use for the volume.
        """
        return pulumi.get(self, "raid_level")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class HaproxyLayerLoadBasedAutoScaling(dict):
    def __init__(__self__, *,
                 downscaling: Optional['outputs.HaproxyLayerLoadBasedAutoScalingDownscaling'] = None,
                 enable: Optional[bool] = None,
                 upscaling: Optional['outputs.HaproxyLayerLoadBasedAutoScalingUpscaling'] = None):
        if downscaling is not None:
            pulumi.set(__self__, "downscaling", downscaling)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if upscaling is not None:
            pulumi.set(__self__, "upscaling", upscaling)

    @property
    @pulumi.getter
    def downscaling(self) -> Optional['outputs.HaproxyLayerLoadBasedAutoScalingDownscaling']:
        return pulumi.get(self, "downscaling")

    @property
    @pulumi.getter
    def enable(self) -> Optional[bool]:
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def upscaling(self) -> Optional['outputs.HaproxyLayerLoadBasedAutoScalingUpscaling']:
        return pulumi.get(self, "upscaling")


@pulumi.output_type
class HaproxyLayerLoadBasedAutoScalingDownscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuThreshold":
            suggest = "cpu_threshold"
        elif key == "ignoreMetricsTime":
            suggest = "ignore_metrics_time"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "loadThreshold":
            suggest = "load_threshold"
        elif key == "memoryThreshold":
            suggest = "memory_threshold"
        elif key == "thresholdsWaitTime":
            suggest = "thresholds_wait_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HaproxyLayerLoadBasedAutoScalingDownscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HaproxyLayerLoadBasedAutoScalingDownscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HaproxyLayerLoadBasedAutoScalingDownscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alarms: Optional[Sequence[str]] = None,
                 cpu_threshold: Optional[float] = None,
                 ignore_metrics_time: Optional[int] = None,
                 instance_count: Optional[int] = None,
                 load_threshold: Optional[float] = None,
                 memory_threshold: Optional[float] = None,
                 thresholds_wait_time: Optional[int] = None):
        if alarms is not None:
            pulumi.set(__self__, "alarms", alarms)
        if cpu_threshold is not None:
            pulumi.set(__self__, "cpu_threshold", cpu_threshold)
        if ignore_metrics_time is not None:
            pulumi.set(__self__, "ignore_metrics_time", ignore_metrics_time)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if load_threshold is not None:
            pulumi.set(__self__, "load_threshold", load_threshold)
        if memory_threshold is not None:
            pulumi.set(__self__, "memory_threshold", memory_threshold)
        if thresholds_wait_time is not None:
            pulumi.set(__self__, "thresholds_wait_time", thresholds_wait_time)

    @property
    @pulumi.getter
    def alarms(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "alarms")

    @property
    @pulumi.getter(name="cpuThreshold")
    def cpu_threshold(self) -> Optional[float]:
        return pulumi.get(self, "cpu_threshold")

    @property
    @pulumi.getter(name="ignoreMetricsTime")
    def ignore_metrics_time(self) -> Optional[int]:
        return pulumi.get(self, "ignore_metrics_time")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="loadThreshold")
    def load_threshold(self) -> Optional[float]:
        return pulumi.get(self, "load_threshold")

    @property
    @pulumi.getter(name="memoryThreshold")
    def memory_threshold(self) -> Optional[float]:
        return pulumi.get(self, "memory_threshold")

    @property
    @pulumi.getter(name="thresholdsWaitTime")
    def thresholds_wait_time(self) -> Optional[int]:
        return pulumi.get(self, "thresholds_wait_time")


@pulumi.output_type
class HaproxyLayerLoadBasedAutoScalingUpscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuThreshold":
            suggest = "cpu_threshold"
        elif key == "ignoreMetricsTime":
            suggest = "ignore_metrics_time"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "loadThreshold":
            suggest = "load_threshold"
        elif key == "memoryThreshold":
            suggest = "memory_threshold"
        elif key == "thresholdsWaitTime":
            suggest = "thresholds_wait_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HaproxyLayerLoadBasedAutoScalingUpscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HaproxyLayerLoadBasedAutoScalingUpscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HaproxyLayerLoadBasedAutoScalingUpscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alarms: Optional[Sequence[str]] = None,
                 cpu_threshold: Optional[float] = None,
                 ignore_metrics_time: Optional[int] = None,
                 instance_count: Optional[int] = None,
                 load_threshold: Optional[float] = None,
                 memory_threshold: Optional[float] = None,
                 thresholds_wait_time: Optional[int] = None):
        if alarms is not None:
            pulumi.set(__self__, "alarms", alarms)
        if cpu_threshold is not None:
            pulumi.set(__self__, "cpu_threshold", cpu_threshold)
        if ignore_metrics_time is not None:
            pulumi.set(__self__, "ignore_metrics_time", ignore_metrics_time)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if load_threshold is not None:
            pulumi.set(__self__, "load_threshold", load_threshold)
        if memory_threshold is not None:
            pulumi.set(__self__, "memory_threshold", memory_threshold)
        if thresholds_wait_time is not None:
            pulumi.set(__self__, "thresholds_wait_time", thresholds_wait_time)

    @property
    @pulumi.getter
    def alarms(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "alarms")

    @property
    @pulumi.getter(name="cpuThreshold")
    def cpu_threshold(self) -> Optional[float]:
        return pulumi.get(self, "cpu_threshold")

    @property
    @pulumi.getter(name="ignoreMetricsTime")
    def ignore_metrics_time(self) -> Optional[int]:
        return pulumi.get(self, "ignore_metrics_time")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="loadThreshold")
    def load_threshold(self) -> Optional[float]:
        return pulumi.get(self, "load_threshold")

    @property
    @pulumi.getter(name="memoryThreshold")
    def memory_threshold(self) -> Optional[float]:
        return pulumi.get(self, "memory_threshold")

    @property
    @pulumi.getter(name="thresholdsWaitTime")
    def thresholds_wait_time(self) -> Optional[int]:
        return pulumi.get(self, "thresholds_wait_time")


@pulumi.output_type
class InstanceEbsBlockDevice(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceName":
            suggest = "device_name"
        elif key == "deleteOnTermination":
            suggest = "delete_on_termination"
        elif key == "snapshotId":
            suggest = "snapshot_id"
        elif key == "volumeSize":
            suggest = "volume_size"
        elif key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceEbsBlockDevice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceEbsBlockDevice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceEbsBlockDevice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_name: str,
                 delete_on_termination: Optional[bool] = None,
                 iops: Optional[int] = None,
                 snapshot_id: Optional[str] = None,
                 volume_size: Optional[int] = None,
                 volume_type: Optional[str] = None):
        pulumi.set(__self__, "device_name", device_name)
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> str:
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[bool]:
        return pulumi.get(self, "delete_on_termination")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[str]:
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[int]:
        return pulumi.get(self, "volume_size")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[str]:
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class InstanceEphemeralBlockDevice(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceName":
            suggest = "device_name"
        elif key == "virtualName":
            suggest = "virtual_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceEphemeralBlockDevice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceEphemeralBlockDevice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceEphemeralBlockDevice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_name: str,
                 virtual_name: str):
        pulumi.set(__self__, "device_name", device_name)
        pulumi.set(__self__, "virtual_name", virtual_name)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> str:
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter(name="virtualName")
    def virtual_name(self) -> str:
        return pulumi.get(self, "virtual_name")


@pulumi.output_type
class InstanceRootBlockDevice(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteOnTermination":
            suggest = "delete_on_termination"
        elif key == "volumeSize":
            suggest = "volume_size"
        elif key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceRootBlockDevice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceRootBlockDevice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceRootBlockDevice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete_on_termination: Optional[bool] = None,
                 iops: Optional[int] = None,
                 volume_size: Optional[int] = None,
                 volume_type: Optional[str] = None):
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[bool]:
        return pulumi.get(self, "delete_on_termination")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[int]:
        return pulumi.get(self, "volume_size")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[str]:
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class JavaAppLayerCloudwatchConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logStreams":
            suggest = "log_streams"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JavaAppLayerCloudwatchConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JavaAppLayerCloudwatchConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JavaAppLayerCloudwatchConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 log_streams: Optional[Sequence['outputs.JavaAppLayerCloudwatchConfigurationLogStream']] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if log_streams is not None:
            pulumi.set(__self__, "log_streams", log_streams)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="logStreams")
    def log_streams(self) -> Optional[Sequence['outputs.JavaAppLayerCloudwatchConfigurationLogStream']]:
        return pulumi.get(self, "log_streams")


@pulumi.output_type
class JavaAppLayerCloudwatchConfigurationLogStream(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupName":
            suggest = "log_group_name"
        elif key == "batchCount":
            suggest = "batch_count"
        elif key == "batchSize":
            suggest = "batch_size"
        elif key == "bufferDuration":
            suggest = "buffer_duration"
        elif key == "datetimeFormat":
            suggest = "datetime_format"
        elif key == "fileFingerprintLines":
            suggest = "file_fingerprint_lines"
        elif key == "initialPosition":
            suggest = "initial_position"
        elif key == "multilineStartPattern":
            suggest = "multiline_start_pattern"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JavaAppLayerCloudwatchConfigurationLogStream. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JavaAppLayerCloudwatchConfigurationLogStream.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JavaAppLayerCloudwatchConfigurationLogStream.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file: str,
                 log_group_name: str,
                 batch_count: Optional[int] = None,
                 batch_size: Optional[int] = None,
                 buffer_duration: Optional[int] = None,
                 datetime_format: Optional[str] = None,
                 encoding: Optional[str] = None,
                 file_fingerprint_lines: Optional[str] = None,
                 initial_position: Optional[str] = None,
                 multiline_start_pattern: Optional[str] = None,
                 time_zone: Optional[str] = None):
        pulumi.set(__self__, "file", file)
        pulumi.set(__self__, "log_group_name", log_group_name)
        if batch_count is not None:
            pulumi.set(__self__, "batch_count", batch_count)
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if buffer_duration is not None:
            pulumi.set(__self__, "buffer_duration", buffer_duration)
        if datetime_format is not None:
            pulumi.set(__self__, "datetime_format", datetime_format)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if file_fingerprint_lines is not None:
            pulumi.set(__self__, "file_fingerprint_lines", file_fingerprint_lines)
        if initial_position is not None:
            pulumi.set(__self__, "initial_position", initial_position)
        if multiline_start_pattern is not None:
            pulumi.set(__self__, "multiline_start_pattern", multiline_start_pattern)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def file(self) -> str:
        return pulumi.get(self, "file")

    @property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> str:
        return pulumi.get(self, "log_group_name")

    @property
    @pulumi.getter(name="batchCount")
    def batch_count(self) -> Optional[int]:
        return pulumi.get(self, "batch_count")

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[int]:
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="bufferDuration")
    def buffer_duration(self) -> Optional[int]:
        return pulumi.get(self, "buffer_duration")

    @property
    @pulumi.getter(name="datetimeFormat")
    def datetime_format(self) -> Optional[str]:
        return pulumi.get(self, "datetime_format")

    @property
    @pulumi.getter
    def encoding(self) -> Optional[str]:
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter(name="fileFingerprintLines")
    def file_fingerprint_lines(self) -> Optional[str]:
        return pulumi.get(self, "file_fingerprint_lines")

    @property
    @pulumi.getter(name="initialPosition")
    def initial_position(self) -> Optional[str]:
        return pulumi.get(self, "initial_position")

    @property
    @pulumi.getter(name="multilineStartPattern")
    def multiline_start_pattern(self) -> Optional[str]:
        return pulumi.get(self, "multiline_start_pattern")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class JavaAppLayerEbsVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPoint":
            suggest = "mount_point"
        elif key == "numberOfDisks":
            suggest = "number_of_disks"
        elif key == "raidLevel":
            suggest = "raid_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JavaAppLayerEbsVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JavaAppLayerEbsVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JavaAppLayerEbsVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_point: str,
                 number_of_disks: int,
                 size: int,
                 encrypted: Optional[bool] = None,
                 iops: Optional[int] = None,
                 raid_level: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str mount_point: The path to mount the EBS volume on the layer's instances.
        :param int number_of_disks: The number of disks to use for the EBS volume.
        :param int size: The size of the volume in gigabytes.
        :param int iops: For PIOPS volumes, the IOPS per disk.
        :param str raid_level: The RAID level to use for the volume.
        :param str type: The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "number_of_disks", number_of_disks)
        pulumi.set(__self__, "size", size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> str:
        """
        The path to mount the EBS volume on the layer's instances.
        """
        return pulumi.get(self, "mount_point")

    @property
    @pulumi.getter(name="numberOfDisks")
    def number_of_disks(self) -> int:
        """
        The number of disks to use for the EBS volume.
        """
        return pulumi.get(self, "number_of_disks")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of the volume in gigabytes.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        For PIOPS volumes, the IOPS per disk.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[str]:
        """
        The RAID level to use for the volume.
        """
        return pulumi.get(self, "raid_level")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class JavaAppLayerLoadBasedAutoScaling(dict):
    def __init__(__self__, *,
                 downscaling: Optional['outputs.JavaAppLayerLoadBasedAutoScalingDownscaling'] = None,
                 enable: Optional[bool] = None,
                 upscaling: Optional['outputs.JavaAppLayerLoadBasedAutoScalingUpscaling'] = None):
        if downscaling is not None:
            pulumi.set(__self__, "downscaling", downscaling)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if upscaling is not None:
            pulumi.set(__self__, "upscaling", upscaling)

    @property
    @pulumi.getter
    def downscaling(self) -> Optional['outputs.JavaAppLayerLoadBasedAutoScalingDownscaling']:
        return pulumi.get(self, "downscaling")

    @property
    @pulumi.getter
    def enable(self) -> Optional[bool]:
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def upscaling(self) -> Optional['outputs.JavaAppLayerLoadBasedAutoScalingUpscaling']:
        return pulumi.get(self, "upscaling")


@pulumi.output_type
class JavaAppLayerLoadBasedAutoScalingDownscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuThreshold":
            suggest = "cpu_threshold"
        elif key == "ignoreMetricsTime":
            suggest = "ignore_metrics_time"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "loadThreshold":
            suggest = "load_threshold"
        elif key == "memoryThreshold":
            suggest = "memory_threshold"
        elif key == "thresholdsWaitTime":
            suggest = "thresholds_wait_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JavaAppLayerLoadBasedAutoScalingDownscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JavaAppLayerLoadBasedAutoScalingDownscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JavaAppLayerLoadBasedAutoScalingDownscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alarms: Optional[Sequence[str]] = None,
                 cpu_threshold: Optional[float] = None,
                 ignore_metrics_time: Optional[int] = None,
                 instance_count: Optional[int] = None,
                 load_threshold: Optional[float] = None,
                 memory_threshold: Optional[float] = None,
                 thresholds_wait_time: Optional[int] = None):
        if alarms is not None:
            pulumi.set(__self__, "alarms", alarms)
        if cpu_threshold is not None:
            pulumi.set(__self__, "cpu_threshold", cpu_threshold)
        if ignore_metrics_time is not None:
            pulumi.set(__self__, "ignore_metrics_time", ignore_metrics_time)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if load_threshold is not None:
            pulumi.set(__self__, "load_threshold", load_threshold)
        if memory_threshold is not None:
            pulumi.set(__self__, "memory_threshold", memory_threshold)
        if thresholds_wait_time is not None:
            pulumi.set(__self__, "thresholds_wait_time", thresholds_wait_time)

    @property
    @pulumi.getter
    def alarms(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "alarms")

    @property
    @pulumi.getter(name="cpuThreshold")
    def cpu_threshold(self) -> Optional[float]:
        return pulumi.get(self, "cpu_threshold")

    @property
    @pulumi.getter(name="ignoreMetricsTime")
    def ignore_metrics_time(self) -> Optional[int]:
        return pulumi.get(self, "ignore_metrics_time")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="loadThreshold")
    def load_threshold(self) -> Optional[float]:
        return pulumi.get(self, "load_threshold")

    @property
    @pulumi.getter(name="memoryThreshold")
    def memory_threshold(self) -> Optional[float]:
        return pulumi.get(self, "memory_threshold")

    @property
    @pulumi.getter(name="thresholdsWaitTime")
    def thresholds_wait_time(self) -> Optional[int]:
        return pulumi.get(self, "thresholds_wait_time")


@pulumi.output_type
class JavaAppLayerLoadBasedAutoScalingUpscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuThreshold":
            suggest = "cpu_threshold"
        elif key == "ignoreMetricsTime":
            suggest = "ignore_metrics_time"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "loadThreshold":
            suggest = "load_threshold"
        elif key == "memoryThreshold":
            suggest = "memory_threshold"
        elif key == "thresholdsWaitTime":
            suggest = "thresholds_wait_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JavaAppLayerLoadBasedAutoScalingUpscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JavaAppLayerLoadBasedAutoScalingUpscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JavaAppLayerLoadBasedAutoScalingUpscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alarms: Optional[Sequence[str]] = None,
                 cpu_threshold: Optional[float] = None,
                 ignore_metrics_time: Optional[int] = None,
                 instance_count: Optional[int] = None,
                 load_threshold: Optional[float] = None,
                 memory_threshold: Optional[float] = None,
                 thresholds_wait_time: Optional[int] = None):
        if alarms is not None:
            pulumi.set(__self__, "alarms", alarms)
        if cpu_threshold is not None:
            pulumi.set(__self__, "cpu_threshold", cpu_threshold)
        if ignore_metrics_time is not None:
            pulumi.set(__self__, "ignore_metrics_time", ignore_metrics_time)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if load_threshold is not None:
            pulumi.set(__self__, "load_threshold", load_threshold)
        if memory_threshold is not None:
            pulumi.set(__self__, "memory_threshold", memory_threshold)
        if thresholds_wait_time is not None:
            pulumi.set(__self__, "thresholds_wait_time", thresholds_wait_time)

    @property
    @pulumi.getter
    def alarms(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "alarms")

    @property
    @pulumi.getter(name="cpuThreshold")
    def cpu_threshold(self) -> Optional[float]:
        return pulumi.get(self, "cpu_threshold")

    @property
    @pulumi.getter(name="ignoreMetricsTime")
    def ignore_metrics_time(self) -> Optional[int]:
        return pulumi.get(self, "ignore_metrics_time")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="loadThreshold")
    def load_threshold(self) -> Optional[float]:
        return pulumi.get(self, "load_threshold")

    @property
    @pulumi.getter(name="memoryThreshold")
    def memory_threshold(self) -> Optional[float]:
        return pulumi.get(self, "memory_threshold")

    @property
    @pulumi.getter(name="thresholdsWaitTime")
    def thresholds_wait_time(self) -> Optional[int]:
        return pulumi.get(self, "thresholds_wait_time")


@pulumi.output_type
class MemcachedLayerCloudwatchConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logStreams":
            suggest = "log_streams"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MemcachedLayerCloudwatchConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MemcachedLayerCloudwatchConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MemcachedLayerCloudwatchConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 log_streams: Optional[Sequence['outputs.MemcachedLayerCloudwatchConfigurationLogStream']] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if log_streams is not None:
            pulumi.set(__self__, "log_streams", log_streams)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="logStreams")
    def log_streams(self) -> Optional[Sequence['outputs.MemcachedLayerCloudwatchConfigurationLogStream']]:
        return pulumi.get(self, "log_streams")


@pulumi.output_type
class MemcachedLayerCloudwatchConfigurationLogStream(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupName":
            suggest = "log_group_name"
        elif key == "batchCount":
            suggest = "batch_count"
        elif key == "batchSize":
            suggest = "batch_size"
        elif key == "bufferDuration":
            suggest = "buffer_duration"
        elif key == "datetimeFormat":
            suggest = "datetime_format"
        elif key == "fileFingerprintLines":
            suggest = "file_fingerprint_lines"
        elif key == "initialPosition":
            suggest = "initial_position"
        elif key == "multilineStartPattern":
            suggest = "multiline_start_pattern"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MemcachedLayerCloudwatchConfigurationLogStream. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MemcachedLayerCloudwatchConfigurationLogStream.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MemcachedLayerCloudwatchConfigurationLogStream.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file: str,
                 log_group_name: str,
                 batch_count: Optional[int] = None,
                 batch_size: Optional[int] = None,
                 buffer_duration: Optional[int] = None,
                 datetime_format: Optional[str] = None,
                 encoding: Optional[str] = None,
                 file_fingerprint_lines: Optional[str] = None,
                 initial_position: Optional[str] = None,
                 multiline_start_pattern: Optional[str] = None,
                 time_zone: Optional[str] = None):
        pulumi.set(__self__, "file", file)
        pulumi.set(__self__, "log_group_name", log_group_name)
        if batch_count is not None:
            pulumi.set(__self__, "batch_count", batch_count)
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if buffer_duration is not None:
            pulumi.set(__self__, "buffer_duration", buffer_duration)
        if datetime_format is not None:
            pulumi.set(__self__, "datetime_format", datetime_format)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if file_fingerprint_lines is not None:
            pulumi.set(__self__, "file_fingerprint_lines", file_fingerprint_lines)
        if initial_position is not None:
            pulumi.set(__self__, "initial_position", initial_position)
        if multiline_start_pattern is not None:
            pulumi.set(__self__, "multiline_start_pattern", multiline_start_pattern)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def file(self) -> str:
        return pulumi.get(self, "file")

    @property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> str:
        return pulumi.get(self, "log_group_name")

    @property
    @pulumi.getter(name="batchCount")
    def batch_count(self) -> Optional[int]:
        return pulumi.get(self, "batch_count")

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[int]:
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="bufferDuration")
    def buffer_duration(self) -> Optional[int]:
        return pulumi.get(self, "buffer_duration")

    @property
    @pulumi.getter(name="datetimeFormat")
    def datetime_format(self) -> Optional[str]:
        return pulumi.get(self, "datetime_format")

    @property
    @pulumi.getter
    def encoding(self) -> Optional[str]:
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter(name="fileFingerprintLines")
    def file_fingerprint_lines(self) -> Optional[str]:
        return pulumi.get(self, "file_fingerprint_lines")

    @property
    @pulumi.getter(name="initialPosition")
    def initial_position(self) -> Optional[str]:
        return pulumi.get(self, "initial_position")

    @property
    @pulumi.getter(name="multilineStartPattern")
    def multiline_start_pattern(self) -> Optional[str]:
        return pulumi.get(self, "multiline_start_pattern")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class MemcachedLayerEbsVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPoint":
            suggest = "mount_point"
        elif key == "numberOfDisks":
            suggest = "number_of_disks"
        elif key == "raidLevel":
            suggest = "raid_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MemcachedLayerEbsVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MemcachedLayerEbsVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MemcachedLayerEbsVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_point: str,
                 number_of_disks: int,
                 size: int,
                 encrypted: Optional[bool] = None,
                 iops: Optional[int] = None,
                 raid_level: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str mount_point: The path to mount the EBS volume on the layer's instances.
        :param int number_of_disks: The number of disks to use for the EBS volume.
        :param int size: The size of the volume in gigabytes.
        :param int iops: For PIOPS volumes, the IOPS per disk.
        :param str raid_level: The RAID level to use for the volume.
        :param str type: The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "number_of_disks", number_of_disks)
        pulumi.set(__self__, "size", size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> str:
        """
        The path to mount the EBS volume on the layer's instances.
        """
        return pulumi.get(self, "mount_point")

    @property
    @pulumi.getter(name="numberOfDisks")
    def number_of_disks(self) -> int:
        """
        The number of disks to use for the EBS volume.
        """
        return pulumi.get(self, "number_of_disks")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of the volume in gigabytes.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        For PIOPS volumes, the IOPS per disk.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[str]:
        """
        The RAID level to use for the volume.
        """
        return pulumi.get(self, "raid_level")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MemcachedLayerLoadBasedAutoScaling(dict):
    def __init__(__self__, *,
                 downscaling: Optional['outputs.MemcachedLayerLoadBasedAutoScalingDownscaling'] = None,
                 enable: Optional[bool] = None,
                 upscaling: Optional['outputs.MemcachedLayerLoadBasedAutoScalingUpscaling'] = None):
        if downscaling is not None:
            pulumi.set(__self__, "downscaling", downscaling)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if upscaling is not None:
            pulumi.set(__self__, "upscaling", upscaling)

    @property
    @pulumi.getter
    def downscaling(self) -> Optional['outputs.MemcachedLayerLoadBasedAutoScalingDownscaling']:
        return pulumi.get(self, "downscaling")

    @property
    @pulumi.getter
    def enable(self) -> Optional[bool]:
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def upscaling(self) -> Optional['outputs.MemcachedLayerLoadBasedAutoScalingUpscaling']:
        return pulumi.get(self, "upscaling")


@pulumi.output_type
class MemcachedLayerLoadBasedAutoScalingDownscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuThreshold":
            suggest = "cpu_threshold"
        elif key == "ignoreMetricsTime":
            suggest = "ignore_metrics_time"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "loadThreshold":
            suggest = "load_threshold"
        elif key == "memoryThreshold":
            suggest = "memory_threshold"
        elif key == "thresholdsWaitTime":
            suggest = "thresholds_wait_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MemcachedLayerLoadBasedAutoScalingDownscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MemcachedLayerLoadBasedAutoScalingDownscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MemcachedLayerLoadBasedAutoScalingDownscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alarms: Optional[Sequence[str]] = None,
                 cpu_threshold: Optional[float] = None,
                 ignore_metrics_time: Optional[int] = None,
                 instance_count: Optional[int] = None,
                 load_threshold: Optional[float] = None,
                 memory_threshold: Optional[float] = None,
                 thresholds_wait_time: Optional[int] = None):
        if alarms is not None:
            pulumi.set(__self__, "alarms", alarms)
        if cpu_threshold is not None:
            pulumi.set(__self__, "cpu_threshold", cpu_threshold)
        if ignore_metrics_time is not None:
            pulumi.set(__self__, "ignore_metrics_time", ignore_metrics_time)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if load_threshold is not None:
            pulumi.set(__self__, "load_threshold", load_threshold)
        if memory_threshold is not None:
            pulumi.set(__self__, "memory_threshold", memory_threshold)
        if thresholds_wait_time is not None:
            pulumi.set(__self__, "thresholds_wait_time", thresholds_wait_time)

    @property
    @pulumi.getter
    def alarms(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "alarms")

    @property
    @pulumi.getter(name="cpuThreshold")
    def cpu_threshold(self) -> Optional[float]:
        return pulumi.get(self, "cpu_threshold")

    @property
    @pulumi.getter(name="ignoreMetricsTime")
    def ignore_metrics_time(self) -> Optional[int]:
        return pulumi.get(self, "ignore_metrics_time")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="loadThreshold")
    def load_threshold(self) -> Optional[float]:
        return pulumi.get(self, "load_threshold")

    @property
    @pulumi.getter(name="memoryThreshold")
    def memory_threshold(self) -> Optional[float]:
        return pulumi.get(self, "memory_threshold")

    @property
    @pulumi.getter(name="thresholdsWaitTime")
    def thresholds_wait_time(self) -> Optional[int]:
        return pulumi.get(self, "thresholds_wait_time")


@pulumi.output_type
class MemcachedLayerLoadBasedAutoScalingUpscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuThreshold":
            suggest = "cpu_threshold"
        elif key == "ignoreMetricsTime":
            suggest = "ignore_metrics_time"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "loadThreshold":
            suggest = "load_threshold"
        elif key == "memoryThreshold":
            suggest = "memory_threshold"
        elif key == "thresholdsWaitTime":
            suggest = "thresholds_wait_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MemcachedLayerLoadBasedAutoScalingUpscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MemcachedLayerLoadBasedAutoScalingUpscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MemcachedLayerLoadBasedAutoScalingUpscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alarms: Optional[Sequence[str]] = None,
                 cpu_threshold: Optional[float] = None,
                 ignore_metrics_time: Optional[int] = None,
                 instance_count: Optional[int] = None,
                 load_threshold: Optional[float] = None,
                 memory_threshold: Optional[float] = None,
                 thresholds_wait_time: Optional[int] = None):
        if alarms is not None:
            pulumi.set(__self__, "alarms", alarms)
        if cpu_threshold is not None:
            pulumi.set(__self__, "cpu_threshold", cpu_threshold)
        if ignore_metrics_time is not None:
            pulumi.set(__self__, "ignore_metrics_time", ignore_metrics_time)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if load_threshold is not None:
            pulumi.set(__self__, "load_threshold", load_threshold)
        if memory_threshold is not None:
            pulumi.set(__self__, "memory_threshold", memory_threshold)
        if thresholds_wait_time is not None:
            pulumi.set(__self__, "thresholds_wait_time", thresholds_wait_time)

    @property
    @pulumi.getter
    def alarms(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "alarms")

    @property
    @pulumi.getter(name="cpuThreshold")
    def cpu_threshold(self) -> Optional[float]:
        return pulumi.get(self, "cpu_threshold")

    @property
    @pulumi.getter(name="ignoreMetricsTime")
    def ignore_metrics_time(self) -> Optional[int]:
        return pulumi.get(self, "ignore_metrics_time")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="loadThreshold")
    def load_threshold(self) -> Optional[float]:
        return pulumi.get(self, "load_threshold")

    @property
    @pulumi.getter(name="memoryThreshold")
    def memory_threshold(self) -> Optional[float]:
        return pulumi.get(self, "memory_threshold")

    @property
    @pulumi.getter(name="thresholdsWaitTime")
    def thresholds_wait_time(self) -> Optional[int]:
        return pulumi.get(self, "thresholds_wait_time")


@pulumi.output_type
class MysqlLayerCloudwatchConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logStreams":
            suggest = "log_streams"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlLayerCloudwatchConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlLayerCloudwatchConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlLayerCloudwatchConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 log_streams: Optional[Sequence['outputs.MysqlLayerCloudwatchConfigurationLogStream']] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if log_streams is not None:
            pulumi.set(__self__, "log_streams", log_streams)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="logStreams")
    def log_streams(self) -> Optional[Sequence['outputs.MysqlLayerCloudwatchConfigurationLogStream']]:
        return pulumi.get(self, "log_streams")


@pulumi.output_type
class MysqlLayerCloudwatchConfigurationLogStream(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupName":
            suggest = "log_group_name"
        elif key == "batchCount":
            suggest = "batch_count"
        elif key == "batchSize":
            suggest = "batch_size"
        elif key == "bufferDuration":
            suggest = "buffer_duration"
        elif key == "datetimeFormat":
            suggest = "datetime_format"
        elif key == "fileFingerprintLines":
            suggest = "file_fingerprint_lines"
        elif key == "initialPosition":
            suggest = "initial_position"
        elif key == "multilineStartPattern":
            suggest = "multiline_start_pattern"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlLayerCloudwatchConfigurationLogStream. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlLayerCloudwatchConfigurationLogStream.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlLayerCloudwatchConfigurationLogStream.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file: str,
                 log_group_name: str,
                 batch_count: Optional[int] = None,
                 batch_size: Optional[int] = None,
                 buffer_duration: Optional[int] = None,
                 datetime_format: Optional[str] = None,
                 encoding: Optional[str] = None,
                 file_fingerprint_lines: Optional[str] = None,
                 initial_position: Optional[str] = None,
                 multiline_start_pattern: Optional[str] = None,
                 time_zone: Optional[str] = None):
        pulumi.set(__self__, "file", file)
        pulumi.set(__self__, "log_group_name", log_group_name)
        if batch_count is not None:
            pulumi.set(__self__, "batch_count", batch_count)
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if buffer_duration is not None:
            pulumi.set(__self__, "buffer_duration", buffer_duration)
        if datetime_format is not None:
            pulumi.set(__self__, "datetime_format", datetime_format)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if file_fingerprint_lines is not None:
            pulumi.set(__self__, "file_fingerprint_lines", file_fingerprint_lines)
        if initial_position is not None:
            pulumi.set(__self__, "initial_position", initial_position)
        if multiline_start_pattern is not None:
            pulumi.set(__self__, "multiline_start_pattern", multiline_start_pattern)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def file(self) -> str:
        return pulumi.get(self, "file")

    @property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> str:
        return pulumi.get(self, "log_group_name")

    @property
    @pulumi.getter(name="batchCount")
    def batch_count(self) -> Optional[int]:
        return pulumi.get(self, "batch_count")

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[int]:
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="bufferDuration")
    def buffer_duration(self) -> Optional[int]:
        return pulumi.get(self, "buffer_duration")

    @property
    @pulumi.getter(name="datetimeFormat")
    def datetime_format(self) -> Optional[str]:
        return pulumi.get(self, "datetime_format")

    @property
    @pulumi.getter
    def encoding(self) -> Optional[str]:
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter(name="fileFingerprintLines")
    def file_fingerprint_lines(self) -> Optional[str]:
        return pulumi.get(self, "file_fingerprint_lines")

    @property
    @pulumi.getter(name="initialPosition")
    def initial_position(self) -> Optional[str]:
        return pulumi.get(self, "initial_position")

    @property
    @pulumi.getter(name="multilineStartPattern")
    def multiline_start_pattern(self) -> Optional[str]:
        return pulumi.get(self, "multiline_start_pattern")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class MysqlLayerEbsVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPoint":
            suggest = "mount_point"
        elif key == "numberOfDisks":
            suggest = "number_of_disks"
        elif key == "raidLevel":
            suggest = "raid_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlLayerEbsVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlLayerEbsVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlLayerEbsVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_point: str,
                 number_of_disks: int,
                 size: int,
                 encrypted: Optional[bool] = None,
                 iops: Optional[int] = None,
                 raid_level: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str mount_point: The path to mount the EBS volume on the layer's instances.
        :param int number_of_disks: The number of disks to use for the EBS volume.
        :param int size: The size of the volume in gigabytes.
        :param int iops: For PIOPS volumes, the IOPS per disk.
        :param str raid_level: The RAID level to use for the volume.
        :param str type: The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "number_of_disks", number_of_disks)
        pulumi.set(__self__, "size", size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> str:
        """
        The path to mount the EBS volume on the layer's instances.
        """
        return pulumi.get(self, "mount_point")

    @property
    @pulumi.getter(name="numberOfDisks")
    def number_of_disks(self) -> int:
        """
        The number of disks to use for the EBS volume.
        """
        return pulumi.get(self, "number_of_disks")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of the volume in gigabytes.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        For PIOPS volumes, the IOPS per disk.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[str]:
        """
        The RAID level to use for the volume.
        """
        return pulumi.get(self, "raid_level")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MysqlLayerLoadBasedAutoScaling(dict):
    def __init__(__self__, *,
                 downscaling: Optional['outputs.MysqlLayerLoadBasedAutoScalingDownscaling'] = None,
                 enable: Optional[bool] = None,
                 upscaling: Optional['outputs.MysqlLayerLoadBasedAutoScalingUpscaling'] = None):
        if downscaling is not None:
            pulumi.set(__self__, "downscaling", downscaling)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if upscaling is not None:
            pulumi.set(__self__, "upscaling", upscaling)

    @property
    @pulumi.getter
    def downscaling(self) -> Optional['outputs.MysqlLayerLoadBasedAutoScalingDownscaling']:
        return pulumi.get(self, "downscaling")

    @property
    @pulumi.getter
    def enable(self) -> Optional[bool]:
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def upscaling(self) -> Optional['outputs.MysqlLayerLoadBasedAutoScalingUpscaling']:
        return pulumi.get(self, "upscaling")


@pulumi.output_type
class MysqlLayerLoadBasedAutoScalingDownscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuThreshold":
            suggest = "cpu_threshold"
        elif key == "ignoreMetricsTime":
            suggest = "ignore_metrics_time"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "loadThreshold":
            suggest = "load_threshold"
        elif key == "memoryThreshold":
            suggest = "memory_threshold"
        elif key == "thresholdsWaitTime":
            suggest = "thresholds_wait_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlLayerLoadBasedAutoScalingDownscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlLayerLoadBasedAutoScalingDownscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlLayerLoadBasedAutoScalingDownscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alarms: Optional[Sequence[str]] = None,
                 cpu_threshold: Optional[float] = None,
                 ignore_metrics_time: Optional[int] = None,
                 instance_count: Optional[int] = None,
                 load_threshold: Optional[float] = None,
                 memory_threshold: Optional[float] = None,
                 thresholds_wait_time: Optional[int] = None):
        if alarms is not None:
            pulumi.set(__self__, "alarms", alarms)
        if cpu_threshold is not None:
            pulumi.set(__self__, "cpu_threshold", cpu_threshold)
        if ignore_metrics_time is not None:
            pulumi.set(__self__, "ignore_metrics_time", ignore_metrics_time)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if load_threshold is not None:
            pulumi.set(__self__, "load_threshold", load_threshold)
        if memory_threshold is not None:
            pulumi.set(__self__, "memory_threshold", memory_threshold)
        if thresholds_wait_time is not None:
            pulumi.set(__self__, "thresholds_wait_time", thresholds_wait_time)

    @property
    @pulumi.getter
    def alarms(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "alarms")

    @property
    @pulumi.getter(name="cpuThreshold")
    def cpu_threshold(self) -> Optional[float]:
        return pulumi.get(self, "cpu_threshold")

    @property
    @pulumi.getter(name="ignoreMetricsTime")
    def ignore_metrics_time(self) -> Optional[int]:
        return pulumi.get(self, "ignore_metrics_time")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="loadThreshold")
    def load_threshold(self) -> Optional[float]:
        return pulumi.get(self, "load_threshold")

    @property
    @pulumi.getter(name="memoryThreshold")
    def memory_threshold(self) -> Optional[float]:
        return pulumi.get(self, "memory_threshold")

    @property
    @pulumi.getter(name="thresholdsWaitTime")
    def thresholds_wait_time(self) -> Optional[int]:
        return pulumi.get(self, "thresholds_wait_time")


@pulumi.output_type
class MysqlLayerLoadBasedAutoScalingUpscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuThreshold":
            suggest = "cpu_threshold"
        elif key == "ignoreMetricsTime":
            suggest = "ignore_metrics_time"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "loadThreshold":
            suggest = "load_threshold"
        elif key == "memoryThreshold":
            suggest = "memory_threshold"
        elif key == "thresholdsWaitTime":
            suggest = "thresholds_wait_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlLayerLoadBasedAutoScalingUpscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlLayerLoadBasedAutoScalingUpscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlLayerLoadBasedAutoScalingUpscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alarms: Optional[Sequence[str]] = None,
                 cpu_threshold: Optional[float] = None,
                 ignore_metrics_time: Optional[int] = None,
                 instance_count: Optional[int] = None,
                 load_threshold: Optional[float] = None,
                 memory_threshold: Optional[float] = None,
                 thresholds_wait_time: Optional[int] = None):
        if alarms is not None:
            pulumi.set(__self__, "alarms", alarms)
        if cpu_threshold is not None:
            pulumi.set(__self__, "cpu_threshold", cpu_threshold)
        if ignore_metrics_time is not None:
            pulumi.set(__self__, "ignore_metrics_time", ignore_metrics_time)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if load_threshold is not None:
            pulumi.set(__self__, "load_threshold", load_threshold)
        if memory_threshold is not None:
            pulumi.set(__self__, "memory_threshold", memory_threshold)
        if thresholds_wait_time is not None:
            pulumi.set(__self__, "thresholds_wait_time", thresholds_wait_time)

    @property
    @pulumi.getter
    def alarms(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "alarms")

    @property
    @pulumi.getter(name="cpuThreshold")
    def cpu_threshold(self) -> Optional[float]:
        return pulumi.get(self, "cpu_threshold")

    @property
    @pulumi.getter(name="ignoreMetricsTime")
    def ignore_metrics_time(self) -> Optional[int]:
        return pulumi.get(self, "ignore_metrics_time")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="loadThreshold")
    def load_threshold(self) -> Optional[float]:
        return pulumi.get(self, "load_threshold")

    @property
    @pulumi.getter(name="memoryThreshold")
    def memory_threshold(self) -> Optional[float]:
        return pulumi.get(self, "memory_threshold")

    @property
    @pulumi.getter(name="thresholdsWaitTime")
    def thresholds_wait_time(self) -> Optional[int]:
        return pulumi.get(self, "thresholds_wait_time")


@pulumi.output_type
class NodejsAppLayerCloudwatchConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logStreams":
            suggest = "log_streams"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodejsAppLayerCloudwatchConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodejsAppLayerCloudwatchConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodejsAppLayerCloudwatchConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 log_streams: Optional[Sequence['outputs.NodejsAppLayerCloudwatchConfigurationLogStream']] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if log_streams is not None:
            pulumi.set(__self__, "log_streams", log_streams)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="logStreams")
    def log_streams(self) -> Optional[Sequence['outputs.NodejsAppLayerCloudwatchConfigurationLogStream']]:
        return pulumi.get(self, "log_streams")


@pulumi.output_type
class NodejsAppLayerCloudwatchConfigurationLogStream(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupName":
            suggest = "log_group_name"
        elif key == "batchCount":
            suggest = "batch_count"
        elif key == "batchSize":
            suggest = "batch_size"
        elif key == "bufferDuration":
            suggest = "buffer_duration"
        elif key == "datetimeFormat":
            suggest = "datetime_format"
        elif key == "fileFingerprintLines":
            suggest = "file_fingerprint_lines"
        elif key == "initialPosition":
            suggest = "initial_position"
        elif key == "multilineStartPattern":
            suggest = "multiline_start_pattern"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodejsAppLayerCloudwatchConfigurationLogStream. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodejsAppLayerCloudwatchConfigurationLogStream.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodejsAppLayerCloudwatchConfigurationLogStream.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file: str,
                 log_group_name: str,
                 batch_count: Optional[int] = None,
                 batch_size: Optional[int] = None,
                 buffer_duration: Optional[int] = None,
                 datetime_format: Optional[str] = None,
                 encoding: Optional[str] = None,
                 file_fingerprint_lines: Optional[str] = None,
                 initial_position: Optional[str] = None,
                 multiline_start_pattern: Optional[str] = None,
                 time_zone: Optional[str] = None):
        pulumi.set(__self__, "file", file)
        pulumi.set(__self__, "log_group_name", log_group_name)
        if batch_count is not None:
            pulumi.set(__self__, "batch_count", batch_count)
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if buffer_duration is not None:
            pulumi.set(__self__, "buffer_duration", buffer_duration)
        if datetime_format is not None:
            pulumi.set(__self__, "datetime_format", datetime_format)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if file_fingerprint_lines is not None:
            pulumi.set(__self__, "file_fingerprint_lines", file_fingerprint_lines)
        if initial_position is not None:
            pulumi.set(__self__, "initial_position", initial_position)
        if multiline_start_pattern is not None:
            pulumi.set(__self__, "multiline_start_pattern", multiline_start_pattern)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def file(self) -> str:
        return pulumi.get(self, "file")

    @property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> str:
        return pulumi.get(self, "log_group_name")

    @property
    @pulumi.getter(name="batchCount")
    def batch_count(self) -> Optional[int]:
        return pulumi.get(self, "batch_count")

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[int]:
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="bufferDuration")
    def buffer_duration(self) -> Optional[int]:
        return pulumi.get(self, "buffer_duration")

    @property
    @pulumi.getter(name="datetimeFormat")
    def datetime_format(self) -> Optional[str]:
        return pulumi.get(self, "datetime_format")

    @property
    @pulumi.getter
    def encoding(self) -> Optional[str]:
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter(name="fileFingerprintLines")
    def file_fingerprint_lines(self) -> Optional[str]:
        return pulumi.get(self, "file_fingerprint_lines")

    @property
    @pulumi.getter(name="initialPosition")
    def initial_position(self) -> Optional[str]:
        return pulumi.get(self, "initial_position")

    @property
    @pulumi.getter(name="multilineStartPattern")
    def multiline_start_pattern(self) -> Optional[str]:
        return pulumi.get(self, "multiline_start_pattern")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class NodejsAppLayerEbsVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPoint":
            suggest = "mount_point"
        elif key == "numberOfDisks":
            suggest = "number_of_disks"
        elif key == "raidLevel":
            suggest = "raid_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodejsAppLayerEbsVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodejsAppLayerEbsVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodejsAppLayerEbsVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_point: str,
                 number_of_disks: int,
                 size: int,
                 encrypted: Optional[bool] = None,
                 iops: Optional[int] = None,
                 raid_level: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str mount_point: The path to mount the EBS volume on the layer's instances.
        :param int number_of_disks: The number of disks to use for the EBS volume.
        :param int size: The size of the volume in gigabytes.
        :param int iops: For PIOPS volumes, the IOPS per disk.
        :param str raid_level: The RAID level to use for the volume.
        :param str type: The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "number_of_disks", number_of_disks)
        pulumi.set(__self__, "size", size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> str:
        """
        The path to mount the EBS volume on the layer's instances.
        """
        return pulumi.get(self, "mount_point")

    @property
    @pulumi.getter(name="numberOfDisks")
    def number_of_disks(self) -> int:
        """
        The number of disks to use for the EBS volume.
        """
        return pulumi.get(self, "number_of_disks")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of the volume in gigabytes.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        For PIOPS volumes, the IOPS per disk.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[str]:
        """
        The RAID level to use for the volume.
        """
        return pulumi.get(self, "raid_level")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class NodejsAppLayerLoadBasedAutoScaling(dict):
    def __init__(__self__, *,
                 downscaling: Optional['outputs.NodejsAppLayerLoadBasedAutoScalingDownscaling'] = None,
                 enable: Optional[bool] = None,
                 upscaling: Optional['outputs.NodejsAppLayerLoadBasedAutoScalingUpscaling'] = None):
        if downscaling is not None:
            pulumi.set(__self__, "downscaling", downscaling)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if upscaling is not None:
            pulumi.set(__self__, "upscaling", upscaling)

    @property
    @pulumi.getter
    def downscaling(self) -> Optional['outputs.NodejsAppLayerLoadBasedAutoScalingDownscaling']:
        return pulumi.get(self, "downscaling")

    @property
    @pulumi.getter
    def enable(self) -> Optional[bool]:
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def upscaling(self) -> Optional['outputs.NodejsAppLayerLoadBasedAutoScalingUpscaling']:
        return pulumi.get(self, "upscaling")


@pulumi.output_type
class NodejsAppLayerLoadBasedAutoScalingDownscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuThreshold":
            suggest = "cpu_threshold"
        elif key == "ignoreMetricsTime":
            suggest = "ignore_metrics_time"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "loadThreshold":
            suggest = "load_threshold"
        elif key == "memoryThreshold":
            suggest = "memory_threshold"
        elif key == "thresholdsWaitTime":
            suggest = "thresholds_wait_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodejsAppLayerLoadBasedAutoScalingDownscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodejsAppLayerLoadBasedAutoScalingDownscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodejsAppLayerLoadBasedAutoScalingDownscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alarms: Optional[Sequence[str]] = None,
                 cpu_threshold: Optional[float] = None,
                 ignore_metrics_time: Optional[int] = None,
                 instance_count: Optional[int] = None,
                 load_threshold: Optional[float] = None,
                 memory_threshold: Optional[float] = None,
                 thresholds_wait_time: Optional[int] = None):
        if alarms is not None:
            pulumi.set(__self__, "alarms", alarms)
        if cpu_threshold is not None:
            pulumi.set(__self__, "cpu_threshold", cpu_threshold)
        if ignore_metrics_time is not None:
            pulumi.set(__self__, "ignore_metrics_time", ignore_metrics_time)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if load_threshold is not None:
            pulumi.set(__self__, "load_threshold", load_threshold)
        if memory_threshold is not None:
            pulumi.set(__self__, "memory_threshold", memory_threshold)
        if thresholds_wait_time is not None:
            pulumi.set(__self__, "thresholds_wait_time", thresholds_wait_time)

    @property
    @pulumi.getter
    def alarms(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "alarms")

    @property
    @pulumi.getter(name="cpuThreshold")
    def cpu_threshold(self) -> Optional[float]:
        return pulumi.get(self, "cpu_threshold")

    @property
    @pulumi.getter(name="ignoreMetricsTime")
    def ignore_metrics_time(self) -> Optional[int]:
        return pulumi.get(self, "ignore_metrics_time")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="loadThreshold")
    def load_threshold(self) -> Optional[float]:
        return pulumi.get(self, "load_threshold")

    @property
    @pulumi.getter(name="memoryThreshold")
    def memory_threshold(self) -> Optional[float]:
        return pulumi.get(self, "memory_threshold")

    @property
    @pulumi.getter(name="thresholdsWaitTime")
    def thresholds_wait_time(self) -> Optional[int]:
        return pulumi.get(self, "thresholds_wait_time")


@pulumi.output_type
class NodejsAppLayerLoadBasedAutoScalingUpscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuThreshold":
            suggest = "cpu_threshold"
        elif key == "ignoreMetricsTime":
            suggest = "ignore_metrics_time"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "loadThreshold":
            suggest = "load_threshold"
        elif key == "memoryThreshold":
            suggest = "memory_threshold"
        elif key == "thresholdsWaitTime":
            suggest = "thresholds_wait_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodejsAppLayerLoadBasedAutoScalingUpscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodejsAppLayerLoadBasedAutoScalingUpscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodejsAppLayerLoadBasedAutoScalingUpscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alarms: Optional[Sequence[str]] = None,
                 cpu_threshold: Optional[float] = None,
                 ignore_metrics_time: Optional[int] = None,
                 instance_count: Optional[int] = None,
                 load_threshold: Optional[float] = None,
                 memory_threshold: Optional[float] = None,
                 thresholds_wait_time: Optional[int] = None):
        if alarms is not None:
            pulumi.set(__self__, "alarms", alarms)
        if cpu_threshold is not None:
            pulumi.set(__self__, "cpu_threshold", cpu_threshold)
        if ignore_metrics_time is not None:
            pulumi.set(__self__, "ignore_metrics_time", ignore_metrics_time)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if load_threshold is not None:
            pulumi.set(__self__, "load_threshold", load_threshold)
        if memory_threshold is not None:
            pulumi.set(__self__, "memory_threshold", memory_threshold)
        if thresholds_wait_time is not None:
            pulumi.set(__self__, "thresholds_wait_time", thresholds_wait_time)

    @property
    @pulumi.getter
    def alarms(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "alarms")

    @property
    @pulumi.getter(name="cpuThreshold")
    def cpu_threshold(self) -> Optional[float]:
        return pulumi.get(self, "cpu_threshold")

    @property
    @pulumi.getter(name="ignoreMetricsTime")
    def ignore_metrics_time(self) -> Optional[int]:
        return pulumi.get(self, "ignore_metrics_time")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="loadThreshold")
    def load_threshold(self) -> Optional[float]:
        return pulumi.get(self, "load_threshold")

    @property
    @pulumi.getter(name="memoryThreshold")
    def memory_threshold(self) -> Optional[float]:
        return pulumi.get(self, "memory_threshold")

    @property
    @pulumi.getter(name="thresholdsWaitTime")
    def thresholds_wait_time(self) -> Optional[int]:
        return pulumi.get(self, "thresholds_wait_time")


@pulumi.output_type
class PhpAppLayerCloudwatchConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logStreams":
            suggest = "log_streams"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PhpAppLayerCloudwatchConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PhpAppLayerCloudwatchConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PhpAppLayerCloudwatchConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 log_streams: Optional[Sequence['outputs.PhpAppLayerCloudwatchConfigurationLogStream']] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if log_streams is not None:
            pulumi.set(__self__, "log_streams", log_streams)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="logStreams")
    def log_streams(self) -> Optional[Sequence['outputs.PhpAppLayerCloudwatchConfigurationLogStream']]:
        return pulumi.get(self, "log_streams")


@pulumi.output_type
class PhpAppLayerCloudwatchConfigurationLogStream(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupName":
            suggest = "log_group_name"
        elif key == "batchCount":
            suggest = "batch_count"
        elif key == "batchSize":
            suggest = "batch_size"
        elif key == "bufferDuration":
            suggest = "buffer_duration"
        elif key == "datetimeFormat":
            suggest = "datetime_format"
        elif key == "fileFingerprintLines":
            suggest = "file_fingerprint_lines"
        elif key == "initialPosition":
            suggest = "initial_position"
        elif key == "multilineStartPattern":
            suggest = "multiline_start_pattern"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PhpAppLayerCloudwatchConfigurationLogStream. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PhpAppLayerCloudwatchConfigurationLogStream.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PhpAppLayerCloudwatchConfigurationLogStream.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file: str,
                 log_group_name: str,
                 batch_count: Optional[int] = None,
                 batch_size: Optional[int] = None,
                 buffer_duration: Optional[int] = None,
                 datetime_format: Optional[str] = None,
                 encoding: Optional[str] = None,
                 file_fingerprint_lines: Optional[str] = None,
                 initial_position: Optional[str] = None,
                 multiline_start_pattern: Optional[str] = None,
                 time_zone: Optional[str] = None):
        pulumi.set(__self__, "file", file)
        pulumi.set(__self__, "log_group_name", log_group_name)
        if batch_count is not None:
            pulumi.set(__self__, "batch_count", batch_count)
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if buffer_duration is not None:
            pulumi.set(__self__, "buffer_duration", buffer_duration)
        if datetime_format is not None:
            pulumi.set(__self__, "datetime_format", datetime_format)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if file_fingerprint_lines is not None:
            pulumi.set(__self__, "file_fingerprint_lines", file_fingerprint_lines)
        if initial_position is not None:
            pulumi.set(__self__, "initial_position", initial_position)
        if multiline_start_pattern is not None:
            pulumi.set(__self__, "multiline_start_pattern", multiline_start_pattern)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def file(self) -> str:
        return pulumi.get(self, "file")

    @property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> str:
        return pulumi.get(self, "log_group_name")

    @property
    @pulumi.getter(name="batchCount")
    def batch_count(self) -> Optional[int]:
        return pulumi.get(self, "batch_count")

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[int]:
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="bufferDuration")
    def buffer_duration(self) -> Optional[int]:
        return pulumi.get(self, "buffer_duration")

    @property
    @pulumi.getter(name="datetimeFormat")
    def datetime_format(self) -> Optional[str]:
        return pulumi.get(self, "datetime_format")

    @property
    @pulumi.getter
    def encoding(self) -> Optional[str]:
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter(name="fileFingerprintLines")
    def file_fingerprint_lines(self) -> Optional[str]:
        return pulumi.get(self, "file_fingerprint_lines")

    @property
    @pulumi.getter(name="initialPosition")
    def initial_position(self) -> Optional[str]:
        return pulumi.get(self, "initial_position")

    @property
    @pulumi.getter(name="multilineStartPattern")
    def multiline_start_pattern(self) -> Optional[str]:
        return pulumi.get(self, "multiline_start_pattern")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class PhpAppLayerEbsVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPoint":
            suggest = "mount_point"
        elif key == "numberOfDisks":
            suggest = "number_of_disks"
        elif key == "raidLevel":
            suggest = "raid_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PhpAppLayerEbsVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PhpAppLayerEbsVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PhpAppLayerEbsVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_point: str,
                 number_of_disks: int,
                 size: int,
                 encrypted: Optional[bool] = None,
                 iops: Optional[int] = None,
                 raid_level: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str mount_point: The path to mount the EBS volume on the layer's instances.
        :param int number_of_disks: The number of disks to use for the EBS volume.
        :param int size: The size of the volume in gigabytes.
        :param int iops: For PIOPS volumes, the IOPS per disk.
        :param str raid_level: The RAID level to use for the volume.
        :param str type: The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "number_of_disks", number_of_disks)
        pulumi.set(__self__, "size", size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> str:
        """
        The path to mount the EBS volume on the layer's instances.
        """
        return pulumi.get(self, "mount_point")

    @property
    @pulumi.getter(name="numberOfDisks")
    def number_of_disks(self) -> int:
        """
        The number of disks to use for the EBS volume.
        """
        return pulumi.get(self, "number_of_disks")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of the volume in gigabytes.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        For PIOPS volumes, the IOPS per disk.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[str]:
        """
        The RAID level to use for the volume.
        """
        return pulumi.get(self, "raid_level")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PhpAppLayerLoadBasedAutoScaling(dict):
    def __init__(__self__, *,
                 downscaling: Optional['outputs.PhpAppLayerLoadBasedAutoScalingDownscaling'] = None,
                 enable: Optional[bool] = None,
                 upscaling: Optional['outputs.PhpAppLayerLoadBasedAutoScalingUpscaling'] = None):
        if downscaling is not None:
            pulumi.set(__self__, "downscaling", downscaling)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if upscaling is not None:
            pulumi.set(__self__, "upscaling", upscaling)

    @property
    @pulumi.getter
    def downscaling(self) -> Optional['outputs.PhpAppLayerLoadBasedAutoScalingDownscaling']:
        return pulumi.get(self, "downscaling")

    @property
    @pulumi.getter
    def enable(self) -> Optional[bool]:
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def upscaling(self) -> Optional['outputs.PhpAppLayerLoadBasedAutoScalingUpscaling']:
        return pulumi.get(self, "upscaling")


@pulumi.output_type
class PhpAppLayerLoadBasedAutoScalingDownscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuThreshold":
            suggest = "cpu_threshold"
        elif key == "ignoreMetricsTime":
            suggest = "ignore_metrics_time"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "loadThreshold":
            suggest = "load_threshold"
        elif key == "memoryThreshold":
            suggest = "memory_threshold"
        elif key == "thresholdsWaitTime":
            suggest = "thresholds_wait_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PhpAppLayerLoadBasedAutoScalingDownscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PhpAppLayerLoadBasedAutoScalingDownscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PhpAppLayerLoadBasedAutoScalingDownscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alarms: Optional[Sequence[str]] = None,
                 cpu_threshold: Optional[float] = None,
                 ignore_metrics_time: Optional[int] = None,
                 instance_count: Optional[int] = None,
                 load_threshold: Optional[float] = None,
                 memory_threshold: Optional[float] = None,
                 thresholds_wait_time: Optional[int] = None):
        if alarms is not None:
            pulumi.set(__self__, "alarms", alarms)
        if cpu_threshold is not None:
            pulumi.set(__self__, "cpu_threshold", cpu_threshold)
        if ignore_metrics_time is not None:
            pulumi.set(__self__, "ignore_metrics_time", ignore_metrics_time)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if load_threshold is not None:
            pulumi.set(__self__, "load_threshold", load_threshold)
        if memory_threshold is not None:
            pulumi.set(__self__, "memory_threshold", memory_threshold)
        if thresholds_wait_time is not None:
            pulumi.set(__self__, "thresholds_wait_time", thresholds_wait_time)

    @property
    @pulumi.getter
    def alarms(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "alarms")

    @property
    @pulumi.getter(name="cpuThreshold")
    def cpu_threshold(self) -> Optional[float]:
        return pulumi.get(self, "cpu_threshold")

    @property
    @pulumi.getter(name="ignoreMetricsTime")
    def ignore_metrics_time(self) -> Optional[int]:
        return pulumi.get(self, "ignore_metrics_time")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="loadThreshold")
    def load_threshold(self) -> Optional[float]:
        return pulumi.get(self, "load_threshold")

    @property
    @pulumi.getter(name="memoryThreshold")
    def memory_threshold(self) -> Optional[float]:
        return pulumi.get(self, "memory_threshold")

    @property
    @pulumi.getter(name="thresholdsWaitTime")
    def thresholds_wait_time(self) -> Optional[int]:
        return pulumi.get(self, "thresholds_wait_time")


@pulumi.output_type
class PhpAppLayerLoadBasedAutoScalingUpscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuThreshold":
            suggest = "cpu_threshold"
        elif key == "ignoreMetricsTime":
            suggest = "ignore_metrics_time"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "loadThreshold":
            suggest = "load_threshold"
        elif key == "memoryThreshold":
            suggest = "memory_threshold"
        elif key == "thresholdsWaitTime":
            suggest = "thresholds_wait_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PhpAppLayerLoadBasedAutoScalingUpscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PhpAppLayerLoadBasedAutoScalingUpscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PhpAppLayerLoadBasedAutoScalingUpscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alarms: Optional[Sequence[str]] = None,
                 cpu_threshold: Optional[float] = None,
                 ignore_metrics_time: Optional[int] = None,
                 instance_count: Optional[int] = None,
                 load_threshold: Optional[float] = None,
                 memory_threshold: Optional[float] = None,
                 thresholds_wait_time: Optional[int] = None):
        if alarms is not None:
            pulumi.set(__self__, "alarms", alarms)
        if cpu_threshold is not None:
            pulumi.set(__self__, "cpu_threshold", cpu_threshold)
        if ignore_metrics_time is not None:
            pulumi.set(__self__, "ignore_metrics_time", ignore_metrics_time)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if load_threshold is not None:
            pulumi.set(__self__, "load_threshold", load_threshold)
        if memory_threshold is not None:
            pulumi.set(__self__, "memory_threshold", memory_threshold)
        if thresholds_wait_time is not None:
            pulumi.set(__self__, "thresholds_wait_time", thresholds_wait_time)

    @property
    @pulumi.getter
    def alarms(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "alarms")

    @property
    @pulumi.getter(name="cpuThreshold")
    def cpu_threshold(self) -> Optional[float]:
        return pulumi.get(self, "cpu_threshold")

    @property
    @pulumi.getter(name="ignoreMetricsTime")
    def ignore_metrics_time(self) -> Optional[int]:
        return pulumi.get(self, "ignore_metrics_time")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="loadThreshold")
    def load_threshold(self) -> Optional[float]:
        return pulumi.get(self, "load_threshold")

    @property
    @pulumi.getter(name="memoryThreshold")
    def memory_threshold(self) -> Optional[float]:
        return pulumi.get(self, "memory_threshold")

    @property
    @pulumi.getter(name="thresholdsWaitTime")
    def thresholds_wait_time(self) -> Optional[int]:
        return pulumi.get(self, "thresholds_wait_time")


@pulumi.output_type
class RailsAppLayerCloudwatchConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logStreams":
            suggest = "log_streams"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RailsAppLayerCloudwatchConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RailsAppLayerCloudwatchConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RailsAppLayerCloudwatchConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 log_streams: Optional[Sequence['outputs.RailsAppLayerCloudwatchConfigurationLogStream']] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if log_streams is not None:
            pulumi.set(__self__, "log_streams", log_streams)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="logStreams")
    def log_streams(self) -> Optional[Sequence['outputs.RailsAppLayerCloudwatchConfigurationLogStream']]:
        return pulumi.get(self, "log_streams")


@pulumi.output_type
class RailsAppLayerCloudwatchConfigurationLogStream(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupName":
            suggest = "log_group_name"
        elif key == "batchCount":
            suggest = "batch_count"
        elif key == "batchSize":
            suggest = "batch_size"
        elif key == "bufferDuration":
            suggest = "buffer_duration"
        elif key == "datetimeFormat":
            suggest = "datetime_format"
        elif key == "fileFingerprintLines":
            suggest = "file_fingerprint_lines"
        elif key == "initialPosition":
            suggest = "initial_position"
        elif key == "multilineStartPattern":
            suggest = "multiline_start_pattern"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RailsAppLayerCloudwatchConfigurationLogStream. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RailsAppLayerCloudwatchConfigurationLogStream.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RailsAppLayerCloudwatchConfigurationLogStream.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file: str,
                 log_group_name: str,
                 batch_count: Optional[int] = None,
                 batch_size: Optional[int] = None,
                 buffer_duration: Optional[int] = None,
                 datetime_format: Optional[str] = None,
                 encoding: Optional[str] = None,
                 file_fingerprint_lines: Optional[str] = None,
                 initial_position: Optional[str] = None,
                 multiline_start_pattern: Optional[str] = None,
                 time_zone: Optional[str] = None):
        pulumi.set(__self__, "file", file)
        pulumi.set(__self__, "log_group_name", log_group_name)
        if batch_count is not None:
            pulumi.set(__self__, "batch_count", batch_count)
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if buffer_duration is not None:
            pulumi.set(__self__, "buffer_duration", buffer_duration)
        if datetime_format is not None:
            pulumi.set(__self__, "datetime_format", datetime_format)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if file_fingerprint_lines is not None:
            pulumi.set(__self__, "file_fingerprint_lines", file_fingerprint_lines)
        if initial_position is not None:
            pulumi.set(__self__, "initial_position", initial_position)
        if multiline_start_pattern is not None:
            pulumi.set(__self__, "multiline_start_pattern", multiline_start_pattern)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def file(self) -> str:
        return pulumi.get(self, "file")

    @property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> str:
        return pulumi.get(self, "log_group_name")

    @property
    @pulumi.getter(name="batchCount")
    def batch_count(self) -> Optional[int]:
        return pulumi.get(self, "batch_count")

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[int]:
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="bufferDuration")
    def buffer_duration(self) -> Optional[int]:
        return pulumi.get(self, "buffer_duration")

    @property
    @pulumi.getter(name="datetimeFormat")
    def datetime_format(self) -> Optional[str]:
        return pulumi.get(self, "datetime_format")

    @property
    @pulumi.getter
    def encoding(self) -> Optional[str]:
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter(name="fileFingerprintLines")
    def file_fingerprint_lines(self) -> Optional[str]:
        return pulumi.get(self, "file_fingerprint_lines")

    @property
    @pulumi.getter(name="initialPosition")
    def initial_position(self) -> Optional[str]:
        return pulumi.get(self, "initial_position")

    @property
    @pulumi.getter(name="multilineStartPattern")
    def multiline_start_pattern(self) -> Optional[str]:
        return pulumi.get(self, "multiline_start_pattern")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class RailsAppLayerEbsVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPoint":
            suggest = "mount_point"
        elif key == "numberOfDisks":
            suggest = "number_of_disks"
        elif key == "raidLevel":
            suggest = "raid_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RailsAppLayerEbsVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RailsAppLayerEbsVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RailsAppLayerEbsVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_point: str,
                 number_of_disks: int,
                 size: int,
                 encrypted: Optional[bool] = None,
                 iops: Optional[int] = None,
                 raid_level: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str mount_point: The path to mount the EBS volume on the layer's instances.
        :param int number_of_disks: The number of disks to use for the EBS volume.
        :param int size: The size of the volume in gigabytes.
        :param int iops: For PIOPS volumes, the IOPS per disk.
        :param str raid_level: The RAID level to use for the volume.
        :param str type: The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "number_of_disks", number_of_disks)
        pulumi.set(__self__, "size", size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> str:
        """
        The path to mount the EBS volume on the layer's instances.
        """
        return pulumi.get(self, "mount_point")

    @property
    @pulumi.getter(name="numberOfDisks")
    def number_of_disks(self) -> int:
        """
        The number of disks to use for the EBS volume.
        """
        return pulumi.get(self, "number_of_disks")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of the volume in gigabytes.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        For PIOPS volumes, the IOPS per disk.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[str]:
        """
        The RAID level to use for the volume.
        """
        return pulumi.get(self, "raid_level")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RailsAppLayerLoadBasedAutoScaling(dict):
    def __init__(__self__, *,
                 downscaling: Optional['outputs.RailsAppLayerLoadBasedAutoScalingDownscaling'] = None,
                 enable: Optional[bool] = None,
                 upscaling: Optional['outputs.RailsAppLayerLoadBasedAutoScalingUpscaling'] = None):
        if downscaling is not None:
            pulumi.set(__self__, "downscaling", downscaling)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if upscaling is not None:
            pulumi.set(__self__, "upscaling", upscaling)

    @property
    @pulumi.getter
    def downscaling(self) -> Optional['outputs.RailsAppLayerLoadBasedAutoScalingDownscaling']:
        return pulumi.get(self, "downscaling")

    @property
    @pulumi.getter
    def enable(self) -> Optional[bool]:
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def upscaling(self) -> Optional['outputs.RailsAppLayerLoadBasedAutoScalingUpscaling']:
        return pulumi.get(self, "upscaling")


@pulumi.output_type
class RailsAppLayerLoadBasedAutoScalingDownscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuThreshold":
            suggest = "cpu_threshold"
        elif key == "ignoreMetricsTime":
            suggest = "ignore_metrics_time"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "loadThreshold":
            suggest = "load_threshold"
        elif key == "memoryThreshold":
            suggest = "memory_threshold"
        elif key == "thresholdsWaitTime":
            suggest = "thresholds_wait_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RailsAppLayerLoadBasedAutoScalingDownscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RailsAppLayerLoadBasedAutoScalingDownscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RailsAppLayerLoadBasedAutoScalingDownscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alarms: Optional[Sequence[str]] = None,
                 cpu_threshold: Optional[float] = None,
                 ignore_metrics_time: Optional[int] = None,
                 instance_count: Optional[int] = None,
                 load_threshold: Optional[float] = None,
                 memory_threshold: Optional[float] = None,
                 thresholds_wait_time: Optional[int] = None):
        if alarms is not None:
            pulumi.set(__self__, "alarms", alarms)
        if cpu_threshold is not None:
            pulumi.set(__self__, "cpu_threshold", cpu_threshold)
        if ignore_metrics_time is not None:
            pulumi.set(__self__, "ignore_metrics_time", ignore_metrics_time)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if load_threshold is not None:
            pulumi.set(__self__, "load_threshold", load_threshold)
        if memory_threshold is not None:
            pulumi.set(__self__, "memory_threshold", memory_threshold)
        if thresholds_wait_time is not None:
            pulumi.set(__self__, "thresholds_wait_time", thresholds_wait_time)

    @property
    @pulumi.getter
    def alarms(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "alarms")

    @property
    @pulumi.getter(name="cpuThreshold")
    def cpu_threshold(self) -> Optional[float]:
        return pulumi.get(self, "cpu_threshold")

    @property
    @pulumi.getter(name="ignoreMetricsTime")
    def ignore_metrics_time(self) -> Optional[int]:
        return pulumi.get(self, "ignore_metrics_time")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="loadThreshold")
    def load_threshold(self) -> Optional[float]:
        return pulumi.get(self, "load_threshold")

    @property
    @pulumi.getter(name="memoryThreshold")
    def memory_threshold(self) -> Optional[float]:
        return pulumi.get(self, "memory_threshold")

    @property
    @pulumi.getter(name="thresholdsWaitTime")
    def thresholds_wait_time(self) -> Optional[int]:
        return pulumi.get(self, "thresholds_wait_time")


@pulumi.output_type
class RailsAppLayerLoadBasedAutoScalingUpscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuThreshold":
            suggest = "cpu_threshold"
        elif key == "ignoreMetricsTime":
            suggest = "ignore_metrics_time"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "loadThreshold":
            suggest = "load_threshold"
        elif key == "memoryThreshold":
            suggest = "memory_threshold"
        elif key == "thresholdsWaitTime":
            suggest = "thresholds_wait_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RailsAppLayerLoadBasedAutoScalingUpscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RailsAppLayerLoadBasedAutoScalingUpscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RailsAppLayerLoadBasedAutoScalingUpscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alarms: Optional[Sequence[str]] = None,
                 cpu_threshold: Optional[float] = None,
                 ignore_metrics_time: Optional[int] = None,
                 instance_count: Optional[int] = None,
                 load_threshold: Optional[float] = None,
                 memory_threshold: Optional[float] = None,
                 thresholds_wait_time: Optional[int] = None):
        if alarms is not None:
            pulumi.set(__self__, "alarms", alarms)
        if cpu_threshold is not None:
            pulumi.set(__self__, "cpu_threshold", cpu_threshold)
        if ignore_metrics_time is not None:
            pulumi.set(__self__, "ignore_metrics_time", ignore_metrics_time)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if load_threshold is not None:
            pulumi.set(__self__, "load_threshold", load_threshold)
        if memory_threshold is not None:
            pulumi.set(__self__, "memory_threshold", memory_threshold)
        if thresholds_wait_time is not None:
            pulumi.set(__self__, "thresholds_wait_time", thresholds_wait_time)

    @property
    @pulumi.getter
    def alarms(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "alarms")

    @property
    @pulumi.getter(name="cpuThreshold")
    def cpu_threshold(self) -> Optional[float]:
        return pulumi.get(self, "cpu_threshold")

    @property
    @pulumi.getter(name="ignoreMetricsTime")
    def ignore_metrics_time(self) -> Optional[int]:
        return pulumi.get(self, "ignore_metrics_time")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="loadThreshold")
    def load_threshold(self) -> Optional[float]:
        return pulumi.get(self, "load_threshold")

    @property
    @pulumi.getter(name="memoryThreshold")
    def memory_threshold(self) -> Optional[float]:
        return pulumi.get(self, "memory_threshold")

    @property
    @pulumi.getter(name="thresholdsWaitTime")
    def thresholds_wait_time(self) -> Optional[int]:
        return pulumi.get(self, "thresholds_wait_time")


@pulumi.output_type
class StackCustomCookbooksSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sshKey":
            suggest = "ssh_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StackCustomCookbooksSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StackCustomCookbooksSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StackCustomCookbooksSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 url: str,
                 password: Optional[str] = None,
                 revision: Optional[str] = None,
                 ssh_key: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str type: The type of source to use. For example, "archive".
        :param str url: The URL where the cookbooks resource can be found.
        :param str password: Password to use when authenticating to the source. The provider cannot perform drift detection of this configuration.
        :param str revision: For sources that are version-aware, the revision to use.
        :param str ssh_key: SSH key to use when authenticating to the source. This provider cannot perform drift detection of this configuration.
        :param str username: Username to use when authenticating to the source.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "url", url)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if ssh_key is not None:
            pulumi.set(__self__, "ssh_key", ssh_key)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of source to use. For example, "archive".
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The URL where the cookbooks resource can be found.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password to use when authenticating to the source. The provider cannot perform drift detection of this configuration.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def revision(self) -> Optional[str]:
        """
        For sources that are version-aware, the revision to use.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> Optional[str]:
        """
        SSH key to use when authenticating to the source. This provider cannot perform drift detection of this configuration.
        """
        return pulumi.get(self, "ssh_key")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username to use when authenticating to the source.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class StaticWebLayerCloudwatchConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logStreams":
            suggest = "log_streams"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StaticWebLayerCloudwatchConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StaticWebLayerCloudwatchConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StaticWebLayerCloudwatchConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 log_streams: Optional[Sequence['outputs.StaticWebLayerCloudwatchConfigurationLogStream']] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if log_streams is not None:
            pulumi.set(__self__, "log_streams", log_streams)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="logStreams")
    def log_streams(self) -> Optional[Sequence['outputs.StaticWebLayerCloudwatchConfigurationLogStream']]:
        return pulumi.get(self, "log_streams")


@pulumi.output_type
class StaticWebLayerCloudwatchConfigurationLogStream(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupName":
            suggest = "log_group_name"
        elif key == "batchCount":
            suggest = "batch_count"
        elif key == "batchSize":
            suggest = "batch_size"
        elif key == "bufferDuration":
            suggest = "buffer_duration"
        elif key == "datetimeFormat":
            suggest = "datetime_format"
        elif key == "fileFingerprintLines":
            suggest = "file_fingerprint_lines"
        elif key == "initialPosition":
            suggest = "initial_position"
        elif key == "multilineStartPattern":
            suggest = "multiline_start_pattern"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StaticWebLayerCloudwatchConfigurationLogStream. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StaticWebLayerCloudwatchConfigurationLogStream.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StaticWebLayerCloudwatchConfigurationLogStream.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file: str,
                 log_group_name: str,
                 batch_count: Optional[int] = None,
                 batch_size: Optional[int] = None,
                 buffer_duration: Optional[int] = None,
                 datetime_format: Optional[str] = None,
                 encoding: Optional[str] = None,
                 file_fingerprint_lines: Optional[str] = None,
                 initial_position: Optional[str] = None,
                 multiline_start_pattern: Optional[str] = None,
                 time_zone: Optional[str] = None):
        pulumi.set(__self__, "file", file)
        pulumi.set(__self__, "log_group_name", log_group_name)
        if batch_count is not None:
            pulumi.set(__self__, "batch_count", batch_count)
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if buffer_duration is not None:
            pulumi.set(__self__, "buffer_duration", buffer_duration)
        if datetime_format is not None:
            pulumi.set(__self__, "datetime_format", datetime_format)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if file_fingerprint_lines is not None:
            pulumi.set(__self__, "file_fingerprint_lines", file_fingerprint_lines)
        if initial_position is not None:
            pulumi.set(__self__, "initial_position", initial_position)
        if multiline_start_pattern is not None:
            pulumi.set(__self__, "multiline_start_pattern", multiline_start_pattern)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def file(self) -> str:
        return pulumi.get(self, "file")

    @property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> str:
        return pulumi.get(self, "log_group_name")

    @property
    @pulumi.getter(name="batchCount")
    def batch_count(self) -> Optional[int]:
        return pulumi.get(self, "batch_count")

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[int]:
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="bufferDuration")
    def buffer_duration(self) -> Optional[int]:
        return pulumi.get(self, "buffer_duration")

    @property
    @pulumi.getter(name="datetimeFormat")
    def datetime_format(self) -> Optional[str]:
        return pulumi.get(self, "datetime_format")

    @property
    @pulumi.getter
    def encoding(self) -> Optional[str]:
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter(name="fileFingerprintLines")
    def file_fingerprint_lines(self) -> Optional[str]:
        return pulumi.get(self, "file_fingerprint_lines")

    @property
    @pulumi.getter(name="initialPosition")
    def initial_position(self) -> Optional[str]:
        return pulumi.get(self, "initial_position")

    @property
    @pulumi.getter(name="multilineStartPattern")
    def multiline_start_pattern(self) -> Optional[str]:
        return pulumi.get(self, "multiline_start_pattern")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class StaticWebLayerEbsVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPoint":
            suggest = "mount_point"
        elif key == "numberOfDisks":
            suggest = "number_of_disks"
        elif key == "raidLevel":
            suggest = "raid_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StaticWebLayerEbsVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StaticWebLayerEbsVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StaticWebLayerEbsVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_point: str,
                 number_of_disks: int,
                 size: int,
                 encrypted: Optional[bool] = None,
                 iops: Optional[int] = None,
                 raid_level: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str mount_point: The path to mount the EBS volume on the layer's instances.
        :param int number_of_disks: The number of disks to use for the EBS volume.
        :param int size: The size of the volume in gigabytes.
        :param int iops: For PIOPS volumes, the IOPS per disk.
        :param str raid_level: The RAID level to use for the volume.
        :param str type: The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "number_of_disks", number_of_disks)
        pulumi.set(__self__, "size", size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if raid_level is not None:
            pulumi.set(__self__, "raid_level", raid_level)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> str:
        """
        The path to mount the EBS volume on the layer's instances.
        """
        return pulumi.get(self, "mount_point")

    @property
    @pulumi.getter(name="numberOfDisks")
    def number_of_disks(self) -> int:
        """
        The number of disks to use for the EBS volume.
        """
        return pulumi.get(self, "number_of_disks")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of the volume in gigabytes.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        For PIOPS volumes, the IOPS per disk.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="raidLevel")
    def raid_level(self) -> Optional[str]:
        """
        The RAID level to use for the volume.
        """
        return pulumi.get(self, "raid_level")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of volume to create. This may be `standard` (the default), `io1` or `gp2`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class StaticWebLayerLoadBasedAutoScaling(dict):
    def __init__(__self__, *,
                 downscaling: Optional['outputs.StaticWebLayerLoadBasedAutoScalingDownscaling'] = None,
                 enable: Optional[bool] = None,
                 upscaling: Optional['outputs.StaticWebLayerLoadBasedAutoScalingUpscaling'] = None):
        if downscaling is not None:
            pulumi.set(__self__, "downscaling", downscaling)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if upscaling is not None:
            pulumi.set(__self__, "upscaling", upscaling)

    @property
    @pulumi.getter
    def downscaling(self) -> Optional['outputs.StaticWebLayerLoadBasedAutoScalingDownscaling']:
        return pulumi.get(self, "downscaling")

    @property
    @pulumi.getter
    def enable(self) -> Optional[bool]:
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def upscaling(self) -> Optional['outputs.StaticWebLayerLoadBasedAutoScalingUpscaling']:
        return pulumi.get(self, "upscaling")


@pulumi.output_type
class StaticWebLayerLoadBasedAutoScalingDownscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuThreshold":
            suggest = "cpu_threshold"
        elif key == "ignoreMetricsTime":
            suggest = "ignore_metrics_time"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "loadThreshold":
            suggest = "load_threshold"
        elif key == "memoryThreshold":
            suggest = "memory_threshold"
        elif key == "thresholdsWaitTime":
            suggest = "thresholds_wait_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StaticWebLayerLoadBasedAutoScalingDownscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StaticWebLayerLoadBasedAutoScalingDownscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StaticWebLayerLoadBasedAutoScalingDownscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alarms: Optional[Sequence[str]] = None,
                 cpu_threshold: Optional[float] = None,
                 ignore_metrics_time: Optional[int] = None,
                 instance_count: Optional[int] = None,
                 load_threshold: Optional[float] = None,
                 memory_threshold: Optional[float] = None,
                 thresholds_wait_time: Optional[int] = None):
        if alarms is not None:
            pulumi.set(__self__, "alarms", alarms)
        if cpu_threshold is not None:
            pulumi.set(__self__, "cpu_threshold", cpu_threshold)
        if ignore_metrics_time is not None:
            pulumi.set(__self__, "ignore_metrics_time", ignore_metrics_time)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if load_threshold is not None:
            pulumi.set(__self__, "load_threshold", load_threshold)
        if memory_threshold is not None:
            pulumi.set(__self__, "memory_threshold", memory_threshold)
        if thresholds_wait_time is not None:
            pulumi.set(__self__, "thresholds_wait_time", thresholds_wait_time)

    @property
    @pulumi.getter
    def alarms(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "alarms")

    @property
    @pulumi.getter(name="cpuThreshold")
    def cpu_threshold(self) -> Optional[float]:
        return pulumi.get(self, "cpu_threshold")

    @property
    @pulumi.getter(name="ignoreMetricsTime")
    def ignore_metrics_time(self) -> Optional[int]:
        return pulumi.get(self, "ignore_metrics_time")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="loadThreshold")
    def load_threshold(self) -> Optional[float]:
        return pulumi.get(self, "load_threshold")

    @property
    @pulumi.getter(name="memoryThreshold")
    def memory_threshold(self) -> Optional[float]:
        return pulumi.get(self, "memory_threshold")

    @property
    @pulumi.getter(name="thresholdsWaitTime")
    def thresholds_wait_time(self) -> Optional[int]:
        return pulumi.get(self, "thresholds_wait_time")


@pulumi.output_type
class StaticWebLayerLoadBasedAutoScalingUpscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuThreshold":
            suggest = "cpu_threshold"
        elif key == "ignoreMetricsTime":
            suggest = "ignore_metrics_time"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "loadThreshold":
            suggest = "load_threshold"
        elif key == "memoryThreshold":
            suggest = "memory_threshold"
        elif key == "thresholdsWaitTime":
            suggest = "thresholds_wait_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StaticWebLayerLoadBasedAutoScalingUpscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StaticWebLayerLoadBasedAutoScalingUpscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StaticWebLayerLoadBasedAutoScalingUpscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alarms: Optional[Sequence[str]] = None,
                 cpu_threshold: Optional[float] = None,
                 ignore_metrics_time: Optional[int] = None,
                 instance_count: Optional[int] = None,
                 load_threshold: Optional[float] = None,
                 memory_threshold: Optional[float] = None,
                 thresholds_wait_time: Optional[int] = None):
        if alarms is not None:
            pulumi.set(__self__, "alarms", alarms)
        if cpu_threshold is not None:
            pulumi.set(__self__, "cpu_threshold", cpu_threshold)
        if ignore_metrics_time is not None:
            pulumi.set(__self__, "ignore_metrics_time", ignore_metrics_time)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if load_threshold is not None:
            pulumi.set(__self__, "load_threshold", load_threshold)
        if memory_threshold is not None:
            pulumi.set(__self__, "memory_threshold", memory_threshold)
        if thresholds_wait_time is not None:
            pulumi.set(__self__, "thresholds_wait_time", thresholds_wait_time)

    @property
    @pulumi.getter
    def alarms(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "alarms")

    @property
    @pulumi.getter(name="cpuThreshold")
    def cpu_threshold(self) -> Optional[float]:
        return pulumi.get(self, "cpu_threshold")

    @property
    @pulumi.getter(name="ignoreMetricsTime")
    def ignore_metrics_time(self) -> Optional[int]:
        return pulumi.get(self, "ignore_metrics_time")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="loadThreshold")
    def load_threshold(self) -> Optional[float]:
        return pulumi.get(self, "load_threshold")

    @property
    @pulumi.getter(name="memoryThreshold")
    def memory_threshold(self) -> Optional[float]:
        return pulumi.get(self, "memory_threshold")

    @property
    @pulumi.getter(name="thresholdsWaitTime")
    def thresholds_wait_time(self) -> Optional[int]:
        return pulumi.get(self, "thresholds_wait_time")


