# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetOrganizationalUnitsResult',
    'AwaitableGetOrganizationalUnitsResult',
    'get_organizational_units',
    'get_organizational_units_output',
]

@pulumi.output_type
class GetOrganizationalUnitsResult:
    """
    A collection of values returned by getOrganizationalUnits.
    """
    def __init__(__self__, children=None, id=None, parent_id=None):
        if children and not isinstance(children, list):
            raise TypeError("Expected argument 'children' to be a list")
        pulumi.set(__self__, "children", children)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if parent_id and not isinstance(parent_id, str):
            raise TypeError("Expected argument 'parent_id' to be a str")
        pulumi.set(__self__, "parent_id", parent_id)

    @property
    @pulumi.getter
    def children(self) -> Sequence['outputs.GetOrganizationalUnitsChildResult']:
        """
        List of child organizational units, which have the following attributes:
        """
        return pulumi.get(self, "children")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> str:
        return pulumi.get(self, "parent_id")


class AwaitableGetOrganizationalUnitsResult(GetOrganizationalUnitsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrganizationalUnitsResult(
            children=self.children,
            id=self.id,
            parent_id=self.parent_id)


def get_organizational_units(parent_id: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrganizationalUnitsResult:
    """
    Get all direct child organizational units under a parent organizational unit. This only provides immediate children, not all children.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    org = aws.organizations.get_organization()
    ou = aws.organizations.get_organizational_units(parent_id=org.roots[0].id)
    ```
    <!--End PulumiCodeChooser -->


    :param str parent_id: Parent ID of the organizational unit.
    """
    __args__ = dict()
    __args__['parentId'] = parent_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:organizations/getOrganizationalUnits:getOrganizationalUnits', __args__, opts=opts, typ=GetOrganizationalUnitsResult).value

    return AwaitableGetOrganizationalUnitsResult(
        children=pulumi.get(__ret__, 'children'),
        id=pulumi.get(__ret__, 'id'),
        parent_id=pulumi.get(__ret__, 'parent_id'))


@_utilities.lift_output_func(get_organizational_units)
def get_organizational_units_output(parent_id: Optional[pulumi.Input[str]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOrganizationalUnitsResult]:
    """
    Get all direct child organizational units under a parent organizational unit. This only provides immediate children, not all children.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_aws as aws

    org = aws.organizations.get_organization()
    ou = aws.organizations.get_organizational_units(parent_id=org.roots[0].id)
    ```
    <!--End PulumiCodeChooser -->


    :param str parent_id: Parent ID of the organizational unit.
    """
    ...
