# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AccountSubscriptionArgs', 'AccountSubscription']

@pulumi.input_type
class AccountSubscriptionArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[str],
                 authentication_method: pulumi.Input[str],
                 edition: pulumi.Input[str],
                 notification_email: pulumi.Input[str],
                 active_directory_name: Optional[pulumi.Input[str]] = None,
                 admin_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 author_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 aws_account_id: Optional[pulumi.Input[str]] = None,
                 contact_number: Optional[pulumi.Input[str]] = None,
                 directory_id: Optional[pulumi.Input[str]] = None,
                 email_address: Optional[pulumi.Input[str]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 reader_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 realm: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AccountSubscription resource.
        :param pulumi.Input[str] account_name: Name of your Amazon QuickSight account. This name is unique over all of AWS, and it appears only when users sign in.
        :param pulumi.Input[str] authentication_method: Method that you want to use to authenticate your Amazon QuickSight account. Currently, the valid values for this parameter are `IAM_AND_QUICKSIGHT`, `IAM_ONLY`, `IAM_IDENTITY_CENTER`, and `ACTIVE_DIRECTORY`.
        :param pulumi.Input[str] edition: Edition of Amazon QuickSight that you want your account to have. Currently, you can choose from `STANDARD`, `ENTERPRISE` or `ENTERPRISE_AND_Q`.
        :param pulumi.Input[str] notification_email: Email address that you want Amazon QuickSight to send notifications to regarding your Amazon QuickSight account or Amazon QuickSight subscription.
               
               The following arguments are optional:
        :param pulumi.Input[str] active_directory_name: Name of your Active Directory. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] admin_groups: Admin group associated with your Active Directory. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] author_groups: Author group associated with your Active Directory.
        :param pulumi.Input[str] aws_account_id: AWS account ID hosting the QuickSight account. Default to provider account.
        :param pulumi.Input[str] contact_number: A 10-digit phone number for the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
        :param pulumi.Input[str] directory_id: Active Directory ID that is associated with your Amazon QuickSight account.
        :param pulumi.Input[str] email_address: Email address of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
        :param pulumi.Input[str] first_name: First name of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
        :param pulumi.Input[str] last_name: Last name of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] reader_groups: Reader group associated with your Active Direcrtory.
        :param pulumi.Input[str] realm: Realm of the Active Directory that is associated with your Amazon QuickSight account.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "authentication_method", authentication_method)
        pulumi.set(__self__, "edition", edition)
        pulumi.set(__self__, "notification_email", notification_email)
        if active_directory_name is not None:
            pulumi.set(__self__, "active_directory_name", active_directory_name)
        if admin_groups is not None:
            pulumi.set(__self__, "admin_groups", admin_groups)
        if author_groups is not None:
            pulumi.set(__self__, "author_groups", author_groups)
        if aws_account_id is not None:
            pulumi.set(__self__, "aws_account_id", aws_account_id)
        if contact_number is not None:
            pulumi.set(__self__, "contact_number", contact_number)
        if directory_id is not None:
            pulumi.set(__self__, "directory_id", directory_id)
        if email_address is not None:
            pulumi.set(__self__, "email_address", email_address)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if reader_groups is not None:
            pulumi.set(__self__, "reader_groups", reader_groups)
        if realm is not None:
            pulumi.set(__self__, "realm", realm)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[str]:
        """
        Name of your Amazon QuickSight account. This name is unique over all of AWS, and it appears only when users sign in.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="authenticationMethod")
    def authentication_method(self) -> pulumi.Input[str]:
        """
        Method that you want to use to authenticate your Amazon QuickSight account. Currently, the valid values for this parameter are `IAM_AND_QUICKSIGHT`, `IAM_ONLY`, `IAM_IDENTITY_CENTER`, and `ACTIVE_DIRECTORY`.
        """
        return pulumi.get(self, "authentication_method")

    @authentication_method.setter
    def authentication_method(self, value: pulumi.Input[str]):
        pulumi.set(self, "authentication_method", value)

    @property
    @pulumi.getter
    def edition(self) -> pulumi.Input[str]:
        """
        Edition of Amazon QuickSight that you want your account to have. Currently, you can choose from `STANDARD`, `ENTERPRISE` or `ENTERPRISE_AND_Q`.
        """
        return pulumi.get(self, "edition")

    @edition.setter
    def edition(self, value: pulumi.Input[str]):
        pulumi.set(self, "edition", value)

    @property
    @pulumi.getter(name="notificationEmail")
    def notification_email(self) -> pulumi.Input[str]:
        """
        Email address that you want Amazon QuickSight to send notifications to regarding your Amazon QuickSight account or Amazon QuickSight subscription.

        The following arguments are optional:
        """
        return pulumi.get(self, "notification_email")

    @notification_email.setter
    def notification_email(self, value: pulumi.Input[str]):
        pulumi.set(self, "notification_email", value)

    @property
    @pulumi.getter(name="activeDirectoryName")
    def active_directory_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of your Active Directory. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account.
        """
        return pulumi.get(self, "active_directory_name")

    @active_directory_name.setter
    def active_directory_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "active_directory_name", value)

    @property
    @pulumi.getter(name="adminGroups")
    def admin_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Admin group associated with your Active Directory. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account.
        """
        return pulumi.get(self, "admin_groups")

    @admin_groups.setter
    def admin_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "admin_groups", value)

    @property
    @pulumi.getter(name="authorGroups")
    def author_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Author group associated with your Active Directory.
        """
        return pulumi.get(self, "author_groups")

    @author_groups.setter
    def author_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "author_groups", value)

    @property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        AWS account ID hosting the QuickSight account. Default to provider account.
        """
        return pulumi.get(self, "aws_account_id")

    @aws_account_id.setter
    def aws_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_account_id", value)

    @property
    @pulumi.getter(name="contactNumber")
    def contact_number(self) -> Optional[pulumi.Input[str]]:
        """
        A 10-digit phone number for the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
        """
        return pulumi.get(self, "contact_number")

    @contact_number.setter
    def contact_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "contact_number", value)

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> Optional[pulumi.Input[str]]:
        """
        Active Directory ID that is associated with your Amazon QuickSight account.
        """
        return pulumi.get(self, "directory_id")

    @directory_id.setter
    def directory_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "directory_id", value)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> Optional[pulumi.Input[str]]:
        """
        Email address of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
        """
        return pulumi.get(self, "email_address")

    @email_address.setter
    def email_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_address", value)

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[str]]:
        """
        First name of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "first_name", value)

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[str]]:
        """
        Last name of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_name", value)

    @property
    @pulumi.getter(name="readerGroups")
    def reader_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Reader group associated with your Active Direcrtory.
        """
        return pulumi.get(self, "reader_groups")

    @reader_groups.setter
    def reader_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "reader_groups", value)

    @property
    @pulumi.getter
    def realm(self) -> Optional[pulumi.Input[str]]:
        """
        Realm of the Active Directory that is associated with your Amazon QuickSight account.
        """
        return pulumi.get(self, "realm")

    @realm.setter
    def realm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "realm", value)


@pulumi.input_type
class _AccountSubscriptionState:
    def __init__(__self__, *,
                 account_name: Optional[pulumi.Input[str]] = None,
                 account_subscription_status: Optional[pulumi.Input[str]] = None,
                 active_directory_name: Optional[pulumi.Input[str]] = None,
                 admin_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 authentication_method: Optional[pulumi.Input[str]] = None,
                 author_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 aws_account_id: Optional[pulumi.Input[str]] = None,
                 contact_number: Optional[pulumi.Input[str]] = None,
                 directory_id: Optional[pulumi.Input[str]] = None,
                 edition: Optional[pulumi.Input[str]] = None,
                 email_address: Optional[pulumi.Input[str]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 notification_email: Optional[pulumi.Input[str]] = None,
                 reader_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 realm: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AccountSubscription resources.
        :param pulumi.Input[str] account_name: Name of your Amazon QuickSight account. This name is unique over all of AWS, and it appears only when users sign in.
        :param pulumi.Input[str] account_subscription_status: Status of the Amazon QuickSight account's subscription.
        :param pulumi.Input[str] active_directory_name: Name of your Active Directory. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] admin_groups: Admin group associated with your Active Directory. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account.
        :param pulumi.Input[str] authentication_method: Method that you want to use to authenticate your Amazon QuickSight account. Currently, the valid values for this parameter are `IAM_AND_QUICKSIGHT`, `IAM_ONLY`, `IAM_IDENTITY_CENTER`, and `ACTIVE_DIRECTORY`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] author_groups: Author group associated with your Active Directory.
        :param pulumi.Input[str] aws_account_id: AWS account ID hosting the QuickSight account. Default to provider account.
        :param pulumi.Input[str] contact_number: A 10-digit phone number for the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
        :param pulumi.Input[str] directory_id: Active Directory ID that is associated with your Amazon QuickSight account.
        :param pulumi.Input[str] edition: Edition of Amazon QuickSight that you want your account to have. Currently, you can choose from `STANDARD`, `ENTERPRISE` or `ENTERPRISE_AND_Q`.
        :param pulumi.Input[str] email_address: Email address of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
        :param pulumi.Input[str] first_name: First name of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
        :param pulumi.Input[str] last_name: Last name of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
        :param pulumi.Input[str] notification_email: Email address that you want Amazon QuickSight to send notifications to regarding your Amazon QuickSight account or Amazon QuickSight subscription.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[str]]] reader_groups: Reader group associated with your Active Direcrtory.
        :param pulumi.Input[str] realm: Realm of the Active Directory that is associated with your Amazon QuickSight account.
        """
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if account_subscription_status is not None:
            pulumi.set(__self__, "account_subscription_status", account_subscription_status)
        if active_directory_name is not None:
            pulumi.set(__self__, "active_directory_name", active_directory_name)
        if admin_groups is not None:
            pulumi.set(__self__, "admin_groups", admin_groups)
        if authentication_method is not None:
            pulumi.set(__self__, "authentication_method", authentication_method)
        if author_groups is not None:
            pulumi.set(__self__, "author_groups", author_groups)
        if aws_account_id is not None:
            pulumi.set(__self__, "aws_account_id", aws_account_id)
        if contact_number is not None:
            pulumi.set(__self__, "contact_number", contact_number)
        if directory_id is not None:
            pulumi.set(__self__, "directory_id", directory_id)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if email_address is not None:
            pulumi.set(__self__, "email_address", email_address)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if notification_email is not None:
            pulumi.set(__self__, "notification_email", notification_email)
        if reader_groups is not None:
            pulumi.set(__self__, "reader_groups", reader_groups)
        if realm is not None:
            pulumi.set(__self__, "realm", realm)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of your Amazon QuickSight account. This name is unique over all of AWS, and it appears only when users sign in.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="accountSubscriptionStatus")
    def account_subscription_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the Amazon QuickSight account's subscription.
        """
        return pulumi.get(self, "account_subscription_status")

    @account_subscription_status.setter
    def account_subscription_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_subscription_status", value)

    @property
    @pulumi.getter(name="activeDirectoryName")
    def active_directory_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of your Active Directory. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account.
        """
        return pulumi.get(self, "active_directory_name")

    @active_directory_name.setter
    def active_directory_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "active_directory_name", value)

    @property
    @pulumi.getter(name="adminGroups")
    def admin_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Admin group associated with your Active Directory. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account.
        """
        return pulumi.get(self, "admin_groups")

    @admin_groups.setter
    def admin_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "admin_groups", value)

    @property
    @pulumi.getter(name="authenticationMethod")
    def authentication_method(self) -> Optional[pulumi.Input[str]]:
        """
        Method that you want to use to authenticate your Amazon QuickSight account. Currently, the valid values for this parameter are `IAM_AND_QUICKSIGHT`, `IAM_ONLY`, `IAM_IDENTITY_CENTER`, and `ACTIVE_DIRECTORY`.
        """
        return pulumi.get(self, "authentication_method")

    @authentication_method.setter
    def authentication_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authentication_method", value)

    @property
    @pulumi.getter(name="authorGroups")
    def author_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Author group associated with your Active Directory.
        """
        return pulumi.get(self, "author_groups")

    @author_groups.setter
    def author_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "author_groups", value)

    @property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        AWS account ID hosting the QuickSight account. Default to provider account.
        """
        return pulumi.get(self, "aws_account_id")

    @aws_account_id.setter
    def aws_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_account_id", value)

    @property
    @pulumi.getter(name="contactNumber")
    def contact_number(self) -> Optional[pulumi.Input[str]]:
        """
        A 10-digit phone number for the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
        """
        return pulumi.get(self, "contact_number")

    @contact_number.setter
    def contact_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "contact_number", value)

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> Optional[pulumi.Input[str]]:
        """
        Active Directory ID that is associated with your Amazon QuickSight account.
        """
        return pulumi.get(self, "directory_id")

    @directory_id.setter
    def directory_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "directory_id", value)

    @property
    @pulumi.getter
    def edition(self) -> Optional[pulumi.Input[str]]:
        """
        Edition of Amazon QuickSight that you want your account to have. Currently, you can choose from `STANDARD`, `ENTERPRISE` or `ENTERPRISE_AND_Q`.
        """
        return pulumi.get(self, "edition")

    @edition.setter
    def edition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "edition", value)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> Optional[pulumi.Input[str]]:
        """
        Email address of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
        """
        return pulumi.get(self, "email_address")

    @email_address.setter
    def email_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_address", value)

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[str]]:
        """
        First name of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "first_name", value)

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[str]]:
        """
        Last name of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_name", value)

    @property
    @pulumi.getter(name="notificationEmail")
    def notification_email(self) -> Optional[pulumi.Input[str]]:
        """
        Email address that you want Amazon QuickSight to send notifications to regarding your Amazon QuickSight account or Amazon QuickSight subscription.

        The following arguments are optional:
        """
        return pulumi.get(self, "notification_email")

    @notification_email.setter
    def notification_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notification_email", value)

    @property
    @pulumi.getter(name="readerGroups")
    def reader_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Reader group associated with your Active Direcrtory.
        """
        return pulumi.get(self, "reader_groups")

    @reader_groups.setter
    def reader_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "reader_groups", value)

    @property
    @pulumi.getter
    def realm(self) -> Optional[pulumi.Input[str]]:
        """
        Realm of the Active Directory that is associated with your Amazon QuickSight account.
        """
        return pulumi.get(self, "realm")

    @realm.setter
    def realm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "realm", value)


class AccountSubscription(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 active_directory_name: Optional[pulumi.Input[str]] = None,
                 admin_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 authentication_method: Optional[pulumi.Input[str]] = None,
                 author_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 aws_account_id: Optional[pulumi.Input[str]] = None,
                 contact_number: Optional[pulumi.Input[str]] = None,
                 directory_id: Optional[pulumi.Input[str]] = None,
                 edition: Optional[pulumi.Input[str]] = None,
                 email_address: Optional[pulumi.Input[str]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 notification_email: Optional[pulumi.Input[str]] = None,
                 reader_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 realm: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS QuickSight Account Subscription.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        subscription = aws.quicksight.AccountSubscription("subscription",
            account_name="quicksight-pulumi",
            authentication_method="IAM_AND_QUICKSIGHT",
            edition="ENTERPRISE",
            notification_email="notification@email.com")
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        You cannot import this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_name: Name of your Amazon QuickSight account. This name is unique over all of AWS, and it appears only when users sign in.
        :param pulumi.Input[str] active_directory_name: Name of your Active Directory. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] admin_groups: Admin group associated with your Active Directory. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account.
        :param pulumi.Input[str] authentication_method: Method that you want to use to authenticate your Amazon QuickSight account. Currently, the valid values for this parameter are `IAM_AND_QUICKSIGHT`, `IAM_ONLY`, `IAM_IDENTITY_CENTER`, and `ACTIVE_DIRECTORY`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] author_groups: Author group associated with your Active Directory.
        :param pulumi.Input[str] aws_account_id: AWS account ID hosting the QuickSight account. Default to provider account.
        :param pulumi.Input[str] contact_number: A 10-digit phone number for the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
        :param pulumi.Input[str] directory_id: Active Directory ID that is associated with your Amazon QuickSight account.
        :param pulumi.Input[str] edition: Edition of Amazon QuickSight that you want your account to have. Currently, you can choose from `STANDARD`, `ENTERPRISE` or `ENTERPRISE_AND_Q`.
        :param pulumi.Input[str] email_address: Email address of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
        :param pulumi.Input[str] first_name: First name of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
        :param pulumi.Input[str] last_name: Last name of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
        :param pulumi.Input[str] notification_email: Email address that you want Amazon QuickSight to send notifications to regarding your Amazon QuickSight account or Amazon QuickSight subscription.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[str]]] reader_groups: Reader group associated with your Active Direcrtory.
        :param pulumi.Input[str] realm: Realm of the Active Directory that is associated with your Amazon QuickSight account.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountSubscriptionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS QuickSight Account Subscription.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        subscription = aws.quicksight.AccountSubscription("subscription",
            account_name="quicksight-pulumi",
            authentication_method="IAM_AND_QUICKSIGHT",
            edition="ENTERPRISE",
            notification_email="notification@email.com")
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        You cannot import this resource.

        :param str resource_name: The name of the resource.
        :param AccountSubscriptionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountSubscriptionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 active_directory_name: Optional[pulumi.Input[str]] = None,
                 admin_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 authentication_method: Optional[pulumi.Input[str]] = None,
                 author_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 aws_account_id: Optional[pulumi.Input[str]] = None,
                 contact_number: Optional[pulumi.Input[str]] = None,
                 directory_id: Optional[pulumi.Input[str]] = None,
                 edition: Optional[pulumi.Input[str]] = None,
                 email_address: Optional[pulumi.Input[str]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 notification_email: Optional[pulumi.Input[str]] = None,
                 reader_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 realm: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountSubscriptionArgs.__new__(AccountSubscriptionArgs)

            if account_name is None and not opts.urn:
                raise TypeError("Missing required property 'account_name'")
            __props__.__dict__["account_name"] = account_name
            __props__.__dict__["active_directory_name"] = active_directory_name
            __props__.__dict__["admin_groups"] = admin_groups
            if authentication_method is None and not opts.urn:
                raise TypeError("Missing required property 'authentication_method'")
            __props__.__dict__["authentication_method"] = authentication_method
            __props__.__dict__["author_groups"] = author_groups
            __props__.__dict__["aws_account_id"] = aws_account_id
            __props__.__dict__["contact_number"] = contact_number
            __props__.__dict__["directory_id"] = directory_id
            if edition is None and not opts.urn:
                raise TypeError("Missing required property 'edition'")
            __props__.__dict__["edition"] = edition
            __props__.__dict__["email_address"] = email_address
            __props__.__dict__["first_name"] = first_name
            __props__.__dict__["last_name"] = last_name
            if notification_email is None and not opts.urn:
                raise TypeError("Missing required property 'notification_email'")
            __props__.__dict__["notification_email"] = notification_email
            __props__.__dict__["reader_groups"] = reader_groups
            __props__.__dict__["realm"] = realm
            __props__.__dict__["account_subscription_status"] = None
        super(AccountSubscription, __self__).__init__(
            'aws:quicksight/accountSubscription:AccountSubscription',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_name: Optional[pulumi.Input[str]] = None,
            account_subscription_status: Optional[pulumi.Input[str]] = None,
            active_directory_name: Optional[pulumi.Input[str]] = None,
            admin_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            authentication_method: Optional[pulumi.Input[str]] = None,
            author_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            aws_account_id: Optional[pulumi.Input[str]] = None,
            contact_number: Optional[pulumi.Input[str]] = None,
            directory_id: Optional[pulumi.Input[str]] = None,
            edition: Optional[pulumi.Input[str]] = None,
            email_address: Optional[pulumi.Input[str]] = None,
            first_name: Optional[pulumi.Input[str]] = None,
            last_name: Optional[pulumi.Input[str]] = None,
            notification_email: Optional[pulumi.Input[str]] = None,
            reader_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            realm: Optional[pulumi.Input[str]] = None) -> 'AccountSubscription':
        """
        Get an existing AccountSubscription resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_name: Name of your Amazon QuickSight account. This name is unique over all of AWS, and it appears only when users sign in.
        :param pulumi.Input[str] account_subscription_status: Status of the Amazon QuickSight account's subscription.
        :param pulumi.Input[str] active_directory_name: Name of your Active Directory. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] admin_groups: Admin group associated with your Active Directory. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account.
        :param pulumi.Input[str] authentication_method: Method that you want to use to authenticate your Amazon QuickSight account. Currently, the valid values for this parameter are `IAM_AND_QUICKSIGHT`, `IAM_ONLY`, `IAM_IDENTITY_CENTER`, and `ACTIVE_DIRECTORY`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] author_groups: Author group associated with your Active Directory.
        :param pulumi.Input[str] aws_account_id: AWS account ID hosting the QuickSight account. Default to provider account.
        :param pulumi.Input[str] contact_number: A 10-digit phone number for the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
        :param pulumi.Input[str] directory_id: Active Directory ID that is associated with your Amazon QuickSight account.
        :param pulumi.Input[str] edition: Edition of Amazon QuickSight that you want your account to have. Currently, you can choose from `STANDARD`, `ENTERPRISE` or `ENTERPRISE_AND_Q`.
        :param pulumi.Input[str] email_address: Email address of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
        :param pulumi.Input[str] first_name: First name of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
        :param pulumi.Input[str] last_name: Last name of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
        :param pulumi.Input[str] notification_email: Email address that you want Amazon QuickSight to send notifications to regarding your Amazon QuickSight account or Amazon QuickSight subscription.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[str]]] reader_groups: Reader group associated with your Active Direcrtory.
        :param pulumi.Input[str] realm: Realm of the Active Directory that is associated with your Amazon QuickSight account.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountSubscriptionState.__new__(_AccountSubscriptionState)

        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["account_subscription_status"] = account_subscription_status
        __props__.__dict__["active_directory_name"] = active_directory_name
        __props__.__dict__["admin_groups"] = admin_groups
        __props__.__dict__["authentication_method"] = authentication_method
        __props__.__dict__["author_groups"] = author_groups
        __props__.__dict__["aws_account_id"] = aws_account_id
        __props__.__dict__["contact_number"] = contact_number
        __props__.__dict__["directory_id"] = directory_id
        __props__.__dict__["edition"] = edition
        __props__.__dict__["email_address"] = email_address
        __props__.__dict__["first_name"] = first_name
        __props__.__dict__["last_name"] = last_name
        __props__.__dict__["notification_email"] = notification_email
        __props__.__dict__["reader_groups"] = reader_groups
        __props__.__dict__["realm"] = realm
        return AccountSubscription(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[str]:
        """
        Name of your Amazon QuickSight account. This name is unique over all of AWS, and it appears only when users sign in.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="accountSubscriptionStatus")
    def account_subscription_status(self) -> pulumi.Output[str]:
        """
        Status of the Amazon QuickSight account's subscription.
        """
        return pulumi.get(self, "account_subscription_status")

    @property
    @pulumi.getter(name="activeDirectoryName")
    def active_directory_name(self) -> pulumi.Output[Optional[str]]:
        """
        Name of your Active Directory. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account.
        """
        return pulumi.get(self, "active_directory_name")

    @property
    @pulumi.getter(name="adminGroups")
    def admin_groups(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Admin group associated with your Active Directory. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account.
        """
        return pulumi.get(self, "admin_groups")

    @property
    @pulumi.getter(name="authenticationMethod")
    def authentication_method(self) -> pulumi.Output[str]:
        """
        Method that you want to use to authenticate your Amazon QuickSight account. Currently, the valid values for this parameter are `IAM_AND_QUICKSIGHT`, `IAM_ONLY`, `IAM_IDENTITY_CENTER`, and `ACTIVE_DIRECTORY`.
        """
        return pulumi.get(self, "authentication_method")

    @property
    @pulumi.getter(name="authorGroups")
    def author_groups(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Author group associated with your Active Directory.
        """
        return pulumi.get(self, "author_groups")

    @property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> pulumi.Output[str]:
        """
        AWS account ID hosting the QuickSight account. Default to provider account.
        """
        return pulumi.get(self, "aws_account_id")

    @property
    @pulumi.getter(name="contactNumber")
    def contact_number(self) -> pulumi.Output[Optional[str]]:
        """
        A 10-digit phone number for the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
        """
        return pulumi.get(self, "contact_number")

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> pulumi.Output[Optional[str]]:
        """
        Active Directory ID that is associated with your Amazon QuickSight account.
        """
        return pulumi.get(self, "directory_id")

    @property
    @pulumi.getter
    def edition(self) -> pulumi.Output[str]:
        """
        Edition of Amazon QuickSight that you want your account to have. Currently, you can choose from `STANDARD`, `ENTERPRISE` or `ENTERPRISE_AND_Q`.
        """
        return pulumi.get(self, "edition")

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> pulumi.Output[Optional[str]]:
        """
        Email address of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> pulumi.Output[Optional[str]]:
        """
        First name of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> pulumi.Output[Optional[str]]:
        """
        Last name of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter(name="notificationEmail")
    def notification_email(self) -> pulumi.Output[str]:
        """
        Email address that you want Amazon QuickSight to send notifications to regarding your Amazon QuickSight account or Amazon QuickSight subscription.

        The following arguments are optional:
        """
        return pulumi.get(self, "notification_email")

    @property
    @pulumi.getter(name="readerGroups")
    def reader_groups(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Reader group associated with your Active Direcrtory.
        """
        return pulumi.get(self, "reader_groups")

    @property
    @pulumi.getter
    def realm(self) -> pulumi.Output[Optional[str]]:
        """
        Realm of the Active Directory that is associated with your Amazon QuickSight account.
        """
        return pulumi.get(self, "realm")

