# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DataSetArgs', 'DataSet']

@pulumi.input_type
class DataSetArgs:
    def __init__(__self__, *,
                 data_set_id: pulumi.Input[str],
                 import_mode: pulumi.Input[str],
                 aws_account_id: Optional[pulumi.Input[str]] = None,
                 column_groups: Optional[pulumi.Input[Sequence[pulumi.Input['DataSetColumnGroupArgs']]]] = None,
                 column_level_permission_rules: Optional[pulumi.Input[Sequence[pulumi.Input['DataSetColumnLevelPermissionRuleArgs']]]] = None,
                 data_set_usage_configuration: Optional[pulumi.Input['DataSetDataSetUsageConfigurationArgs']] = None,
                 field_folders: Optional[pulumi.Input[Sequence[pulumi.Input['DataSetFieldFolderArgs']]]] = None,
                 logical_table_maps: Optional[pulumi.Input[Sequence[pulumi.Input['DataSetLogicalTableMapArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input['DataSetPermissionArgs']]]] = None,
                 physical_table_maps: Optional[pulumi.Input[Sequence[pulumi.Input['DataSetPhysicalTableMapArgs']]]] = None,
                 refresh_properties: Optional[pulumi.Input['DataSetRefreshPropertiesArgs']] = None,
                 row_level_permission_data_set: Optional[pulumi.Input['DataSetRowLevelPermissionDataSetArgs']] = None,
                 row_level_permission_tag_configuration: Optional[pulumi.Input['DataSetRowLevelPermissionTagConfigurationArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a DataSet resource.
        :param pulumi.Input[str] data_set_id: Identifier for the data set.
        :param pulumi.Input[str] import_mode: Indicates whether you want to import the data into SPICE. Valid values are `SPICE` and `DIRECT_QUERY`.
        :param pulumi.Input[str] aws_account_id: AWS account ID.
        :param pulumi.Input[Sequence[pulumi.Input['DataSetColumnGroupArgs']]] column_groups: Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported. See column_groups.
        :param pulumi.Input[Sequence[pulumi.Input['DataSetColumnLevelPermissionRuleArgs']]] column_level_permission_rules: A set of 1 or more definitions of a [ColumnLevelPermissionRule](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html). See column_level_permission_rules.
        :param pulumi.Input['DataSetDataSetUsageConfigurationArgs'] data_set_usage_configuration: The usage configuration to apply to child datasets that reference this dataset as a source. See data_set_usage_configuration.
        :param pulumi.Input[Sequence[pulumi.Input['DataSetFieldFolderArgs']]] field_folders: The folder that contains fields and nested subfolders for your dataset. See field_folders.
        :param pulumi.Input[Sequence[pulumi.Input['DataSetLogicalTableMapArgs']]] logical_table_maps: Configures the combination and transformation of the data from the physical tables. Maximum of 1 entry. See logical_table_map.
        :param pulumi.Input[str] name: Display name for the dataset.
        :param pulumi.Input[Sequence[pulumi.Input['DataSetPermissionArgs']]] permissions: A set of resource permissions on the data source. Maximum of 64 items. See permissions.
        :param pulumi.Input[Sequence[pulumi.Input['DataSetPhysicalTableMapArgs']]] physical_table_maps: Declares the physical tables that are available in the underlying data sources. See physical_table_map.
               
               The following arguments are optional:
        :param pulumi.Input['DataSetRefreshPropertiesArgs'] refresh_properties: The refresh properties for the data set. **NOTE**: Only valid when `import_mode` is set to `SPICE`. See refresh_properties.
        :param pulumi.Input['DataSetRowLevelPermissionDataSetArgs'] row_level_permission_data_set: The row-level security configuration for the data that you want to create. See row_level_permission_data_set.
        :param pulumi.Input['DataSetRowLevelPermissionTagConfigurationArgs'] row_level_permission_tag_configuration: The configuration of tags on a dataset to set row-level security. Row-level security tags are currently supported for anonymous embedding only. See row_level_permission_tag_configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "data_set_id", data_set_id)
        pulumi.set(__self__, "import_mode", import_mode)
        if aws_account_id is not None:
            pulumi.set(__self__, "aws_account_id", aws_account_id)
        if column_groups is not None:
            pulumi.set(__self__, "column_groups", column_groups)
        if column_level_permission_rules is not None:
            pulumi.set(__self__, "column_level_permission_rules", column_level_permission_rules)
        if data_set_usage_configuration is not None:
            pulumi.set(__self__, "data_set_usage_configuration", data_set_usage_configuration)
        if field_folders is not None:
            pulumi.set(__self__, "field_folders", field_folders)
        if logical_table_maps is not None:
            pulumi.set(__self__, "logical_table_maps", logical_table_maps)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if physical_table_maps is not None:
            pulumi.set(__self__, "physical_table_maps", physical_table_maps)
        if refresh_properties is not None:
            pulumi.set(__self__, "refresh_properties", refresh_properties)
        if row_level_permission_data_set is not None:
            pulumi.set(__self__, "row_level_permission_data_set", row_level_permission_data_set)
        if row_level_permission_tag_configuration is not None:
            pulumi.set(__self__, "row_level_permission_tag_configuration", row_level_permission_tag_configuration)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="dataSetId")
    def data_set_id(self) -> pulumi.Input[str]:
        """
        Identifier for the data set.
        """
        return pulumi.get(self, "data_set_id")

    @data_set_id.setter
    def data_set_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_set_id", value)

    @property
    @pulumi.getter(name="importMode")
    def import_mode(self) -> pulumi.Input[str]:
        """
        Indicates whether you want to import the data into SPICE. Valid values are `SPICE` and `DIRECT_QUERY`.
        """
        return pulumi.get(self, "import_mode")

    @import_mode.setter
    def import_mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "import_mode", value)

    @property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        AWS account ID.
        """
        return pulumi.get(self, "aws_account_id")

    @aws_account_id.setter
    def aws_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_account_id", value)

    @property
    @pulumi.getter(name="columnGroups")
    def column_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataSetColumnGroupArgs']]]]:
        """
        Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported. See column_groups.
        """
        return pulumi.get(self, "column_groups")

    @column_groups.setter
    def column_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataSetColumnGroupArgs']]]]):
        pulumi.set(self, "column_groups", value)

    @property
    @pulumi.getter(name="columnLevelPermissionRules")
    def column_level_permission_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataSetColumnLevelPermissionRuleArgs']]]]:
        """
        A set of 1 or more definitions of a [ColumnLevelPermissionRule](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html). See column_level_permission_rules.
        """
        return pulumi.get(self, "column_level_permission_rules")

    @column_level_permission_rules.setter
    def column_level_permission_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataSetColumnLevelPermissionRuleArgs']]]]):
        pulumi.set(self, "column_level_permission_rules", value)

    @property
    @pulumi.getter(name="dataSetUsageConfiguration")
    def data_set_usage_configuration(self) -> Optional[pulumi.Input['DataSetDataSetUsageConfigurationArgs']]:
        """
        The usage configuration to apply to child datasets that reference this dataset as a source. See data_set_usage_configuration.
        """
        return pulumi.get(self, "data_set_usage_configuration")

    @data_set_usage_configuration.setter
    def data_set_usage_configuration(self, value: Optional[pulumi.Input['DataSetDataSetUsageConfigurationArgs']]):
        pulumi.set(self, "data_set_usage_configuration", value)

    @property
    @pulumi.getter(name="fieldFolders")
    def field_folders(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataSetFieldFolderArgs']]]]:
        """
        The folder that contains fields and nested subfolders for your dataset. See field_folders.
        """
        return pulumi.get(self, "field_folders")

    @field_folders.setter
    def field_folders(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataSetFieldFolderArgs']]]]):
        pulumi.set(self, "field_folders", value)

    @property
    @pulumi.getter(name="logicalTableMaps")
    def logical_table_maps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataSetLogicalTableMapArgs']]]]:
        """
        Configures the combination and transformation of the data from the physical tables. Maximum of 1 entry. See logical_table_map.
        """
        return pulumi.get(self, "logical_table_maps")

    @logical_table_maps.setter
    def logical_table_maps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataSetLogicalTableMapArgs']]]]):
        pulumi.set(self, "logical_table_maps", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Display name for the dataset.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataSetPermissionArgs']]]]:
        """
        A set of resource permissions on the data source. Maximum of 64 items. See permissions.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataSetPermissionArgs']]]]):
        pulumi.set(self, "permissions", value)

    @property
    @pulumi.getter(name="physicalTableMaps")
    def physical_table_maps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataSetPhysicalTableMapArgs']]]]:
        """
        Declares the physical tables that are available in the underlying data sources. See physical_table_map.

        The following arguments are optional:
        """
        return pulumi.get(self, "physical_table_maps")

    @physical_table_maps.setter
    def physical_table_maps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataSetPhysicalTableMapArgs']]]]):
        pulumi.set(self, "physical_table_maps", value)

    @property
    @pulumi.getter(name="refreshProperties")
    def refresh_properties(self) -> Optional[pulumi.Input['DataSetRefreshPropertiesArgs']]:
        """
        The refresh properties for the data set. **NOTE**: Only valid when `import_mode` is set to `SPICE`. See refresh_properties.
        """
        return pulumi.get(self, "refresh_properties")

    @refresh_properties.setter
    def refresh_properties(self, value: Optional[pulumi.Input['DataSetRefreshPropertiesArgs']]):
        pulumi.set(self, "refresh_properties", value)

    @property
    @pulumi.getter(name="rowLevelPermissionDataSet")
    def row_level_permission_data_set(self) -> Optional[pulumi.Input['DataSetRowLevelPermissionDataSetArgs']]:
        """
        The row-level security configuration for the data that you want to create. See row_level_permission_data_set.
        """
        return pulumi.get(self, "row_level_permission_data_set")

    @row_level_permission_data_set.setter
    def row_level_permission_data_set(self, value: Optional[pulumi.Input['DataSetRowLevelPermissionDataSetArgs']]):
        pulumi.set(self, "row_level_permission_data_set", value)

    @property
    @pulumi.getter(name="rowLevelPermissionTagConfiguration")
    def row_level_permission_tag_configuration(self) -> Optional[pulumi.Input['DataSetRowLevelPermissionTagConfigurationArgs']]:
        """
        The configuration of tags on a dataset to set row-level security. Row-level security tags are currently supported for anonymous embedding only. See row_level_permission_tag_configuration.
        """
        return pulumi.get(self, "row_level_permission_tag_configuration")

    @row_level_permission_tag_configuration.setter
    def row_level_permission_tag_configuration(self, value: Optional[pulumi.Input['DataSetRowLevelPermissionTagConfigurationArgs']]):
        pulumi.set(self, "row_level_permission_tag_configuration", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DataSetState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 aws_account_id: Optional[pulumi.Input[str]] = None,
                 column_groups: Optional[pulumi.Input[Sequence[pulumi.Input['DataSetColumnGroupArgs']]]] = None,
                 column_level_permission_rules: Optional[pulumi.Input[Sequence[pulumi.Input['DataSetColumnLevelPermissionRuleArgs']]]] = None,
                 data_set_id: Optional[pulumi.Input[str]] = None,
                 data_set_usage_configuration: Optional[pulumi.Input['DataSetDataSetUsageConfigurationArgs']] = None,
                 field_folders: Optional[pulumi.Input[Sequence[pulumi.Input['DataSetFieldFolderArgs']]]] = None,
                 import_mode: Optional[pulumi.Input[str]] = None,
                 logical_table_maps: Optional[pulumi.Input[Sequence[pulumi.Input['DataSetLogicalTableMapArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_columns: Optional[pulumi.Input[Sequence[pulumi.Input['DataSetOutputColumnArgs']]]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input['DataSetPermissionArgs']]]] = None,
                 physical_table_maps: Optional[pulumi.Input[Sequence[pulumi.Input['DataSetPhysicalTableMapArgs']]]] = None,
                 refresh_properties: Optional[pulumi.Input['DataSetRefreshPropertiesArgs']] = None,
                 row_level_permission_data_set: Optional[pulumi.Input['DataSetRowLevelPermissionDataSetArgs']] = None,
                 row_level_permission_tag_configuration: Optional[pulumi.Input['DataSetRowLevelPermissionTagConfigurationArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering DataSet resources.
        :param pulumi.Input[str] arn: ARN of the dataset that contains permissions for RLS.
        :param pulumi.Input[str] aws_account_id: AWS account ID.
        :param pulumi.Input[Sequence[pulumi.Input['DataSetColumnGroupArgs']]] column_groups: Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported. See column_groups.
        :param pulumi.Input[Sequence[pulumi.Input['DataSetColumnLevelPermissionRuleArgs']]] column_level_permission_rules: A set of 1 or more definitions of a [ColumnLevelPermissionRule](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html). See column_level_permission_rules.
        :param pulumi.Input[str] data_set_id: Identifier for the data set.
        :param pulumi.Input['DataSetDataSetUsageConfigurationArgs'] data_set_usage_configuration: The usage configuration to apply to child datasets that reference this dataset as a source. See data_set_usage_configuration.
        :param pulumi.Input[Sequence[pulumi.Input['DataSetFieldFolderArgs']]] field_folders: The folder that contains fields and nested subfolders for your dataset. See field_folders.
        :param pulumi.Input[str] import_mode: Indicates whether you want to import the data into SPICE. Valid values are `SPICE` and `DIRECT_QUERY`.
        :param pulumi.Input[Sequence[pulumi.Input['DataSetLogicalTableMapArgs']]] logical_table_maps: Configures the combination and transformation of the data from the physical tables. Maximum of 1 entry. See logical_table_map.
        :param pulumi.Input[str] name: Display name for the dataset.
        :param pulumi.Input[Sequence[pulumi.Input['DataSetPermissionArgs']]] permissions: A set of resource permissions on the data source. Maximum of 64 items. See permissions.
        :param pulumi.Input[Sequence[pulumi.Input['DataSetPhysicalTableMapArgs']]] physical_table_maps: Declares the physical tables that are available in the underlying data sources. See physical_table_map.
               
               The following arguments are optional:
        :param pulumi.Input['DataSetRefreshPropertiesArgs'] refresh_properties: The refresh properties for the data set. **NOTE**: Only valid when `import_mode` is set to `SPICE`. See refresh_properties.
        :param pulumi.Input['DataSetRowLevelPermissionDataSetArgs'] row_level_permission_data_set: The row-level security configuration for the data that you want to create. See row_level_permission_data_set.
        :param pulumi.Input['DataSetRowLevelPermissionTagConfigurationArgs'] row_level_permission_tag_configuration: The configuration of tags on a dataset to set row-level security. Row-level security tags are currently supported for anonymous embedding only. See row_level_permission_tag_configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if aws_account_id is not None:
            pulumi.set(__self__, "aws_account_id", aws_account_id)
        if column_groups is not None:
            pulumi.set(__self__, "column_groups", column_groups)
        if column_level_permission_rules is not None:
            pulumi.set(__self__, "column_level_permission_rules", column_level_permission_rules)
        if data_set_id is not None:
            pulumi.set(__self__, "data_set_id", data_set_id)
        if data_set_usage_configuration is not None:
            pulumi.set(__self__, "data_set_usage_configuration", data_set_usage_configuration)
        if field_folders is not None:
            pulumi.set(__self__, "field_folders", field_folders)
        if import_mode is not None:
            pulumi.set(__self__, "import_mode", import_mode)
        if logical_table_maps is not None:
            pulumi.set(__self__, "logical_table_maps", logical_table_maps)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output_columns is not None:
            pulumi.set(__self__, "output_columns", output_columns)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if physical_table_maps is not None:
            pulumi.set(__self__, "physical_table_maps", physical_table_maps)
        if refresh_properties is not None:
            pulumi.set(__self__, "refresh_properties", refresh_properties)
        if row_level_permission_data_set is not None:
            pulumi.set(__self__, "row_level_permission_data_set", row_level_permission_data_set)
        if row_level_permission_tag_configuration is not None:
            pulumi.set(__self__, "row_level_permission_tag_configuration", row_level_permission_tag_configuration)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the dataset that contains permissions for RLS.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        AWS account ID.
        """
        return pulumi.get(self, "aws_account_id")

    @aws_account_id.setter
    def aws_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_account_id", value)

    @property
    @pulumi.getter(name="columnGroups")
    def column_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataSetColumnGroupArgs']]]]:
        """
        Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported. See column_groups.
        """
        return pulumi.get(self, "column_groups")

    @column_groups.setter
    def column_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataSetColumnGroupArgs']]]]):
        pulumi.set(self, "column_groups", value)

    @property
    @pulumi.getter(name="columnLevelPermissionRules")
    def column_level_permission_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataSetColumnLevelPermissionRuleArgs']]]]:
        """
        A set of 1 or more definitions of a [ColumnLevelPermissionRule](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html). See column_level_permission_rules.
        """
        return pulumi.get(self, "column_level_permission_rules")

    @column_level_permission_rules.setter
    def column_level_permission_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataSetColumnLevelPermissionRuleArgs']]]]):
        pulumi.set(self, "column_level_permission_rules", value)

    @property
    @pulumi.getter(name="dataSetId")
    def data_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier for the data set.
        """
        return pulumi.get(self, "data_set_id")

    @data_set_id.setter
    def data_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_set_id", value)

    @property
    @pulumi.getter(name="dataSetUsageConfiguration")
    def data_set_usage_configuration(self) -> Optional[pulumi.Input['DataSetDataSetUsageConfigurationArgs']]:
        """
        The usage configuration to apply to child datasets that reference this dataset as a source. See data_set_usage_configuration.
        """
        return pulumi.get(self, "data_set_usage_configuration")

    @data_set_usage_configuration.setter
    def data_set_usage_configuration(self, value: Optional[pulumi.Input['DataSetDataSetUsageConfigurationArgs']]):
        pulumi.set(self, "data_set_usage_configuration", value)

    @property
    @pulumi.getter(name="fieldFolders")
    def field_folders(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataSetFieldFolderArgs']]]]:
        """
        The folder that contains fields and nested subfolders for your dataset. See field_folders.
        """
        return pulumi.get(self, "field_folders")

    @field_folders.setter
    def field_folders(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataSetFieldFolderArgs']]]]):
        pulumi.set(self, "field_folders", value)

    @property
    @pulumi.getter(name="importMode")
    def import_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether you want to import the data into SPICE. Valid values are `SPICE` and `DIRECT_QUERY`.
        """
        return pulumi.get(self, "import_mode")

    @import_mode.setter
    def import_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "import_mode", value)

    @property
    @pulumi.getter(name="logicalTableMaps")
    def logical_table_maps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataSetLogicalTableMapArgs']]]]:
        """
        Configures the combination and transformation of the data from the physical tables. Maximum of 1 entry. See logical_table_map.
        """
        return pulumi.get(self, "logical_table_maps")

    @logical_table_maps.setter
    def logical_table_maps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataSetLogicalTableMapArgs']]]]):
        pulumi.set(self, "logical_table_maps", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Display name for the dataset.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outputColumns")
    def output_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataSetOutputColumnArgs']]]]:
        return pulumi.get(self, "output_columns")

    @output_columns.setter
    def output_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataSetOutputColumnArgs']]]]):
        pulumi.set(self, "output_columns", value)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataSetPermissionArgs']]]]:
        """
        A set of resource permissions on the data source. Maximum of 64 items. See permissions.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataSetPermissionArgs']]]]):
        pulumi.set(self, "permissions", value)

    @property
    @pulumi.getter(name="physicalTableMaps")
    def physical_table_maps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataSetPhysicalTableMapArgs']]]]:
        """
        Declares the physical tables that are available in the underlying data sources. See physical_table_map.

        The following arguments are optional:
        """
        return pulumi.get(self, "physical_table_maps")

    @physical_table_maps.setter
    def physical_table_maps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataSetPhysicalTableMapArgs']]]]):
        pulumi.set(self, "physical_table_maps", value)

    @property
    @pulumi.getter(name="refreshProperties")
    def refresh_properties(self) -> Optional[pulumi.Input['DataSetRefreshPropertiesArgs']]:
        """
        The refresh properties for the data set. **NOTE**: Only valid when `import_mode` is set to `SPICE`. See refresh_properties.
        """
        return pulumi.get(self, "refresh_properties")

    @refresh_properties.setter
    def refresh_properties(self, value: Optional[pulumi.Input['DataSetRefreshPropertiesArgs']]):
        pulumi.set(self, "refresh_properties", value)

    @property
    @pulumi.getter(name="rowLevelPermissionDataSet")
    def row_level_permission_data_set(self) -> Optional[pulumi.Input['DataSetRowLevelPermissionDataSetArgs']]:
        """
        The row-level security configuration for the data that you want to create. See row_level_permission_data_set.
        """
        return pulumi.get(self, "row_level_permission_data_set")

    @row_level_permission_data_set.setter
    def row_level_permission_data_set(self, value: Optional[pulumi.Input['DataSetRowLevelPermissionDataSetArgs']]):
        pulumi.set(self, "row_level_permission_data_set", value)

    @property
    @pulumi.getter(name="rowLevelPermissionTagConfiguration")
    def row_level_permission_tag_configuration(self) -> Optional[pulumi.Input['DataSetRowLevelPermissionTagConfigurationArgs']]:
        """
        The configuration of tags on a dataset to set row-level security. Row-level security tags are currently supported for anonymous embedding only. See row_level_permission_tag_configuration.
        """
        return pulumi.get(self, "row_level_permission_tag_configuration")

    @row_level_permission_tag_configuration.setter
    def row_level_permission_tag_configuration(self, value: Optional[pulumi.Input['DataSetRowLevelPermissionTagConfigurationArgs']]):
        pulumi.set(self, "row_level_permission_tag_configuration", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)


class DataSet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_account_id: Optional[pulumi.Input[str]] = None,
                 column_groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSetColumnGroupArgs']]]]] = None,
                 column_level_permission_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSetColumnLevelPermissionRuleArgs']]]]] = None,
                 data_set_id: Optional[pulumi.Input[str]] = None,
                 data_set_usage_configuration: Optional[pulumi.Input[pulumi.InputType['DataSetDataSetUsageConfigurationArgs']]] = None,
                 field_folders: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSetFieldFolderArgs']]]]] = None,
                 import_mode: Optional[pulumi.Input[str]] = None,
                 logical_table_maps: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSetLogicalTableMapArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSetPermissionArgs']]]]] = None,
                 physical_table_maps: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSetPhysicalTableMapArgs']]]]] = None,
                 refresh_properties: Optional[pulumi.Input[pulumi.InputType['DataSetRefreshPropertiesArgs']]] = None,
                 row_level_permission_data_set: Optional[pulumi.Input[pulumi.InputType['DataSetRowLevelPermissionDataSetArgs']]] = None,
                 row_level_permission_tag_configuration: Optional[pulumi.Input[pulumi.InputType['DataSetRowLevelPermissionTagConfigurationArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Resource for managing a QuickSight Data Set.

        ## Example Usage

        ### Basic Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.quicksight.DataSet("example",
            data_set_id="example-id",
            name="example-name",
            import_mode="SPICE",
            physical_table_maps=[aws.quicksight.DataSetPhysicalTableMapArgs(
                physical_table_map_id="example-id",
                s3_source=aws.quicksight.DataSetPhysicalTableMapS3SourceArgs(
                    data_source_arn=example_aws_quicksight_data_source["arn"],
                    input_columns=[aws.quicksight.DataSetPhysicalTableMapS3SourceInputColumnArgs(
                        name="Column1",
                        type="STRING",
                    )],
                    upload_settings=aws.quicksight.DataSetPhysicalTableMapS3SourceUploadSettingsArgs(
                        format="JSON",
                    ),
                ),
            )])
        ```
        <!--End PulumiCodeChooser -->

        ### With Column Level Permission Rules

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.quicksight.DataSet("example",
            data_set_id="example-id",
            name="example-name",
            import_mode="SPICE",
            physical_table_maps=[aws.quicksight.DataSetPhysicalTableMapArgs(
                physical_table_map_id="example-id",
                s3_source=aws.quicksight.DataSetPhysicalTableMapS3SourceArgs(
                    data_source_arn=example_aws_quicksight_data_source["arn"],
                    input_columns=[aws.quicksight.DataSetPhysicalTableMapS3SourceInputColumnArgs(
                        name="Column1",
                        type="STRING",
                    )],
                    upload_settings=aws.quicksight.DataSetPhysicalTableMapS3SourceUploadSettingsArgs(
                        format="JSON",
                    ),
                ),
            )],
            column_level_permission_rules=[aws.quicksight.DataSetColumnLevelPermissionRuleArgs(
                column_names=["Column1"],
                principals=[example_aws_quicksight_user["arn"]],
            )])
        ```
        <!--End PulumiCodeChooser -->

        ### With Field Folders

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.quicksight.DataSet("example",
            data_set_id="example-id",
            name="example-name",
            import_mode="SPICE",
            physical_table_maps=[aws.quicksight.DataSetPhysicalTableMapArgs(
                physical_table_map_id="example-id",
                s3_source=aws.quicksight.DataSetPhysicalTableMapS3SourceArgs(
                    data_source_arn=example_aws_quicksight_data_source["arn"],
                    input_columns=[aws.quicksight.DataSetPhysicalTableMapS3SourceInputColumnArgs(
                        name="Column1",
                        type="STRING",
                    )],
                    upload_settings=aws.quicksight.DataSetPhysicalTableMapS3SourceUploadSettingsArgs(
                        format="JSON",
                    ),
                ),
            )],
            field_folders=[aws.quicksight.DataSetFieldFolderArgs(
                field_folders_id="example-id",
                columns=["Column1"],
                description="example description",
            )])
        ```
        <!--End PulumiCodeChooser -->

        ### With Permissions

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.quicksight.DataSet("example",
            data_set_id="example-id",
            name="example-name",
            import_mode="SPICE",
            physical_table_maps=[aws.quicksight.DataSetPhysicalTableMapArgs(
                physical_table_map_id="example-id",
                s3_source=aws.quicksight.DataSetPhysicalTableMapS3SourceArgs(
                    data_source_arn=example_aws_quicksight_data_source["arn"],
                    input_columns=[aws.quicksight.DataSetPhysicalTableMapS3SourceInputColumnArgs(
                        name="Column1",
                        type="STRING",
                    )],
                    upload_settings=aws.quicksight.DataSetPhysicalTableMapS3SourceUploadSettingsArgs(
                        format="JSON",
                    ),
                ),
            )],
            permissions=[aws.quicksight.DataSetPermissionArgs(
                actions=[
                    "quicksight:DescribeDataSet",
                    "quicksight:DescribeDataSetPermissions",
                    "quicksight:PassDataSet",
                    "quicksight:DescribeIngestion",
                    "quicksight:ListIngestions",
                ],
                principal=example_aws_quicksight_user["arn"],
            )])
        ```
        <!--End PulumiCodeChooser -->

        ### With Row Level Permission Tag Configuration

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.quicksight.DataSet("example",
            data_set_id="example-id",
            name="example-name",
            import_mode="SPICE",
            physical_table_maps=[aws.quicksight.DataSetPhysicalTableMapArgs(
                physical_table_map_id="example-id",
                s3_source=aws.quicksight.DataSetPhysicalTableMapS3SourceArgs(
                    data_source_arn=example_aws_quicksight_data_source["arn"],
                    input_columns=[aws.quicksight.DataSetPhysicalTableMapS3SourceInputColumnArgs(
                        name="Column1",
                        type="STRING",
                    )],
                    upload_settings=aws.quicksight.DataSetPhysicalTableMapS3SourceUploadSettingsArgs(
                        format="JSON",
                    ),
                ),
            )],
            row_level_permission_tag_configuration=aws.quicksight.DataSetRowLevelPermissionTagConfigurationArgs(
                status="ENABLED",
                tag_rules=[aws.quicksight.DataSetRowLevelPermissionTagConfigurationTagRuleArgs(
                    column_name="Column1",
                    tag_key="tagkey",
                    match_all_value="*",
                    tag_multi_value_delimiter=",",
                )],
            ))
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import a QuickSight Data Set using the AWS account ID and data set ID separated by a comma (`,`). For example:

        ```sh
        $ pulumi import aws:quicksight/dataSet:DataSet example 123456789012,example-id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] aws_account_id: AWS account ID.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSetColumnGroupArgs']]]] column_groups: Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported. See column_groups.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSetColumnLevelPermissionRuleArgs']]]] column_level_permission_rules: A set of 1 or more definitions of a [ColumnLevelPermissionRule](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html). See column_level_permission_rules.
        :param pulumi.Input[str] data_set_id: Identifier for the data set.
        :param pulumi.Input[pulumi.InputType['DataSetDataSetUsageConfigurationArgs']] data_set_usage_configuration: The usage configuration to apply to child datasets that reference this dataset as a source. See data_set_usage_configuration.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSetFieldFolderArgs']]]] field_folders: The folder that contains fields and nested subfolders for your dataset. See field_folders.
        :param pulumi.Input[str] import_mode: Indicates whether you want to import the data into SPICE. Valid values are `SPICE` and `DIRECT_QUERY`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSetLogicalTableMapArgs']]]] logical_table_maps: Configures the combination and transformation of the data from the physical tables. Maximum of 1 entry. See logical_table_map.
        :param pulumi.Input[str] name: Display name for the dataset.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSetPermissionArgs']]]] permissions: A set of resource permissions on the data source. Maximum of 64 items. See permissions.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSetPhysicalTableMapArgs']]]] physical_table_maps: Declares the physical tables that are available in the underlying data sources. See physical_table_map.
               
               The following arguments are optional:
        :param pulumi.Input[pulumi.InputType['DataSetRefreshPropertiesArgs']] refresh_properties: The refresh properties for the data set. **NOTE**: Only valid when `import_mode` is set to `SPICE`. See refresh_properties.
        :param pulumi.Input[pulumi.InputType['DataSetRowLevelPermissionDataSetArgs']] row_level_permission_data_set: The row-level security configuration for the data that you want to create. See row_level_permission_data_set.
        :param pulumi.Input[pulumi.InputType['DataSetRowLevelPermissionTagConfigurationArgs']] row_level_permission_tag_configuration: The configuration of tags on a dataset to set row-level security. Row-level security tags are currently supported for anonymous embedding only. See row_level_permission_tag_configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataSetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing a QuickSight Data Set.

        ## Example Usage

        ### Basic Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.quicksight.DataSet("example",
            data_set_id="example-id",
            name="example-name",
            import_mode="SPICE",
            physical_table_maps=[aws.quicksight.DataSetPhysicalTableMapArgs(
                physical_table_map_id="example-id",
                s3_source=aws.quicksight.DataSetPhysicalTableMapS3SourceArgs(
                    data_source_arn=example_aws_quicksight_data_source["arn"],
                    input_columns=[aws.quicksight.DataSetPhysicalTableMapS3SourceInputColumnArgs(
                        name="Column1",
                        type="STRING",
                    )],
                    upload_settings=aws.quicksight.DataSetPhysicalTableMapS3SourceUploadSettingsArgs(
                        format="JSON",
                    ),
                ),
            )])
        ```
        <!--End PulumiCodeChooser -->

        ### With Column Level Permission Rules

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.quicksight.DataSet("example",
            data_set_id="example-id",
            name="example-name",
            import_mode="SPICE",
            physical_table_maps=[aws.quicksight.DataSetPhysicalTableMapArgs(
                physical_table_map_id="example-id",
                s3_source=aws.quicksight.DataSetPhysicalTableMapS3SourceArgs(
                    data_source_arn=example_aws_quicksight_data_source["arn"],
                    input_columns=[aws.quicksight.DataSetPhysicalTableMapS3SourceInputColumnArgs(
                        name="Column1",
                        type="STRING",
                    )],
                    upload_settings=aws.quicksight.DataSetPhysicalTableMapS3SourceUploadSettingsArgs(
                        format="JSON",
                    ),
                ),
            )],
            column_level_permission_rules=[aws.quicksight.DataSetColumnLevelPermissionRuleArgs(
                column_names=["Column1"],
                principals=[example_aws_quicksight_user["arn"]],
            )])
        ```
        <!--End PulumiCodeChooser -->

        ### With Field Folders

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.quicksight.DataSet("example",
            data_set_id="example-id",
            name="example-name",
            import_mode="SPICE",
            physical_table_maps=[aws.quicksight.DataSetPhysicalTableMapArgs(
                physical_table_map_id="example-id",
                s3_source=aws.quicksight.DataSetPhysicalTableMapS3SourceArgs(
                    data_source_arn=example_aws_quicksight_data_source["arn"],
                    input_columns=[aws.quicksight.DataSetPhysicalTableMapS3SourceInputColumnArgs(
                        name="Column1",
                        type="STRING",
                    )],
                    upload_settings=aws.quicksight.DataSetPhysicalTableMapS3SourceUploadSettingsArgs(
                        format="JSON",
                    ),
                ),
            )],
            field_folders=[aws.quicksight.DataSetFieldFolderArgs(
                field_folders_id="example-id",
                columns=["Column1"],
                description="example description",
            )])
        ```
        <!--End PulumiCodeChooser -->

        ### With Permissions

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.quicksight.DataSet("example",
            data_set_id="example-id",
            name="example-name",
            import_mode="SPICE",
            physical_table_maps=[aws.quicksight.DataSetPhysicalTableMapArgs(
                physical_table_map_id="example-id",
                s3_source=aws.quicksight.DataSetPhysicalTableMapS3SourceArgs(
                    data_source_arn=example_aws_quicksight_data_source["arn"],
                    input_columns=[aws.quicksight.DataSetPhysicalTableMapS3SourceInputColumnArgs(
                        name="Column1",
                        type="STRING",
                    )],
                    upload_settings=aws.quicksight.DataSetPhysicalTableMapS3SourceUploadSettingsArgs(
                        format="JSON",
                    ),
                ),
            )],
            permissions=[aws.quicksight.DataSetPermissionArgs(
                actions=[
                    "quicksight:DescribeDataSet",
                    "quicksight:DescribeDataSetPermissions",
                    "quicksight:PassDataSet",
                    "quicksight:DescribeIngestion",
                    "quicksight:ListIngestions",
                ],
                principal=example_aws_quicksight_user["arn"],
            )])
        ```
        <!--End PulumiCodeChooser -->

        ### With Row Level Permission Tag Configuration

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.quicksight.DataSet("example",
            data_set_id="example-id",
            name="example-name",
            import_mode="SPICE",
            physical_table_maps=[aws.quicksight.DataSetPhysicalTableMapArgs(
                physical_table_map_id="example-id",
                s3_source=aws.quicksight.DataSetPhysicalTableMapS3SourceArgs(
                    data_source_arn=example_aws_quicksight_data_source["arn"],
                    input_columns=[aws.quicksight.DataSetPhysicalTableMapS3SourceInputColumnArgs(
                        name="Column1",
                        type="STRING",
                    )],
                    upload_settings=aws.quicksight.DataSetPhysicalTableMapS3SourceUploadSettingsArgs(
                        format="JSON",
                    ),
                ),
            )],
            row_level_permission_tag_configuration=aws.quicksight.DataSetRowLevelPermissionTagConfigurationArgs(
                status="ENABLED",
                tag_rules=[aws.quicksight.DataSetRowLevelPermissionTagConfigurationTagRuleArgs(
                    column_name="Column1",
                    tag_key="tagkey",
                    match_all_value="*",
                    tag_multi_value_delimiter=",",
                )],
            ))
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import a QuickSight Data Set using the AWS account ID and data set ID separated by a comma (`,`). For example:

        ```sh
        $ pulumi import aws:quicksight/dataSet:DataSet example 123456789012,example-id
        ```

        :param str resource_name: The name of the resource.
        :param DataSetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataSetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_account_id: Optional[pulumi.Input[str]] = None,
                 column_groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSetColumnGroupArgs']]]]] = None,
                 column_level_permission_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSetColumnLevelPermissionRuleArgs']]]]] = None,
                 data_set_id: Optional[pulumi.Input[str]] = None,
                 data_set_usage_configuration: Optional[pulumi.Input[pulumi.InputType['DataSetDataSetUsageConfigurationArgs']]] = None,
                 field_folders: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSetFieldFolderArgs']]]]] = None,
                 import_mode: Optional[pulumi.Input[str]] = None,
                 logical_table_maps: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSetLogicalTableMapArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSetPermissionArgs']]]]] = None,
                 physical_table_maps: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSetPhysicalTableMapArgs']]]]] = None,
                 refresh_properties: Optional[pulumi.Input[pulumi.InputType['DataSetRefreshPropertiesArgs']]] = None,
                 row_level_permission_data_set: Optional[pulumi.Input[pulumi.InputType['DataSetRowLevelPermissionDataSetArgs']]] = None,
                 row_level_permission_tag_configuration: Optional[pulumi.Input[pulumi.InputType['DataSetRowLevelPermissionTagConfigurationArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataSetArgs.__new__(DataSetArgs)

            __props__.__dict__["aws_account_id"] = aws_account_id
            __props__.__dict__["column_groups"] = column_groups
            __props__.__dict__["column_level_permission_rules"] = column_level_permission_rules
            if data_set_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_set_id'")
            __props__.__dict__["data_set_id"] = data_set_id
            __props__.__dict__["data_set_usage_configuration"] = data_set_usage_configuration
            __props__.__dict__["field_folders"] = field_folders
            if import_mode is None and not opts.urn:
                raise TypeError("Missing required property 'import_mode'")
            __props__.__dict__["import_mode"] = import_mode
            __props__.__dict__["logical_table_maps"] = logical_table_maps
            __props__.__dict__["name"] = name
            __props__.__dict__["permissions"] = permissions
            __props__.__dict__["physical_table_maps"] = physical_table_maps
            __props__.__dict__["refresh_properties"] = refresh_properties
            __props__.__dict__["row_level_permission_data_set"] = row_level_permission_data_set
            __props__.__dict__["row_level_permission_tag_configuration"] = row_level_permission_tag_configuration
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["output_columns"] = None
            __props__.__dict__["tags_all"] = None
        super(DataSet, __self__).__init__(
            'aws:quicksight/dataSet:DataSet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            aws_account_id: Optional[pulumi.Input[str]] = None,
            column_groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSetColumnGroupArgs']]]]] = None,
            column_level_permission_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSetColumnLevelPermissionRuleArgs']]]]] = None,
            data_set_id: Optional[pulumi.Input[str]] = None,
            data_set_usage_configuration: Optional[pulumi.Input[pulumi.InputType['DataSetDataSetUsageConfigurationArgs']]] = None,
            field_folders: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSetFieldFolderArgs']]]]] = None,
            import_mode: Optional[pulumi.Input[str]] = None,
            logical_table_maps: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSetLogicalTableMapArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            output_columns: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSetOutputColumnArgs']]]]] = None,
            permissions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSetPermissionArgs']]]]] = None,
            physical_table_maps: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSetPhysicalTableMapArgs']]]]] = None,
            refresh_properties: Optional[pulumi.Input[pulumi.InputType['DataSetRefreshPropertiesArgs']]] = None,
            row_level_permission_data_set: Optional[pulumi.Input[pulumi.InputType['DataSetRowLevelPermissionDataSetArgs']]] = None,
            row_level_permission_tag_configuration: Optional[pulumi.Input[pulumi.InputType['DataSetRowLevelPermissionTagConfigurationArgs']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'DataSet':
        """
        Get an existing DataSet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: ARN of the dataset that contains permissions for RLS.
        :param pulumi.Input[str] aws_account_id: AWS account ID.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSetColumnGroupArgs']]]] column_groups: Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported. See column_groups.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSetColumnLevelPermissionRuleArgs']]]] column_level_permission_rules: A set of 1 or more definitions of a [ColumnLevelPermissionRule](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html). See column_level_permission_rules.
        :param pulumi.Input[str] data_set_id: Identifier for the data set.
        :param pulumi.Input[pulumi.InputType['DataSetDataSetUsageConfigurationArgs']] data_set_usage_configuration: The usage configuration to apply to child datasets that reference this dataset as a source. See data_set_usage_configuration.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSetFieldFolderArgs']]]] field_folders: The folder that contains fields and nested subfolders for your dataset. See field_folders.
        :param pulumi.Input[str] import_mode: Indicates whether you want to import the data into SPICE. Valid values are `SPICE` and `DIRECT_QUERY`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSetLogicalTableMapArgs']]]] logical_table_maps: Configures the combination and transformation of the data from the physical tables. Maximum of 1 entry. See logical_table_map.
        :param pulumi.Input[str] name: Display name for the dataset.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSetPermissionArgs']]]] permissions: A set of resource permissions on the data source. Maximum of 64 items. See permissions.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSetPhysicalTableMapArgs']]]] physical_table_maps: Declares the physical tables that are available in the underlying data sources. See physical_table_map.
               
               The following arguments are optional:
        :param pulumi.Input[pulumi.InputType['DataSetRefreshPropertiesArgs']] refresh_properties: The refresh properties for the data set. **NOTE**: Only valid when `import_mode` is set to `SPICE`. See refresh_properties.
        :param pulumi.Input[pulumi.InputType['DataSetRowLevelPermissionDataSetArgs']] row_level_permission_data_set: The row-level security configuration for the data that you want to create. See row_level_permission_data_set.
        :param pulumi.Input[pulumi.InputType['DataSetRowLevelPermissionTagConfigurationArgs']] row_level_permission_tag_configuration: The configuration of tags on a dataset to set row-level security. Row-level security tags are currently supported for anonymous embedding only. See row_level_permission_tag_configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataSetState.__new__(_DataSetState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["aws_account_id"] = aws_account_id
        __props__.__dict__["column_groups"] = column_groups
        __props__.__dict__["column_level_permission_rules"] = column_level_permission_rules
        __props__.__dict__["data_set_id"] = data_set_id
        __props__.__dict__["data_set_usage_configuration"] = data_set_usage_configuration
        __props__.__dict__["field_folders"] = field_folders
        __props__.__dict__["import_mode"] = import_mode
        __props__.__dict__["logical_table_maps"] = logical_table_maps
        __props__.__dict__["name"] = name
        __props__.__dict__["output_columns"] = output_columns
        __props__.__dict__["permissions"] = permissions
        __props__.__dict__["physical_table_maps"] = physical_table_maps
        __props__.__dict__["refresh_properties"] = refresh_properties
        __props__.__dict__["row_level_permission_data_set"] = row_level_permission_data_set
        __props__.__dict__["row_level_permission_tag_configuration"] = row_level_permission_tag_configuration
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return DataSet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN of the dataset that contains permissions for RLS.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> pulumi.Output[str]:
        """
        AWS account ID.
        """
        return pulumi.get(self, "aws_account_id")

    @property
    @pulumi.getter(name="columnGroups")
    def column_groups(self) -> pulumi.Output[Optional[Sequence['outputs.DataSetColumnGroup']]]:
        """
        Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported. See column_groups.
        """
        return pulumi.get(self, "column_groups")

    @property
    @pulumi.getter(name="columnLevelPermissionRules")
    def column_level_permission_rules(self) -> pulumi.Output[Optional[Sequence['outputs.DataSetColumnLevelPermissionRule']]]:
        """
        A set of 1 or more definitions of a [ColumnLevelPermissionRule](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html). See column_level_permission_rules.
        """
        return pulumi.get(self, "column_level_permission_rules")

    @property
    @pulumi.getter(name="dataSetId")
    def data_set_id(self) -> pulumi.Output[str]:
        """
        Identifier for the data set.
        """
        return pulumi.get(self, "data_set_id")

    @property
    @pulumi.getter(name="dataSetUsageConfiguration")
    def data_set_usage_configuration(self) -> pulumi.Output['outputs.DataSetDataSetUsageConfiguration']:
        """
        The usage configuration to apply to child datasets that reference this dataset as a source. See data_set_usage_configuration.
        """
        return pulumi.get(self, "data_set_usage_configuration")

    @property
    @pulumi.getter(name="fieldFolders")
    def field_folders(self) -> pulumi.Output[Optional[Sequence['outputs.DataSetFieldFolder']]]:
        """
        The folder that contains fields and nested subfolders for your dataset. See field_folders.
        """
        return pulumi.get(self, "field_folders")

    @property
    @pulumi.getter(name="importMode")
    def import_mode(self) -> pulumi.Output[str]:
        """
        Indicates whether you want to import the data into SPICE. Valid values are `SPICE` and `DIRECT_QUERY`.
        """
        return pulumi.get(self, "import_mode")

    @property
    @pulumi.getter(name="logicalTableMaps")
    def logical_table_maps(self) -> pulumi.Output[Sequence['outputs.DataSetLogicalTableMap']]:
        """
        Configures the combination and transformation of the data from the physical tables. Maximum of 1 entry. See logical_table_map.
        """
        return pulumi.get(self, "logical_table_maps")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Display name for the dataset.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outputColumns")
    def output_columns(self) -> pulumi.Output[Sequence['outputs.DataSetOutputColumn']]:
        return pulumi.get(self, "output_columns")

    @property
    @pulumi.getter
    def permissions(self) -> pulumi.Output[Optional[Sequence['outputs.DataSetPermission']]]:
        """
        A set of resource permissions on the data source. Maximum of 64 items. See permissions.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter(name="physicalTableMaps")
    def physical_table_maps(self) -> pulumi.Output[Optional[Sequence['outputs.DataSetPhysicalTableMap']]]:
        """
        Declares the physical tables that are available in the underlying data sources. See physical_table_map.

        The following arguments are optional:
        """
        return pulumi.get(self, "physical_table_maps")

    @property
    @pulumi.getter(name="refreshProperties")
    def refresh_properties(self) -> pulumi.Output[Optional['outputs.DataSetRefreshProperties']]:
        """
        The refresh properties for the data set. **NOTE**: Only valid when `import_mode` is set to `SPICE`. See refresh_properties.
        """
        return pulumi.get(self, "refresh_properties")

    @property
    @pulumi.getter(name="rowLevelPermissionDataSet")
    def row_level_permission_data_set(self) -> pulumi.Output[Optional['outputs.DataSetRowLevelPermissionDataSet']]:
        """
        The row-level security configuration for the data that you want to create. See row_level_permission_data_set.
        """
        return pulumi.get(self, "row_level_permission_data_set")

    @property
    @pulumi.getter(name="rowLevelPermissionTagConfiguration")
    def row_level_permission_tag_configuration(self) -> pulumi.Output[Optional['outputs.DataSetRowLevelPermissionTagConfiguration']]:
        """
        The configuration of tags on a dataset to set row-level security. Row-level security tags are currently supported for anonymous embedding only. See row_level_permission_tag_configuration.
        """
        return pulumi.get(self, "row_level_permission_tag_configuration")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

