# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IamPolicyAssignmentArgs', 'IamPolicyAssignment']

@pulumi.input_type
class IamPolicyAssignmentArgs:
    def __init__(__self__, *,
                 assignment_name: pulumi.Input[str],
                 assignment_status: pulumi.Input[str],
                 aws_account_id: Optional[pulumi.Input[str]] = None,
                 identities: Optional[pulumi.Input['IamPolicyAssignmentIdentitiesArgs']] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 policy_arn: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a IamPolicyAssignment resource.
        :param pulumi.Input[str] assignment_name: Name of the assignment.
        :param pulumi.Input[str] assignment_status: Status of the assignment. Valid values are `ENABLED`, `DISABLED`, and `DRAFT`.
               
               The following arguments are optional:
        :param pulumi.Input[str] aws_account_id: AWS account ID.
        :param pulumi.Input['IamPolicyAssignmentIdentitiesArgs'] identities: Amazon QuickSight users, groups, or both to assign the policy to. See `identities` block.
        :param pulumi.Input[str] namespace: Namespace that contains the assignment. Defaults to `default`.
        :param pulumi.Input[str] policy_arn: ARN of the IAM policy to apply to the Amazon QuickSight users and groups specified in this assignment.
        """
        pulumi.set(__self__, "assignment_name", assignment_name)
        pulumi.set(__self__, "assignment_status", assignment_status)
        if aws_account_id is not None:
            pulumi.set(__self__, "aws_account_id", aws_account_id)
        if identities is not None:
            pulumi.set(__self__, "identities", identities)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if policy_arn is not None:
            pulumi.set(__self__, "policy_arn", policy_arn)

    @property
    @pulumi.getter(name="assignmentName")
    def assignment_name(self) -> pulumi.Input[str]:
        """
        Name of the assignment.
        """
        return pulumi.get(self, "assignment_name")

    @assignment_name.setter
    def assignment_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "assignment_name", value)

    @property
    @pulumi.getter(name="assignmentStatus")
    def assignment_status(self) -> pulumi.Input[str]:
        """
        Status of the assignment. Valid values are `ENABLED`, `DISABLED`, and `DRAFT`.

        The following arguments are optional:
        """
        return pulumi.get(self, "assignment_status")

    @assignment_status.setter
    def assignment_status(self, value: pulumi.Input[str]):
        pulumi.set(self, "assignment_status", value)

    @property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        AWS account ID.
        """
        return pulumi.get(self, "aws_account_id")

    @aws_account_id.setter
    def aws_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_account_id", value)

    @property
    @pulumi.getter
    def identities(self) -> Optional[pulumi.Input['IamPolicyAssignmentIdentitiesArgs']]:
        """
        Amazon QuickSight users, groups, or both to assign the policy to. See `identities` block.
        """
        return pulumi.get(self, "identities")

    @identities.setter
    def identities(self, value: Optional[pulumi.Input['IamPolicyAssignmentIdentitiesArgs']]):
        pulumi.set(self, "identities", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Namespace that contains the assignment. Defaults to `default`.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="policyArn")
    def policy_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the IAM policy to apply to the Amazon QuickSight users and groups specified in this assignment.
        """
        return pulumi.get(self, "policy_arn")

    @policy_arn.setter
    def policy_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_arn", value)


@pulumi.input_type
class _IamPolicyAssignmentState:
    def __init__(__self__, *,
                 assignment_id: Optional[pulumi.Input[str]] = None,
                 assignment_name: Optional[pulumi.Input[str]] = None,
                 assignment_status: Optional[pulumi.Input[str]] = None,
                 aws_account_id: Optional[pulumi.Input[str]] = None,
                 identities: Optional[pulumi.Input['IamPolicyAssignmentIdentitiesArgs']] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 policy_arn: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering IamPolicyAssignment resources.
        :param pulumi.Input[str] assignment_id: Assignment ID.
        :param pulumi.Input[str] assignment_name: Name of the assignment.
        :param pulumi.Input[str] assignment_status: Status of the assignment. Valid values are `ENABLED`, `DISABLED`, and `DRAFT`.
               
               The following arguments are optional:
        :param pulumi.Input[str] aws_account_id: AWS account ID.
        :param pulumi.Input['IamPolicyAssignmentIdentitiesArgs'] identities: Amazon QuickSight users, groups, or both to assign the policy to. See `identities` block.
        :param pulumi.Input[str] namespace: Namespace that contains the assignment. Defaults to `default`.
        :param pulumi.Input[str] policy_arn: ARN of the IAM policy to apply to the Amazon QuickSight users and groups specified in this assignment.
        """
        if assignment_id is not None:
            pulumi.set(__self__, "assignment_id", assignment_id)
        if assignment_name is not None:
            pulumi.set(__self__, "assignment_name", assignment_name)
        if assignment_status is not None:
            pulumi.set(__self__, "assignment_status", assignment_status)
        if aws_account_id is not None:
            pulumi.set(__self__, "aws_account_id", aws_account_id)
        if identities is not None:
            pulumi.set(__self__, "identities", identities)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if policy_arn is not None:
            pulumi.set(__self__, "policy_arn", policy_arn)

    @property
    @pulumi.getter(name="assignmentId")
    def assignment_id(self) -> Optional[pulumi.Input[str]]:
        """
        Assignment ID.
        """
        return pulumi.get(self, "assignment_id")

    @assignment_id.setter
    def assignment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "assignment_id", value)

    @property
    @pulumi.getter(name="assignmentName")
    def assignment_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the assignment.
        """
        return pulumi.get(self, "assignment_name")

    @assignment_name.setter
    def assignment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "assignment_name", value)

    @property
    @pulumi.getter(name="assignmentStatus")
    def assignment_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the assignment. Valid values are `ENABLED`, `DISABLED`, and `DRAFT`.

        The following arguments are optional:
        """
        return pulumi.get(self, "assignment_status")

    @assignment_status.setter
    def assignment_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "assignment_status", value)

    @property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        AWS account ID.
        """
        return pulumi.get(self, "aws_account_id")

    @aws_account_id.setter
    def aws_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_account_id", value)

    @property
    @pulumi.getter
    def identities(self) -> Optional[pulumi.Input['IamPolicyAssignmentIdentitiesArgs']]:
        """
        Amazon QuickSight users, groups, or both to assign the policy to. See `identities` block.
        """
        return pulumi.get(self, "identities")

    @identities.setter
    def identities(self, value: Optional[pulumi.Input['IamPolicyAssignmentIdentitiesArgs']]):
        pulumi.set(self, "identities", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Namespace that contains the assignment. Defaults to `default`.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="policyArn")
    def policy_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the IAM policy to apply to the Amazon QuickSight users and groups specified in this assignment.
        """
        return pulumi.get(self, "policy_arn")

    @policy_arn.setter
    def policy_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_arn", value)


class IamPolicyAssignment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assignment_name: Optional[pulumi.Input[str]] = None,
                 assignment_status: Optional[pulumi.Input[str]] = None,
                 aws_account_id: Optional[pulumi.Input[str]] = None,
                 identities: Optional[pulumi.Input[pulumi.InputType['IamPolicyAssignmentIdentitiesArgs']]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 policy_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS QuickSight IAM Policy Assignment.

        ## Example Usage

        ### Basic Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.quicksight.IamPolicyAssignment("example",
            assignment_name="example",
            assignment_status="ENABLED",
            policy_arn=example_aws_iam_policy["arn"],
            identities=aws.quicksight.IamPolicyAssignmentIdentitiesArgs(
                users=[example_aws_quicksight_user["userName"]],
            ))
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import QuickSight IAM Policy Assignment using the AWS account ID, namespace, and assignment name separated by commas (`,`). For example:

        ```sh
        $ pulumi import aws:quicksight/iamPolicyAssignment:IamPolicyAssignment example 123456789012,default,example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] assignment_name: Name of the assignment.
        :param pulumi.Input[str] assignment_status: Status of the assignment. Valid values are `ENABLED`, `DISABLED`, and `DRAFT`.
               
               The following arguments are optional:
        :param pulumi.Input[str] aws_account_id: AWS account ID.
        :param pulumi.Input[pulumi.InputType['IamPolicyAssignmentIdentitiesArgs']] identities: Amazon QuickSight users, groups, or both to assign the policy to. See `identities` block.
        :param pulumi.Input[str] namespace: Namespace that contains the assignment. Defaults to `default`.
        :param pulumi.Input[str] policy_arn: ARN of the IAM policy to apply to the Amazon QuickSight users and groups specified in this assignment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IamPolicyAssignmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS QuickSight IAM Policy Assignment.

        ## Example Usage

        ### Basic Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.quicksight.IamPolicyAssignment("example",
            assignment_name="example",
            assignment_status="ENABLED",
            policy_arn=example_aws_iam_policy["arn"],
            identities=aws.quicksight.IamPolicyAssignmentIdentitiesArgs(
                users=[example_aws_quicksight_user["userName"]],
            ))
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import QuickSight IAM Policy Assignment using the AWS account ID, namespace, and assignment name separated by commas (`,`). For example:

        ```sh
        $ pulumi import aws:quicksight/iamPolicyAssignment:IamPolicyAssignment example 123456789012,default,example
        ```

        :param str resource_name: The name of the resource.
        :param IamPolicyAssignmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IamPolicyAssignmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assignment_name: Optional[pulumi.Input[str]] = None,
                 assignment_status: Optional[pulumi.Input[str]] = None,
                 aws_account_id: Optional[pulumi.Input[str]] = None,
                 identities: Optional[pulumi.Input[pulumi.InputType['IamPolicyAssignmentIdentitiesArgs']]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 policy_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IamPolicyAssignmentArgs.__new__(IamPolicyAssignmentArgs)

            if assignment_name is None and not opts.urn:
                raise TypeError("Missing required property 'assignment_name'")
            __props__.__dict__["assignment_name"] = assignment_name
            if assignment_status is None and not opts.urn:
                raise TypeError("Missing required property 'assignment_status'")
            __props__.__dict__["assignment_status"] = assignment_status
            __props__.__dict__["aws_account_id"] = aws_account_id
            __props__.__dict__["identities"] = identities
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["policy_arn"] = policy_arn
            __props__.__dict__["assignment_id"] = None
        super(IamPolicyAssignment, __self__).__init__(
            'aws:quicksight/iamPolicyAssignment:IamPolicyAssignment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            assignment_id: Optional[pulumi.Input[str]] = None,
            assignment_name: Optional[pulumi.Input[str]] = None,
            assignment_status: Optional[pulumi.Input[str]] = None,
            aws_account_id: Optional[pulumi.Input[str]] = None,
            identities: Optional[pulumi.Input[pulumi.InputType['IamPolicyAssignmentIdentitiesArgs']]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            policy_arn: Optional[pulumi.Input[str]] = None) -> 'IamPolicyAssignment':
        """
        Get an existing IamPolicyAssignment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] assignment_id: Assignment ID.
        :param pulumi.Input[str] assignment_name: Name of the assignment.
        :param pulumi.Input[str] assignment_status: Status of the assignment. Valid values are `ENABLED`, `DISABLED`, and `DRAFT`.
               
               The following arguments are optional:
        :param pulumi.Input[str] aws_account_id: AWS account ID.
        :param pulumi.Input[pulumi.InputType['IamPolicyAssignmentIdentitiesArgs']] identities: Amazon QuickSight users, groups, or both to assign the policy to. See `identities` block.
        :param pulumi.Input[str] namespace: Namespace that contains the assignment. Defaults to `default`.
        :param pulumi.Input[str] policy_arn: ARN of the IAM policy to apply to the Amazon QuickSight users and groups specified in this assignment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IamPolicyAssignmentState.__new__(_IamPolicyAssignmentState)

        __props__.__dict__["assignment_id"] = assignment_id
        __props__.__dict__["assignment_name"] = assignment_name
        __props__.__dict__["assignment_status"] = assignment_status
        __props__.__dict__["aws_account_id"] = aws_account_id
        __props__.__dict__["identities"] = identities
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["policy_arn"] = policy_arn
        return IamPolicyAssignment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="assignmentId")
    def assignment_id(self) -> pulumi.Output[str]:
        """
        Assignment ID.
        """
        return pulumi.get(self, "assignment_id")

    @property
    @pulumi.getter(name="assignmentName")
    def assignment_name(self) -> pulumi.Output[str]:
        """
        Name of the assignment.
        """
        return pulumi.get(self, "assignment_name")

    @property
    @pulumi.getter(name="assignmentStatus")
    def assignment_status(self) -> pulumi.Output[str]:
        """
        Status of the assignment. Valid values are `ENABLED`, `DISABLED`, and `DRAFT`.

        The following arguments are optional:
        """
        return pulumi.get(self, "assignment_status")

    @property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> pulumi.Output[str]:
        """
        AWS account ID.
        """
        return pulumi.get(self, "aws_account_id")

    @property
    @pulumi.getter
    def identities(self) -> pulumi.Output[Optional['outputs.IamPolicyAssignmentIdentities']]:
        """
        Amazon QuickSight users, groups, or both to assign the policy to. See `identities` block.
        """
        return pulumi.get(self, "identities")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[str]:
        """
        Namespace that contains the assignment. Defaults to `default`.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="policyArn")
    def policy_arn(self) -> pulumi.Output[Optional[str]]:
        """
        ARN of the IAM policy to apply to the Amazon QuickSight users and groups specified in this assignment.
        """
        return pulumi.get(self, "policy_arn")

