# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'ClusterMasterUserSecretArgs',
    'ClusterParameterGroupParameterArgs',
    'ClusterRestoreToPointInTimeArgs',
    'ClusterS3ImportArgs',
    'ClusterScalingConfigurationArgs',
    'ClusterServerlessv2ScalingConfigurationArgs',
    'ExportTaskTimeoutsArgs',
    'GlobalClusterGlobalClusterMemberArgs',
    'InstanceBlueGreenUpdateArgs',
    'InstanceListenerEndpointArgs',
    'InstanceMasterUserSecretArgs',
    'InstanceRestoreToPointInTimeArgs',
    'InstanceS3ImportArgs',
    'OptionGroupOptionArgs',
    'OptionGroupOptionOptionSettingArgs',
    'ParameterGroupParameterArgs',
    'ProxyAuthArgs',
    'ProxyDefaultTargetGroupConnectionPoolConfigArgs',
    'ReservedInstanceRecurringChargeArgs',
    'GetClustersFilterArgs',
    'GetEngineVersionFilterArgs',
    'GetInstancesFilterArgs',
]

@pulumi.input_type
class ClusterMasterUserSecretArgs:
    def __init__(__self__, *,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 secret_arn: Optional[pulumi.Input[str]] = None,
                 secret_status: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] kms_key_id: ARN for the KMS encryption key. When specifying `kms_key_id`, `storage_encrypted` needs to be set to true.
        :param pulumi.Input[str] secret_arn: Amazon Resource Name (ARN) of the secret.
        :param pulumi.Input[str] secret_status: Status of the secret. Valid Values: `creating` | `active` | `rotating` | `impaired`.
        """
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)
        if secret_status is not None:
            pulumi.set(__self__, "secret_status", secret_status)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARN for the KMS encryption key. When specifying `kms_key_id`, `storage_encrypted` needs to be set to true.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of the secret.
        """
        return pulumi.get(self, "secret_arn")

    @secret_arn.setter
    def secret_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_arn", value)

    @property
    @pulumi.getter(name="secretStatus")
    def secret_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the secret. Valid Values: `creating` | `active` | `rotating` | `impaired`.
        """
        return pulumi.get(self, "secret_status")

    @secret_status.setter
    def secret_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_status", value)


@pulumi.input_type
class ClusterParameterGroupParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str],
                 apply_method: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The name of the DB parameter.
        :param pulumi.Input[str] value: The value of the DB parameter.
        :param pulumi.Input[str] apply_method: "immediate" (default), or "pending-reboot". Some
               engines can't apply some parameters without a reboot, and you will need to
               specify "pending-reboot" here.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if apply_method is not None:
            pulumi.set(__self__, "apply_method", apply_method)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the DB parameter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value of the DB parameter.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="applyMethod")
    def apply_method(self) -> Optional[pulumi.Input[str]]:
        """
        "immediate" (default), or "pending-reboot". Some
        engines can't apply some parameters without a reboot, and you will need to
        specify "pending-reboot" here.
        """
        return pulumi.get(self, "apply_method")

    @apply_method.setter
    def apply_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "apply_method", value)


@pulumi.input_type
class ClusterRestoreToPointInTimeArgs:
    def __init__(__self__, *,
                 source_cluster_identifier: pulumi.Input[str],
                 restore_to_time: Optional[pulumi.Input[str]] = None,
                 restore_type: Optional[pulumi.Input[str]] = None,
                 use_latest_restorable_time: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] source_cluster_identifier: Identifier of the source database cluster from which to restore. When restoring from a cluster in another AWS account, the identifier is the ARN of that cluster.
        :param pulumi.Input[str] restore_to_time: Date and time in UTC format to restore the database cluster to. Conflicts with `use_latest_restorable_time`.
        :param pulumi.Input[str] restore_type: Type of restore to be performed.
               Valid options are `full-copy` (default) and `copy-on-write`.
        :param pulumi.Input[bool] use_latest_restorable_time: Set to true to restore the database cluster to the latest restorable backup time. Defaults to false. Conflicts with `restore_to_time`.
        """
        pulumi.set(__self__, "source_cluster_identifier", source_cluster_identifier)
        if restore_to_time is not None:
            pulumi.set(__self__, "restore_to_time", restore_to_time)
        if restore_type is not None:
            pulumi.set(__self__, "restore_type", restore_type)
        if use_latest_restorable_time is not None:
            pulumi.set(__self__, "use_latest_restorable_time", use_latest_restorable_time)

    @property
    @pulumi.getter(name="sourceClusterIdentifier")
    def source_cluster_identifier(self) -> pulumi.Input[str]:
        """
        Identifier of the source database cluster from which to restore. When restoring from a cluster in another AWS account, the identifier is the ARN of that cluster.
        """
        return pulumi.get(self, "source_cluster_identifier")

    @source_cluster_identifier.setter
    def source_cluster_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_cluster_identifier", value)

    @property
    @pulumi.getter(name="restoreToTime")
    def restore_to_time(self) -> Optional[pulumi.Input[str]]:
        """
        Date and time in UTC format to restore the database cluster to. Conflicts with `use_latest_restorable_time`.
        """
        return pulumi.get(self, "restore_to_time")

    @restore_to_time.setter
    def restore_to_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "restore_to_time", value)

    @property
    @pulumi.getter(name="restoreType")
    def restore_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of restore to be performed.
        Valid options are `full-copy` (default) and `copy-on-write`.
        """
        return pulumi.get(self, "restore_type")

    @restore_type.setter
    def restore_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "restore_type", value)

    @property
    @pulumi.getter(name="useLatestRestorableTime")
    def use_latest_restorable_time(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true to restore the database cluster to the latest restorable backup time. Defaults to false. Conflicts with `restore_to_time`.
        """
        return pulumi.get(self, "use_latest_restorable_time")

    @use_latest_restorable_time.setter
    def use_latest_restorable_time(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_latest_restorable_time", value)


@pulumi.input_type
class ClusterS3ImportArgs:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[str],
                 ingestion_role: pulumi.Input[str],
                 source_engine: pulumi.Input[str],
                 source_engine_version: pulumi.Input[str],
                 bucket_prefix: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket_name: Bucket name where your backup is stored
        :param pulumi.Input[str] ingestion_role: Role applied to load the data.
        :param pulumi.Input[str] source_engine: Source engine for the backup
        :param pulumi.Input[str] source_engine_version: Version of the source engine used to make the backup
               
               This will not recreate the resource if the S3 object changes in some way. It's only used to initialize the database. This only works currently with the aurora engine. See AWS for currently supported engines and options. See [Aurora S3 Migration Docs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AuroraMySQL.Migrating.ExtMySQL.html#AuroraMySQL.Migrating.ExtMySQL.S3).
        :param pulumi.Input[str] bucket_prefix: Can be blank, but is the path to your backup
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "ingestion_role", ingestion_role)
        pulumi.set(__self__, "source_engine", source_engine)
        pulumi.set(__self__, "source_engine_version", source_engine_version)
        if bucket_prefix is not None:
            pulumi.set(__self__, "bucket_prefix", bucket_prefix)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[str]:
        """
        Bucket name where your backup is stored
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="ingestionRole")
    def ingestion_role(self) -> pulumi.Input[str]:
        """
        Role applied to load the data.
        """
        return pulumi.get(self, "ingestion_role")

    @ingestion_role.setter
    def ingestion_role(self, value: pulumi.Input[str]):
        pulumi.set(self, "ingestion_role", value)

    @property
    @pulumi.getter(name="sourceEngine")
    def source_engine(self) -> pulumi.Input[str]:
        """
        Source engine for the backup
        """
        return pulumi.get(self, "source_engine")

    @source_engine.setter
    def source_engine(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_engine", value)

    @property
    @pulumi.getter(name="sourceEngineVersion")
    def source_engine_version(self) -> pulumi.Input[str]:
        """
        Version of the source engine used to make the backup

        This will not recreate the resource if the S3 object changes in some way. It's only used to initialize the database. This only works currently with the aurora engine. See AWS for currently supported engines and options. See [Aurora S3 Migration Docs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AuroraMySQL.Migrating.ExtMySQL.html#AuroraMySQL.Migrating.ExtMySQL.S3).
        """
        return pulumi.get(self, "source_engine_version")

    @source_engine_version.setter
    def source_engine_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_engine_version", value)

    @property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Can be blank, but is the path to your backup
        """
        return pulumi.get(self, "bucket_prefix")

    @bucket_prefix.setter
    def bucket_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket_prefix", value)


@pulumi.input_type
class ClusterScalingConfigurationArgs:
    def __init__(__self__, *,
                 auto_pause: Optional[pulumi.Input[bool]] = None,
                 max_capacity: Optional[pulumi.Input[int]] = None,
                 min_capacity: Optional[pulumi.Input[int]] = None,
                 seconds_until_auto_pause: Optional[pulumi.Input[int]] = None,
                 timeout_action: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] auto_pause: Whether to enable automatic pause. A DB cluster can be paused only when it's idle (it has no connections). If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this case, the DB cluster is restored when there is a request to connect to it. Defaults to `true`.
        :param pulumi.Input[int] max_capacity: Maximum capacity for an Aurora DB cluster in `serverless` DB engine mode. The maximum capacity must be greater than or equal to the minimum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `16`.
        :param pulumi.Input[int] min_capacity: Minimum capacity for an Aurora DB cluster in `serverless` DB engine mode. The minimum capacity must be lesser than or equal to the maximum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `1`.
        :param pulumi.Input[int] seconds_until_auto_pause: Time, in seconds, before an Aurora DB cluster in serverless mode is paused. Valid values are `300` through `86400`. Defaults to `300`.
        :param pulumi.Input[str] timeout_action: Action to take when the timeout is reached. Valid values: `ForceApplyCapacityChange`, `RollbackCapacityChange`. Defaults to `RollbackCapacityChange`. See [documentation](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.timeout-action).
        """
        if auto_pause is not None:
            pulumi.set(__self__, "auto_pause", auto_pause)
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if min_capacity is not None:
            pulumi.set(__self__, "min_capacity", min_capacity)
        if seconds_until_auto_pause is not None:
            pulumi.set(__self__, "seconds_until_auto_pause", seconds_until_auto_pause)
        if timeout_action is not None:
            pulumi.set(__self__, "timeout_action", timeout_action)

    @property
    @pulumi.getter(name="autoPause")
    def auto_pause(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable automatic pause. A DB cluster can be paused only when it's idle (it has no connections). If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this case, the DB cluster is restored when there is a request to connect to it. Defaults to `true`.
        """
        return pulumi.get(self, "auto_pause")

    @auto_pause.setter
    def auto_pause(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_pause", value)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum capacity for an Aurora DB cluster in `serverless` DB engine mode. The maximum capacity must be greater than or equal to the minimum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `16`.
        """
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_capacity", value)

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum capacity for an Aurora DB cluster in `serverless` DB engine mode. The minimum capacity must be lesser than or equal to the maximum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `1`.
        """
        return pulumi.get(self, "min_capacity")

    @min_capacity.setter
    def min_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_capacity", value)

    @property
    @pulumi.getter(name="secondsUntilAutoPause")
    def seconds_until_auto_pause(self) -> Optional[pulumi.Input[int]]:
        """
        Time, in seconds, before an Aurora DB cluster in serverless mode is paused. Valid values are `300` through `86400`. Defaults to `300`.
        """
        return pulumi.get(self, "seconds_until_auto_pause")

    @seconds_until_auto_pause.setter
    def seconds_until_auto_pause(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "seconds_until_auto_pause", value)

    @property
    @pulumi.getter(name="timeoutAction")
    def timeout_action(self) -> Optional[pulumi.Input[str]]:
        """
        Action to take when the timeout is reached. Valid values: `ForceApplyCapacityChange`, `RollbackCapacityChange`. Defaults to `RollbackCapacityChange`. See [documentation](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.timeout-action).
        """
        return pulumi.get(self, "timeout_action")

    @timeout_action.setter
    def timeout_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout_action", value)


@pulumi.input_type
class ClusterServerlessv2ScalingConfigurationArgs:
    def __init__(__self__, *,
                 max_capacity: pulumi.Input[float],
                 min_capacity: pulumi.Input[float]):
        """
        :param pulumi.Input[float] max_capacity: Maximum capacity for an Aurora DB cluster in `serverless` DB engine mode. The maximum capacity must be greater than or equal to the minimum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `16`.
        :param pulumi.Input[float] min_capacity: Minimum capacity for an Aurora DB cluster in `serverless` DB engine mode. The minimum capacity must be lesser than or equal to the maximum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `1`.
        """
        pulumi.set(__self__, "max_capacity", max_capacity)
        pulumi.set(__self__, "min_capacity", min_capacity)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> pulumi.Input[float]:
        """
        Maximum capacity for an Aurora DB cluster in `serverless` DB engine mode. The maximum capacity must be greater than or equal to the minimum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `16`.
        """
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: pulumi.Input[float]):
        pulumi.set(self, "max_capacity", value)

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> pulumi.Input[float]:
        """
        Minimum capacity for an Aurora DB cluster in `serverless` DB engine mode. The minimum capacity must be lesser than or equal to the maximum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `1`.
        """
        return pulumi.get(self, "min_capacity")

    @min_capacity.setter
    def min_capacity(self, value: pulumi.Input[float]):
        pulumi.set(self, "min_capacity", value)


@pulumi.input_type
class ExportTaskTimeoutsArgs:
    def __init__(__self__, *,
                 create: Optional[pulumi.Input[str]] = None,
                 delete: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param pulumi.Input[str] delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)

    @property
    @pulumi.getter
    def create(self) -> Optional[pulumi.Input[str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @create.setter
    def create(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create", value)

    @property
    @pulumi.getter
    def delete(self) -> Optional[pulumi.Input[str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @delete.setter
    def delete(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delete", value)


@pulumi.input_type
class GlobalClusterGlobalClusterMemberArgs:
    def __init__(__self__, *,
                 db_cluster_arn: Optional[pulumi.Input[str]] = None,
                 is_writer: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] db_cluster_arn: Amazon Resource Name (ARN) of member DB Cluster
        :param pulumi.Input[bool] is_writer: Whether the member is the primary DB Cluster
        """
        if db_cluster_arn is not None:
            pulumi.set(__self__, "db_cluster_arn", db_cluster_arn)
        if is_writer is not None:
            pulumi.set(__self__, "is_writer", is_writer)

    @property
    @pulumi.getter(name="dbClusterArn")
    def db_cluster_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of member DB Cluster
        """
        return pulumi.get(self, "db_cluster_arn")

    @db_cluster_arn.setter
    def db_cluster_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_cluster_arn", value)

    @property
    @pulumi.getter(name="isWriter")
    def is_writer(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the member is the primary DB Cluster
        """
        return pulumi.get(self, "is_writer")

    @is_writer.setter
    def is_writer(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_writer", value)


@pulumi.input_type
class InstanceBlueGreenUpdateArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] enabled: Enables low-downtime updates when `true`.
               Default is `false`.
               
               [instance-replication]:
               https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Replication.html
               [instance-maintenance]:
               https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html
               [blue-green]:
               https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables low-downtime updates when `true`.
        Default is `false`.

        [instance-replication]:
        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Replication.html
        [instance-maintenance]:
        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html
        [blue-green]:
        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class InstanceListenerEndpointArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 hosted_zone_id: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] address: Specifies the DNS address of the DB instance.
        :param pulumi.Input[str] hosted_zone_id: Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
        :param pulumi.Input[int] port: The port on which the DB accepts connections.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if hosted_zone_id is not None:
            pulumi.set(__self__, "hosted_zone_id", hosted_zone_id)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the DNS address of the DB instance.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="hostedZoneId")
    def hosted_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
        """
        return pulumi.get(self, "hosted_zone_id")

    @hosted_zone_id.setter
    def hosted_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hosted_zone_id", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port on which the DB accepts connections.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class InstanceMasterUserSecretArgs:
    def __init__(__self__, *,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 secret_arn: Optional[pulumi.Input[str]] = None,
                 secret_status: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] kms_key_id: The ARN for the KMS encryption key. If creating an
               encrypted replica, set this to the destination KMS ARN.
        :param pulumi.Input[str] secret_arn: The Amazon Resource Name (ARN) of the secret.
        :param pulumi.Input[str] secret_status: The status of the secret. Valid Values: `creating` | `active` | `rotating` | `impaired`.
        """
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)
        if secret_status is not None:
            pulumi.set(__self__, "secret_status", secret_status)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN for the KMS encryption key. If creating an
        encrypted replica, set this to the destination KMS ARN.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the secret.
        """
        return pulumi.get(self, "secret_arn")

    @secret_arn.setter
    def secret_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_arn", value)

    @property
    @pulumi.getter(name="secretStatus")
    def secret_status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the secret. Valid Values: `creating` | `active` | `rotating` | `impaired`.
        """
        return pulumi.get(self, "secret_status")

    @secret_status.setter
    def secret_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_status", value)


@pulumi.input_type
class InstanceRestoreToPointInTimeArgs:
    def __init__(__self__, *,
                 restore_time: Optional[pulumi.Input[str]] = None,
                 source_db_instance_automated_backups_arn: Optional[pulumi.Input[str]] = None,
                 source_db_instance_identifier: Optional[pulumi.Input[str]] = None,
                 source_dbi_resource_id: Optional[pulumi.Input[str]] = None,
                 use_latest_restorable_time: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] restore_time: The date and time to restore from. Value must be a time in Universal Coordinated Time (UTC) format and must be before the latest restorable time for the DB instance. Cannot be specified with `use_latest_restorable_time`.
        :param pulumi.Input[str] source_db_instance_automated_backups_arn: The ARN of the automated backup from which to restore. Required if `source_db_instance_identifier` or `source_dbi_resource_id` is not specified.
        :param pulumi.Input[str] source_db_instance_identifier: The identifier of the source DB instance from which to restore. Must match the identifier of an existing DB instance. Required if `source_db_instance_automated_backups_arn` or `source_dbi_resource_id` is not specified.
        :param pulumi.Input[str] source_dbi_resource_id: The resource ID of the source DB instance from which to restore. Required if `source_db_instance_identifier` or `source_db_instance_automated_backups_arn` is not specified.
        :param pulumi.Input[bool] use_latest_restorable_time: A boolean value that indicates whether the DB instance is restored from the latest backup time. Defaults to `false`. Cannot be specified with `restore_time`.
        """
        if restore_time is not None:
            pulumi.set(__self__, "restore_time", restore_time)
        if source_db_instance_automated_backups_arn is not None:
            pulumi.set(__self__, "source_db_instance_automated_backups_arn", source_db_instance_automated_backups_arn)
        if source_db_instance_identifier is not None:
            pulumi.set(__self__, "source_db_instance_identifier", source_db_instance_identifier)
        if source_dbi_resource_id is not None:
            pulumi.set(__self__, "source_dbi_resource_id", source_dbi_resource_id)
        if use_latest_restorable_time is not None:
            pulumi.set(__self__, "use_latest_restorable_time", use_latest_restorable_time)

    @property
    @pulumi.getter(name="restoreTime")
    def restore_time(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time to restore from. Value must be a time in Universal Coordinated Time (UTC) format and must be before the latest restorable time for the DB instance. Cannot be specified with `use_latest_restorable_time`.
        """
        return pulumi.get(self, "restore_time")

    @restore_time.setter
    def restore_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "restore_time", value)

    @property
    @pulumi.getter(name="sourceDbInstanceAutomatedBackupsArn")
    def source_db_instance_automated_backups_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the automated backup from which to restore. Required if `source_db_instance_identifier` or `source_dbi_resource_id` is not specified.
        """
        return pulumi.get(self, "source_db_instance_automated_backups_arn")

    @source_db_instance_automated_backups_arn.setter
    def source_db_instance_automated_backups_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_db_instance_automated_backups_arn", value)

    @property
    @pulumi.getter(name="sourceDbInstanceIdentifier")
    def source_db_instance_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the source DB instance from which to restore. Must match the identifier of an existing DB instance. Required if `source_db_instance_automated_backups_arn` or `source_dbi_resource_id` is not specified.
        """
        return pulumi.get(self, "source_db_instance_identifier")

    @source_db_instance_identifier.setter
    def source_db_instance_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_db_instance_identifier", value)

    @property
    @pulumi.getter(name="sourceDbiResourceId")
    def source_dbi_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource ID of the source DB instance from which to restore. Required if `source_db_instance_identifier` or `source_db_instance_automated_backups_arn` is not specified.
        """
        return pulumi.get(self, "source_dbi_resource_id")

    @source_dbi_resource_id.setter
    def source_dbi_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_dbi_resource_id", value)

    @property
    @pulumi.getter(name="useLatestRestorableTime")
    def use_latest_restorable_time(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean value that indicates whether the DB instance is restored from the latest backup time. Defaults to `false`. Cannot be specified with `restore_time`.
        """
        return pulumi.get(self, "use_latest_restorable_time")

    @use_latest_restorable_time.setter
    def use_latest_restorable_time(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_latest_restorable_time", value)


@pulumi.input_type
class InstanceS3ImportArgs:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[str],
                 ingestion_role: pulumi.Input[str],
                 source_engine: pulumi.Input[str],
                 source_engine_version: pulumi.Input[str],
                 bucket_prefix: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket_name: The bucket name where your backup is stored
        :param pulumi.Input[str] ingestion_role: Role applied to load the data.
        :param pulumi.Input[str] source_engine: Source engine for the backup
        :param pulumi.Input[str] source_engine_version: Version of the source engine used to make the backup
               
               This will not recreate the resource if the S3 object changes in some way.  It's only used to initialize the database.
        :param pulumi.Input[str] bucket_prefix: Can be blank, but is the path to your backup
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "ingestion_role", ingestion_role)
        pulumi.set(__self__, "source_engine", source_engine)
        pulumi.set(__self__, "source_engine_version", source_engine_version)
        if bucket_prefix is not None:
            pulumi.set(__self__, "bucket_prefix", bucket_prefix)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[str]:
        """
        The bucket name where your backup is stored
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="ingestionRole")
    def ingestion_role(self) -> pulumi.Input[str]:
        """
        Role applied to load the data.
        """
        return pulumi.get(self, "ingestion_role")

    @ingestion_role.setter
    def ingestion_role(self, value: pulumi.Input[str]):
        pulumi.set(self, "ingestion_role", value)

    @property
    @pulumi.getter(name="sourceEngine")
    def source_engine(self) -> pulumi.Input[str]:
        """
        Source engine for the backup
        """
        return pulumi.get(self, "source_engine")

    @source_engine.setter
    def source_engine(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_engine", value)

    @property
    @pulumi.getter(name="sourceEngineVersion")
    def source_engine_version(self) -> pulumi.Input[str]:
        """
        Version of the source engine used to make the backup

        This will not recreate the resource if the S3 object changes in some way.  It's only used to initialize the database.
        """
        return pulumi.get(self, "source_engine_version")

    @source_engine_version.setter
    def source_engine_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_engine_version", value)

    @property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Can be blank, but is the path to your backup
        """
        return pulumi.get(self, "bucket_prefix")

    @bucket_prefix.setter
    def bucket_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket_prefix", value)


@pulumi.input_type
class OptionGroupOptionArgs:
    def __init__(__self__, *,
                 option_name: pulumi.Input[str],
                 db_security_group_memberships: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 option_settings: Optional[pulumi.Input[Sequence[pulumi.Input['OptionGroupOptionOptionSettingArgs']]]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 vpc_security_group_memberships: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] option_name: Name of the option (e.g., MEMCACHED).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] db_security_group_memberships: List of DB Security Groups for which the option is enabled.
        :param pulumi.Input[Sequence[pulumi.Input['OptionGroupOptionOptionSettingArgs']]] option_settings: The option settings to apply. See `option_settings` Block below for more details.
        :param pulumi.Input[int] port: Port number when connecting to the option (e.g., 11211). Leaving out or removing `port` from your configuration does not remove or clear a port from the option in AWS. AWS may assign a default port. Not including `port` in your configuration means that the AWS provider will ignore a previously set value, a value set by AWS, and any port changes.
        :param pulumi.Input[str] version: Version of the option (e.g., 13.1.0.0). Leaving out or removing `version` from your configuration does not remove or clear a version from the option in AWS. AWS may assign a default version. Not including `version` in your configuration means that the AWS provider will ignore a previously set value, a value set by AWS, and any version changes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_security_group_memberships: List of VPC Security Groups for which the option is enabled.
        """
        pulumi.set(__self__, "option_name", option_name)
        if db_security_group_memberships is not None:
            pulumi.set(__self__, "db_security_group_memberships", db_security_group_memberships)
        if option_settings is not None:
            pulumi.set(__self__, "option_settings", option_settings)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vpc_security_group_memberships is not None:
            pulumi.set(__self__, "vpc_security_group_memberships", vpc_security_group_memberships)

    @property
    @pulumi.getter(name="optionName")
    def option_name(self) -> pulumi.Input[str]:
        """
        Name of the option (e.g., MEMCACHED).
        """
        return pulumi.get(self, "option_name")

    @option_name.setter
    def option_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "option_name", value)

    @property
    @pulumi.getter(name="dbSecurityGroupMemberships")
    def db_security_group_memberships(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of DB Security Groups for which the option is enabled.
        """
        return pulumi.get(self, "db_security_group_memberships")

    @db_security_group_memberships.setter
    def db_security_group_memberships(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "db_security_group_memberships", value)

    @property
    @pulumi.getter(name="optionSettings")
    def option_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OptionGroupOptionOptionSettingArgs']]]]:
        """
        The option settings to apply. See `option_settings` Block below for more details.
        """
        return pulumi.get(self, "option_settings")

    @option_settings.setter
    def option_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OptionGroupOptionOptionSettingArgs']]]]):
        pulumi.set(self, "option_settings", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port number when connecting to the option (e.g., 11211). Leaving out or removing `port` from your configuration does not remove or clear a port from the option in AWS. AWS may assign a default port. Not including `port` in your configuration means that the AWS provider will ignore a previously set value, a value set by AWS, and any port changes.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the option (e.g., 13.1.0.0). Leaving out or removing `version` from your configuration does not remove or clear a version from the option in AWS. AWS may assign a default version. Not including `version` in your configuration means that the AWS provider will ignore a previously set value, a value set by AWS, and any version changes.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="vpcSecurityGroupMemberships")
    def vpc_security_group_memberships(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of VPC Security Groups for which the option is enabled.
        """
        return pulumi.get(self, "vpc_security_group_memberships")

    @vpc_security_group_memberships.setter
    def vpc_security_group_memberships(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vpc_security_group_memberships", value)


@pulumi.input_type
class OptionGroupOptionOptionSettingArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: Name of the setting.
        :param pulumi.Input[str] value: Value of the setting.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the setting.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Value of the setting.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ParameterGroupParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str],
                 apply_method: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The name of the DB parameter.
        :param pulumi.Input[str] value: The value of the DB parameter.
        :param pulumi.Input[str] apply_method: "immediate" (default), or "pending-reboot". Some
               engines can't apply some parameters without a reboot, and you will need to
               specify "pending-reboot" here.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if apply_method is not None:
            pulumi.set(__self__, "apply_method", apply_method)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the DB parameter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value of the DB parameter.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="applyMethod")
    def apply_method(self) -> Optional[pulumi.Input[str]]:
        """
        "immediate" (default), or "pending-reboot". Some
        engines can't apply some parameters without a reboot, and you will need to
        specify "pending-reboot" here.
        """
        return pulumi.get(self, "apply_method")

    @apply_method.setter
    def apply_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "apply_method", value)


@pulumi.input_type
class ProxyAuthArgs:
    def __init__(__self__, *,
                 auth_scheme: Optional[pulumi.Input[str]] = None,
                 client_password_auth_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 iam_auth: Optional[pulumi.Input[str]] = None,
                 secret_arn: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] auth_scheme: The type of authentication that the proxy uses for connections from the proxy to the underlying database. One of `SECRETS`.
        :param pulumi.Input[str] client_password_auth_type: The type of authentication the proxy uses for connections from clients. Valid values are `MYSQL_NATIVE_PASSWORD`, `POSTGRES_SCRAM_SHA_256`, `POSTGRES_MD5`, and `SQL_SERVER_AUTHENTICATION`.
        :param pulumi.Input[str] description: A user-specified description about the authentication used by a proxy to log in as a specific database user.
        :param pulumi.Input[str] iam_auth: Whether to require or disallow AWS Identity and Access Management (IAM) authentication for connections to the proxy. One of `DISABLED`, `REQUIRED`.
        :param pulumi.Input[str] secret_arn: The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager.
        :param pulumi.Input[str] username: The name of the database user to which the proxy connects.
        """
        if auth_scheme is not None:
            pulumi.set(__self__, "auth_scheme", auth_scheme)
        if client_password_auth_type is not None:
            pulumi.set(__self__, "client_password_auth_type", client_password_auth_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if iam_auth is not None:
            pulumi.set(__self__, "iam_auth", iam_auth)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="authScheme")
    def auth_scheme(self) -> Optional[pulumi.Input[str]]:
        """
        The type of authentication that the proxy uses for connections from the proxy to the underlying database. One of `SECRETS`.
        """
        return pulumi.get(self, "auth_scheme")

    @auth_scheme.setter
    def auth_scheme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_scheme", value)

    @property
    @pulumi.getter(name="clientPasswordAuthType")
    def client_password_auth_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of authentication the proxy uses for connections from clients. Valid values are `MYSQL_NATIVE_PASSWORD`, `POSTGRES_SCRAM_SHA_256`, `POSTGRES_MD5`, and `SQL_SERVER_AUTHENTICATION`.
        """
        return pulumi.get(self, "client_password_auth_type")

    @client_password_auth_type.setter
    def client_password_auth_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_password_auth_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A user-specified description about the authentication used by a proxy to log in as a specific database user.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="iamAuth")
    def iam_auth(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to require or disallow AWS Identity and Access Management (IAM) authentication for connections to the proxy. One of `DISABLED`, `REQUIRED`.
        """
        return pulumi.get(self, "iam_auth")

    @iam_auth.setter
    def iam_auth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iam_auth", value)

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager.
        """
        return pulumi.get(self, "secret_arn")

    @secret_arn.setter
    def secret_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_arn", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the database user to which the proxy connects.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class ProxyDefaultTargetGroupConnectionPoolConfigArgs:
    def __init__(__self__, *,
                 connection_borrow_timeout: Optional[pulumi.Input[int]] = None,
                 init_query: Optional[pulumi.Input[str]] = None,
                 max_connections_percent: Optional[pulumi.Input[int]] = None,
                 max_idle_connections_percent: Optional[pulumi.Input[int]] = None,
                 session_pinning_filters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[int] connection_borrow_timeout: The number of seconds for a proxy to wait for a connection to become available in the connection pool. Only applies when the proxy has opened its maximum number of connections and all connections are busy with client sessions.
        :param pulumi.Input[str] init_query: One or more SQL statements for the proxy to run when opening each new database connection. Typically used with `SET` statements to make sure that each connection has identical settings such as time zone and character set. This setting is empty by default. For multiple statements, use semicolons as the separator. You can also include multiple variables in a single `SET` statement, such as `SET x=1, y=2`.
        :param pulumi.Input[int] max_connections_percent: The maximum size of the connection pool for each target in a target group. For Aurora MySQL, it is expressed as a percentage of the max_connections setting for the RDS DB instance or Aurora DB cluster used by the target group.
        :param pulumi.Input[int] max_idle_connections_percent: Controls how actively the proxy closes idle database connections in the connection pool. A high value enables the proxy to leave a high percentage of idle connections open. A low value causes the proxy to close idle client connections and return the underlying database connections to the connection pool. For Aurora MySQL, it is expressed as a percentage of the max_connections setting for the RDS DB instance or Aurora DB cluster used by the target group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] session_pinning_filters: Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection. Including an item in the list exempts that class of SQL operations from the pinning behavior. Currently, the only allowed value is `EXCLUDE_VARIABLE_SETS`.
        """
        if connection_borrow_timeout is not None:
            pulumi.set(__self__, "connection_borrow_timeout", connection_borrow_timeout)
        if init_query is not None:
            pulumi.set(__self__, "init_query", init_query)
        if max_connections_percent is not None:
            pulumi.set(__self__, "max_connections_percent", max_connections_percent)
        if max_idle_connections_percent is not None:
            pulumi.set(__self__, "max_idle_connections_percent", max_idle_connections_percent)
        if session_pinning_filters is not None:
            pulumi.set(__self__, "session_pinning_filters", session_pinning_filters)

    @property
    @pulumi.getter(name="connectionBorrowTimeout")
    def connection_borrow_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The number of seconds for a proxy to wait for a connection to become available in the connection pool. Only applies when the proxy has opened its maximum number of connections and all connections are busy with client sessions.
        """
        return pulumi.get(self, "connection_borrow_timeout")

    @connection_borrow_timeout.setter
    def connection_borrow_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "connection_borrow_timeout", value)

    @property
    @pulumi.getter(name="initQuery")
    def init_query(self) -> Optional[pulumi.Input[str]]:
        """
        One or more SQL statements for the proxy to run when opening each new database connection. Typically used with `SET` statements to make sure that each connection has identical settings such as time zone and character set. This setting is empty by default. For multiple statements, use semicolons as the separator. You can also include multiple variables in a single `SET` statement, such as `SET x=1, y=2`.
        """
        return pulumi.get(self, "init_query")

    @init_query.setter
    def init_query(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "init_query", value)

    @property
    @pulumi.getter(name="maxConnectionsPercent")
    def max_connections_percent(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum size of the connection pool for each target in a target group. For Aurora MySQL, it is expressed as a percentage of the max_connections setting for the RDS DB instance or Aurora DB cluster used by the target group.
        """
        return pulumi.get(self, "max_connections_percent")

    @max_connections_percent.setter
    def max_connections_percent(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_connections_percent", value)

    @property
    @pulumi.getter(name="maxIdleConnectionsPercent")
    def max_idle_connections_percent(self) -> Optional[pulumi.Input[int]]:
        """
        Controls how actively the proxy closes idle database connections in the connection pool. A high value enables the proxy to leave a high percentage of idle connections open. A low value causes the proxy to close idle client connections and return the underlying database connections to the connection pool. For Aurora MySQL, it is expressed as a percentage of the max_connections setting for the RDS DB instance or Aurora DB cluster used by the target group.
        """
        return pulumi.get(self, "max_idle_connections_percent")

    @max_idle_connections_percent.setter
    def max_idle_connections_percent(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_idle_connections_percent", value)

    @property
    @pulumi.getter(name="sessionPinningFilters")
    def session_pinning_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection. Including an item in the list exempts that class of SQL operations from the pinning behavior. Currently, the only allowed value is `EXCLUDE_VARIABLE_SETS`.
        """
        return pulumi.get(self, "session_pinning_filters")

    @session_pinning_filters.setter
    def session_pinning_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "session_pinning_filters", value)


@pulumi.input_type
class ReservedInstanceRecurringChargeArgs:
    def __init__(__self__, *,
                 recurring_charge_amount: Optional[pulumi.Input[int]] = None,
                 recurring_charge_frequency: Optional[pulumi.Input[str]] = None):
        if recurring_charge_amount is not None:
            pulumi.set(__self__, "recurring_charge_amount", recurring_charge_amount)
        if recurring_charge_frequency is not None:
            pulumi.set(__self__, "recurring_charge_frequency", recurring_charge_frequency)

    @property
    @pulumi.getter(name="recurringChargeAmount")
    def recurring_charge_amount(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "recurring_charge_amount")

    @recurring_charge_amount.setter
    def recurring_charge_amount(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recurring_charge_amount", value)

    @property
    @pulumi.getter(name="recurringChargeFrequency")
    def recurring_charge_frequency(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "recurring_charge_frequency")

    @recurring_charge_frequency.setter
    def recurring_charge_frequency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recurring_charge_frequency", value)


@pulumi.input_type
class GetClustersFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Name of the filter field. Valid values can be found in the [RDS DescribeDBClusters API Reference](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBClusters.html).
        :param Sequence[str] values: Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the filter field. Valid values can be found in the [RDS DescribeDBClusters API Reference](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBClusters.html).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetEngineVersionFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetInstancesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Name of the filter field. Valid values can be found in the [RDS DescribeDBClusters API Reference](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBClusters.html) or [RDS DescribeDBInstances API Reference](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstances.html).
        :param Sequence[str] values: Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the filter field. Valid values can be found in the [RDS DescribeDBClusters API Reference](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBClusters.html) or [RDS DescribeDBInstances API Reference](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstances.html).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


