# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AuthenticationProfileArgs', 'AuthenticationProfile']

@pulumi.input_type
class AuthenticationProfileArgs:
    def __init__(__self__, *,
                 authentication_profile_content: pulumi.Input[str],
                 authentication_profile_name: pulumi.Input[str]):
        """
        The set of arguments for constructing a AuthenticationProfile resource.
        :param pulumi.Input[str] authentication_profile_content: The content of the authentication profile in JSON format. The maximum length of the JSON string is determined by a quota for your account.
        :param pulumi.Input[str] authentication_profile_name: The name of the authentication profile.
        """
        pulumi.set(__self__, "authentication_profile_content", authentication_profile_content)
        pulumi.set(__self__, "authentication_profile_name", authentication_profile_name)

    @property
    @pulumi.getter(name="authenticationProfileContent")
    def authentication_profile_content(self) -> pulumi.Input[str]:
        """
        The content of the authentication profile in JSON format. The maximum length of the JSON string is determined by a quota for your account.
        """
        return pulumi.get(self, "authentication_profile_content")

    @authentication_profile_content.setter
    def authentication_profile_content(self, value: pulumi.Input[str]):
        pulumi.set(self, "authentication_profile_content", value)

    @property
    @pulumi.getter(name="authenticationProfileName")
    def authentication_profile_name(self) -> pulumi.Input[str]:
        """
        The name of the authentication profile.
        """
        return pulumi.get(self, "authentication_profile_name")

    @authentication_profile_name.setter
    def authentication_profile_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "authentication_profile_name", value)


@pulumi.input_type
class _AuthenticationProfileState:
    def __init__(__self__, *,
                 authentication_profile_content: Optional[pulumi.Input[str]] = None,
                 authentication_profile_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AuthenticationProfile resources.
        :param pulumi.Input[str] authentication_profile_content: The content of the authentication profile in JSON format. The maximum length of the JSON string is determined by a quota for your account.
        :param pulumi.Input[str] authentication_profile_name: The name of the authentication profile.
        """
        if authentication_profile_content is not None:
            pulumi.set(__self__, "authentication_profile_content", authentication_profile_content)
        if authentication_profile_name is not None:
            pulumi.set(__self__, "authentication_profile_name", authentication_profile_name)

    @property
    @pulumi.getter(name="authenticationProfileContent")
    def authentication_profile_content(self) -> Optional[pulumi.Input[str]]:
        """
        The content of the authentication profile in JSON format. The maximum length of the JSON string is determined by a quota for your account.
        """
        return pulumi.get(self, "authentication_profile_content")

    @authentication_profile_content.setter
    def authentication_profile_content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authentication_profile_content", value)

    @property
    @pulumi.getter(name="authenticationProfileName")
    def authentication_profile_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the authentication profile.
        """
        return pulumi.get(self, "authentication_profile_name")

    @authentication_profile_name.setter
    def authentication_profile_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authentication_profile_name", value)


class AuthenticationProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_profile_content: Optional[pulumi.Input[str]] = None,
                 authentication_profile_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a Redshift authentication profile

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.redshift.AuthenticationProfile("example",
            authentication_profile_name="example",
            authentication_profile_content=json.dumps({
                "allowDBUserOverride": "1",
                "clientID": "ExampleClientID",
                "appID": "example",
            }))
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Redshift Authentication by `authentication_profile_name`. For example:

        ```sh
        $ pulumi import aws:redshift/authenticationProfile:AuthenticationProfile test example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] authentication_profile_content: The content of the authentication profile in JSON format. The maximum length of the JSON string is determined by a quota for your account.
        :param pulumi.Input[str] authentication_profile_name: The name of the authentication profile.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthenticationProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a Redshift authentication profile

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.redshift.AuthenticationProfile("example",
            authentication_profile_name="example",
            authentication_profile_content=json.dumps({
                "allowDBUserOverride": "1",
                "clientID": "ExampleClientID",
                "appID": "example",
            }))
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Redshift Authentication by `authentication_profile_name`. For example:

        ```sh
        $ pulumi import aws:redshift/authenticationProfile:AuthenticationProfile test example
        ```

        :param str resource_name: The name of the resource.
        :param AuthenticationProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthenticationProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_profile_content: Optional[pulumi.Input[str]] = None,
                 authentication_profile_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthenticationProfileArgs.__new__(AuthenticationProfileArgs)

            if authentication_profile_content is None and not opts.urn:
                raise TypeError("Missing required property 'authentication_profile_content'")
            __props__.__dict__["authentication_profile_content"] = authentication_profile_content
            if authentication_profile_name is None and not opts.urn:
                raise TypeError("Missing required property 'authentication_profile_name'")
            __props__.__dict__["authentication_profile_name"] = authentication_profile_name
        super(AuthenticationProfile, __self__).__init__(
            'aws:redshift/authenticationProfile:AuthenticationProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication_profile_content: Optional[pulumi.Input[str]] = None,
            authentication_profile_name: Optional[pulumi.Input[str]] = None) -> 'AuthenticationProfile':
        """
        Get an existing AuthenticationProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] authentication_profile_content: The content of the authentication profile in JSON format. The maximum length of the JSON string is determined by a quota for your account.
        :param pulumi.Input[str] authentication_profile_name: The name of the authentication profile.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthenticationProfileState.__new__(_AuthenticationProfileState)

        __props__.__dict__["authentication_profile_content"] = authentication_profile_content
        __props__.__dict__["authentication_profile_name"] = authentication_profile_name
        return AuthenticationProfile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authenticationProfileContent")
    def authentication_profile_content(self) -> pulumi.Output[str]:
        """
        The content of the authentication profile in JSON format. The maximum length of the JSON string is determined by a quota for your account.
        """
        return pulumi.get(self, "authentication_profile_content")

    @property
    @pulumi.getter(name="authenticationProfileName")
    def authentication_profile_name(self) -> pulumi.Output[str]:
        """
        The name of the authentication profile.
        """
        return pulumi.get(self, "authentication_profile_name")

