# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'RecordAliasArgs',
    'RecordCidrRoutingPolicyArgs',
    'RecordFailoverRoutingPolicyArgs',
    'RecordGeolocationRoutingPolicyArgs',
    'RecordGeoproximityRoutingPolicyArgs',
    'RecordGeoproximityRoutingPolicyCoordinateArgs',
    'RecordLatencyRoutingPolicyArgs',
    'RecordWeightedRoutingPolicyArgs',
    'ResolverEndpointIpAddressArgs',
    'ResolverRuleTargetIpArgs',
    'ZoneVpcArgs',
    'GetQueryLogConfigFilterArgs',
    'GetResolverEndpointFilterArgs',
    'GetTrafficPolicyDocumentEndpointArgs',
    'GetTrafficPolicyDocumentRuleArgs',
    'GetTrafficPolicyDocumentRuleGeoProximityLocationArgs',
    'GetTrafficPolicyDocumentRuleItemArgs',
    'GetTrafficPolicyDocumentRuleLocationArgs',
    'GetTrafficPolicyDocumentRulePrimaryArgs',
    'GetTrafficPolicyDocumentRuleRegionArgs',
    'GetTrafficPolicyDocumentRuleSecondaryArgs',
]

@pulumi.input_type
class RecordAliasArgs:
    def __init__(__self__, *,
                 evaluate_target_health: pulumi.Input[bool],
                 name: pulumi.Input[str],
                 zone_id: pulumi.Input[str]):
        """
        :param pulumi.Input[bool] evaluate_target_health: Set to `true` if you want Route 53 to determine whether to respond to DNS queries using this resource record set by checking the health of the resource record set. Some resources have special requirements, see [related part of documentation](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/resource-record-sets-values.html#rrsets-values-alias-evaluate-target-health).
        :param pulumi.Input[str] name: DNS domain name for a CloudFront distribution, S3 bucket, ELB, or another resource record set in this hosted zone.
        :param pulumi.Input[str] zone_id: Hosted zone ID for a CloudFront distribution, S3 bucket, ELB, or Route 53 hosted zone. See `resource_elb.zone_id` for example.
        """
        pulumi.set(__self__, "evaluate_target_health", evaluate_target_health)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="evaluateTargetHealth")
    def evaluate_target_health(self) -> pulumi.Input[bool]:
        """
        Set to `true` if you want Route 53 to determine whether to respond to DNS queries using this resource record set by checking the health of the resource record set. Some resources have special requirements, see [related part of documentation](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/resource-record-sets-values.html#rrsets-values-alias-evaluate-target-health).
        """
        return pulumi.get(self, "evaluate_target_health")

    @evaluate_target_health.setter
    def evaluate_target_health(self, value: pulumi.Input[bool]):
        pulumi.set(self, "evaluate_target_health", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        DNS domain name for a CloudFront distribution, S3 bucket, ELB, or another resource record set in this hosted zone.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[str]:
        """
        Hosted zone ID for a CloudFront distribution, S3 bucket, ELB, or Route 53 hosted zone. See `resource_elb.zone_id` for example.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class RecordCidrRoutingPolicyArgs:
    def __init__(__self__, *,
                 collection_id: pulumi.Input[str],
                 location_name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] collection_id: The CIDR collection ID. See the `route53.CidrCollection` resource for more details.
        :param pulumi.Input[str] location_name: The CIDR collection location name. See the `route53.CidrLocation` resource for more details. A `location_name` with an asterisk `"*"` can be used to create a default CIDR record. `collection_id` is still required for default record.
        """
        pulumi.set(__self__, "collection_id", collection_id)
        pulumi.set(__self__, "location_name", location_name)

    @property
    @pulumi.getter(name="collectionId")
    def collection_id(self) -> pulumi.Input[str]:
        """
        The CIDR collection ID. See the `route53.CidrCollection` resource for more details.
        """
        return pulumi.get(self, "collection_id")

    @collection_id.setter
    def collection_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "collection_id", value)

    @property
    @pulumi.getter(name="locationName")
    def location_name(self) -> pulumi.Input[str]:
        """
        The CIDR collection location name. See the `route53.CidrLocation` resource for more details. A `location_name` with an asterisk `"*"` can be used to create a default CIDR record. `collection_id` is still required for default record.
        """
        return pulumi.get(self, "location_name")

    @location_name.setter
    def location_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "location_name", value)


@pulumi.input_type
class RecordFailoverRoutingPolicyArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] type: `PRIMARY` or `SECONDARY`. A `PRIMARY` record will be served if its healthcheck is passing, otherwise the `SECONDARY` will be served. See http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-configuring-options.html#dns-failover-failover-rrsets
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        `PRIMARY` or `SECONDARY`. A `PRIMARY` record will be served if its healthcheck is passing, otherwise the `SECONDARY` will be served. See http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-configuring-options.html#dns-failover-failover-rrsets
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class RecordGeolocationRoutingPolicyArgs:
    def __init__(__self__, *,
                 continent: Optional[pulumi.Input[str]] = None,
                 country: Optional[pulumi.Input[str]] = None,
                 subdivision: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] continent: A two-letter continent code. See http://docs.aws.amazon.com/Route53/latest/APIReference/API_GetGeoLocation.html for code details. Either `continent` or `country` must be specified.
        :param pulumi.Input[str] country: A two-character country code or `*` to indicate a default resource record set.
        :param pulumi.Input[str] subdivision: A subdivision code for a country.
        """
        if continent is not None:
            pulumi.set(__self__, "continent", continent)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if subdivision is not None:
            pulumi.set(__self__, "subdivision", subdivision)

    @property
    @pulumi.getter
    def continent(self) -> Optional[pulumi.Input[str]]:
        """
        A two-letter continent code. See http://docs.aws.amazon.com/Route53/latest/APIReference/API_GetGeoLocation.html for code details. Either `continent` or `country` must be specified.
        """
        return pulumi.get(self, "continent")

    @continent.setter
    def continent(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "continent", value)

    @property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[str]]:
        """
        A two-character country code or `*` to indicate a default resource record set.
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter
    def subdivision(self) -> Optional[pulumi.Input[str]]:
        """
        A subdivision code for a country.
        """
        return pulumi.get(self, "subdivision")

    @subdivision.setter
    def subdivision(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subdivision", value)


@pulumi.input_type
class RecordGeoproximityRoutingPolicyArgs:
    def __init__(__self__, *,
                 aws_region: Optional[pulumi.Input[str]] = None,
                 bias: Optional[pulumi.Input[int]] = None,
                 coordinates: Optional[pulumi.Input[Sequence[pulumi.Input['RecordGeoproximityRoutingPolicyCoordinateArgs']]]] = None,
                 local_zone_group: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] aws_region: A AWS region where the resource is present.
        :param pulumi.Input[int] bias: Route more traffic or less traffic to the resource by specifying a value ranges between -90 to 90. See https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy-geoproximity.html for bias details.
        :param pulumi.Input[Sequence[pulumi.Input['RecordGeoproximityRoutingPolicyCoordinateArgs']]] coordinates: Specify `latitude` and `longitude` for routing traffic to non-AWS resources.
        :param pulumi.Input[str] local_zone_group: A AWS local zone group where the resource is present. See https://docs.aws.amazon.com/local-zones/latest/ug/available-local-zones.html for local zone group list.
        """
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)
        if bias is not None:
            pulumi.set(__self__, "bias", bias)
        if coordinates is not None:
            pulumi.set(__self__, "coordinates", coordinates)
        if local_zone_group is not None:
            pulumi.set(__self__, "local_zone_group", local_zone_group)

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[pulumi.Input[str]]:
        """
        A AWS region where the resource is present.
        """
        return pulumi.get(self, "aws_region")

    @aws_region.setter
    def aws_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_region", value)

    @property
    @pulumi.getter
    def bias(self) -> Optional[pulumi.Input[int]]:
        """
        Route more traffic or less traffic to the resource by specifying a value ranges between -90 to 90. See https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy-geoproximity.html for bias details.
        """
        return pulumi.get(self, "bias")

    @bias.setter
    def bias(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bias", value)

    @property
    @pulumi.getter
    def coordinates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecordGeoproximityRoutingPolicyCoordinateArgs']]]]:
        """
        Specify `latitude` and `longitude` for routing traffic to non-AWS resources.
        """
        return pulumi.get(self, "coordinates")

    @coordinates.setter
    def coordinates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecordGeoproximityRoutingPolicyCoordinateArgs']]]]):
        pulumi.set(self, "coordinates", value)

    @property
    @pulumi.getter(name="localZoneGroup")
    def local_zone_group(self) -> Optional[pulumi.Input[str]]:
        """
        A AWS local zone group where the resource is present. See https://docs.aws.amazon.com/local-zones/latest/ug/available-local-zones.html for local zone group list.
        """
        return pulumi.get(self, "local_zone_group")

    @local_zone_group.setter
    def local_zone_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_zone_group", value)


@pulumi.input_type
class RecordGeoproximityRoutingPolicyCoordinateArgs:
    def __init__(__self__, *,
                 latitude: pulumi.Input[str],
                 longitude: pulumi.Input[str]):
        pulumi.set(__self__, "latitude", latitude)
        pulumi.set(__self__, "longitude", longitude)

    @property
    @pulumi.getter
    def latitude(self) -> pulumi.Input[str]:
        return pulumi.get(self, "latitude")

    @latitude.setter
    def latitude(self, value: pulumi.Input[str]):
        pulumi.set(self, "latitude", value)

    @property
    @pulumi.getter
    def longitude(self) -> pulumi.Input[str]:
        return pulumi.get(self, "longitude")

    @longitude.setter
    def longitude(self, value: pulumi.Input[str]):
        pulumi.set(self, "longitude", value)


@pulumi.input_type
class RecordLatencyRoutingPolicyArgs:
    def __init__(__self__, *,
                 region: pulumi.Input[str]):
        """
        :param pulumi.Input[str] region: An AWS region from which to measure latency. See http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-latency
        """
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        An AWS region from which to measure latency. See http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-latency
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class RecordWeightedRoutingPolicyArgs:
    def __init__(__self__, *,
                 weight: pulumi.Input[int]):
        """
        :param pulumi.Input[int] weight: A numeric value indicating the relative weight of the record. See http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-weighted.
        """
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def weight(self) -> pulumi.Input[int]:
        """
        A numeric value indicating the relative weight of the record. See http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-weighted.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: pulumi.Input[int]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class ResolverEndpointIpAddressArgs:
    def __init__(__self__, *,
                 subnet_id: pulumi.Input[str],
                 ip: Optional[pulumi.Input[str]] = None,
                 ip_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] subnet_id: The ID of the subnet that contains the IP address.
        :param pulumi.Input[str] ip: The IP address in the subnet that you want to use for DNS queries.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_id is not None:
            pulumi.set(__self__, "ip_id", ip_id)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The ID of the subnet that contains the IP address.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address in the subnet that you want to use for DNS queries.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter(name="ipId")
    def ip_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ip_id")

    @ip_id.setter
    def ip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_id", value)


@pulumi.input_type
class ResolverRuleTargetIpArgs:
    def __init__(__self__, *,
                 ip: pulumi.Input[str],
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] ip: One IP address that you want to forward DNS queries to. You can specify only IPv4 addresses.
        :param pulumi.Input[int] port: The port at `ip` that you want to forward DNS queries to. Default value is `53`
        """
        pulumi.set(__self__, "ip", ip)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Input[str]:
        """
        One IP address that you want to forward DNS queries to. You can specify only IPv4 addresses.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port at `ip` that you want to forward DNS queries to. Default value is `53`
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class ZoneVpcArgs:
    def __init__(__self__, *,
                 vpc_id: pulumi.Input[str],
                 vpc_region: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] vpc_id: ID of the VPC to associate.
        :param pulumi.Input[str] vpc_region: Region of the VPC to associate. Defaults to AWS provider region.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        if vpc_region is not None:
            pulumi.set(__self__, "vpc_region", vpc_region)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        ID of the VPC to associate.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vpcRegion")
    def vpc_region(self) -> Optional[pulumi.Input[str]]:
        """
        Region of the VPC to associate. Defaults to AWS provider region.
        """
        return pulumi.get(self, "vpc_region")

    @vpc_region.setter
    def vpc_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_region", value)


@pulumi.input_type
class GetQueryLogConfigFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: The name of the query logging configuration.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the query logging configuration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetResolverEndpointFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetTrafficPolicyDocumentEndpointArgs:
    def __init__(__self__, *,
                 id: str,
                 region: Optional[str] = None,
                 type: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str id: ID of an endpoint you want to assign.
        :param str region: To route traffic to an Amazon S3 bucket that is configured as a website endpoint, specify the region in which you created the bucket for `region`.
        :param str type: Type of the endpoint. Valid values are `value` , `cloudfront` , `elastic-load-balancer`, `s3-website`
        :param str value: Value of the `type`.
        """
        pulumi.set(__self__, "id", id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of an endpoint you want to assign.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: str):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        To route traffic to an Amazon S3 bucket that is configured as a website endpoint, specify the region in which you created the bucket for `region`.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the endpoint. Valid values are `value` , `cloudfront` , `elastic-load-balancer`, `s3-website`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Value of the `type`.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class GetTrafficPolicyDocumentRuleArgs:
    def __init__(__self__, *,
                 id: str,
                 geo_proximity_locations: Optional[Sequence['GetTrafficPolicyDocumentRuleGeoProximityLocationArgs']] = None,
                 items: Optional[Sequence['GetTrafficPolicyDocumentRuleItemArgs']] = None,
                 locations: Optional[Sequence['GetTrafficPolicyDocumentRuleLocationArgs']] = None,
                 primary: Optional['GetTrafficPolicyDocumentRulePrimaryArgs'] = None,
                 regions: Optional[Sequence['GetTrafficPolicyDocumentRuleRegionArgs']] = None,
                 secondary: Optional['GetTrafficPolicyDocumentRuleSecondaryArgs'] = None,
                 type: Optional[str] = None):
        """
        :param str id: ID of a rule you want to assign.
        :param Sequence['GetTrafficPolicyDocumentRuleGeoProximityLocationArgs'] geo_proximity_locations: Configuration block for when you add a geoproximity rule, you configure Amazon Route 53 to route traffic to your resources based on the geographic location of your resources. Only valid for `geoproximity` type. See below
        :param Sequence['GetTrafficPolicyDocumentRuleItemArgs'] items: Configuration block for when you add a multivalue answer rule, you configure your traffic policy to route traffic approximately randomly to your healthy resources.  Only valid for `multivalue` type. See below
        :param Sequence['GetTrafficPolicyDocumentRuleLocationArgs'] locations: Configuration block for when you add a geolocation rule, you configure your traffic policy to route your traffic based on the geographic location of your users.  Only valid for `geo` type. See below
        :param 'GetTrafficPolicyDocumentRulePrimaryArgs' primary: Configuration block for the settings for the rule or endpoint that you want to route traffic to whenever the corresponding resources are available. Only valid for `failover` type. See below
        :param Sequence['GetTrafficPolicyDocumentRuleRegionArgs'] regions: To route traffic to an Amazon S3 bucket that is configured as a website endpoint, specify the region in which you created the bucket for `region`.
        :param 'GetTrafficPolicyDocumentRuleSecondaryArgs' secondary: Configuration block for the rule or endpoint that you want to route traffic to whenever the primary resources are not available. Only valid for `failover` type. See below
        :param str type: Type of the rule.
        """
        pulumi.set(__self__, "id", id)
        if geo_proximity_locations is not None:
            pulumi.set(__self__, "geo_proximity_locations", geo_proximity_locations)
        if items is not None:
            pulumi.set(__self__, "items", items)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if secondary is not None:
            pulumi.set(__self__, "secondary", secondary)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of a rule you want to assign.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: str):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="geoProximityLocations")
    def geo_proximity_locations(self) -> Optional[Sequence['GetTrafficPolicyDocumentRuleGeoProximityLocationArgs']]:
        """
        Configuration block for when you add a geoproximity rule, you configure Amazon Route 53 to route traffic to your resources based on the geographic location of your resources. Only valid for `geoproximity` type. See below
        """
        return pulumi.get(self, "geo_proximity_locations")

    @geo_proximity_locations.setter
    def geo_proximity_locations(self, value: Optional[Sequence['GetTrafficPolicyDocumentRuleGeoProximityLocationArgs']]):
        pulumi.set(self, "geo_proximity_locations", value)

    @property
    @pulumi.getter
    def items(self) -> Optional[Sequence['GetTrafficPolicyDocumentRuleItemArgs']]:
        """
        Configuration block for when you add a multivalue answer rule, you configure your traffic policy to route traffic approximately randomly to your healthy resources.  Only valid for `multivalue` type. See below
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[Sequence['GetTrafficPolicyDocumentRuleItemArgs']]):
        pulumi.set(self, "items", value)

    @property
    @pulumi.getter
    def locations(self) -> Optional[Sequence['GetTrafficPolicyDocumentRuleLocationArgs']]:
        """
        Configuration block for when you add a geolocation rule, you configure your traffic policy to route your traffic based on the geographic location of your users.  Only valid for `geo` type. See below
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[Sequence['GetTrafficPolicyDocumentRuleLocationArgs']]):
        pulumi.set(self, "locations", value)

    @property
    @pulumi.getter
    def primary(self) -> Optional['GetTrafficPolicyDocumentRulePrimaryArgs']:
        """
        Configuration block for the settings for the rule or endpoint that you want to route traffic to whenever the corresponding resources are available. Only valid for `failover` type. See below
        """
        return pulumi.get(self, "primary")

    @primary.setter
    def primary(self, value: Optional['GetTrafficPolicyDocumentRulePrimaryArgs']):
        pulumi.set(self, "primary", value)

    @property
    @pulumi.getter
    def regions(self) -> Optional[Sequence['GetTrafficPolicyDocumentRuleRegionArgs']]:
        """
        To route traffic to an Amazon S3 bucket that is configured as a website endpoint, specify the region in which you created the bucket for `region`.
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: Optional[Sequence['GetTrafficPolicyDocumentRuleRegionArgs']]):
        pulumi.set(self, "regions", value)

    @property
    @pulumi.getter
    def secondary(self) -> Optional['GetTrafficPolicyDocumentRuleSecondaryArgs']:
        """
        Configuration block for the rule or endpoint that you want to route traffic to whenever the primary resources are not available. Only valid for `failover` type. See below
        """
        return pulumi.get(self, "secondary")

    @secondary.setter
    def secondary(self, value: Optional['GetTrafficPolicyDocumentRuleSecondaryArgs']):
        pulumi.set(self, "secondary", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the rule.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class GetTrafficPolicyDocumentRuleGeoProximityLocationArgs:
    def __init__(__self__, *,
                 bias: Optional[str] = None,
                 endpoint_reference: Optional[str] = None,
                 evaluate_target_health: Optional[bool] = None,
                 health_check: Optional[str] = None,
                 latitude: Optional[str] = None,
                 longitude: Optional[str] = None,
                 region: Optional[str] = None,
                 rule_reference: Optional[str] = None):
        """
        :param str bias: Specify a value for `bias` if you want to route more traffic to an endpoint from nearby endpoints (positive values) or route less traffic to an endpoint (negative values).
        :param str endpoint_reference: References to an endpoint.
        :param bool evaluate_target_health: Indicates whether you want Amazon Route 53 to evaluate the health of the endpoint and route traffic only to healthy endpoints.
        :param str health_check: If you want to associate a health check with the endpoint or rule.
        :param str latitude: Represents the location south (negative) or north (positive) of the equator. Valid values are -90 degrees to 90 degrees.
        :param str longitude: Represents the location west (negative) or east (positive) of the prime meridian. Valid values are -180 degrees to 180 degrees.
        :param str region: If your endpoint is an AWS resource, specify the AWS Region that you created the resource in.
        :param str rule_reference: References to a rule.
        """
        if bias is not None:
            pulumi.set(__self__, "bias", bias)
        if endpoint_reference is not None:
            pulumi.set(__self__, "endpoint_reference", endpoint_reference)
        if evaluate_target_health is not None:
            pulumi.set(__self__, "evaluate_target_health", evaluate_target_health)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if latitude is not None:
            pulumi.set(__self__, "latitude", latitude)
        if longitude is not None:
            pulumi.set(__self__, "longitude", longitude)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rule_reference is not None:
            pulumi.set(__self__, "rule_reference", rule_reference)

    @property
    @pulumi.getter
    def bias(self) -> Optional[str]:
        """
        Specify a value for `bias` if you want to route more traffic to an endpoint from nearby endpoints (positive values) or route less traffic to an endpoint (negative values).
        """
        return pulumi.get(self, "bias")

    @bias.setter
    def bias(self, value: Optional[str]):
        pulumi.set(self, "bias", value)

    @property
    @pulumi.getter(name="endpointReference")
    def endpoint_reference(self) -> Optional[str]:
        """
        References to an endpoint.
        """
        return pulumi.get(self, "endpoint_reference")

    @endpoint_reference.setter
    def endpoint_reference(self, value: Optional[str]):
        pulumi.set(self, "endpoint_reference", value)

    @property
    @pulumi.getter(name="evaluateTargetHealth")
    def evaluate_target_health(self) -> Optional[bool]:
        """
        Indicates whether you want Amazon Route 53 to evaluate the health of the endpoint and route traffic only to healthy endpoints.
        """
        return pulumi.get(self, "evaluate_target_health")

    @evaluate_target_health.setter
    def evaluate_target_health(self, value: Optional[bool]):
        pulumi.set(self, "evaluate_target_health", value)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[str]:
        """
        If you want to associate a health check with the endpoint or rule.
        """
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[str]):
        pulumi.set(self, "health_check", value)

    @property
    @pulumi.getter
    def latitude(self) -> Optional[str]:
        """
        Represents the location south (negative) or north (positive) of the equator. Valid values are -90 degrees to 90 degrees.
        """
        return pulumi.get(self, "latitude")

    @latitude.setter
    def latitude(self, value: Optional[str]):
        pulumi.set(self, "latitude", value)

    @property
    @pulumi.getter
    def longitude(self) -> Optional[str]:
        """
        Represents the location west (negative) or east (positive) of the prime meridian. Valid values are -180 degrees to 180 degrees.
        """
        return pulumi.get(self, "longitude")

    @longitude.setter
    def longitude(self, value: Optional[str]):
        pulumi.set(self, "longitude", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        If your endpoint is an AWS resource, specify the AWS Region that you created the resource in.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="ruleReference")
    def rule_reference(self) -> Optional[str]:
        """
        References to a rule.
        """
        return pulumi.get(self, "rule_reference")

    @rule_reference.setter
    def rule_reference(self, value: Optional[str]):
        pulumi.set(self, "rule_reference", value)


@pulumi.input_type
class GetTrafficPolicyDocumentRuleItemArgs:
    def __init__(__self__, *,
                 endpoint_reference: Optional[str] = None,
                 health_check: Optional[str] = None):
        """
        :param str endpoint_reference: References to an endpoint.
        :param str health_check: If you want to associate a health check with the endpoint or rule.
        """
        if endpoint_reference is not None:
            pulumi.set(__self__, "endpoint_reference", endpoint_reference)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)

    @property
    @pulumi.getter(name="endpointReference")
    def endpoint_reference(self) -> Optional[str]:
        """
        References to an endpoint.
        """
        return pulumi.get(self, "endpoint_reference")

    @endpoint_reference.setter
    def endpoint_reference(self, value: Optional[str]):
        pulumi.set(self, "endpoint_reference", value)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[str]:
        """
        If you want to associate a health check with the endpoint or rule.
        """
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[str]):
        pulumi.set(self, "health_check", value)


@pulumi.input_type
class GetTrafficPolicyDocumentRuleLocationArgs:
    def __init__(__self__, *,
                 continent: Optional[str] = None,
                 country: Optional[str] = None,
                 endpoint_reference: Optional[str] = None,
                 evaluate_target_health: Optional[bool] = None,
                 health_check: Optional[str] = None,
                 is_default: Optional[bool] = None,
                 rule_reference: Optional[str] = None,
                 subdivision: Optional[str] = None):
        """
        :param str continent: Value of a continent.
        :param str country: Value of a country.
        :param str endpoint_reference: References to an endpoint.
        :param bool evaluate_target_health: Indicates whether you want Amazon Route 53 to evaluate the health of the endpoint and route traffic only to healthy endpoints.
        :param str health_check: If you want to associate a health check with the endpoint or rule.
        :param bool is_default: Indicates whether this set of values represents the default location.
        :param str rule_reference: References to a rule.
        :param str subdivision: Value of a subdivision.
        """
        if continent is not None:
            pulumi.set(__self__, "continent", continent)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if endpoint_reference is not None:
            pulumi.set(__self__, "endpoint_reference", endpoint_reference)
        if evaluate_target_health is not None:
            pulumi.set(__self__, "evaluate_target_health", evaluate_target_health)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if rule_reference is not None:
            pulumi.set(__self__, "rule_reference", rule_reference)
        if subdivision is not None:
            pulumi.set(__self__, "subdivision", subdivision)

    @property
    @pulumi.getter
    def continent(self) -> Optional[str]:
        """
        Value of a continent.
        """
        return pulumi.get(self, "continent")

    @continent.setter
    def continent(self, value: Optional[str]):
        pulumi.set(self, "continent", value)

    @property
    @pulumi.getter
    def country(self) -> Optional[str]:
        """
        Value of a country.
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[str]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter(name="endpointReference")
    def endpoint_reference(self) -> Optional[str]:
        """
        References to an endpoint.
        """
        return pulumi.get(self, "endpoint_reference")

    @endpoint_reference.setter
    def endpoint_reference(self, value: Optional[str]):
        pulumi.set(self, "endpoint_reference", value)

    @property
    @pulumi.getter(name="evaluateTargetHealth")
    def evaluate_target_health(self) -> Optional[bool]:
        """
        Indicates whether you want Amazon Route 53 to evaluate the health of the endpoint and route traffic only to healthy endpoints.
        """
        return pulumi.get(self, "evaluate_target_health")

    @evaluate_target_health.setter
    def evaluate_target_health(self, value: Optional[bool]):
        pulumi.set(self, "evaluate_target_health", value)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[str]:
        """
        If you want to associate a health check with the endpoint or rule.
        """
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[str]):
        pulumi.set(self, "health_check", value)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[bool]:
        """
        Indicates whether this set of values represents the default location.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[bool]):
        pulumi.set(self, "is_default", value)

    @property
    @pulumi.getter(name="ruleReference")
    def rule_reference(self) -> Optional[str]:
        """
        References to a rule.
        """
        return pulumi.get(self, "rule_reference")

    @rule_reference.setter
    def rule_reference(self, value: Optional[str]):
        pulumi.set(self, "rule_reference", value)

    @property
    @pulumi.getter
    def subdivision(self) -> Optional[str]:
        """
        Value of a subdivision.
        """
        return pulumi.get(self, "subdivision")

    @subdivision.setter
    def subdivision(self, value: Optional[str]):
        pulumi.set(self, "subdivision", value)


@pulumi.input_type
class GetTrafficPolicyDocumentRulePrimaryArgs:
    def __init__(__self__, *,
                 endpoint_reference: Optional[str] = None,
                 evaluate_target_health: Optional[bool] = None,
                 health_check: Optional[str] = None,
                 rule_reference: Optional[str] = None):
        """
        :param str endpoint_reference: References to an endpoint.
        :param bool evaluate_target_health: Indicates whether you want Amazon Route 53 to evaluate the health of the endpoint and route traffic only to healthy endpoints.
        :param str health_check: If you want to associate a health check with the endpoint or rule.
        :param str rule_reference: References to a rule.
        """
        if endpoint_reference is not None:
            pulumi.set(__self__, "endpoint_reference", endpoint_reference)
        if evaluate_target_health is not None:
            pulumi.set(__self__, "evaluate_target_health", evaluate_target_health)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if rule_reference is not None:
            pulumi.set(__self__, "rule_reference", rule_reference)

    @property
    @pulumi.getter(name="endpointReference")
    def endpoint_reference(self) -> Optional[str]:
        """
        References to an endpoint.
        """
        return pulumi.get(self, "endpoint_reference")

    @endpoint_reference.setter
    def endpoint_reference(self, value: Optional[str]):
        pulumi.set(self, "endpoint_reference", value)

    @property
    @pulumi.getter(name="evaluateTargetHealth")
    def evaluate_target_health(self) -> Optional[bool]:
        """
        Indicates whether you want Amazon Route 53 to evaluate the health of the endpoint and route traffic only to healthy endpoints.
        """
        return pulumi.get(self, "evaluate_target_health")

    @evaluate_target_health.setter
    def evaluate_target_health(self, value: Optional[bool]):
        pulumi.set(self, "evaluate_target_health", value)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[str]:
        """
        If you want to associate a health check with the endpoint or rule.
        """
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[str]):
        pulumi.set(self, "health_check", value)

    @property
    @pulumi.getter(name="ruleReference")
    def rule_reference(self) -> Optional[str]:
        """
        References to a rule.
        """
        return pulumi.get(self, "rule_reference")

    @rule_reference.setter
    def rule_reference(self, value: Optional[str]):
        pulumi.set(self, "rule_reference", value)


@pulumi.input_type
class GetTrafficPolicyDocumentRuleRegionArgs:
    def __init__(__self__, *,
                 endpoint_reference: Optional[str] = None,
                 evaluate_target_health: Optional[bool] = None,
                 health_check: Optional[str] = None,
                 region: Optional[str] = None,
                 rule_reference: Optional[str] = None):
        """
        :param str endpoint_reference: References to an endpoint.
        :param bool evaluate_target_health: Indicates whether you want Amazon Route 53 to evaluate the health of the endpoint and route traffic only to healthy endpoints.
        :param str health_check: If you want to associate a health check with the endpoint or rule.
        :param str region: Region code for the AWS Region that you created the resource in.
        :param str rule_reference: References to a rule.
        """
        if endpoint_reference is not None:
            pulumi.set(__self__, "endpoint_reference", endpoint_reference)
        if evaluate_target_health is not None:
            pulumi.set(__self__, "evaluate_target_health", evaluate_target_health)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rule_reference is not None:
            pulumi.set(__self__, "rule_reference", rule_reference)

    @property
    @pulumi.getter(name="endpointReference")
    def endpoint_reference(self) -> Optional[str]:
        """
        References to an endpoint.
        """
        return pulumi.get(self, "endpoint_reference")

    @endpoint_reference.setter
    def endpoint_reference(self, value: Optional[str]):
        pulumi.set(self, "endpoint_reference", value)

    @property
    @pulumi.getter(name="evaluateTargetHealth")
    def evaluate_target_health(self) -> Optional[bool]:
        """
        Indicates whether you want Amazon Route 53 to evaluate the health of the endpoint and route traffic only to healthy endpoints.
        """
        return pulumi.get(self, "evaluate_target_health")

    @evaluate_target_health.setter
    def evaluate_target_health(self, value: Optional[bool]):
        pulumi.set(self, "evaluate_target_health", value)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[str]:
        """
        If you want to associate a health check with the endpoint or rule.
        """
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[str]):
        pulumi.set(self, "health_check", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        Region code for the AWS Region that you created the resource in.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="ruleReference")
    def rule_reference(self) -> Optional[str]:
        """
        References to a rule.
        """
        return pulumi.get(self, "rule_reference")

    @rule_reference.setter
    def rule_reference(self, value: Optional[str]):
        pulumi.set(self, "rule_reference", value)


@pulumi.input_type
class GetTrafficPolicyDocumentRuleSecondaryArgs:
    def __init__(__self__, *,
                 endpoint_reference: Optional[str] = None,
                 evaluate_target_health: Optional[bool] = None,
                 health_check: Optional[str] = None,
                 rule_reference: Optional[str] = None):
        """
        :param str endpoint_reference: References to an endpoint.
        :param bool evaluate_target_health: Indicates whether you want Amazon Route 53 to evaluate the health of the endpoint and route traffic only to healthy endpoints.
        :param str health_check: If you want to associate a health check with the endpoint or rule.
        :param str rule_reference: References to a rule.
        """
        if endpoint_reference is not None:
            pulumi.set(__self__, "endpoint_reference", endpoint_reference)
        if evaluate_target_health is not None:
            pulumi.set(__self__, "evaluate_target_health", evaluate_target_health)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if rule_reference is not None:
            pulumi.set(__self__, "rule_reference", rule_reference)

    @property
    @pulumi.getter(name="endpointReference")
    def endpoint_reference(self) -> Optional[str]:
        """
        References to an endpoint.
        """
        return pulumi.get(self, "endpoint_reference")

    @endpoint_reference.setter
    def endpoint_reference(self, value: Optional[str]):
        pulumi.set(self, "endpoint_reference", value)

    @property
    @pulumi.getter(name="evaluateTargetHealth")
    def evaluate_target_health(self) -> Optional[bool]:
        """
        Indicates whether you want Amazon Route 53 to evaluate the health of the endpoint and route traffic only to healthy endpoints.
        """
        return pulumi.get(self, "evaluate_target_health")

    @evaluate_target_health.setter
    def evaluate_target_health(self, value: Optional[bool]):
        pulumi.set(self, "evaluate_target_health", value)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[str]:
        """
        If you want to associate a health check with the endpoint or rule.
        """
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[str]):
        pulumi.set(self, "health_check", value)

    @property
    @pulumi.getter(name="ruleReference")
    def rule_reference(self) -> Optional[str]:
        """
        References to a rule.
        """
        return pulumi.get(self, "rule_reference")

    @rule_reference.setter
    def rule_reference(self, value: Optional[str]):
        pulumi.set(self, "rule_reference", value)


