# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['HealthCheckArgs', 'HealthCheck']

@pulumi.input_type
class HealthCheckArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 child_health_threshold: Optional[pulumi.Input[int]] = None,
                 child_healthchecks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cloudwatch_alarm_name: Optional[pulumi.Input[str]] = None,
                 cloudwatch_alarm_region: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 enable_sni: Optional[pulumi.Input[bool]] = None,
                 failure_threshold: Optional[pulumi.Input[int]] = None,
                 fqdn: Optional[pulumi.Input[str]] = None,
                 insufficient_data_health_status: Optional[pulumi.Input[str]] = None,
                 invert_healthcheck: Optional[pulumi.Input[bool]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 measure_latency: Optional[pulumi.Input[bool]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 reference_name: Optional[pulumi.Input[str]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 request_interval: Optional[pulumi.Input[int]] = None,
                 resource_path: Optional[pulumi.Input[str]] = None,
                 routing_control_arn: Optional[pulumi.Input[str]] = None,
                 search_string: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a HealthCheck resource.
        :param pulumi.Input[str] type: The protocol to use when performing health checks. Valid values are `HTTP`, `HTTPS`, `HTTP_STR_MATCH`, `HTTPS_STR_MATCH`, `TCP`, `CALCULATED`, `CLOUDWATCH_METRIC` and `RECOVERY_CONTROL`.
        :param pulumi.Input[int] child_health_threshold: The minimum number of child health checks that must be healthy for Route 53 to consider the parent health check to be healthy. Valid values are integers between 0 and 256, inclusive
        :param pulumi.Input[Sequence[pulumi.Input[str]]] child_healthchecks: For a specified parent health check, a list of HealthCheckId values for the associated child health checks.
        :param pulumi.Input[str] cloudwatch_alarm_name: The name of the CloudWatch alarm.
        :param pulumi.Input[str] cloudwatch_alarm_region: The CloudWatchRegion that the CloudWatch alarm was created in.
        :param pulumi.Input[bool] disabled: A boolean value that stops Route 53 from performing health checks. When set to true, Route 53 will do the following depending on the type of health check:
               * For health checks that check the health of endpoints, Route5 53 stops submitting requests to your application, server, or other resource.
               * For calculated health checks, Route 53 stops aggregating the status of the referenced health checks.
               * For health checks that monitor CloudWatch alarms, Route 53 stops monitoring the corresponding CloudWatch metrics.
               
               > **Note:** After you disable a health check, Route 53 considers the status of the health check to always be healthy. If you configured DNS failover, Route 53 continues to route traffic to the corresponding resources. If you want to stop routing traffic to a resource, change the value of `invert_healthcheck`.
        :param pulumi.Input[bool] enable_sni: A boolean value that indicates whether Route53 should send the `fqdn` to the endpoint when performing the health check. This defaults to AWS' defaults: when the `type` is "HTTPS" `enable_sni` defaults to `true`, when `type` is anything else `enable_sni` defaults to `false`.
        :param pulumi.Input[int] failure_threshold: The number of consecutive health checks that an endpoint must pass or fail.
        :param pulumi.Input[str] fqdn: The fully qualified domain name of the endpoint to be checked. If a value is set for `ip_address`, the value set for `fqdn` will be passed in the `Host` header.
        :param pulumi.Input[str] insufficient_data_health_status: The status of the health check when CloudWatch has insufficient data about the state of associated alarm. Valid values are `Healthy` , `Unhealthy` and `LastKnownStatus`.
        :param pulumi.Input[bool] invert_healthcheck: A boolean value that indicates whether the status of health check should be inverted. For example, if a health check is healthy but Inverted is True , then Route 53 considers the health check to be unhealthy.
        :param pulumi.Input[str] ip_address: The IP address of the endpoint to be checked.
        :param pulumi.Input[bool] measure_latency: A Boolean value that indicates whether you want Route 53 to measure the latency between health checkers in multiple AWS regions and your endpoint and to display CloudWatch latency graphs in the Route 53 console.
        :param pulumi.Input[int] port: The port of the endpoint to be checked.
        :param pulumi.Input[str] reference_name: This is a reference name used in Caller Reference
               (helpful for identifying single health_check set amongst others)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] regions: A list of AWS regions that you want Amazon Route 53 health checkers to check the specified endpoint from.
        :param pulumi.Input[int] request_interval: The number of seconds between the time that Amazon Route 53 gets a response from your endpoint and the time that it sends the next health-check request.
        :param pulumi.Input[str] resource_path: The path that you want Amazon Route 53 to request when performing health checks.
        :param pulumi.Input[str] routing_control_arn: The Amazon Resource Name (ARN) for the Route 53 Application Recovery Controller routing control. This is used when health check type is `RECOVERY_CONTROL`
        :param pulumi.Input[str] search_string: String searched in the first 5120 bytes of the response body for check to be considered healthy. Only valid with `HTTP_STR_MATCH` and `HTTPS_STR_MATCH`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the health check. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "type", type)
        if child_health_threshold is not None:
            pulumi.set(__self__, "child_health_threshold", child_health_threshold)
        if child_healthchecks is not None:
            pulumi.set(__self__, "child_healthchecks", child_healthchecks)
        if cloudwatch_alarm_name is not None:
            pulumi.set(__self__, "cloudwatch_alarm_name", cloudwatch_alarm_name)
        if cloudwatch_alarm_region is not None:
            pulumi.set(__self__, "cloudwatch_alarm_region", cloudwatch_alarm_region)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if enable_sni is not None:
            pulumi.set(__self__, "enable_sni", enable_sni)
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if insufficient_data_health_status is not None:
            pulumi.set(__self__, "insufficient_data_health_status", insufficient_data_health_status)
        if invert_healthcheck is not None:
            pulumi.set(__self__, "invert_healthcheck", invert_healthcheck)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if measure_latency is not None:
            pulumi.set(__self__, "measure_latency", measure_latency)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if reference_name is not None:
            pulumi.set(__self__, "reference_name", reference_name)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if request_interval is not None:
            pulumi.set(__self__, "request_interval", request_interval)
        if resource_path is not None:
            pulumi.set(__self__, "resource_path", resource_path)
        if routing_control_arn is not None:
            pulumi.set(__self__, "routing_control_arn", routing_control_arn)
        if search_string is not None:
            pulumi.set(__self__, "search_string", search_string)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The protocol to use when performing health checks. Valid values are `HTTP`, `HTTPS`, `HTTP_STR_MATCH`, `HTTPS_STR_MATCH`, `TCP`, `CALCULATED`, `CLOUDWATCH_METRIC` and `RECOVERY_CONTROL`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="childHealthThreshold")
    def child_health_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of child health checks that must be healthy for Route 53 to consider the parent health check to be healthy. Valid values are integers between 0 and 256, inclusive
        """
        return pulumi.get(self, "child_health_threshold")

    @child_health_threshold.setter
    def child_health_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "child_health_threshold", value)

    @property
    @pulumi.getter(name="childHealthchecks")
    def child_healthchecks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        For a specified parent health check, a list of HealthCheckId values for the associated child health checks.
        """
        return pulumi.get(self, "child_healthchecks")

    @child_healthchecks.setter
    def child_healthchecks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "child_healthchecks", value)

    @property
    @pulumi.getter(name="cloudwatchAlarmName")
    def cloudwatch_alarm_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the CloudWatch alarm.
        """
        return pulumi.get(self, "cloudwatch_alarm_name")

    @cloudwatch_alarm_name.setter
    def cloudwatch_alarm_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloudwatch_alarm_name", value)

    @property
    @pulumi.getter(name="cloudwatchAlarmRegion")
    def cloudwatch_alarm_region(self) -> Optional[pulumi.Input[str]]:
        """
        The CloudWatchRegion that the CloudWatch alarm was created in.
        """
        return pulumi.get(self, "cloudwatch_alarm_region")

    @cloudwatch_alarm_region.setter
    def cloudwatch_alarm_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloudwatch_alarm_region", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean value that stops Route 53 from performing health checks. When set to true, Route 53 will do the following depending on the type of health check:
        * For health checks that check the health of endpoints, Route5 53 stops submitting requests to your application, server, or other resource.
        * For calculated health checks, Route 53 stops aggregating the status of the referenced health checks.
        * For health checks that monitor CloudWatch alarms, Route 53 stops monitoring the corresponding CloudWatch metrics.

        > **Note:** After you disable a health check, Route 53 considers the status of the health check to always be healthy. If you configured DNS failover, Route 53 continues to route traffic to the corresponding resources. If you want to stop routing traffic to a resource, change the value of `invert_healthcheck`.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="enableSni")
    def enable_sni(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean value that indicates whether Route53 should send the `fqdn` to the endpoint when performing the health check. This defaults to AWS' defaults: when the `type` is "HTTPS" `enable_sni` defaults to `true`, when `type` is anything else `enable_sni` defaults to `false`.
        """
        return pulumi.get(self, "enable_sni")

    @enable_sni.setter
    def enable_sni(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_sni", value)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The number of consecutive health checks that an endpoint must pass or fail.
        """
        return pulumi.get(self, "failure_threshold")

    @failure_threshold.setter
    def failure_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failure_threshold", value)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified domain name of the endpoint to be checked. If a value is set for `ip_address`, the value set for `fqdn` will be passed in the `Host` header.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fqdn", value)

    @property
    @pulumi.getter(name="insufficientDataHealthStatus")
    def insufficient_data_health_status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the health check when CloudWatch has insufficient data about the state of associated alarm. Valid values are `Healthy` , `Unhealthy` and `LastKnownStatus`.
        """
        return pulumi.get(self, "insufficient_data_health_status")

    @insufficient_data_health_status.setter
    def insufficient_data_health_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "insufficient_data_health_status", value)

    @property
    @pulumi.getter(name="invertHealthcheck")
    def invert_healthcheck(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean value that indicates whether the status of health check should be inverted. For example, if a health check is healthy but Inverted is True , then Route 53 considers the health check to be unhealthy.
        """
        return pulumi.get(self, "invert_healthcheck")

    @invert_healthcheck.setter
    def invert_healthcheck(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "invert_healthcheck", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address of the endpoint to be checked.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="measureLatency")
    def measure_latency(self) -> Optional[pulumi.Input[bool]]:
        """
        A Boolean value that indicates whether you want Route 53 to measure the latency between health checkers in multiple AWS regions and your endpoint and to display CloudWatch latency graphs in the Route 53 console.
        """
        return pulumi.get(self, "measure_latency")

    @measure_latency.setter
    def measure_latency(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "measure_latency", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port of the endpoint to be checked.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="referenceName")
    def reference_name(self) -> Optional[pulumi.Input[str]]:
        """
        This is a reference name used in Caller Reference
        (helpful for identifying single health_check set amongst others)
        """
        return pulumi.get(self, "reference_name")

    @reference_name.setter
    def reference_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reference_name", value)

    @property
    @pulumi.getter
    def regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of AWS regions that you want Amazon Route 53 health checkers to check the specified endpoint from.
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "regions", value)

    @property
    @pulumi.getter(name="requestInterval")
    def request_interval(self) -> Optional[pulumi.Input[int]]:
        """
        The number of seconds between the time that Amazon Route 53 gets a response from your endpoint and the time that it sends the next health-check request.
        """
        return pulumi.get(self, "request_interval")

    @request_interval.setter
    def request_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "request_interval", value)

    @property
    @pulumi.getter(name="resourcePath")
    def resource_path(self) -> Optional[pulumi.Input[str]]:
        """
        The path that you want Amazon Route 53 to request when performing health checks.
        """
        return pulumi.get(self, "resource_path")

    @resource_path.setter
    def resource_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_path", value)

    @property
    @pulumi.getter(name="routingControlArn")
    def routing_control_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) for the Route 53 Application Recovery Controller routing control. This is used when health check type is `RECOVERY_CONTROL`
        """
        return pulumi.get(self, "routing_control_arn")

    @routing_control_arn.setter
    def routing_control_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "routing_control_arn", value)

    @property
    @pulumi.getter(name="searchString")
    def search_string(self) -> Optional[pulumi.Input[str]]:
        """
        String searched in the first 5120 bytes of the response body for check to be considered healthy. Only valid with `HTTP_STR_MATCH` and `HTTPS_STR_MATCH`.
        """
        return pulumi.get(self, "search_string")

    @search_string.setter
    def search_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "search_string", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the health check. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _HealthCheckState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 child_health_threshold: Optional[pulumi.Input[int]] = None,
                 child_healthchecks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cloudwatch_alarm_name: Optional[pulumi.Input[str]] = None,
                 cloudwatch_alarm_region: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 enable_sni: Optional[pulumi.Input[bool]] = None,
                 failure_threshold: Optional[pulumi.Input[int]] = None,
                 fqdn: Optional[pulumi.Input[str]] = None,
                 insufficient_data_health_status: Optional[pulumi.Input[str]] = None,
                 invert_healthcheck: Optional[pulumi.Input[bool]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 measure_latency: Optional[pulumi.Input[bool]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 reference_name: Optional[pulumi.Input[str]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 request_interval: Optional[pulumi.Input[int]] = None,
                 resource_path: Optional[pulumi.Input[str]] = None,
                 routing_control_arn: Optional[pulumi.Input[str]] = None,
                 search_string: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering HealthCheck resources.
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) of the Health Check.
        :param pulumi.Input[int] child_health_threshold: The minimum number of child health checks that must be healthy for Route 53 to consider the parent health check to be healthy. Valid values are integers between 0 and 256, inclusive
        :param pulumi.Input[Sequence[pulumi.Input[str]]] child_healthchecks: For a specified parent health check, a list of HealthCheckId values for the associated child health checks.
        :param pulumi.Input[str] cloudwatch_alarm_name: The name of the CloudWatch alarm.
        :param pulumi.Input[str] cloudwatch_alarm_region: The CloudWatchRegion that the CloudWatch alarm was created in.
        :param pulumi.Input[bool] disabled: A boolean value that stops Route 53 from performing health checks. When set to true, Route 53 will do the following depending on the type of health check:
               * For health checks that check the health of endpoints, Route5 53 stops submitting requests to your application, server, or other resource.
               * For calculated health checks, Route 53 stops aggregating the status of the referenced health checks.
               * For health checks that monitor CloudWatch alarms, Route 53 stops monitoring the corresponding CloudWatch metrics.
               
               > **Note:** After you disable a health check, Route 53 considers the status of the health check to always be healthy. If you configured DNS failover, Route 53 continues to route traffic to the corresponding resources. If you want to stop routing traffic to a resource, change the value of `invert_healthcheck`.
        :param pulumi.Input[bool] enable_sni: A boolean value that indicates whether Route53 should send the `fqdn` to the endpoint when performing the health check. This defaults to AWS' defaults: when the `type` is "HTTPS" `enable_sni` defaults to `true`, when `type` is anything else `enable_sni` defaults to `false`.
        :param pulumi.Input[int] failure_threshold: The number of consecutive health checks that an endpoint must pass or fail.
        :param pulumi.Input[str] fqdn: The fully qualified domain name of the endpoint to be checked. If a value is set for `ip_address`, the value set for `fqdn` will be passed in the `Host` header.
        :param pulumi.Input[str] insufficient_data_health_status: The status of the health check when CloudWatch has insufficient data about the state of associated alarm. Valid values are `Healthy` , `Unhealthy` and `LastKnownStatus`.
        :param pulumi.Input[bool] invert_healthcheck: A boolean value that indicates whether the status of health check should be inverted. For example, if a health check is healthy but Inverted is True , then Route 53 considers the health check to be unhealthy.
        :param pulumi.Input[str] ip_address: The IP address of the endpoint to be checked.
        :param pulumi.Input[bool] measure_latency: A Boolean value that indicates whether you want Route 53 to measure the latency between health checkers in multiple AWS regions and your endpoint and to display CloudWatch latency graphs in the Route 53 console.
        :param pulumi.Input[int] port: The port of the endpoint to be checked.
        :param pulumi.Input[str] reference_name: This is a reference name used in Caller Reference
               (helpful for identifying single health_check set amongst others)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] regions: A list of AWS regions that you want Amazon Route 53 health checkers to check the specified endpoint from.
        :param pulumi.Input[int] request_interval: The number of seconds between the time that Amazon Route 53 gets a response from your endpoint and the time that it sends the next health-check request.
        :param pulumi.Input[str] resource_path: The path that you want Amazon Route 53 to request when performing health checks.
        :param pulumi.Input[str] routing_control_arn: The Amazon Resource Name (ARN) for the Route 53 Application Recovery Controller routing control. This is used when health check type is `RECOVERY_CONTROL`
        :param pulumi.Input[str] search_string: String searched in the first 5120 bytes of the response body for check to be considered healthy. Only valid with `HTTP_STR_MATCH` and `HTTPS_STR_MATCH`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the health check. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] type: The protocol to use when performing health checks. Valid values are `HTTP`, `HTTPS`, `HTTP_STR_MATCH`, `HTTPS_STR_MATCH`, `TCP`, `CALCULATED`, `CLOUDWATCH_METRIC` and `RECOVERY_CONTROL`.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if child_health_threshold is not None:
            pulumi.set(__self__, "child_health_threshold", child_health_threshold)
        if child_healthchecks is not None:
            pulumi.set(__self__, "child_healthchecks", child_healthchecks)
        if cloudwatch_alarm_name is not None:
            pulumi.set(__self__, "cloudwatch_alarm_name", cloudwatch_alarm_name)
        if cloudwatch_alarm_region is not None:
            pulumi.set(__self__, "cloudwatch_alarm_region", cloudwatch_alarm_region)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if enable_sni is not None:
            pulumi.set(__self__, "enable_sni", enable_sni)
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if insufficient_data_health_status is not None:
            pulumi.set(__self__, "insufficient_data_health_status", insufficient_data_health_status)
        if invert_healthcheck is not None:
            pulumi.set(__self__, "invert_healthcheck", invert_healthcheck)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if measure_latency is not None:
            pulumi.set(__self__, "measure_latency", measure_latency)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if reference_name is not None:
            pulumi.set(__self__, "reference_name", reference_name)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if request_interval is not None:
            pulumi.set(__self__, "request_interval", request_interval)
        if resource_path is not None:
            pulumi.set(__self__, "resource_path", resource_path)
        if routing_control_arn is not None:
            pulumi.set(__self__, "routing_control_arn", routing_control_arn)
        if search_string is not None:
            pulumi.set(__self__, "search_string", search_string)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the Health Check.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="childHealthThreshold")
    def child_health_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of child health checks that must be healthy for Route 53 to consider the parent health check to be healthy. Valid values are integers between 0 and 256, inclusive
        """
        return pulumi.get(self, "child_health_threshold")

    @child_health_threshold.setter
    def child_health_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "child_health_threshold", value)

    @property
    @pulumi.getter(name="childHealthchecks")
    def child_healthchecks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        For a specified parent health check, a list of HealthCheckId values for the associated child health checks.
        """
        return pulumi.get(self, "child_healthchecks")

    @child_healthchecks.setter
    def child_healthchecks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "child_healthchecks", value)

    @property
    @pulumi.getter(name="cloudwatchAlarmName")
    def cloudwatch_alarm_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the CloudWatch alarm.
        """
        return pulumi.get(self, "cloudwatch_alarm_name")

    @cloudwatch_alarm_name.setter
    def cloudwatch_alarm_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloudwatch_alarm_name", value)

    @property
    @pulumi.getter(name="cloudwatchAlarmRegion")
    def cloudwatch_alarm_region(self) -> Optional[pulumi.Input[str]]:
        """
        The CloudWatchRegion that the CloudWatch alarm was created in.
        """
        return pulumi.get(self, "cloudwatch_alarm_region")

    @cloudwatch_alarm_region.setter
    def cloudwatch_alarm_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloudwatch_alarm_region", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean value that stops Route 53 from performing health checks. When set to true, Route 53 will do the following depending on the type of health check:
        * For health checks that check the health of endpoints, Route5 53 stops submitting requests to your application, server, or other resource.
        * For calculated health checks, Route 53 stops aggregating the status of the referenced health checks.
        * For health checks that monitor CloudWatch alarms, Route 53 stops monitoring the corresponding CloudWatch metrics.

        > **Note:** After you disable a health check, Route 53 considers the status of the health check to always be healthy. If you configured DNS failover, Route 53 continues to route traffic to the corresponding resources. If you want to stop routing traffic to a resource, change the value of `invert_healthcheck`.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="enableSni")
    def enable_sni(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean value that indicates whether Route53 should send the `fqdn` to the endpoint when performing the health check. This defaults to AWS' defaults: when the `type` is "HTTPS" `enable_sni` defaults to `true`, when `type` is anything else `enable_sni` defaults to `false`.
        """
        return pulumi.get(self, "enable_sni")

    @enable_sni.setter
    def enable_sni(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_sni", value)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The number of consecutive health checks that an endpoint must pass or fail.
        """
        return pulumi.get(self, "failure_threshold")

    @failure_threshold.setter
    def failure_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failure_threshold", value)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified domain name of the endpoint to be checked. If a value is set for `ip_address`, the value set for `fqdn` will be passed in the `Host` header.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fqdn", value)

    @property
    @pulumi.getter(name="insufficientDataHealthStatus")
    def insufficient_data_health_status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the health check when CloudWatch has insufficient data about the state of associated alarm. Valid values are `Healthy` , `Unhealthy` and `LastKnownStatus`.
        """
        return pulumi.get(self, "insufficient_data_health_status")

    @insufficient_data_health_status.setter
    def insufficient_data_health_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "insufficient_data_health_status", value)

    @property
    @pulumi.getter(name="invertHealthcheck")
    def invert_healthcheck(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean value that indicates whether the status of health check should be inverted. For example, if a health check is healthy but Inverted is True , then Route 53 considers the health check to be unhealthy.
        """
        return pulumi.get(self, "invert_healthcheck")

    @invert_healthcheck.setter
    def invert_healthcheck(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "invert_healthcheck", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address of the endpoint to be checked.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="measureLatency")
    def measure_latency(self) -> Optional[pulumi.Input[bool]]:
        """
        A Boolean value that indicates whether you want Route 53 to measure the latency between health checkers in multiple AWS regions and your endpoint and to display CloudWatch latency graphs in the Route 53 console.
        """
        return pulumi.get(self, "measure_latency")

    @measure_latency.setter
    def measure_latency(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "measure_latency", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port of the endpoint to be checked.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="referenceName")
    def reference_name(self) -> Optional[pulumi.Input[str]]:
        """
        This is a reference name used in Caller Reference
        (helpful for identifying single health_check set amongst others)
        """
        return pulumi.get(self, "reference_name")

    @reference_name.setter
    def reference_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reference_name", value)

    @property
    @pulumi.getter
    def regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of AWS regions that you want Amazon Route 53 health checkers to check the specified endpoint from.
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "regions", value)

    @property
    @pulumi.getter(name="requestInterval")
    def request_interval(self) -> Optional[pulumi.Input[int]]:
        """
        The number of seconds between the time that Amazon Route 53 gets a response from your endpoint and the time that it sends the next health-check request.
        """
        return pulumi.get(self, "request_interval")

    @request_interval.setter
    def request_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "request_interval", value)

    @property
    @pulumi.getter(name="resourcePath")
    def resource_path(self) -> Optional[pulumi.Input[str]]:
        """
        The path that you want Amazon Route 53 to request when performing health checks.
        """
        return pulumi.get(self, "resource_path")

    @resource_path.setter
    def resource_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_path", value)

    @property
    @pulumi.getter(name="routingControlArn")
    def routing_control_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) for the Route 53 Application Recovery Controller routing control. This is used when health check type is `RECOVERY_CONTROL`
        """
        return pulumi.get(self, "routing_control_arn")

    @routing_control_arn.setter
    def routing_control_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "routing_control_arn", value)

    @property
    @pulumi.getter(name="searchString")
    def search_string(self) -> Optional[pulumi.Input[str]]:
        """
        String searched in the first 5120 bytes of the response body for check to be considered healthy. Only valid with `HTTP_STR_MATCH` and `HTTPS_STR_MATCH`.
        """
        return pulumi.get(self, "search_string")

    @search_string.setter
    def search_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "search_string", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the health check. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol to use when performing health checks. Valid values are `HTTP`, `HTTPS`, `HTTP_STR_MATCH`, `HTTPS_STR_MATCH`, `TCP`, `CALCULATED`, `CLOUDWATCH_METRIC` and `RECOVERY_CONTROL`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class HealthCheck(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 child_health_threshold: Optional[pulumi.Input[int]] = None,
                 child_healthchecks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cloudwatch_alarm_name: Optional[pulumi.Input[str]] = None,
                 cloudwatch_alarm_region: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 enable_sni: Optional[pulumi.Input[bool]] = None,
                 failure_threshold: Optional[pulumi.Input[int]] = None,
                 fqdn: Optional[pulumi.Input[str]] = None,
                 insufficient_data_health_status: Optional[pulumi.Input[str]] = None,
                 invert_healthcheck: Optional[pulumi.Input[bool]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 measure_latency: Optional[pulumi.Input[bool]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 reference_name: Optional[pulumi.Input[str]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 request_interval: Optional[pulumi.Input[int]] = None,
                 resource_path: Optional[pulumi.Input[str]] = None,
                 routing_control_arn: Optional[pulumi.Input[str]] = None,
                 search_string: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Route53 health check.

        ## Example Usage

        ### Connectivity and HTTP Status Code Check

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.route53.HealthCheck("example",
            fqdn="example.com",
            port=80,
            type="HTTP",
            resource_path="/",
            failure_threshold=5,
            request_interval=30,
            tags={
                "Name": "tf-test-health-check",
            })
        ```
        <!--End PulumiCodeChooser -->

        ### Connectivity and String Matching Check

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.route53.HealthCheck("example",
            failure_threshold=5,
            fqdn="example.com",
            port=443,
            request_interval=30,
            resource_path="/",
            search_string="example",
            type="HTTPS_STR_MATCH")
        ```
        <!--End PulumiCodeChooser -->

        ### Aggregate Check

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        parent = aws.route53.HealthCheck("parent",
            type="CALCULATED",
            child_health_threshold=1,
            child_healthchecks=[child["id"]],
            tags={
                "Name": "tf-test-calculated-health-check",
            })
        ```
        <!--End PulumiCodeChooser -->

        ### CloudWatch Alarm Check

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        foobar = aws.cloudwatch.MetricAlarm("foobar",
            name="test-foobar5",
            comparison_operator="GreaterThanOrEqualToThreshold",
            evaluation_periods=2,
            metric_name="CPUUtilization",
            namespace="AWS/EC2",
            period=120,
            statistic="Average",
            threshold=80,
            alarm_description="This metric monitors ec2 cpu utilization")
        foo = aws.route53.HealthCheck("foo",
            type="CLOUDWATCH_METRIC",
            cloudwatch_alarm_name=foobar.name,
            cloudwatch_alarm_region="us-west-2",
            insufficient_data_health_status="Healthy")
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Route53 Health Checks using the health check `id`. For example:

        ```sh
        $ pulumi import aws:route53/healthCheck:HealthCheck http_check abcdef11-2222-3333-4444-555555fedcba
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] child_health_threshold: The minimum number of child health checks that must be healthy for Route 53 to consider the parent health check to be healthy. Valid values are integers between 0 and 256, inclusive
        :param pulumi.Input[Sequence[pulumi.Input[str]]] child_healthchecks: For a specified parent health check, a list of HealthCheckId values for the associated child health checks.
        :param pulumi.Input[str] cloudwatch_alarm_name: The name of the CloudWatch alarm.
        :param pulumi.Input[str] cloudwatch_alarm_region: The CloudWatchRegion that the CloudWatch alarm was created in.
        :param pulumi.Input[bool] disabled: A boolean value that stops Route 53 from performing health checks. When set to true, Route 53 will do the following depending on the type of health check:
               * For health checks that check the health of endpoints, Route5 53 stops submitting requests to your application, server, or other resource.
               * For calculated health checks, Route 53 stops aggregating the status of the referenced health checks.
               * For health checks that monitor CloudWatch alarms, Route 53 stops monitoring the corresponding CloudWatch metrics.
               
               > **Note:** After you disable a health check, Route 53 considers the status of the health check to always be healthy. If you configured DNS failover, Route 53 continues to route traffic to the corresponding resources. If you want to stop routing traffic to a resource, change the value of `invert_healthcheck`.
        :param pulumi.Input[bool] enable_sni: A boolean value that indicates whether Route53 should send the `fqdn` to the endpoint when performing the health check. This defaults to AWS' defaults: when the `type` is "HTTPS" `enable_sni` defaults to `true`, when `type` is anything else `enable_sni` defaults to `false`.
        :param pulumi.Input[int] failure_threshold: The number of consecutive health checks that an endpoint must pass or fail.
        :param pulumi.Input[str] fqdn: The fully qualified domain name of the endpoint to be checked. If a value is set for `ip_address`, the value set for `fqdn` will be passed in the `Host` header.
        :param pulumi.Input[str] insufficient_data_health_status: The status of the health check when CloudWatch has insufficient data about the state of associated alarm. Valid values are `Healthy` , `Unhealthy` and `LastKnownStatus`.
        :param pulumi.Input[bool] invert_healthcheck: A boolean value that indicates whether the status of health check should be inverted. For example, if a health check is healthy but Inverted is True , then Route 53 considers the health check to be unhealthy.
        :param pulumi.Input[str] ip_address: The IP address of the endpoint to be checked.
        :param pulumi.Input[bool] measure_latency: A Boolean value that indicates whether you want Route 53 to measure the latency between health checkers in multiple AWS regions and your endpoint and to display CloudWatch latency graphs in the Route 53 console.
        :param pulumi.Input[int] port: The port of the endpoint to be checked.
        :param pulumi.Input[str] reference_name: This is a reference name used in Caller Reference
               (helpful for identifying single health_check set amongst others)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] regions: A list of AWS regions that you want Amazon Route 53 health checkers to check the specified endpoint from.
        :param pulumi.Input[int] request_interval: The number of seconds between the time that Amazon Route 53 gets a response from your endpoint and the time that it sends the next health-check request.
        :param pulumi.Input[str] resource_path: The path that you want Amazon Route 53 to request when performing health checks.
        :param pulumi.Input[str] routing_control_arn: The Amazon Resource Name (ARN) for the Route 53 Application Recovery Controller routing control. This is used when health check type is `RECOVERY_CONTROL`
        :param pulumi.Input[str] search_string: String searched in the first 5120 bytes of the response body for check to be considered healthy. Only valid with `HTTP_STR_MATCH` and `HTTPS_STR_MATCH`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the health check. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] type: The protocol to use when performing health checks. Valid values are `HTTP`, `HTTPS`, `HTTP_STR_MATCH`, `HTTPS_STR_MATCH`, `TCP`, `CALCULATED`, `CLOUDWATCH_METRIC` and `RECOVERY_CONTROL`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HealthCheckArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Route53 health check.

        ## Example Usage

        ### Connectivity and HTTP Status Code Check

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.route53.HealthCheck("example",
            fqdn="example.com",
            port=80,
            type="HTTP",
            resource_path="/",
            failure_threshold=5,
            request_interval=30,
            tags={
                "Name": "tf-test-health-check",
            })
        ```
        <!--End PulumiCodeChooser -->

        ### Connectivity and String Matching Check

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.route53.HealthCheck("example",
            failure_threshold=5,
            fqdn="example.com",
            port=443,
            request_interval=30,
            resource_path="/",
            search_string="example",
            type="HTTPS_STR_MATCH")
        ```
        <!--End PulumiCodeChooser -->

        ### Aggregate Check

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        parent = aws.route53.HealthCheck("parent",
            type="CALCULATED",
            child_health_threshold=1,
            child_healthchecks=[child["id"]],
            tags={
                "Name": "tf-test-calculated-health-check",
            })
        ```
        <!--End PulumiCodeChooser -->

        ### CloudWatch Alarm Check

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        foobar = aws.cloudwatch.MetricAlarm("foobar",
            name="test-foobar5",
            comparison_operator="GreaterThanOrEqualToThreshold",
            evaluation_periods=2,
            metric_name="CPUUtilization",
            namespace="AWS/EC2",
            period=120,
            statistic="Average",
            threshold=80,
            alarm_description="This metric monitors ec2 cpu utilization")
        foo = aws.route53.HealthCheck("foo",
            type="CLOUDWATCH_METRIC",
            cloudwatch_alarm_name=foobar.name,
            cloudwatch_alarm_region="us-west-2",
            insufficient_data_health_status="Healthy")
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Route53 Health Checks using the health check `id`. For example:

        ```sh
        $ pulumi import aws:route53/healthCheck:HealthCheck http_check abcdef11-2222-3333-4444-555555fedcba
        ```

        :param str resource_name: The name of the resource.
        :param HealthCheckArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HealthCheckArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 child_health_threshold: Optional[pulumi.Input[int]] = None,
                 child_healthchecks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cloudwatch_alarm_name: Optional[pulumi.Input[str]] = None,
                 cloudwatch_alarm_region: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 enable_sni: Optional[pulumi.Input[bool]] = None,
                 failure_threshold: Optional[pulumi.Input[int]] = None,
                 fqdn: Optional[pulumi.Input[str]] = None,
                 insufficient_data_health_status: Optional[pulumi.Input[str]] = None,
                 invert_healthcheck: Optional[pulumi.Input[bool]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 measure_latency: Optional[pulumi.Input[bool]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 reference_name: Optional[pulumi.Input[str]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 request_interval: Optional[pulumi.Input[int]] = None,
                 resource_path: Optional[pulumi.Input[str]] = None,
                 routing_control_arn: Optional[pulumi.Input[str]] = None,
                 search_string: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HealthCheckArgs.__new__(HealthCheckArgs)

            __props__.__dict__["child_health_threshold"] = child_health_threshold
            __props__.__dict__["child_healthchecks"] = child_healthchecks
            __props__.__dict__["cloudwatch_alarm_name"] = cloudwatch_alarm_name
            __props__.__dict__["cloudwatch_alarm_region"] = cloudwatch_alarm_region
            __props__.__dict__["disabled"] = disabled
            __props__.__dict__["enable_sni"] = enable_sni
            __props__.__dict__["failure_threshold"] = failure_threshold
            __props__.__dict__["fqdn"] = fqdn
            __props__.__dict__["insufficient_data_health_status"] = insufficient_data_health_status
            __props__.__dict__["invert_healthcheck"] = invert_healthcheck
            __props__.__dict__["ip_address"] = ip_address
            __props__.__dict__["measure_latency"] = measure_latency
            __props__.__dict__["port"] = port
            __props__.__dict__["reference_name"] = reference_name
            __props__.__dict__["regions"] = regions
            __props__.__dict__["request_interval"] = request_interval
            __props__.__dict__["resource_path"] = resource_path
            __props__.__dict__["routing_control_arn"] = routing_control_arn
            __props__.__dict__["search_string"] = search_string
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(HealthCheck, __self__).__init__(
            'aws:route53/healthCheck:HealthCheck',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            child_health_threshold: Optional[pulumi.Input[int]] = None,
            child_healthchecks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            cloudwatch_alarm_name: Optional[pulumi.Input[str]] = None,
            cloudwatch_alarm_region: Optional[pulumi.Input[str]] = None,
            disabled: Optional[pulumi.Input[bool]] = None,
            enable_sni: Optional[pulumi.Input[bool]] = None,
            failure_threshold: Optional[pulumi.Input[int]] = None,
            fqdn: Optional[pulumi.Input[str]] = None,
            insufficient_data_health_status: Optional[pulumi.Input[str]] = None,
            invert_healthcheck: Optional[pulumi.Input[bool]] = None,
            ip_address: Optional[pulumi.Input[str]] = None,
            measure_latency: Optional[pulumi.Input[bool]] = None,
            port: Optional[pulumi.Input[int]] = None,
            reference_name: Optional[pulumi.Input[str]] = None,
            regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            request_interval: Optional[pulumi.Input[int]] = None,
            resource_path: Optional[pulumi.Input[str]] = None,
            routing_control_arn: Optional[pulumi.Input[str]] = None,
            search_string: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'HealthCheck':
        """
        Get an existing HealthCheck resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) of the Health Check.
        :param pulumi.Input[int] child_health_threshold: The minimum number of child health checks that must be healthy for Route 53 to consider the parent health check to be healthy. Valid values are integers between 0 and 256, inclusive
        :param pulumi.Input[Sequence[pulumi.Input[str]]] child_healthchecks: For a specified parent health check, a list of HealthCheckId values for the associated child health checks.
        :param pulumi.Input[str] cloudwatch_alarm_name: The name of the CloudWatch alarm.
        :param pulumi.Input[str] cloudwatch_alarm_region: The CloudWatchRegion that the CloudWatch alarm was created in.
        :param pulumi.Input[bool] disabled: A boolean value that stops Route 53 from performing health checks. When set to true, Route 53 will do the following depending on the type of health check:
               * For health checks that check the health of endpoints, Route5 53 stops submitting requests to your application, server, or other resource.
               * For calculated health checks, Route 53 stops aggregating the status of the referenced health checks.
               * For health checks that monitor CloudWatch alarms, Route 53 stops monitoring the corresponding CloudWatch metrics.
               
               > **Note:** After you disable a health check, Route 53 considers the status of the health check to always be healthy. If you configured DNS failover, Route 53 continues to route traffic to the corresponding resources. If you want to stop routing traffic to a resource, change the value of `invert_healthcheck`.
        :param pulumi.Input[bool] enable_sni: A boolean value that indicates whether Route53 should send the `fqdn` to the endpoint when performing the health check. This defaults to AWS' defaults: when the `type` is "HTTPS" `enable_sni` defaults to `true`, when `type` is anything else `enable_sni` defaults to `false`.
        :param pulumi.Input[int] failure_threshold: The number of consecutive health checks that an endpoint must pass or fail.
        :param pulumi.Input[str] fqdn: The fully qualified domain name of the endpoint to be checked. If a value is set for `ip_address`, the value set for `fqdn` will be passed in the `Host` header.
        :param pulumi.Input[str] insufficient_data_health_status: The status of the health check when CloudWatch has insufficient data about the state of associated alarm. Valid values are `Healthy` , `Unhealthy` and `LastKnownStatus`.
        :param pulumi.Input[bool] invert_healthcheck: A boolean value that indicates whether the status of health check should be inverted. For example, if a health check is healthy but Inverted is True , then Route 53 considers the health check to be unhealthy.
        :param pulumi.Input[str] ip_address: The IP address of the endpoint to be checked.
        :param pulumi.Input[bool] measure_latency: A Boolean value that indicates whether you want Route 53 to measure the latency between health checkers in multiple AWS regions and your endpoint and to display CloudWatch latency graphs in the Route 53 console.
        :param pulumi.Input[int] port: The port of the endpoint to be checked.
        :param pulumi.Input[str] reference_name: This is a reference name used in Caller Reference
               (helpful for identifying single health_check set amongst others)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] regions: A list of AWS regions that you want Amazon Route 53 health checkers to check the specified endpoint from.
        :param pulumi.Input[int] request_interval: The number of seconds between the time that Amazon Route 53 gets a response from your endpoint and the time that it sends the next health-check request.
        :param pulumi.Input[str] resource_path: The path that you want Amazon Route 53 to request when performing health checks.
        :param pulumi.Input[str] routing_control_arn: The Amazon Resource Name (ARN) for the Route 53 Application Recovery Controller routing control. This is used when health check type is `RECOVERY_CONTROL`
        :param pulumi.Input[str] search_string: String searched in the first 5120 bytes of the response body for check to be considered healthy. Only valid with `HTTP_STR_MATCH` and `HTTPS_STR_MATCH`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the health check. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] type: The protocol to use when performing health checks. Valid values are `HTTP`, `HTTPS`, `HTTP_STR_MATCH`, `HTTPS_STR_MATCH`, `TCP`, `CALCULATED`, `CLOUDWATCH_METRIC` and `RECOVERY_CONTROL`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HealthCheckState.__new__(_HealthCheckState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["child_health_threshold"] = child_health_threshold
        __props__.__dict__["child_healthchecks"] = child_healthchecks
        __props__.__dict__["cloudwatch_alarm_name"] = cloudwatch_alarm_name
        __props__.__dict__["cloudwatch_alarm_region"] = cloudwatch_alarm_region
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["enable_sni"] = enable_sni
        __props__.__dict__["failure_threshold"] = failure_threshold
        __props__.__dict__["fqdn"] = fqdn
        __props__.__dict__["insufficient_data_health_status"] = insufficient_data_health_status
        __props__.__dict__["invert_healthcheck"] = invert_healthcheck
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["measure_latency"] = measure_latency
        __props__.__dict__["port"] = port
        __props__.__dict__["reference_name"] = reference_name
        __props__.__dict__["regions"] = regions
        __props__.__dict__["request_interval"] = request_interval
        __props__.__dict__["resource_path"] = resource_path
        __props__.__dict__["routing_control_arn"] = routing_control_arn
        __props__.__dict__["search_string"] = search_string
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["type"] = type
        return HealthCheck(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the Health Check.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="childHealthThreshold")
    def child_health_threshold(self) -> pulumi.Output[Optional[int]]:
        """
        The minimum number of child health checks that must be healthy for Route 53 to consider the parent health check to be healthy. Valid values are integers between 0 and 256, inclusive
        """
        return pulumi.get(self, "child_health_threshold")

    @property
    @pulumi.getter(name="childHealthchecks")
    def child_healthchecks(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        For a specified parent health check, a list of HealthCheckId values for the associated child health checks.
        """
        return pulumi.get(self, "child_healthchecks")

    @property
    @pulumi.getter(name="cloudwatchAlarmName")
    def cloudwatch_alarm_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the CloudWatch alarm.
        """
        return pulumi.get(self, "cloudwatch_alarm_name")

    @property
    @pulumi.getter(name="cloudwatchAlarmRegion")
    def cloudwatch_alarm_region(self) -> pulumi.Output[Optional[str]]:
        """
        The CloudWatchRegion that the CloudWatch alarm was created in.
        """
        return pulumi.get(self, "cloudwatch_alarm_region")

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[bool]]:
        """
        A boolean value that stops Route 53 from performing health checks. When set to true, Route 53 will do the following depending on the type of health check:
        * For health checks that check the health of endpoints, Route5 53 stops submitting requests to your application, server, or other resource.
        * For calculated health checks, Route 53 stops aggregating the status of the referenced health checks.
        * For health checks that monitor CloudWatch alarms, Route 53 stops monitoring the corresponding CloudWatch metrics.

        > **Note:** After you disable a health check, Route 53 considers the status of the health check to always be healthy. If you configured DNS failover, Route 53 continues to route traffic to the corresponding resources. If you want to stop routing traffic to a resource, change the value of `invert_healthcheck`.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="enableSni")
    def enable_sni(self) -> pulumi.Output[bool]:
        """
        A boolean value that indicates whether Route53 should send the `fqdn` to the endpoint when performing the health check. This defaults to AWS' defaults: when the `type` is "HTTPS" `enable_sni` defaults to `true`, when `type` is anything else `enable_sni` defaults to `false`.
        """
        return pulumi.get(self, "enable_sni")

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> pulumi.Output[int]:
        """
        The number of consecutive health checks that an endpoint must pass or fail.
        """
        return pulumi.get(self, "failure_threshold")

    @property
    @pulumi.getter
    def fqdn(self) -> pulumi.Output[Optional[str]]:
        """
        The fully qualified domain name of the endpoint to be checked. If a value is set for `ip_address`, the value set for `fqdn` will be passed in the `Host` header.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="insufficientDataHealthStatus")
    def insufficient_data_health_status(self) -> pulumi.Output[Optional[str]]:
        """
        The status of the health check when CloudWatch has insufficient data about the state of associated alarm. Valid values are `Healthy` , `Unhealthy` and `LastKnownStatus`.
        """
        return pulumi.get(self, "insufficient_data_health_status")

    @property
    @pulumi.getter(name="invertHealthcheck")
    def invert_healthcheck(self) -> pulumi.Output[Optional[bool]]:
        """
        A boolean value that indicates whether the status of health check should be inverted. For example, if a health check is healthy but Inverted is True , then Route 53 considers the health check to be unhealthy.
        """
        return pulumi.get(self, "invert_healthcheck")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[Optional[str]]:
        """
        The IP address of the endpoint to be checked.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="measureLatency")
    def measure_latency(self) -> pulumi.Output[Optional[bool]]:
        """
        A Boolean value that indicates whether you want Route 53 to measure the latency between health checkers in multiple AWS regions and your endpoint and to display CloudWatch latency graphs in the Route 53 console.
        """
        return pulumi.get(self, "measure_latency")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[int]]:
        """
        The port of the endpoint to be checked.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="referenceName")
    def reference_name(self) -> pulumi.Output[Optional[str]]:
        """
        This is a reference name used in Caller Reference
        (helpful for identifying single health_check set amongst others)
        """
        return pulumi.get(self, "reference_name")

    @property
    @pulumi.getter
    def regions(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of AWS regions that you want Amazon Route 53 health checkers to check the specified endpoint from.
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter(name="requestInterval")
    def request_interval(self) -> pulumi.Output[Optional[int]]:
        """
        The number of seconds between the time that Amazon Route 53 gets a response from your endpoint and the time that it sends the next health-check request.
        """
        return pulumi.get(self, "request_interval")

    @property
    @pulumi.getter(name="resourcePath")
    def resource_path(self) -> pulumi.Output[Optional[str]]:
        """
        The path that you want Amazon Route 53 to request when performing health checks.
        """
        return pulumi.get(self, "resource_path")

    @property
    @pulumi.getter(name="routingControlArn")
    def routing_control_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon Resource Name (ARN) for the Route 53 Application Recovery Controller routing control. This is used when health check type is `RECOVERY_CONTROL`
        """
        return pulumi.get(self, "routing_control_arn")

    @property
    @pulumi.getter(name="searchString")
    def search_string(self) -> pulumi.Output[Optional[str]]:
        """
        String searched in the first 5120 bytes of the response body for check to be considered healthy. Only valid with `HTTP_STR_MATCH` and `HTTPS_STR_MATCH`.
        """
        return pulumi.get(self, "search_string")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the health check. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The protocol to use when performing health checks. Valid values are `HTTP`, `HTTPS`, `HTTP_STR_MATCH`, `HTTPS_STR_MATCH`, `TCP`, `CALCULATED`, `CLOUDWATCH_METRIC` and `RECOVERY_CONTROL`.
        """
        return pulumi.get(self, "type")

