# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SafetyRuleArgs', 'SafetyRule']

@pulumi.input_type
class SafetyRuleArgs:
    def __init__(__self__, *,
                 control_panel_arn: pulumi.Input[str],
                 rule_config: pulumi.Input['SafetyRuleRuleConfigArgs'],
                 wait_period_ms: pulumi.Input[int],
                 asserted_controls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 gating_controls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 target_controls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a SafetyRule resource.
        :param pulumi.Input[str] control_panel_arn: ARN of the control panel in which this safety rule will reside.
        :param pulumi.Input['SafetyRuleRuleConfigArgs'] rule_config: Configuration block for safety rule criteria. See below.
        :param pulumi.Input[int] wait_period_ms: Evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[str]]] asserted_controls: Routing controls that are part of transactions that are evaluated to determine if a request to change a routing control state is allowed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gating_controls: Gating controls for the new gating rule. That is, routing controls that are evaluated by the rule configuration that you specify.
        :param pulumi.Input[str] name: Name describing the safety rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_controls: Routing controls that can only be set or unset if the specified `rule_config` evaluates to true for the specified `gating_controls`.
        """
        pulumi.set(__self__, "control_panel_arn", control_panel_arn)
        pulumi.set(__self__, "rule_config", rule_config)
        pulumi.set(__self__, "wait_period_ms", wait_period_ms)
        if asserted_controls is not None:
            pulumi.set(__self__, "asserted_controls", asserted_controls)
        if gating_controls is not None:
            pulumi.set(__self__, "gating_controls", gating_controls)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if target_controls is not None:
            pulumi.set(__self__, "target_controls", target_controls)

    @property
    @pulumi.getter(name="controlPanelArn")
    def control_panel_arn(self) -> pulumi.Input[str]:
        """
        ARN of the control panel in which this safety rule will reside.
        """
        return pulumi.get(self, "control_panel_arn")

    @control_panel_arn.setter
    def control_panel_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "control_panel_arn", value)

    @property
    @pulumi.getter(name="ruleConfig")
    def rule_config(self) -> pulumi.Input['SafetyRuleRuleConfigArgs']:
        """
        Configuration block for safety rule criteria. See below.
        """
        return pulumi.get(self, "rule_config")

    @rule_config.setter
    def rule_config(self, value: pulumi.Input['SafetyRuleRuleConfigArgs']):
        pulumi.set(self, "rule_config", value)

    @property
    @pulumi.getter(name="waitPeriodMs")
    def wait_period_ms(self) -> pulumi.Input[int]:
        """
        Evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail.

        The following arguments are optional:
        """
        return pulumi.get(self, "wait_period_ms")

    @wait_period_ms.setter
    def wait_period_ms(self, value: pulumi.Input[int]):
        pulumi.set(self, "wait_period_ms", value)

    @property
    @pulumi.getter(name="assertedControls")
    def asserted_controls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Routing controls that are part of transactions that are evaluated to determine if a request to change a routing control state is allowed.
        """
        return pulumi.get(self, "asserted_controls")

    @asserted_controls.setter
    def asserted_controls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "asserted_controls", value)

    @property
    @pulumi.getter(name="gatingControls")
    def gating_controls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Gating controls for the new gating rule. That is, routing controls that are evaluated by the rule configuration that you specify.
        """
        return pulumi.get(self, "gating_controls")

    @gating_controls.setter
    def gating_controls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "gating_controls", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name describing the safety rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="targetControls")
    def target_controls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Routing controls that can only be set or unset if the specified `rule_config` evaluates to true for the specified `gating_controls`.
        """
        return pulumi.get(self, "target_controls")

    @target_controls.setter
    def target_controls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "target_controls", value)


@pulumi.input_type
class _SafetyRuleState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 asserted_controls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 control_panel_arn: Optional[pulumi.Input[str]] = None,
                 gating_controls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rule_config: Optional[pulumi.Input['SafetyRuleRuleConfigArgs']] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 target_controls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 wait_period_ms: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering SafetyRule resources.
        :param pulumi.Input[str] arn: ARN of the safety rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] asserted_controls: Routing controls that are part of transactions that are evaluated to determine if a request to change a routing control state is allowed.
        :param pulumi.Input[str] control_panel_arn: ARN of the control panel in which this safety rule will reside.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gating_controls: Gating controls for the new gating rule. That is, routing controls that are evaluated by the rule configuration that you specify.
        :param pulumi.Input[str] name: Name describing the safety rule.
        :param pulumi.Input['SafetyRuleRuleConfigArgs'] rule_config: Configuration block for safety rule criteria. See below.
        :param pulumi.Input[str] status: Status of the safety rule. `PENDING` when it is being created/updated, `PENDING_DELETION` when it is being deleted, and `DEPLOYED` otherwise.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_controls: Routing controls that can only be set or unset if the specified `rule_config` evaluates to true for the specified `gating_controls`.
        :param pulumi.Input[int] wait_period_ms: Evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail.
               
               The following arguments are optional:
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if asserted_controls is not None:
            pulumi.set(__self__, "asserted_controls", asserted_controls)
        if control_panel_arn is not None:
            pulumi.set(__self__, "control_panel_arn", control_panel_arn)
        if gating_controls is not None:
            pulumi.set(__self__, "gating_controls", gating_controls)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rule_config is not None:
            pulumi.set(__self__, "rule_config", rule_config)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if target_controls is not None:
            pulumi.set(__self__, "target_controls", target_controls)
        if wait_period_ms is not None:
            pulumi.set(__self__, "wait_period_ms", wait_period_ms)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the safety rule.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="assertedControls")
    def asserted_controls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Routing controls that are part of transactions that are evaluated to determine if a request to change a routing control state is allowed.
        """
        return pulumi.get(self, "asserted_controls")

    @asserted_controls.setter
    def asserted_controls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "asserted_controls", value)

    @property
    @pulumi.getter(name="controlPanelArn")
    def control_panel_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the control panel in which this safety rule will reside.
        """
        return pulumi.get(self, "control_panel_arn")

    @control_panel_arn.setter
    def control_panel_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "control_panel_arn", value)

    @property
    @pulumi.getter(name="gatingControls")
    def gating_controls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Gating controls for the new gating rule. That is, routing controls that are evaluated by the rule configuration that you specify.
        """
        return pulumi.get(self, "gating_controls")

    @gating_controls.setter
    def gating_controls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "gating_controls", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name describing the safety rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ruleConfig")
    def rule_config(self) -> Optional[pulumi.Input['SafetyRuleRuleConfigArgs']]:
        """
        Configuration block for safety rule criteria. See below.
        """
        return pulumi.get(self, "rule_config")

    @rule_config.setter
    def rule_config(self, value: Optional[pulumi.Input['SafetyRuleRuleConfigArgs']]):
        pulumi.set(self, "rule_config", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the safety rule. `PENDING` when it is being created/updated, `PENDING_DELETION` when it is being deleted, and `DEPLOYED` otherwise.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="targetControls")
    def target_controls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Routing controls that can only be set or unset if the specified `rule_config` evaluates to true for the specified `gating_controls`.
        """
        return pulumi.get(self, "target_controls")

    @target_controls.setter
    def target_controls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "target_controls", value)

    @property
    @pulumi.getter(name="waitPeriodMs")
    def wait_period_ms(self) -> Optional[pulumi.Input[int]]:
        """
        Evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail.

        The following arguments are optional:
        """
        return pulumi.get(self, "wait_period_ms")

    @wait_period_ms.setter
    def wait_period_ms(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "wait_period_ms", value)


class SafetyRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 asserted_controls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 control_panel_arn: Optional[pulumi.Input[str]] = None,
                 gating_controls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rule_config: Optional[pulumi.Input[pulumi.InputType['SafetyRuleRuleConfigArgs']]] = None,
                 target_controls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 wait_period_ms: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Provides an AWS Route 53 Recovery Control Config Safety Rule

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.route53recoverycontrol.SafetyRule("example",
            asserted_controls=[example_aws_route53recoverycontrolconfig_routing_control["arn"]],
            control_panel_arn="arn:aws:route53-recovery-control::313517334327:controlpanel/abd5fbfc052d4844a082dbf400f61da8",
            name="daisyguttridge",
            wait_period_ms=5000,
            rule_config=aws.route53recoverycontrol.SafetyRuleRuleConfigArgs(
                inverted=False,
                threshold=1,
                type="ATLEAST",
            ))
        ```
        <!--End PulumiCodeChooser -->

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.route53recoverycontrol.SafetyRule("example",
            name="i_o",
            control_panel_arn="arn:aws:route53-recovery-control::313517334327:controlpanel/abd5fbfc052d4844a082dbf400f61da8",
            wait_period_ms=5000,
            gating_controls=[example_aws_route53recoverycontrolconfig_routing_control["arn"]],
            target_controls=[example_aws_route53recoverycontrolconfig_routing_control["arn"]],
            rule_config=aws.route53recoverycontrol.SafetyRuleRuleConfigArgs(
                inverted=False,
                threshold=1,
                type="ATLEAST",
            ))
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Route53 Recovery Control Config Safety Rule using the safety rule ARN. For example:

        ```sh
        $ pulumi import aws:route53recoverycontrol/safetyRule:SafetyRule myrule arn:aws:route53-recovery-control::313517334327:controlpanel/1bfba17df8684f5dab0467b71424f7e8/safetyrule/3bacc77003364c0f
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] asserted_controls: Routing controls that are part of transactions that are evaluated to determine if a request to change a routing control state is allowed.
        :param pulumi.Input[str] control_panel_arn: ARN of the control panel in which this safety rule will reside.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gating_controls: Gating controls for the new gating rule. That is, routing controls that are evaluated by the rule configuration that you specify.
        :param pulumi.Input[str] name: Name describing the safety rule.
        :param pulumi.Input[pulumi.InputType['SafetyRuleRuleConfigArgs']] rule_config: Configuration block for safety rule criteria. See below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_controls: Routing controls that can only be set or unset if the specified `rule_config` evaluates to true for the specified `gating_controls`.
        :param pulumi.Input[int] wait_period_ms: Evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SafetyRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an AWS Route 53 Recovery Control Config Safety Rule

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.route53recoverycontrol.SafetyRule("example",
            asserted_controls=[example_aws_route53recoverycontrolconfig_routing_control["arn"]],
            control_panel_arn="arn:aws:route53-recovery-control::313517334327:controlpanel/abd5fbfc052d4844a082dbf400f61da8",
            name="daisyguttridge",
            wait_period_ms=5000,
            rule_config=aws.route53recoverycontrol.SafetyRuleRuleConfigArgs(
                inverted=False,
                threshold=1,
                type="ATLEAST",
            ))
        ```
        <!--End PulumiCodeChooser -->

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.route53recoverycontrol.SafetyRule("example",
            name="i_o",
            control_panel_arn="arn:aws:route53-recovery-control::313517334327:controlpanel/abd5fbfc052d4844a082dbf400f61da8",
            wait_period_ms=5000,
            gating_controls=[example_aws_route53recoverycontrolconfig_routing_control["arn"]],
            target_controls=[example_aws_route53recoverycontrolconfig_routing_control["arn"]],
            rule_config=aws.route53recoverycontrol.SafetyRuleRuleConfigArgs(
                inverted=False,
                threshold=1,
                type="ATLEAST",
            ))
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Route53 Recovery Control Config Safety Rule using the safety rule ARN. For example:

        ```sh
        $ pulumi import aws:route53recoverycontrol/safetyRule:SafetyRule myrule arn:aws:route53-recovery-control::313517334327:controlpanel/1bfba17df8684f5dab0467b71424f7e8/safetyrule/3bacc77003364c0f
        ```

        :param str resource_name: The name of the resource.
        :param SafetyRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SafetyRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 asserted_controls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 control_panel_arn: Optional[pulumi.Input[str]] = None,
                 gating_controls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rule_config: Optional[pulumi.Input[pulumi.InputType['SafetyRuleRuleConfigArgs']]] = None,
                 target_controls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 wait_period_ms: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SafetyRuleArgs.__new__(SafetyRuleArgs)

            __props__.__dict__["asserted_controls"] = asserted_controls
            if control_panel_arn is None and not opts.urn:
                raise TypeError("Missing required property 'control_panel_arn'")
            __props__.__dict__["control_panel_arn"] = control_panel_arn
            __props__.__dict__["gating_controls"] = gating_controls
            __props__.__dict__["name"] = name
            if rule_config is None and not opts.urn:
                raise TypeError("Missing required property 'rule_config'")
            __props__.__dict__["rule_config"] = rule_config
            __props__.__dict__["target_controls"] = target_controls
            if wait_period_ms is None and not opts.urn:
                raise TypeError("Missing required property 'wait_period_ms'")
            __props__.__dict__["wait_period_ms"] = wait_period_ms
            __props__.__dict__["arn"] = None
            __props__.__dict__["status"] = None
        super(SafetyRule, __self__).__init__(
            'aws:route53recoverycontrol/safetyRule:SafetyRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            asserted_controls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            control_panel_arn: Optional[pulumi.Input[str]] = None,
            gating_controls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            rule_config: Optional[pulumi.Input[pulumi.InputType['SafetyRuleRuleConfigArgs']]] = None,
            status: Optional[pulumi.Input[str]] = None,
            target_controls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            wait_period_ms: Optional[pulumi.Input[int]] = None) -> 'SafetyRule':
        """
        Get an existing SafetyRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: ARN of the safety rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] asserted_controls: Routing controls that are part of transactions that are evaluated to determine if a request to change a routing control state is allowed.
        :param pulumi.Input[str] control_panel_arn: ARN of the control panel in which this safety rule will reside.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] gating_controls: Gating controls for the new gating rule. That is, routing controls that are evaluated by the rule configuration that you specify.
        :param pulumi.Input[str] name: Name describing the safety rule.
        :param pulumi.Input[pulumi.InputType['SafetyRuleRuleConfigArgs']] rule_config: Configuration block for safety rule criteria. See below.
        :param pulumi.Input[str] status: Status of the safety rule. `PENDING` when it is being created/updated, `PENDING_DELETION` when it is being deleted, and `DEPLOYED` otherwise.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_controls: Routing controls that can only be set or unset if the specified `rule_config` evaluates to true for the specified `gating_controls`.
        :param pulumi.Input[int] wait_period_ms: Evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SafetyRuleState.__new__(_SafetyRuleState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["asserted_controls"] = asserted_controls
        __props__.__dict__["control_panel_arn"] = control_panel_arn
        __props__.__dict__["gating_controls"] = gating_controls
        __props__.__dict__["name"] = name
        __props__.__dict__["rule_config"] = rule_config
        __props__.__dict__["status"] = status
        __props__.__dict__["target_controls"] = target_controls
        __props__.__dict__["wait_period_ms"] = wait_period_ms
        return SafetyRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN of the safety rule.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="assertedControls")
    def asserted_controls(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Routing controls that are part of transactions that are evaluated to determine if a request to change a routing control state is allowed.
        """
        return pulumi.get(self, "asserted_controls")

    @property
    @pulumi.getter(name="controlPanelArn")
    def control_panel_arn(self) -> pulumi.Output[str]:
        """
        ARN of the control panel in which this safety rule will reside.
        """
        return pulumi.get(self, "control_panel_arn")

    @property
    @pulumi.getter(name="gatingControls")
    def gating_controls(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Gating controls for the new gating rule. That is, routing controls that are evaluated by the rule configuration that you specify.
        """
        return pulumi.get(self, "gating_controls")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name describing the safety rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ruleConfig")
    def rule_config(self) -> pulumi.Output['outputs.SafetyRuleRuleConfig']:
        """
        Configuration block for safety rule criteria. See below.
        """
        return pulumi.get(self, "rule_config")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Status of the safety rule. `PENDING` when it is being created/updated, `PENDING_DELETION` when it is being deleted, and `DEPLOYED` otherwise.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="targetControls")
    def target_controls(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Routing controls that can only be set or unset if the specified `rule_config` evaluates to true for the specified `gating_controls`.
        """
        return pulumi.get(self, "target_controls")

    @property
    @pulumi.getter(name="waitPeriodMs")
    def wait_period_ms(self) -> pulumi.Output[int]:
        """
        Evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail.

        The following arguments are optional:
        """
        return pulumi.get(self, "wait_period_ms")

