# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AccessGrantsInstanceArgs', 'AccessGrantsInstance']

@pulumi.input_type
class AccessGrantsInstanceArgs:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 identity_center_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a AccessGrantsInstance resource.
        :param pulumi.Input[str] identity_center_arn: The ARN of the AWS IAM Identity Center instance associated with the S3 Access Grants instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if identity_center_arn is not None:
            pulumi.set(__self__, "identity_center_arn", identity_center_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="identityCenterArn")
    def identity_center_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the AWS IAM Identity Center instance associated with the S3 Access Grants instance.
        """
        return pulumi.get(self, "identity_center_arn")

    @identity_center_arn.setter
    def identity_center_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_center_arn", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AccessGrantsInstanceState:
    def __init__(__self__, *,
                 access_grants_instance_arn: Optional[pulumi.Input[str]] = None,
                 access_grants_instance_id: Optional[pulumi.Input[str]] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 identity_center_application_arn: Optional[pulumi.Input[str]] = None,
                 identity_center_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering AccessGrantsInstance resources.
        :param pulumi.Input[str] access_grants_instance_arn: Amazon Resource Name (ARN) of the S3 Access Grants instance.
        :param pulumi.Input[str] access_grants_instance_id: Unique ID of the S3 Access Grants instance.
        :param pulumi.Input[str] identity_center_application_arn: The ARN of the AWS IAM Identity Center instance application; a subresource of the original Identity Center instance.
        :param pulumi.Input[str] identity_center_arn: The ARN of the AWS IAM Identity Center instance associated with the S3 Access Grants instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if access_grants_instance_arn is not None:
            pulumi.set(__self__, "access_grants_instance_arn", access_grants_instance_arn)
        if access_grants_instance_id is not None:
            pulumi.set(__self__, "access_grants_instance_id", access_grants_instance_id)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if identity_center_application_arn is not None:
            pulumi.set(__self__, "identity_center_application_arn", identity_center_application_arn)
        if identity_center_arn is not None:
            pulumi.set(__self__, "identity_center_arn", identity_center_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter(name="accessGrantsInstanceArn")
    def access_grants_instance_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of the S3 Access Grants instance.
        """
        return pulumi.get(self, "access_grants_instance_arn")

    @access_grants_instance_arn.setter
    def access_grants_instance_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_grants_instance_arn", value)

    @property
    @pulumi.getter(name="accessGrantsInstanceId")
    def access_grants_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique ID of the S3 Access Grants instance.
        """
        return pulumi.get(self, "access_grants_instance_id")

    @access_grants_instance_id.setter
    def access_grants_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_grants_instance_id", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="identityCenterApplicationArn")
    def identity_center_application_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the AWS IAM Identity Center instance application; a subresource of the original Identity Center instance.
        """
        return pulumi.get(self, "identity_center_application_arn")

    @identity_center_application_arn.setter
    def identity_center_application_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_center_application_arn", value)

    @property
    @pulumi.getter(name="identityCenterArn")
    def identity_center_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the AWS IAM Identity Center instance associated with the S3 Access Grants instance.
        """
        return pulumi.get(self, "identity_center_arn")

    @identity_center_arn.setter
    def identity_center_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_center_arn", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)


class AccessGrantsInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 identity_center_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides a resource to manage an S3 Access Grants instance, which serves as a logical grouping for access grants.
        You can have one S3 Access Grants instance per Region in your account.

        ## Example Usage

        ### Basic Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3control.AccessGrantsInstance("example")
        ```
        <!--End PulumiCodeChooser -->

        ### AWS IAM Identity Center

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3control.AccessGrantsInstance("example", identity_center_arn="arn:aws:sso:::instance/ssoins-890759e9c7bfdc1d")
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import S3 Access Grants instances using the `account_id`. For example:

        ```sh
        $ pulumi import aws:s3control/accessGrantsInstance:AccessGrantsInstance example 123456789012
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] identity_center_arn: The ARN of the AWS IAM Identity Center instance associated with the S3 Access Grants instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AccessGrantsInstanceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage an S3 Access Grants instance, which serves as a logical grouping for access grants.
        You can have one S3 Access Grants instance per Region in your account.

        ## Example Usage

        ### Basic Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3control.AccessGrantsInstance("example")
        ```
        <!--End PulumiCodeChooser -->

        ### AWS IAM Identity Center

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3control.AccessGrantsInstance("example", identity_center_arn="arn:aws:sso:::instance/ssoins-890759e9c7bfdc1d")
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import S3 Access Grants instances using the `account_id`. For example:

        ```sh
        $ pulumi import aws:s3control/accessGrantsInstance:AccessGrantsInstance example 123456789012
        ```

        :param str resource_name: The name of the resource.
        :param AccessGrantsInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccessGrantsInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 identity_center_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccessGrantsInstanceArgs.__new__(AccessGrantsInstanceArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["identity_center_arn"] = identity_center_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["access_grants_instance_arn"] = None
            __props__.__dict__["access_grants_instance_id"] = None
            __props__.__dict__["identity_center_application_arn"] = None
            __props__.__dict__["tags_all"] = None
        super(AccessGrantsInstance, __self__).__init__(
            'aws:s3control/accessGrantsInstance:AccessGrantsInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_grants_instance_arn: Optional[pulumi.Input[str]] = None,
            access_grants_instance_id: Optional[pulumi.Input[str]] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            identity_center_application_arn: Optional[pulumi.Input[str]] = None,
            identity_center_arn: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'AccessGrantsInstance':
        """
        Get an existing AccessGrantsInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_grants_instance_arn: Amazon Resource Name (ARN) of the S3 Access Grants instance.
        :param pulumi.Input[str] access_grants_instance_id: Unique ID of the S3 Access Grants instance.
        :param pulumi.Input[str] identity_center_application_arn: The ARN of the AWS IAM Identity Center instance application; a subresource of the original Identity Center instance.
        :param pulumi.Input[str] identity_center_arn: The ARN of the AWS IAM Identity Center instance associated with the S3 Access Grants instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccessGrantsInstanceState.__new__(_AccessGrantsInstanceState)

        __props__.__dict__["access_grants_instance_arn"] = access_grants_instance_arn
        __props__.__dict__["access_grants_instance_id"] = access_grants_instance_id
        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["identity_center_application_arn"] = identity_center_application_arn
        __props__.__dict__["identity_center_arn"] = identity_center_arn
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return AccessGrantsInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessGrantsInstanceArn")
    def access_grants_instance_arn(self) -> pulumi.Output[str]:
        """
        Amazon Resource Name (ARN) of the S3 Access Grants instance.
        """
        return pulumi.get(self, "access_grants_instance_arn")

    @property
    @pulumi.getter(name="accessGrantsInstanceId")
    def access_grants_instance_id(self) -> pulumi.Output[str]:
        """
        Unique ID of the S3 Access Grants instance.
        """
        return pulumi.get(self, "access_grants_instance_id")

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="identityCenterApplicationArn")
    def identity_center_application_arn(self) -> pulumi.Output[str]:
        """
        The ARN of the AWS IAM Identity Center instance application; a subresource of the original Identity Center instance.
        """
        return pulumi.get(self, "identity_center_application_arn")

    @property
    @pulumi.getter(name="identityCenterArn")
    def identity_center_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The ARN of the AWS IAM Identity Center instance associated with the S3 Access Grants instance.
        """
        return pulumi.get(self, "identity_center_arn")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

