# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ObjectLambdaAccessPointPolicyArgs', 'ObjectLambdaAccessPointPolicy']

@pulumi.input_type
class ObjectLambdaAccessPointPolicyArgs:
    def __init__(__self__, *,
                 policy: pulumi.Input[str],
                 account_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ObjectLambdaAccessPointPolicy resource.
        :param pulumi.Input[str] policy: The Object Lambda Access Point resource policy document.
        :param pulumi.Input[str] account_id: The AWS account ID for the account that owns the Object Lambda Access Point. Defaults to automatically determined account ID of the AWS provider.
        :param pulumi.Input[str] name: The name of the Object Lambda Access Point.
        """
        pulumi.set(__self__, "policy", policy)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def policy(self) -> pulumi.Input[str]:
        """
        The Object Lambda Access Point resource policy document.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS account ID for the account that owns the Object Lambda Access Point. Defaults to automatically determined account ID of the AWS provider.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Object Lambda Access Point.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ObjectLambdaAccessPointPolicyState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 has_public_access_policy: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ObjectLambdaAccessPointPolicy resources.
        :param pulumi.Input[str] account_id: The AWS account ID for the account that owns the Object Lambda Access Point. Defaults to automatically determined account ID of the AWS provider.
        :param pulumi.Input[bool] has_public_access_policy: Indicates whether this access point currently has a policy that allows public access.
        :param pulumi.Input[str] name: The name of the Object Lambda Access Point.
        :param pulumi.Input[str] policy: The Object Lambda Access Point resource policy document.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if has_public_access_policy is not None:
            pulumi.set(__self__, "has_public_access_policy", has_public_access_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS account ID for the account that owns the Object Lambda Access Point. Defaults to automatically determined account ID of the AWS provider.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="hasPublicAccessPolicy")
    def has_public_access_policy(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether this access point currently has a policy that allows public access.
        """
        return pulumi.get(self, "has_public_access_policy")

    @has_public_access_policy.setter
    def has_public_access_policy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "has_public_access_policy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Object Lambda Access Point.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[str]]:
        """
        The Object Lambda Access Point resource policy document.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy", value)


class ObjectLambdaAccessPointPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage an S3 Object Lambda Access Point resource policy.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.s3.BucketV2("example", bucket="example")
        example_access_point = aws.s3.AccessPoint("example",
            bucket=example.id,
            name="example")
        example_object_lambda_access_point = aws.s3control.ObjectLambdaAccessPoint("example",
            name="example",
            configuration=aws.s3control.ObjectLambdaAccessPointConfigurationArgs(
                supporting_access_point=example_access_point.arn,
                transformation_configurations=[aws.s3control.ObjectLambdaAccessPointConfigurationTransformationConfigurationArgs(
                    actions=["GetObject"],
                    content_transformation=aws.s3control.ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationArgs(
                        aws_lambda=aws.s3control.ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambdaArgs(
                            function_arn=example_aws_lambda_function["arn"],
                        ),
                    ),
                )],
            ))
        example_object_lambda_access_point_policy = aws.s3control.ObjectLambdaAccessPointPolicy("example",
            name=example_object_lambda_access_point.name,
            policy=pulumi.Output.json_dumps({
                "version": "2008-10-17",
                "statement": [{
                    "effect": "Allow",
                    "action": "s3-object-lambda:GetObject",
                    "principal": {
                        "AWS": current["accountId"],
                    },
                    "resource": example_object_lambda_access_point.arn,
                }],
            }))
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Object Lambda Access Point policies using the `account_id` and `name`, separated by a colon (`:`). For example:

        ```sh
        $ pulumi import aws:s3control/objectLambdaAccessPointPolicy:ObjectLambdaAccessPointPolicy example 123456789012:example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The AWS account ID for the account that owns the Object Lambda Access Point. Defaults to automatically determined account ID of the AWS provider.
        :param pulumi.Input[str] name: The name of the Object Lambda Access Point.
        :param pulumi.Input[str] policy: The Object Lambda Access Point resource policy document.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ObjectLambdaAccessPointPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage an S3 Object Lambda Access Point resource policy.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.s3.BucketV2("example", bucket="example")
        example_access_point = aws.s3.AccessPoint("example",
            bucket=example.id,
            name="example")
        example_object_lambda_access_point = aws.s3control.ObjectLambdaAccessPoint("example",
            name="example",
            configuration=aws.s3control.ObjectLambdaAccessPointConfigurationArgs(
                supporting_access_point=example_access_point.arn,
                transformation_configurations=[aws.s3control.ObjectLambdaAccessPointConfigurationTransformationConfigurationArgs(
                    actions=["GetObject"],
                    content_transformation=aws.s3control.ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationArgs(
                        aws_lambda=aws.s3control.ObjectLambdaAccessPointConfigurationTransformationConfigurationContentTransformationAwsLambdaArgs(
                            function_arn=example_aws_lambda_function["arn"],
                        ),
                    ),
                )],
            ))
        example_object_lambda_access_point_policy = aws.s3control.ObjectLambdaAccessPointPolicy("example",
            name=example_object_lambda_access_point.name,
            policy=pulumi.Output.json_dumps({
                "version": "2008-10-17",
                "statement": [{
                    "effect": "Allow",
                    "action": "s3-object-lambda:GetObject",
                    "principal": {
                        "AWS": current["accountId"],
                    },
                    "resource": example_object_lambda_access_point.arn,
                }],
            }))
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Object Lambda Access Point policies using the `account_id` and `name`, separated by a colon (`:`). For example:

        ```sh
        $ pulumi import aws:s3control/objectLambdaAccessPointPolicy:ObjectLambdaAccessPointPolicy example 123456789012:example
        ```

        :param str resource_name: The name of the resource.
        :param ObjectLambdaAccessPointPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ObjectLambdaAccessPointPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ObjectLambdaAccessPointPolicyArgs.__new__(ObjectLambdaAccessPointPolicyArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["name"] = name
            if policy is None and not opts.urn:
                raise TypeError("Missing required property 'policy'")
            __props__.__dict__["policy"] = policy
            __props__.__dict__["has_public_access_policy"] = None
        super(ObjectLambdaAccessPointPolicy, __self__).__init__(
            'aws:s3control/objectLambdaAccessPointPolicy:ObjectLambdaAccessPointPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            has_public_access_policy: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            policy: Optional[pulumi.Input[str]] = None) -> 'ObjectLambdaAccessPointPolicy':
        """
        Get an existing ObjectLambdaAccessPointPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The AWS account ID for the account that owns the Object Lambda Access Point. Defaults to automatically determined account ID of the AWS provider.
        :param pulumi.Input[bool] has_public_access_policy: Indicates whether this access point currently has a policy that allows public access.
        :param pulumi.Input[str] name: The name of the Object Lambda Access Point.
        :param pulumi.Input[str] policy: The Object Lambda Access Point resource policy document.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ObjectLambdaAccessPointPolicyState.__new__(_ObjectLambdaAccessPointPolicyState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["has_public_access_policy"] = has_public_access_policy
        __props__.__dict__["name"] = name
        __props__.__dict__["policy"] = policy
        return ObjectLambdaAccessPointPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        The AWS account ID for the account that owns the Object Lambda Access Point. Defaults to automatically determined account ID of the AWS provider.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="hasPublicAccessPolicy")
    def has_public_access_policy(self) -> pulumi.Output[bool]:
        """
        Indicates whether this access point currently has a policy that allows public access.
        """
        return pulumi.get(self, "has_public_access_policy")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Object Lambda Access Point.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def policy(self) -> pulumi.Output[str]:
        """
        The Object Lambda Access Point resource policy document.
        """
        return pulumi.get(self, "policy")

