# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'AwsLogSourceSourceArgs',
    'CustomLogSourceAttributeArgs',
    'CustomLogSourceConfigurationArgs',
    'CustomLogSourceConfigurationCrawlerConfigurationArgs',
    'CustomLogSourceConfigurationProviderIdentityArgs',
    'CustomLogSourceProviderDetailArgs',
    'DataLakeConfigurationArgs',
    'DataLakeConfigurationEncryptionConfigurationArgs',
    'DataLakeConfigurationLifecycleConfigurationArgs',
    'DataLakeConfigurationLifecycleConfigurationExpirationArgs',
    'DataLakeConfigurationLifecycleConfigurationTransitionArgs',
    'DataLakeConfigurationReplicationConfigurationArgs',
    'DataLakeTimeoutsArgs',
    'SubscriberNotificationConfigurationArgs',
    'SubscriberNotificationConfigurationHttpsNotificationConfigurationArgs',
    'SubscriberNotificationConfigurationSqsNotificationConfigurationArgs',
    'SubscriberSourceArgs',
    'SubscriberSourceAwsLogSourceResourceArgs',
    'SubscriberSourceCustomLogSourceResourceArgs',
    'SubscriberSourceCustomLogSourceResourceAttributeArgs',
    'SubscriberSourceCustomLogSourceResourceProviderArgs',
    'SubscriberSubscriberIdentityArgs',
    'SubscriberTimeoutsArgs',
]

@pulumi.input_type
class AwsLogSourceSourceArgs:
    def __init__(__self__, *,
                 regions: pulumi.Input[Sequence[pulumi.Input[str]]],
                 source_name: pulumi.Input[str],
                 accounts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] regions: Specify the Regions where you want to enable Security Lake.
        :param pulumi.Input[str] source_name: The name for a AWS source. This must be a Regionally unique value. Valid values: `ROUTE53`, `VPC_FLOW`, `SH_FINDINGS`, `CLOUD_TRAIL_MGMT`, `LAMBDA_EXECUTION`, `S3_DATA`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] accounts: Specify the AWS account information where you want to enable Security Lake.
        :param pulumi.Input[str] source_version: The version for a AWS source. This must be a Regionally unique value.
        """
        pulumi.set(__self__, "regions", regions)
        pulumi.set(__self__, "source_name", source_name)
        if accounts is not None:
            pulumi.set(__self__, "accounts", accounts)
        if source_version is not None:
            pulumi.set(__self__, "source_version", source_version)

    @property
    @pulumi.getter
    def regions(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specify the Regions where you want to enable Security Lake.
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "regions", value)

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> pulumi.Input[str]:
        """
        The name for a AWS source. This must be a Regionally unique value. Valid values: `ROUTE53`, `VPC_FLOW`, `SH_FINDINGS`, `CLOUD_TRAIL_MGMT`, `LAMBDA_EXECUTION`, `S3_DATA`.
        """
        return pulumi.get(self, "source_name")

    @source_name.setter
    def source_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_name", value)

    @property
    @pulumi.getter
    def accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specify the AWS account information where you want to enable Security Lake.
        """
        return pulumi.get(self, "accounts")

    @accounts.setter
    def accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "accounts", value)

    @property
    @pulumi.getter(name="sourceVersion")
    def source_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version for a AWS source. This must be a Regionally unique value.
        """
        return pulumi.get(self, "source_version")

    @source_version.setter
    def source_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_version", value)


@pulumi.input_type
class CustomLogSourceAttributeArgs:
    def __init__(__self__, *,
                 crawler_arn: pulumi.Input[str],
                 database_arn: pulumi.Input[str],
                 table_arn: pulumi.Input[str]):
        """
        :param pulumi.Input[str] crawler_arn: The ARN of the AWS Glue crawler.
        :param pulumi.Input[str] database_arn: The ARN of the AWS Glue database where results are written.
        :param pulumi.Input[str] table_arn: The ARN of the AWS Glue table.
        """
        pulumi.set(__self__, "crawler_arn", crawler_arn)
        pulumi.set(__self__, "database_arn", database_arn)
        pulumi.set(__self__, "table_arn", table_arn)

    @property
    @pulumi.getter(name="crawlerArn")
    def crawler_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the AWS Glue crawler.
        """
        return pulumi.get(self, "crawler_arn")

    @crawler_arn.setter
    def crawler_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "crawler_arn", value)

    @property
    @pulumi.getter(name="databaseArn")
    def database_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the AWS Glue database where results are written.
        """
        return pulumi.get(self, "database_arn")

    @database_arn.setter
    def database_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_arn", value)

    @property
    @pulumi.getter(name="tableArn")
    def table_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the AWS Glue table.
        """
        return pulumi.get(self, "table_arn")

    @table_arn.setter
    def table_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_arn", value)


@pulumi.input_type
class CustomLogSourceConfigurationArgs:
    def __init__(__self__, *,
                 crawler_configuration: Optional[pulumi.Input['CustomLogSourceConfigurationCrawlerConfigurationArgs']] = None,
                 provider_identity: Optional[pulumi.Input['CustomLogSourceConfigurationProviderIdentityArgs']] = None):
        """
        :param pulumi.Input['CustomLogSourceConfigurationCrawlerConfigurationArgs'] crawler_configuration: The configuration for the Glue Crawler for the third-party custom source.
        :param pulumi.Input['CustomLogSourceConfigurationProviderIdentityArgs'] provider_identity: The identity of the log provider for the third-party custom source.
        """
        if crawler_configuration is not None:
            pulumi.set(__self__, "crawler_configuration", crawler_configuration)
        if provider_identity is not None:
            pulumi.set(__self__, "provider_identity", provider_identity)

    @property
    @pulumi.getter(name="crawlerConfiguration")
    def crawler_configuration(self) -> Optional[pulumi.Input['CustomLogSourceConfigurationCrawlerConfigurationArgs']]:
        """
        The configuration for the Glue Crawler for the third-party custom source.
        """
        return pulumi.get(self, "crawler_configuration")

    @crawler_configuration.setter
    def crawler_configuration(self, value: Optional[pulumi.Input['CustomLogSourceConfigurationCrawlerConfigurationArgs']]):
        pulumi.set(self, "crawler_configuration", value)

    @property
    @pulumi.getter(name="providerIdentity")
    def provider_identity(self) -> Optional[pulumi.Input['CustomLogSourceConfigurationProviderIdentityArgs']]:
        """
        The identity of the log provider for the third-party custom source.
        """
        return pulumi.get(self, "provider_identity")

    @provider_identity.setter
    def provider_identity(self, value: Optional[pulumi.Input['CustomLogSourceConfigurationProviderIdentityArgs']]):
        pulumi.set(self, "provider_identity", value)


@pulumi.input_type
class CustomLogSourceConfigurationCrawlerConfigurationArgs:
    def __init__(__self__, *,
                 role_arn: pulumi.Input[str]):
        """
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role to be used by the AWS Glue crawler.
        """
        pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role to be used by the AWS Glue crawler.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)


@pulumi.input_type
class CustomLogSourceConfigurationProviderIdentityArgs:
    def __init__(__self__, *,
                 external_id: pulumi.Input[str],
                 principal: pulumi.Input[str]):
        """
        :param pulumi.Input[str] external_id: The external ID used to estalish trust relationship with the AWS identity.
        :param pulumi.Input[str] principal: The AWS identity principal.
        """
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "principal", principal)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Input[str]:
        """
        The external ID used to estalish trust relationship with the AWS identity.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter
    def principal(self) -> pulumi.Input[str]:
        """
        The AWS identity principal.
        """
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: pulumi.Input[str]):
        pulumi.set(self, "principal", value)


@pulumi.input_type
class CustomLogSourceProviderDetailArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 role_arn: pulumi.Input[str]):
        """
        :param pulumi.Input[str] location: The location of the partition in the Amazon S3 bucket for Security Lake.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role to be used by the AWS Glue crawler.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The location of the partition in the Amazon S3 bucket for Security Lake.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role to be used by the AWS Glue crawler.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)


@pulumi.input_type
class DataLakeConfigurationArgs:
    def __init__(__self__, *,
                 region: pulumi.Input[str],
                 encryption_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['DataLakeConfigurationEncryptionConfigurationArgs']]]] = None,
                 lifecycle_configuration: Optional[pulumi.Input['DataLakeConfigurationLifecycleConfigurationArgs']] = None,
                 replication_configuration: Optional[pulumi.Input['DataLakeConfigurationReplicationConfigurationArgs']] = None):
        """
        :param pulumi.Input[str] region: The AWS Regions where Security Lake is automatically enabled.
        :param pulumi.Input[Sequence[pulumi.Input['DataLakeConfigurationEncryptionConfigurationArgs']]] encryption_configurations: Provides encryption details of Amazon Security Lake object.
        :param pulumi.Input['DataLakeConfigurationLifecycleConfigurationArgs'] lifecycle_configuration: Provides lifecycle details of Amazon Security Lake object.
        :param pulumi.Input['DataLakeConfigurationReplicationConfigurationArgs'] replication_configuration: Provides replication details of Amazon Security Lake object.
        """
        pulumi.set(__self__, "region", region)
        if encryption_configurations is not None:
            pulumi.set(__self__, "encryption_configurations", encryption_configurations)
        if lifecycle_configuration is not None:
            pulumi.set(__self__, "lifecycle_configuration", lifecycle_configuration)
        if replication_configuration is not None:
            pulumi.set(__self__, "replication_configuration", replication_configuration)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        The AWS Regions where Security Lake is automatically enabled.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="encryptionConfigurations")
    def encryption_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataLakeConfigurationEncryptionConfigurationArgs']]]]:
        """
        Provides encryption details of Amazon Security Lake object.
        """
        return pulumi.get(self, "encryption_configurations")

    @encryption_configurations.setter
    def encryption_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataLakeConfigurationEncryptionConfigurationArgs']]]]):
        pulumi.set(self, "encryption_configurations", value)

    @property
    @pulumi.getter(name="lifecycleConfiguration")
    def lifecycle_configuration(self) -> Optional[pulumi.Input['DataLakeConfigurationLifecycleConfigurationArgs']]:
        """
        Provides lifecycle details of Amazon Security Lake object.
        """
        return pulumi.get(self, "lifecycle_configuration")

    @lifecycle_configuration.setter
    def lifecycle_configuration(self, value: Optional[pulumi.Input['DataLakeConfigurationLifecycleConfigurationArgs']]):
        pulumi.set(self, "lifecycle_configuration", value)

    @property
    @pulumi.getter(name="replicationConfiguration")
    def replication_configuration(self) -> Optional[pulumi.Input['DataLakeConfigurationReplicationConfigurationArgs']]:
        """
        Provides replication details of Amazon Security Lake object.
        """
        return pulumi.get(self, "replication_configuration")

    @replication_configuration.setter
    def replication_configuration(self, value: Optional[pulumi.Input['DataLakeConfigurationReplicationConfigurationArgs']]):
        pulumi.set(self, "replication_configuration", value)


@pulumi.input_type
class DataLakeConfigurationEncryptionConfigurationArgs:
    def __init__(__self__, *,
                 kms_key_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] kms_key_id: The id of KMS encryption key used by Amazon Security Lake to encrypt the Security Lake object.
        """
        pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Input[str]:
        """
        The id of KMS encryption key used by Amazon Security Lake to encrypt the Security Lake object.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "kms_key_id", value)


@pulumi.input_type
class DataLakeConfigurationLifecycleConfigurationArgs:
    def __init__(__self__, *,
                 expiration: Optional[pulumi.Input['DataLakeConfigurationLifecycleConfigurationExpirationArgs']] = None,
                 transitions: Optional[pulumi.Input[Sequence[pulumi.Input['DataLakeConfigurationLifecycleConfigurationTransitionArgs']]]] = None):
        """
        :param pulumi.Input['DataLakeConfigurationLifecycleConfigurationExpirationArgs'] expiration: Provides data expiration details of Amazon Security Lake object.
        :param pulumi.Input[Sequence[pulumi.Input['DataLakeConfigurationLifecycleConfigurationTransitionArgs']]] transitions: Provides data storage transition details of Amazon Security Lake object.
        """
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if transitions is not None:
            pulumi.set(__self__, "transitions", transitions)

    @property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input['DataLakeConfigurationLifecycleConfigurationExpirationArgs']]:
        """
        Provides data expiration details of Amazon Security Lake object.
        """
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input['DataLakeConfigurationLifecycleConfigurationExpirationArgs']]):
        pulumi.set(self, "expiration", value)

    @property
    @pulumi.getter
    def transitions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataLakeConfigurationLifecycleConfigurationTransitionArgs']]]]:
        """
        Provides data storage transition details of Amazon Security Lake object.
        """
        return pulumi.get(self, "transitions")

    @transitions.setter
    def transitions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataLakeConfigurationLifecycleConfigurationTransitionArgs']]]]):
        pulumi.set(self, "transitions", value)


@pulumi.input_type
class DataLakeConfigurationLifecycleConfigurationExpirationArgs:
    def __init__(__self__, *,
                 days: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] days: Number of days before data transition to a different S3 Storage Class in the Amazon Security Lake object.
        """
        if days is not None:
            pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter
    def days(self) -> Optional[pulumi.Input[int]]:
        """
        Number of days before data transition to a different S3 Storage Class in the Amazon Security Lake object.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "days", value)


@pulumi.input_type
class DataLakeConfigurationLifecycleConfigurationTransitionArgs:
    def __init__(__self__, *,
                 days: Optional[pulumi.Input[int]] = None,
                 storage_class: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] days: Number of days before data transition to a different S3 Storage Class in the Amazon Security Lake object.
        :param pulumi.Input[str] storage_class: The range of storage classes that you can choose from based on the data access, resiliency, and cost requirements of your workloads.
        """
        if days is not None:
            pulumi.set(__self__, "days", days)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)

    @property
    @pulumi.getter
    def days(self) -> Optional[pulumi.Input[int]]:
        """
        Number of days before data transition to a different S3 Storage Class in the Amazon Security Lake object.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "days", value)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[pulumi.Input[str]]:
        """
        The range of storage classes that you can choose from based on the data access, resiliency, and cost requirements of your workloads.
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_class", value)


@pulumi.input_type
class DataLakeConfigurationReplicationConfigurationArgs:
    def __init__(__self__, *,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] regions: Replication enables automatic, asynchronous copying of objects across Amazon S3 buckets. Amazon S3 buckets that are configured for object replication can be owned by the same AWS account or by different accounts. You can replicate objects to a single destination bucket or to multiple destination buckets. The destination buckets can be in different AWS Regions or within the same Region as the source bucket.
        :param pulumi.Input[str] role_arn: Replication settings for the Amazon S3 buckets. This parameter uses the AWS Identity and Access Management (IAM) role you created that is managed by Security Lake, to ensure the replication setting is correct.
        """
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter
    def regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Replication enables automatic, asynchronous copying of objects across Amazon S3 buckets. Amazon S3 buckets that are configured for object replication can be owned by the same AWS account or by different accounts. You can replicate objects to a single destination bucket or to multiple destination buckets. The destination buckets can be in different AWS Regions or within the same Region as the source bucket.
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "regions", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Replication settings for the Amazon S3 buckets. This parameter uses the AWS Identity and Access Management (IAM) role you created that is managed by Security Lake, to ensure the replication setting is correct.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)


@pulumi.input_type
class DataLakeTimeoutsArgs:
    def __init__(__self__, *,
                 create: Optional[pulumi.Input[str]] = None,
                 delete: Optional[pulumi.Input[str]] = None,
                 update: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param pulumi.Input[str] delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param pulumi.Input[str] update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[pulumi.Input[str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @create.setter
    def create(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create", value)

    @property
    @pulumi.getter
    def delete(self) -> Optional[pulumi.Input[str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @delete.setter
    def delete(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delete", value)

    @property
    @pulumi.getter
    def update(self) -> Optional[pulumi.Input[str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")

    @update.setter
    def update(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update", value)


@pulumi.input_type
class SubscriberNotificationConfigurationArgs:
    def __init__(__self__, *,
                 https_notification_configuration: Optional[pulumi.Input['SubscriberNotificationConfigurationHttpsNotificationConfigurationArgs']] = None,
                 sqs_notification_configuration: Optional[pulumi.Input['SubscriberNotificationConfigurationSqsNotificationConfigurationArgs']] = None):
        """
        :param pulumi.Input['SubscriberNotificationConfigurationHttpsNotificationConfigurationArgs'] https_notification_configuration: The configurations for HTTPS subscriber notification.
        :param pulumi.Input['SubscriberNotificationConfigurationSqsNotificationConfigurationArgs'] sqs_notification_configuration: The configurations for SQS subscriber notification.
        """
        if https_notification_configuration is not None:
            pulumi.set(__self__, "https_notification_configuration", https_notification_configuration)
        if sqs_notification_configuration is not None:
            pulumi.set(__self__, "sqs_notification_configuration", sqs_notification_configuration)

    @property
    @pulumi.getter(name="httpsNotificationConfiguration")
    def https_notification_configuration(self) -> Optional[pulumi.Input['SubscriberNotificationConfigurationHttpsNotificationConfigurationArgs']]:
        """
        The configurations for HTTPS subscriber notification.
        """
        return pulumi.get(self, "https_notification_configuration")

    @https_notification_configuration.setter
    def https_notification_configuration(self, value: Optional[pulumi.Input['SubscriberNotificationConfigurationHttpsNotificationConfigurationArgs']]):
        pulumi.set(self, "https_notification_configuration", value)

    @property
    @pulumi.getter(name="sqsNotificationConfiguration")
    def sqs_notification_configuration(self) -> Optional[pulumi.Input['SubscriberNotificationConfigurationSqsNotificationConfigurationArgs']]:
        """
        The configurations for SQS subscriber notification.
        """
        return pulumi.get(self, "sqs_notification_configuration")

    @sqs_notification_configuration.setter
    def sqs_notification_configuration(self, value: Optional[pulumi.Input['SubscriberNotificationConfigurationSqsNotificationConfigurationArgs']]):
        pulumi.set(self, "sqs_notification_configuration", value)


@pulumi.input_type
class SubscriberNotificationConfigurationHttpsNotificationConfigurationArgs:
    def __init__(__self__, *,
                 authorization_api_key_name: Optional[pulumi.Input[str]] = None,
                 authorization_api_key_value: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 http_method: Optional[pulumi.Input[str]] = None,
                 target_role_arn: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] authorization_api_key_name: The key name for the notification subscription.
        :param pulumi.Input[str] authorization_api_key_value: The key value for the notification subscription.
        :param pulumi.Input[str] endpoint: The subscription endpoint in Security Lake. If you prefer notification with an HTTPs endpoint, populate this field.
        :param pulumi.Input[str] http_method: The HTTPS method used for the notification subscription.
        :param pulumi.Input[str] target_role_arn: The Amazon Resource Name (ARN) of the EventBridge API destinations IAM role that you created. For more information about ARNs and how to use them in policies, see Managing data access and AWS Managed Policies in the Amazon Security Lake User Guide.
        """
        if authorization_api_key_name is not None:
            pulumi.set(__self__, "authorization_api_key_name", authorization_api_key_name)
        if authorization_api_key_value is not None:
            pulumi.set(__self__, "authorization_api_key_value", authorization_api_key_value)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if http_method is not None:
            pulumi.set(__self__, "http_method", http_method)
        if target_role_arn is not None:
            pulumi.set(__self__, "target_role_arn", target_role_arn)

    @property
    @pulumi.getter(name="authorizationApiKeyName")
    def authorization_api_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The key name for the notification subscription.
        """
        return pulumi.get(self, "authorization_api_key_name")

    @authorization_api_key_name.setter
    def authorization_api_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization_api_key_name", value)

    @property
    @pulumi.getter(name="authorizationApiKeyValue")
    def authorization_api_key_value(self) -> Optional[pulumi.Input[str]]:
        """
        The key value for the notification subscription.
        """
        return pulumi.get(self, "authorization_api_key_value")

    @authorization_api_key_value.setter
    def authorization_api_key_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization_api_key_value", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The subscription endpoint in Security Lake. If you prefer notification with an HTTPs endpoint, populate this field.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTPS method used for the notification subscription.
        """
        return pulumi.get(self, "http_method")

    @http_method.setter
    def http_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_method", value)

    @property
    @pulumi.getter(name="targetRoleArn")
    def target_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the EventBridge API destinations IAM role that you created. For more information about ARNs and how to use them in policies, see Managing data access and AWS Managed Policies in the Amazon Security Lake User Guide.
        """
        return pulumi.get(self, "target_role_arn")

    @target_role_arn.setter
    def target_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_role_arn", value)


@pulumi.input_type
class SubscriberNotificationConfigurationSqsNotificationConfigurationArgs:
    def __init__(__self__):
        pass


@pulumi.input_type
class SubscriberSourceArgs:
    def __init__(__self__, *,
                 aws_log_source_resource: Optional[pulumi.Input['SubscriberSourceAwsLogSourceResourceArgs']] = None,
                 custom_log_source_resource: Optional[pulumi.Input['SubscriberSourceCustomLogSourceResourceArgs']] = None):
        """
        :param pulumi.Input['SubscriberSourceAwsLogSourceResourceArgs'] aws_log_source_resource: Amazon Security Lake supports log and event collection for natively supported AWS services.
        :param pulumi.Input['SubscriberSourceCustomLogSourceResourceArgs'] custom_log_source_resource: Amazon Security Lake supports custom source types.
        """
        if aws_log_source_resource is not None:
            pulumi.set(__self__, "aws_log_source_resource", aws_log_source_resource)
        if custom_log_source_resource is not None:
            pulumi.set(__self__, "custom_log_source_resource", custom_log_source_resource)

    @property
    @pulumi.getter(name="awsLogSourceResource")
    def aws_log_source_resource(self) -> Optional[pulumi.Input['SubscriberSourceAwsLogSourceResourceArgs']]:
        """
        Amazon Security Lake supports log and event collection for natively supported AWS services.
        """
        return pulumi.get(self, "aws_log_source_resource")

    @aws_log_source_resource.setter
    def aws_log_source_resource(self, value: Optional[pulumi.Input['SubscriberSourceAwsLogSourceResourceArgs']]):
        pulumi.set(self, "aws_log_source_resource", value)

    @property
    @pulumi.getter(name="customLogSourceResource")
    def custom_log_source_resource(self) -> Optional[pulumi.Input['SubscriberSourceCustomLogSourceResourceArgs']]:
        """
        Amazon Security Lake supports custom source types.
        """
        return pulumi.get(self, "custom_log_source_resource")

    @custom_log_source_resource.setter
    def custom_log_source_resource(self, value: Optional[pulumi.Input['SubscriberSourceCustomLogSourceResourceArgs']]):
        pulumi.set(self, "custom_log_source_resource", value)


@pulumi.input_type
class SubscriberSourceAwsLogSourceResourceArgs:
    def __init__(__self__, *,
                 source_name: Optional[pulumi.Input[str]] = None,
                 source_version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] source_name: The name for a third-party custom source. This must be a Regionally unique value.
        :param pulumi.Input[str] source_version: The version for a third-party custom source. This must be a Regionally unique value.
        """
        if source_name is not None:
            pulumi.set(__self__, "source_name", source_name)
        if source_version is not None:
            pulumi.set(__self__, "source_version", source_version)

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name for a third-party custom source. This must be a Regionally unique value.
        """
        return pulumi.get(self, "source_name")

    @source_name.setter
    def source_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_name", value)

    @property
    @pulumi.getter(name="sourceVersion")
    def source_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version for a third-party custom source. This must be a Regionally unique value.
        """
        return pulumi.get(self, "source_version")

    @source_version.setter
    def source_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_version", value)


@pulumi.input_type
class SubscriberSourceCustomLogSourceResourceArgs:
    def __init__(__self__, *,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriberSourceCustomLogSourceResourceAttributeArgs']]]] = None,
                 providers: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriberSourceCustomLogSourceResourceProviderArgs']]]] = None,
                 source_name: Optional[pulumi.Input[str]] = None,
                 source_version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['SubscriberSourceCustomLogSourceResourceAttributeArgs']]] attributes: The attributes of a third-party custom source.
        :param pulumi.Input[str] source_name: The name for a third-party custom source. This must be a Regionally unique value.
        :param pulumi.Input[str] source_version: The version for a third-party custom source. This must be a Regionally unique value.
        """
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if providers is not None:
            pulumi.set(__self__, "providers", providers)
        if source_name is not None:
            pulumi.set(__self__, "source_name", source_name)
        if source_version is not None:
            pulumi.set(__self__, "source_version", source_version)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubscriberSourceCustomLogSourceResourceAttributeArgs']]]]:
        """
        The attributes of a third-party custom source.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriberSourceCustomLogSourceResourceAttributeArgs']]]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def providers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubscriberSourceCustomLogSourceResourceProviderArgs']]]]:
        return pulumi.get(self, "providers")

    @providers.setter
    def providers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriberSourceCustomLogSourceResourceProviderArgs']]]]):
        pulumi.set(self, "providers", value)

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name for a third-party custom source. This must be a Regionally unique value.
        """
        return pulumi.get(self, "source_name")

    @source_name.setter
    def source_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_name", value)

    @property
    @pulumi.getter(name="sourceVersion")
    def source_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version for a third-party custom source. This must be a Regionally unique value.
        """
        return pulumi.get(self, "source_version")

    @source_version.setter
    def source_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_version", value)


@pulumi.input_type
class SubscriberSourceCustomLogSourceResourceAttributeArgs:
    def __init__(__self__, *,
                 crawler_arn: pulumi.Input[str],
                 database_arn: pulumi.Input[str],
                 table_arn: pulumi.Input[str]):
        """
        :param pulumi.Input[str] crawler_arn: The ARN of the AWS Glue crawler.
        :param pulumi.Input[str] database_arn: The ARN of the AWS Glue database where results are written.
        :param pulumi.Input[str] table_arn: The ARN of the AWS Glue table.
        """
        pulumi.set(__self__, "crawler_arn", crawler_arn)
        pulumi.set(__self__, "database_arn", database_arn)
        pulumi.set(__self__, "table_arn", table_arn)

    @property
    @pulumi.getter(name="crawlerArn")
    def crawler_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the AWS Glue crawler.
        """
        return pulumi.get(self, "crawler_arn")

    @crawler_arn.setter
    def crawler_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "crawler_arn", value)

    @property
    @pulumi.getter(name="databaseArn")
    def database_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the AWS Glue database where results are written.
        """
        return pulumi.get(self, "database_arn")

    @database_arn.setter
    def database_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_arn", value)

    @property
    @pulumi.getter(name="tableArn")
    def table_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the AWS Glue table.
        """
        return pulumi.get(self, "table_arn")

    @table_arn.setter
    def table_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_arn", value)


@pulumi.input_type
class SubscriberSourceCustomLogSourceResourceProviderArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 role_arn: pulumi.Input[str]):
        """
        :param pulumi.Input[str] location: The location of the partition in the Amazon S3 bucket for Security Lake.
        :param pulumi.Input[str] role_arn: The ARN of the IAM role to be used by the entity putting logs into your custom source partition.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The location of the partition in the Amazon S3 bucket for Security Lake.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the IAM role to be used by the entity putting logs into your custom source partition.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)


@pulumi.input_type
class SubscriberSubscriberIdentityArgs:
    def __init__(__self__, *,
                 external_id: pulumi.Input[str],
                 principal: pulumi.Input[str]):
        """
        :param pulumi.Input[str] external_id: The AWS Regions where Security Lake is automatically enabled.
        :param pulumi.Input[str] principal: Provides encryption details of Amazon Security Lake object.
        """
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "principal", principal)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Input[str]:
        """
        The AWS Regions where Security Lake is automatically enabled.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter
    def principal(self) -> pulumi.Input[str]:
        """
        Provides encryption details of Amazon Security Lake object.
        """
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: pulumi.Input[str]):
        pulumi.set(self, "principal", value)


@pulumi.input_type
class SubscriberTimeoutsArgs:
    def __init__(__self__, *,
                 create: Optional[pulumi.Input[str]] = None,
                 delete: Optional[pulumi.Input[str]] = None,
                 update: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param pulumi.Input[str] delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param pulumi.Input[str] update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[pulumi.Input[str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @create.setter
    def create(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create", value)

    @property
    @pulumi.getter
    def delete(self) -> Optional[pulumi.Input[str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @delete.setter
    def delete(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delete", value)

    @property
    @pulumi.getter
    def update(self) -> Optional[pulumi.Input[str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")

    @update.setter
    def update(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update", value)


