# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceQuotaArgs', 'ServiceQuota']

@pulumi.input_type
class ServiceQuotaArgs:
    def __init__(__self__, *,
                 quota_code: pulumi.Input[str],
                 service_code: pulumi.Input[str],
                 value: pulumi.Input[float]):
        """
        The set of arguments for constructing a ServiceQuota resource.
        :param pulumi.Input[str] quota_code: Code of the service quota to track. For example: `L-F678F1CE`. Available values can be found with the [AWS CLI service-quotas list-service-quotas command](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html).
        :param pulumi.Input[str] service_code: Code of the service to track. For example: `vpc`. Available values can be found with the [AWS CLI service-quotas list-services command](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-services.html).
        :param pulumi.Input[float] value: Float specifying the desired value for the service quota. If the desired value is higher than the current value, a quota increase request is submitted. When a known request is submitted and pending, the value reflects the desired value of the pending request.
        """
        pulumi.set(__self__, "quota_code", quota_code)
        pulumi.set(__self__, "service_code", service_code)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="quotaCode")
    def quota_code(self) -> pulumi.Input[str]:
        """
        Code of the service quota to track. For example: `L-F678F1CE`. Available values can be found with the [AWS CLI service-quotas list-service-quotas command](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html).
        """
        return pulumi.get(self, "quota_code")

    @quota_code.setter
    def quota_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "quota_code", value)

    @property
    @pulumi.getter(name="serviceCode")
    def service_code(self) -> pulumi.Input[str]:
        """
        Code of the service to track. For example: `vpc`. Available values can be found with the [AWS CLI service-quotas list-services command](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-services.html).
        """
        return pulumi.get(self, "service_code")

    @service_code.setter
    def service_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_code", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[float]:
        """
        Float specifying the desired value for the service quota. If the desired value is higher than the current value, a quota increase request is submitted. When a known request is submitted and pending, the value reflects the desired value of the pending request.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[float]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class _ServiceQuotaState:
    def __init__(__self__, *,
                 adjustable: Optional[pulumi.Input[bool]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 default_value: Optional[pulumi.Input[float]] = None,
                 quota_code: Optional[pulumi.Input[str]] = None,
                 quota_name: Optional[pulumi.Input[str]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 request_status: Optional[pulumi.Input[str]] = None,
                 service_code: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 usage_metrics: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceQuotaUsageMetricArgs']]]] = None,
                 value: Optional[pulumi.Input[float]] = None):
        """
        Input properties used for looking up and filtering ServiceQuota resources.
        :param pulumi.Input[bool] adjustable: Whether the service quota can be increased.
        :param pulumi.Input[str] arn: Amazon Resource Name (ARN) of the service quota.
        :param pulumi.Input[float] default_value: Default value of the service quota.
        :param pulumi.Input[str] quota_code: Code of the service quota to track. For example: `L-F678F1CE`. Available values can be found with the [AWS CLI service-quotas list-service-quotas command](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html).
        :param pulumi.Input[str] quota_name: Name of the quota.
        :param pulumi.Input[str] service_code: Code of the service to track. For example: `vpc`. Available values can be found with the [AWS CLI service-quotas list-services command](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-services.html).
        :param pulumi.Input[str] service_name: Name of the service.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceQuotaUsageMetricArgs']]] usage_metrics: Information about the measurement.
        :param pulumi.Input[float] value: Float specifying the desired value for the service quota. If the desired value is higher than the current value, a quota increase request is submitted. When a known request is submitted and pending, the value reflects the desired value of the pending request.
        """
        if adjustable is not None:
            pulumi.set(__self__, "adjustable", adjustable)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if quota_code is not None:
            pulumi.set(__self__, "quota_code", quota_code)
        if quota_name is not None:
            pulumi.set(__self__, "quota_name", quota_name)
        if request_id is not None:
            pulumi.set(__self__, "request_id", request_id)
        if request_status is not None:
            pulumi.set(__self__, "request_status", request_status)
        if service_code is not None:
            pulumi.set(__self__, "service_code", service_code)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if usage_metrics is not None:
            pulumi.set(__self__, "usage_metrics", usage_metrics)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def adjustable(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the service quota can be increased.
        """
        return pulumi.get(self, "adjustable")

    @adjustable.setter
    def adjustable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "adjustable", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of the service quota.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[pulumi.Input[float]]:
        """
        Default value of the service quota.
        """
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "default_value", value)

    @property
    @pulumi.getter(name="quotaCode")
    def quota_code(self) -> Optional[pulumi.Input[str]]:
        """
        Code of the service quota to track. For example: `L-F678F1CE`. Available values can be found with the [AWS CLI service-quotas list-service-quotas command](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html).
        """
        return pulumi.get(self, "quota_code")

    @quota_code.setter
    def quota_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "quota_code", value)

    @property
    @pulumi.getter(name="quotaName")
    def quota_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the quota.
        """
        return pulumi.get(self, "quota_name")

    @quota_name.setter
    def quota_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "quota_name", value)

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "request_id")

    @request_id.setter
    def request_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_id", value)

    @property
    @pulumi.getter(name="requestStatus")
    def request_status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "request_status")

    @request_status.setter
    def request_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_status", value)

    @property
    @pulumi.getter(name="serviceCode")
    def service_code(self) -> Optional[pulumi.Input[str]]:
        """
        Code of the service to track. For example: `vpc`. Available values can be found with the [AWS CLI service-quotas list-services command](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-services.html).
        """
        return pulumi.get(self, "service_code")

    @service_code.setter
    def service_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_code", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the service.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="usageMetrics")
    def usage_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceQuotaUsageMetricArgs']]]]:
        """
        Information about the measurement.
        """
        return pulumi.get(self, "usage_metrics")

    @usage_metrics.setter
    def usage_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceQuotaUsageMetricArgs']]]]):
        pulumi.set(self, "usage_metrics", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[float]]:
        """
        Float specifying the desired value for the service quota. If the desired value is higher than the current value, a quota increase request is submitted. When a known request is submitted and pending, the value reflects the desired value of the pending request.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "value", value)


class ServiceQuota(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 quota_code: Optional[pulumi.Input[str]] = None,
                 service_code: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[float]] = None,
                 __props__=None):
        """
        Manages an individual Service Quota.

        > **NOTE:** Global quotas apply to all AWS regions, but can only be accessed in `us-east-1` in the Commercial partition or `us-gov-west-1` in the GovCloud partition. In other regions, the AWS API will return the error `The request failed because the specified service does not exist.`

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.servicequotas.ServiceQuota("example",
            quota_code="L-F678F1CE",
            service_code="vpc",
            value=75)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import `aws_servicequotas_service_quota` using the service code and quota code, separated by a front slash (`/`). For example:

        ~> __NOTE:__ This resource does not require explicit import and will assume management of an existing service quota on Pulumi resource creation.

        ```sh
        $ pulumi import aws:servicequotas/serviceQuota:ServiceQuota example vpc/L-F678F1CE
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] quota_code: Code of the service quota to track. For example: `L-F678F1CE`. Available values can be found with the [AWS CLI service-quotas list-service-quotas command](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html).
        :param pulumi.Input[str] service_code: Code of the service to track. For example: `vpc`. Available values can be found with the [AWS CLI service-quotas list-services command](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-services.html).
        :param pulumi.Input[float] value: Float specifying the desired value for the service quota. If the desired value is higher than the current value, a quota increase request is submitted. When a known request is submitted and pending, the value reflects the desired value of the pending request.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceQuotaArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an individual Service Quota.

        > **NOTE:** Global quotas apply to all AWS regions, but can only be accessed in `us-east-1` in the Commercial partition or `us-gov-west-1` in the GovCloud partition. In other regions, the AWS API will return the error `The request failed because the specified service does not exist.`

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.servicequotas.ServiceQuota("example",
            quota_code="L-F678F1CE",
            service_code="vpc",
            value=75)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import `aws_servicequotas_service_quota` using the service code and quota code, separated by a front slash (`/`). For example:

        ~> __NOTE:__ This resource does not require explicit import and will assume management of an existing service quota on Pulumi resource creation.

        ```sh
        $ pulumi import aws:servicequotas/serviceQuota:ServiceQuota example vpc/L-F678F1CE
        ```

        :param str resource_name: The name of the resource.
        :param ServiceQuotaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceQuotaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 quota_code: Optional[pulumi.Input[str]] = None,
                 service_code: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[float]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceQuotaArgs.__new__(ServiceQuotaArgs)

            if quota_code is None and not opts.urn:
                raise TypeError("Missing required property 'quota_code'")
            __props__.__dict__["quota_code"] = quota_code
            if service_code is None and not opts.urn:
                raise TypeError("Missing required property 'service_code'")
            __props__.__dict__["service_code"] = service_code
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = value
            __props__.__dict__["adjustable"] = None
            __props__.__dict__["arn"] = None
            __props__.__dict__["default_value"] = None
            __props__.__dict__["quota_name"] = None
            __props__.__dict__["request_id"] = None
            __props__.__dict__["request_status"] = None
            __props__.__dict__["service_name"] = None
            __props__.__dict__["usage_metrics"] = None
        super(ServiceQuota, __self__).__init__(
            'aws:servicequotas/serviceQuota:ServiceQuota',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            adjustable: Optional[pulumi.Input[bool]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            default_value: Optional[pulumi.Input[float]] = None,
            quota_code: Optional[pulumi.Input[str]] = None,
            quota_name: Optional[pulumi.Input[str]] = None,
            request_id: Optional[pulumi.Input[str]] = None,
            request_status: Optional[pulumi.Input[str]] = None,
            service_code: Optional[pulumi.Input[str]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            usage_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceQuotaUsageMetricArgs']]]]] = None,
            value: Optional[pulumi.Input[float]] = None) -> 'ServiceQuota':
        """
        Get an existing ServiceQuota resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] adjustable: Whether the service quota can be increased.
        :param pulumi.Input[str] arn: Amazon Resource Name (ARN) of the service quota.
        :param pulumi.Input[float] default_value: Default value of the service quota.
        :param pulumi.Input[str] quota_code: Code of the service quota to track. For example: `L-F678F1CE`. Available values can be found with the [AWS CLI service-quotas list-service-quotas command](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html).
        :param pulumi.Input[str] quota_name: Name of the quota.
        :param pulumi.Input[str] service_code: Code of the service to track. For example: `vpc`. Available values can be found with the [AWS CLI service-quotas list-services command](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-services.html).
        :param pulumi.Input[str] service_name: Name of the service.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceQuotaUsageMetricArgs']]]] usage_metrics: Information about the measurement.
        :param pulumi.Input[float] value: Float specifying the desired value for the service quota. If the desired value is higher than the current value, a quota increase request is submitted. When a known request is submitted and pending, the value reflects the desired value of the pending request.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceQuotaState.__new__(_ServiceQuotaState)

        __props__.__dict__["adjustable"] = adjustable
        __props__.__dict__["arn"] = arn
        __props__.__dict__["default_value"] = default_value
        __props__.__dict__["quota_code"] = quota_code
        __props__.__dict__["quota_name"] = quota_name
        __props__.__dict__["request_id"] = request_id
        __props__.__dict__["request_status"] = request_status
        __props__.__dict__["service_code"] = service_code
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["usage_metrics"] = usage_metrics
        __props__.__dict__["value"] = value
        return ServiceQuota(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def adjustable(self) -> pulumi.Output[bool]:
        """
        Whether the service quota can be increased.
        """
        return pulumi.get(self, "adjustable")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        Amazon Resource Name (ARN) of the service quota.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> pulumi.Output[float]:
        """
        Default value of the service quota.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter(name="quotaCode")
    def quota_code(self) -> pulumi.Output[str]:
        """
        Code of the service quota to track. For example: `L-F678F1CE`. Available values can be found with the [AWS CLI service-quotas list-service-quotas command](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html).
        """
        return pulumi.get(self, "quota_code")

    @property
    @pulumi.getter(name="quotaName")
    def quota_name(self) -> pulumi.Output[str]:
        """
        Name of the quota.
        """
        return pulumi.get(self, "quota_name")

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "request_id")

    @property
    @pulumi.getter(name="requestStatus")
    def request_status(self) -> pulumi.Output[str]:
        return pulumi.get(self, "request_status")

    @property
    @pulumi.getter(name="serviceCode")
    def service_code(self) -> pulumi.Output[str]:
        """
        Code of the service to track. For example: `vpc`. Available values can be found with the [AWS CLI service-quotas list-services command](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-services.html).
        """
        return pulumi.get(self, "service_code")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        Name of the service.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="usageMetrics")
    def usage_metrics(self) -> pulumi.Output[Sequence['outputs.ServiceQuotaUsageMetric']]:
        """
        Information about the measurement.
        """
        return pulumi.get(self, "usage_metrics")

    @property
    @pulumi.getter
    def value(self) -> pulumi.Output[float]:
        """
        Float specifying the desired value for the service quota. If the desired value is higher than the current value, a quota increase request is submitted. When a known request is submitted and pending, the value reflects the desired value of the pending request.
        """
        return pulumi.get(self, "value")

