# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MaintenanceWindowTaskArgs', 'MaintenanceWindowTask']

@pulumi.input_type
class MaintenanceWindowTaskArgs:
    def __init__(__self__, *,
                 task_arn: pulumi.Input[str],
                 task_type: pulumi.Input[str],
                 window_id: pulumi.Input[str],
                 cutoff_behavior: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 max_concurrency: Optional[pulumi.Input[str]] = None,
                 max_errors: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 service_role_arn: Optional[pulumi.Input[str]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input['MaintenanceWindowTaskTargetArgs']]]] = None,
                 task_invocation_parameters: Optional[pulumi.Input['MaintenanceWindowTaskTaskInvocationParametersArgs']] = None):
        """
        The set of arguments for constructing a MaintenanceWindowTask resource.
        :param pulumi.Input[str] task_arn: The ARN of the task to execute.
        :param pulumi.Input[str] task_type: The type of task being registered. Valid values: `AUTOMATION`, `LAMBDA`, `RUN_COMMAND` or `STEP_FUNCTIONS`.
        :param pulumi.Input[str] window_id: The Id of the maintenance window to register the task with.
        :param pulumi.Input[str] cutoff_behavior: Indicates whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached. Valid values are `CONTINUE_TASK` and `CANCEL_TASK`.
        :param pulumi.Input[str] description: The description of the maintenance window task.
        :param pulumi.Input[str] max_concurrency: The maximum number of targets this task can be run for in parallel.
        :param pulumi.Input[str] max_errors: The maximum number of errors allowed before this task stops being scheduled.
        :param pulumi.Input[str] name: The name of the maintenance window task.
        :param pulumi.Input[int] priority: The priority of the task in the Maintenance Window, the lower the number the higher the priority. Tasks in a Maintenance Window are scheduled in priority order with tasks that have the same priority scheduled in parallel.
        :param pulumi.Input[str] service_role_arn: The role that should be assumed when executing the task. If a role is not provided, Systems Manager uses your account's service-linked role. If no service-linked role for Systems Manager exists in your account, it is created for you.
        :param pulumi.Input[Sequence[pulumi.Input['MaintenanceWindowTaskTargetArgs']]] targets: The targets (either instances or window target ids). Instances are specified using Key=InstanceIds,Values=instanceid1,instanceid2. Window target ids are specified using Key=WindowTargetIds,Values=window target id1, window target id2.
        :param pulumi.Input['MaintenanceWindowTaskTaskInvocationParametersArgs'] task_invocation_parameters: Configuration block with parameters for task execution.
        """
        pulumi.set(__self__, "task_arn", task_arn)
        pulumi.set(__self__, "task_type", task_type)
        pulumi.set(__self__, "window_id", window_id)
        if cutoff_behavior is not None:
            pulumi.set(__self__, "cutoff_behavior", cutoff_behavior)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if max_concurrency is not None:
            pulumi.set(__self__, "max_concurrency", max_concurrency)
        if max_errors is not None:
            pulumi.set(__self__, "max_errors", max_errors)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if service_role_arn is not None:
            pulumi.set(__self__, "service_role_arn", service_role_arn)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)
        if task_invocation_parameters is not None:
            pulumi.set(__self__, "task_invocation_parameters", task_invocation_parameters)

    @property
    @pulumi.getter(name="taskArn")
    def task_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the task to execute.
        """
        return pulumi.get(self, "task_arn")

    @task_arn.setter
    def task_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_arn", value)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        The type of task being registered. Valid values: `AUTOMATION`, `LAMBDA`, `RUN_COMMAND` or `STEP_FUNCTIONS`.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="windowId")
    def window_id(self) -> pulumi.Input[str]:
        """
        The Id of the maintenance window to register the task with.
        """
        return pulumi.get(self, "window_id")

    @window_id.setter
    def window_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "window_id", value)

    @property
    @pulumi.getter(name="cutoffBehavior")
    def cutoff_behavior(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached. Valid values are `CONTINUE_TASK` and `CANCEL_TASK`.
        """
        return pulumi.get(self, "cutoff_behavior")

    @cutoff_behavior.setter
    def cutoff_behavior(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cutoff_behavior", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the maintenance window task.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum number of targets this task can be run for in parallel.
        """
        return pulumi.get(self, "max_concurrency")

    @max_concurrency.setter
    def max_concurrency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_concurrency", value)

    @property
    @pulumi.getter(name="maxErrors")
    def max_errors(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum number of errors allowed before this task stops being scheduled.
        """
        return pulumi.get(self, "max_errors")

    @max_errors.setter
    def max_errors(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_errors", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the maintenance window task.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        The priority of the task in the Maintenance Window, the lower the number the higher the priority. Tasks in a Maintenance Window are scheduled in priority order with tasks that have the same priority scheduled in parallel.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="serviceRoleArn")
    def service_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The role that should be assumed when executing the task. If a role is not provided, Systems Manager uses your account's service-linked role. If no service-linked role for Systems Manager exists in your account, it is created for you.
        """
        return pulumi.get(self, "service_role_arn")

    @service_role_arn.setter
    def service_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_role_arn", value)

    @property
    @pulumi.getter
    def targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MaintenanceWindowTaskTargetArgs']]]]:
        """
        The targets (either instances or window target ids). Instances are specified using Key=InstanceIds,Values=instanceid1,instanceid2. Window target ids are specified using Key=WindowTargetIds,Values=window target id1, window target id2.
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MaintenanceWindowTaskTargetArgs']]]]):
        pulumi.set(self, "targets", value)

    @property
    @pulumi.getter(name="taskInvocationParameters")
    def task_invocation_parameters(self) -> Optional[pulumi.Input['MaintenanceWindowTaskTaskInvocationParametersArgs']]:
        """
        Configuration block with parameters for task execution.
        """
        return pulumi.get(self, "task_invocation_parameters")

    @task_invocation_parameters.setter
    def task_invocation_parameters(self, value: Optional[pulumi.Input['MaintenanceWindowTaskTaskInvocationParametersArgs']]):
        pulumi.set(self, "task_invocation_parameters", value)


@pulumi.input_type
class _MaintenanceWindowTaskState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 cutoff_behavior: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 max_concurrency: Optional[pulumi.Input[str]] = None,
                 max_errors: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 service_role_arn: Optional[pulumi.Input[str]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input['MaintenanceWindowTaskTargetArgs']]]] = None,
                 task_arn: Optional[pulumi.Input[str]] = None,
                 task_invocation_parameters: Optional[pulumi.Input['MaintenanceWindowTaskTaskInvocationParametersArgs']] = None,
                 task_type: Optional[pulumi.Input[str]] = None,
                 window_id: Optional[pulumi.Input[str]] = None,
                 window_task_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MaintenanceWindowTask resources.
        :param pulumi.Input[str] arn: The ARN of the maintenance window task.
        :param pulumi.Input[str] cutoff_behavior: Indicates whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached. Valid values are `CONTINUE_TASK` and `CANCEL_TASK`.
        :param pulumi.Input[str] description: The description of the maintenance window task.
        :param pulumi.Input[str] max_concurrency: The maximum number of targets this task can be run for in parallel.
        :param pulumi.Input[str] max_errors: The maximum number of errors allowed before this task stops being scheduled.
        :param pulumi.Input[str] name: The name of the maintenance window task.
        :param pulumi.Input[int] priority: The priority of the task in the Maintenance Window, the lower the number the higher the priority. Tasks in a Maintenance Window are scheduled in priority order with tasks that have the same priority scheduled in parallel.
        :param pulumi.Input[str] service_role_arn: The role that should be assumed when executing the task. If a role is not provided, Systems Manager uses your account's service-linked role. If no service-linked role for Systems Manager exists in your account, it is created for you.
        :param pulumi.Input[Sequence[pulumi.Input['MaintenanceWindowTaskTargetArgs']]] targets: The targets (either instances or window target ids). Instances are specified using Key=InstanceIds,Values=instanceid1,instanceid2. Window target ids are specified using Key=WindowTargetIds,Values=window target id1, window target id2.
        :param pulumi.Input[str] task_arn: The ARN of the task to execute.
        :param pulumi.Input['MaintenanceWindowTaskTaskInvocationParametersArgs'] task_invocation_parameters: Configuration block with parameters for task execution.
        :param pulumi.Input[str] task_type: The type of task being registered. Valid values: `AUTOMATION`, `LAMBDA`, `RUN_COMMAND` or `STEP_FUNCTIONS`.
        :param pulumi.Input[str] window_id: The Id of the maintenance window to register the task with.
        :param pulumi.Input[str] window_task_id: The ID of the maintenance window task.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if cutoff_behavior is not None:
            pulumi.set(__self__, "cutoff_behavior", cutoff_behavior)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if max_concurrency is not None:
            pulumi.set(__self__, "max_concurrency", max_concurrency)
        if max_errors is not None:
            pulumi.set(__self__, "max_errors", max_errors)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if service_role_arn is not None:
            pulumi.set(__self__, "service_role_arn", service_role_arn)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)
        if task_arn is not None:
            pulumi.set(__self__, "task_arn", task_arn)
        if task_invocation_parameters is not None:
            pulumi.set(__self__, "task_invocation_parameters", task_invocation_parameters)
        if task_type is not None:
            pulumi.set(__self__, "task_type", task_type)
        if window_id is not None:
            pulumi.set(__self__, "window_id", window_id)
        if window_task_id is not None:
            pulumi.set(__self__, "window_task_id", window_task_id)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the maintenance window task.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="cutoffBehavior")
    def cutoff_behavior(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached. Valid values are `CONTINUE_TASK` and `CANCEL_TASK`.
        """
        return pulumi.get(self, "cutoff_behavior")

    @cutoff_behavior.setter
    def cutoff_behavior(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cutoff_behavior", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the maintenance window task.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum number of targets this task can be run for in parallel.
        """
        return pulumi.get(self, "max_concurrency")

    @max_concurrency.setter
    def max_concurrency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_concurrency", value)

    @property
    @pulumi.getter(name="maxErrors")
    def max_errors(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum number of errors allowed before this task stops being scheduled.
        """
        return pulumi.get(self, "max_errors")

    @max_errors.setter
    def max_errors(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_errors", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the maintenance window task.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        The priority of the task in the Maintenance Window, the lower the number the higher the priority. Tasks in a Maintenance Window are scheduled in priority order with tasks that have the same priority scheduled in parallel.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="serviceRoleArn")
    def service_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The role that should be assumed when executing the task. If a role is not provided, Systems Manager uses your account's service-linked role. If no service-linked role for Systems Manager exists in your account, it is created for you.
        """
        return pulumi.get(self, "service_role_arn")

    @service_role_arn.setter
    def service_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_role_arn", value)

    @property
    @pulumi.getter
    def targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MaintenanceWindowTaskTargetArgs']]]]:
        """
        The targets (either instances or window target ids). Instances are specified using Key=InstanceIds,Values=instanceid1,instanceid2. Window target ids are specified using Key=WindowTargetIds,Values=window target id1, window target id2.
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MaintenanceWindowTaskTargetArgs']]]]):
        pulumi.set(self, "targets", value)

    @property
    @pulumi.getter(name="taskArn")
    def task_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the task to execute.
        """
        return pulumi.get(self, "task_arn")

    @task_arn.setter
    def task_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "task_arn", value)

    @property
    @pulumi.getter(name="taskInvocationParameters")
    def task_invocation_parameters(self) -> Optional[pulumi.Input['MaintenanceWindowTaskTaskInvocationParametersArgs']]:
        """
        Configuration block with parameters for task execution.
        """
        return pulumi.get(self, "task_invocation_parameters")

    @task_invocation_parameters.setter
    def task_invocation_parameters(self, value: Optional[pulumi.Input['MaintenanceWindowTaskTaskInvocationParametersArgs']]):
        pulumi.set(self, "task_invocation_parameters", value)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of task being registered. Valid values: `AUTOMATION`, `LAMBDA`, `RUN_COMMAND` or `STEP_FUNCTIONS`.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="windowId")
    def window_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of the maintenance window to register the task with.
        """
        return pulumi.get(self, "window_id")

    @window_id.setter
    def window_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "window_id", value)

    @property
    @pulumi.getter(name="windowTaskId")
    def window_task_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the maintenance window task.
        """
        return pulumi.get(self, "window_task_id")

    @window_task_id.setter
    def window_task_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "window_task_id", value)


class MaintenanceWindowTask(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cutoff_behavior: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 max_concurrency: Optional[pulumi.Input[str]] = None,
                 max_errors: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 service_role_arn: Optional[pulumi.Input[str]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MaintenanceWindowTaskTargetArgs']]]]] = None,
                 task_arn: Optional[pulumi.Input[str]] = None,
                 task_invocation_parameters: Optional[pulumi.Input[pulumi.InputType['MaintenanceWindowTaskTaskInvocationParametersArgs']]] = None,
                 task_type: Optional[pulumi.Input[str]] = None,
                 window_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides an SSM Maintenance Window Task resource

        ## Example Usage

        ### Automation Tasks

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssm.MaintenanceWindowTask("example",
            max_concurrency="2",
            max_errors="1",
            priority=1,
            task_arn="AWS-RestartEC2Instance",
            task_type="AUTOMATION",
            window_id=example_aws_ssm_maintenance_window["id"],
            targets=[aws.ssm.MaintenanceWindowTaskTargetArgs(
                key="InstanceIds",
                values=[example_aws_instance["id"]],
            )],
            task_invocation_parameters=aws.ssm.MaintenanceWindowTaskTaskInvocationParametersArgs(
                automation_parameters=aws.ssm.MaintenanceWindowTaskTaskInvocationParametersAutomationParametersArgs(
                    document_version="$LATEST",
                    parameters=[aws.ssm.MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameterArgs(
                        name="InstanceId",
                        values=[example_aws_instance["id"]],
                    )],
                ),
            ))
        ```
        <!--End PulumiCodeChooser -->

        ### Lambda Tasks

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        example = aws.ssm.MaintenanceWindowTask("example",
            max_concurrency="2",
            max_errors="1",
            priority=1,
            task_arn=example_aws_lambda_function["arn"],
            task_type="LAMBDA",
            window_id=example_aws_ssm_maintenance_window["id"],
            targets=[aws.ssm.MaintenanceWindowTaskTargetArgs(
                key="InstanceIds",
                values=[example_aws_instance["id"]],
            )],
            task_invocation_parameters=aws.ssm.MaintenanceWindowTaskTaskInvocationParametersArgs(
                lambda_parameters=aws.ssm.MaintenanceWindowTaskTaskInvocationParametersLambdaParametersArgs(
                    client_context=std.base64encode(input="{\\"key1\\":\\"value1\\"}").result,
                    payload="{\\"key1\\":\\"value1\\"}",
                ),
            ))
        ```
        <!--End PulumiCodeChooser -->

        ### Run Command Tasks

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssm.MaintenanceWindowTask("example",
            max_concurrency="2",
            max_errors="1",
            priority=1,
            task_arn="AWS-RunShellScript",
            task_type="RUN_COMMAND",
            window_id=example_aws_ssm_maintenance_window["id"],
            targets=[aws.ssm.MaintenanceWindowTaskTargetArgs(
                key="InstanceIds",
                values=[example_aws_instance["id"]],
            )],
            task_invocation_parameters=aws.ssm.MaintenanceWindowTaskTaskInvocationParametersArgs(
                run_command_parameters=aws.ssm.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersArgs(
                    output_s3_bucket=example_aws_s3_bucket["id"],
                    output_s3_key_prefix="output",
                    service_role_arn=example_aws_iam_role["arn"],
                    timeout_seconds=600,
                    notification_config=aws.ssm.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfigArgs(
                        notification_arn=example_aws_sns_topic["arn"],
                        notification_events=["All"],
                        notification_type="Command",
                    ),
                    parameters=[aws.ssm.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgs(
                        name="commands",
                        values=["date"],
                    )],
                ),
            ))
        ```
        <!--End PulumiCodeChooser -->

        ### Step Function Tasks

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssm.MaintenanceWindowTask("example",
            max_concurrency="2",
            max_errors="1",
            priority=1,
            task_arn=example_aws_sfn_activity["id"],
            task_type="STEP_FUNCTIONS",
            window_id=example_aws_ssm_maintenance_window["id"],
            targets=[aws.ssm.MaintenanceWindowTaskTargetArgs(
                key="InstanceIds",
                values=[example_aws_instance["id"]],
            )],
            task_invocation_parameters=aws.ssm.MaintenanceWindowTaskTaskInvocationParametersArgs(
                step_functions_parameters=aws.ssm.MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParametersArgs(
                    input="{\\"key1\\":\\"value1\\"}",
                    name="example",
                ),
            ))
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import AWS Maintenance Window Task using the `window_id` and `window_task_id` separated by `/`. For example:

        ```sh
        $ pulumi import aws:ssm/maintenanceWindowTask:MaintenanceWindowTask task <window_id>/<window_task_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cutoff_behavior: Indicates whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached. Valid values are `CONTINUE_TASK` and `CANCEL_TASK`.
        :param pulumi.Input[str] description: The description of the maintenance window task.
        :param pulumi.Input[str] max_concurrency: The maximum number of targets this task can be run for in parallel.
        :param pulumi.Input[str] max_errors: The maximum number of errors allowed before this task stops being scheduled.
        :param pulumi.Input[str] name: The name of the maintenance window task.
        :param pulumi.Input[int] priority: The priority of the task in the Maintenance Window, the lower the number the higher the priority. Tasks in a Maintenance Window are scheduled in priority order with tasks that have the same priority scheduled in parallel.
        :param pulumi.Input[str] service_role_arn: The role that should be assumed when executing the task. If a role is not provided, Systems Manager uses your account's service-linked role. If no service-linked role for Systems Manager exists in your account, it is created for you.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MaintenanceWindowTaskTargetArgs']]]] targets: The targets (either instances or window target ids). Instances are specified using Key=InstanceIds,Values=instanceid1,instanceid2. Window target ids are specified using Key=WindowTargetIds,Values=window target id1, window target id2.
        :param pulumi.Input[str] task_arn: The ARN of the task to execute.
        :param pulumi.Input[pulumi.InputType['MaintenanceWindowTaskTaskInvocationParametersArgs']] task_invocation_parameters: Configuration block with parameters for task execution.
        :param pulumi.Input[str] task_type: The type of task being registered. Valid values: `AUTOMATION`, `LAMBDA`, `RUN_COMMAND` or `STEP_FUNCTIONS`.
        :param pulumi.Input[str] window_id: The Id of the maintenance window to register the task with.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MaintenanceWindowTaskArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an SSM Maintenance Window Task resource

        ## Example Usage

        ### Automation Tasks

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssm.MaintenanceWindowTask("example",
            max_concurrency="2",
            max_errors="1",
            priority=1,
            task_arn="AWS-RestartEC2Instance",
            task_type="AUTOMATION",
            window_id=example_aws_ssm_maintenance_window["id"],
            targets=[aws.ssm.MaintenanceWindowTaskTargetArgs(
                key="InstanceIds",
                values=[example_aws_instance["id"]],
            )],
            task_invocation_parameters=aws.ssm.MaintenanceWindowTaskTaskInvocationParametersArgs(
                automation_parameters=aws.ssm.MaintenanceWindowTaskTaskInvocationParametersAutomationParametersArgs(
                    document_version="$LATEST",
                    parameters=[aws.ssm.MaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameterArgs(
                        name="InstanceId",
                        values=[example_aws_instance["id"]],
                    )],
                ),
            ))
        ```
        <!--End PulumiCodeChooser -->

        ### Lambda Tasks

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        example = aws.ssm.MaintenanceWindowTask("example",
            max_concurrency="2",
            max_errors="1",
            priority=1,
            task_arn=example_aws_lambda_function["arn"],
            task_type="LAMBDA",
            window_id=example_aws_ssm_maintenance_window["id"],
            targets=[aws.ssm.MaintenanceWindowTaskTargetArgs(
                key="InstanceIds",
                values=[example_aws_instance["id"]],
            )],
            task_invocation_parameters=aws.ssm.MaintenanceWindowTaskTaskInvocationParametersArgs(
                lambda_parameters=aws.ssm.MaintenanceWindowTaskTaskInvocationParametersLambdaParametersArgs(
                    client_context=std.base64encode(input="{\\"key1\\":\\"value1\\"}").result,
                    payload="{\\"key1\\":\\"value1\\"}",
                ),
            ))
        ```
        <!--End PulumiCodeChooser -->

        ### Run Command Tasks

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssm.MaintenanceWindowTask("example",
            max_concurrency="2",
            max_errors="1",
            priority=1,
            task_arn="AWS-RunShellScript",
            task_type="RUN_COMMAND",
            window_id=example_aws_ssm_maintenance_window["id"],
            targets=[aws.ssm.MaintenanceWindowTaskTargetArgs(
                key="InstanceIds",
                values=[example_aws_instance["id"]],
            )],
            task_invocation_parameters=aws.ssm.MaintenanceWindowTaskTaskInvocationParametersArgs(
                run_command_parameters=aws.ssm.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersArgs(
                    output_s3_bucket=example_aws_s3_bucket["id"],
                    output_s3_key_prefix="output",
                    service_role_arn=example_aws_iam_role["arn"],
                    timeout_seconds=600,
                    notification_config=aws.ssm.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfigArgs(
                        notification_arn=example_aws_sns_topic["arn"],
                        notification_events=["All"],
                        notification_type="Command",
                    ),
                    parameters=[aws.ssm.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameterArgs(
                        name="commands",
                        values=["date"],
                    )],
                ),
            ))
        ```
        <!--End PulumiCodeChooser -->

        ### Step Function Tasks

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssm.MaintenanceWindowTask("example",
            max_concurrency="2",
            max_errors="1",
            priority=1,
            task_arn=example_aws_sfn_activity["id"],
            task_type="STEP_FUNCTIONS",
            window_id=example_aws_ssm_maintenance_window["id"],
            targets=[aws.ssm.MaintenanceWindowTaskTargetArgs(
                key="InstanceIds",
                values=[example_aws_instance["id"]],
            )],
            task_invocation_parameters=aws.ssm.MaintenanceWindowTaskTaskInvocationParametersArgs(
                step_functions_parameters=aws.ssm.MaintenanceWindowTaskTaskInvocationParametersStepFunctionsParametersArgs(
                    input="{\\"key1\\":\\"value1\\"}",
                    name="example",
                ),
            ))
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import AWS Maintenance Window Task using the `window_id` and `window_task_id` separated by `/`. For example:

        ```sh
        $ pulumi import aws:ssm/maintenanceWindowTask:MaintenanceWindowTask task <window_id>/<window_task_id>
        ```

        :param str resource_name: The name of the resource.
        :param MaintenanceWindowTaskArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MaintenanceWindowTaskArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cutoff_behavior: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 max_concurrency: Optional[pulumi.Input[str]] = None,
                 max_errors: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 service_role_arn: Optional[pulumi.Input[str]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MaintenanceWindowTaskTargetArgs']]]]] = None,
                 task_arn: Optional[pulumi.Input[str]] = None,
                 task_invocation_parameters: Optional[pulumi.Input[pulumi.InputType['MaintenanceWindowTaskTaskInvocationParametersArgs']]] = None,
                 task_type: Optional[pulumi.Input[str]] = None,
                 window_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MaintenanceWindowTaskArgs.__new__(MaintenanceWindowTaskArgs)

            __props__.__dict__["cutoff_behavior"] = cutoff_behavior
            __props__.__dict__["description"] = description
            __props__.__dict__["max_concurrency"] = max_concurrency
            __props__.__dict__["max_errors"] = max_errors
            __props__.__dict__["name"] = name
            __props__.__dict__["priority"] = priority
            __props__.__dict__["service_role_arn"] = service_role_arn
            __props__.__dict__["targets"] = targets
            if task_arn is None and not opts.urn:
                raise TypeError("Missing required property 'task_arn'")
            __props__.__dict__["task_arn"] = task_arn
            __props__.__dict__["task_invocation_parameters"] = task_invocation_parameters
            if task_type is None and not opts.urn:
                raise TypeError("Missing required property 'task_type'")
            __props__.__dict__["task_type"] = task_type
            if window_id is None and not opts.urn:
                raise TypeError("Missing required property 'window_id'")
            __props__.__dict__["window_id"] = window_id
            __props__.__dict__["arn"] = None
            __props__.__dict__["window_task_id"] = None
        super(MaintenanceWindowTask, __self__).__init__(
            'aws:ssm/maintenanceWindowTask:MaintenanceWindowTask',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            cutoff_behavior: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            max_concurrency: Optional[pulumi.Input[str]] = None,
            max_errors: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            service_role_arn: Optional[pulumi.Input[str]] = None,
            targets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MaintenanceWindowTaskTargetArgs']]]]] = None,
            task_arn: Optional[pulumi.Input[str]] = None,
            task_invocation_parameters: Optional[pulumi.Input[pulumi.InputType['MaintenanceWindowTaskTaskInvocationParametersArgs']]] = None,
            task_type: Optional[pulumi.Input[str]] = None,
            window_id: Optional[pulumi.Input[str]] = None,
            window_task_id: Optional[pulumi.Input[str]] = None) -> 'MaintenanceWindowTask':
        """
        Get an existing MaintenanceWindowTask resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The ARN of the maintenance window task.
        :param pulumi.Input[str] cutoff_behavior: Indicates whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached. Valid values are `CONTINUE_TASK` and `CANCEL_TASK`.
        :param pulumi.Input[str] description: The description of the maintenance window task.
        :param pulumi.Input[str] max_concurrency: The maximum number of targets this task can be run for in parallel.
        :param pulumi.Input[str] max_errors: The maximum number of errors allowed before this task stops being scheduled.
        :param pulumi.Input[str] name: The name of the maintenance window task.
        :param pulumi.Input[int] priority: The priority of the task in the Maintenance Window, the lower the number the higher the priority. Tasks in a Maintenance Window are scheduled in priority order with tasks that have the same priority scheduled in parallel.
        :param pulumi.Input[str] service_role_arn: The role that should be assumed when executing the task. If a role is not provided, Systems Manager uses your account's service-linked role. If no service-linked role for Systems Manager exists in your account, it is created for you.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MaintenanceWindowTaskTargetArgs']]]] targets: The targets (either instances or window target ids). Instances are specified using Key=InstanceIds,Values=instanceid1,instanceid2. Window target ids are specified using Key=WindowTargetIds,Values=window target id1, window target id2.
        :param pulumi.Input[str] task_arn: The ARN of the task to execute.
        :param pulumi.Input[pulumi.InputType['MaintenanceWindowTaskTaskInvocationParametersArgs']] task_invocation_parameters: Configuration block with parameters for task execution.
        :param pulumi.Input[str] task_type: The type of task being registered. Valid values: `AUTOMATION`, `LAMBDA`, `RUN_COMMAND` or `STEP_FUNCTIONS`.
        :param pulumi.Input[str] window_id: The Id of the maintenance window to register the task with.
        :param pulumi.Input[str] window_task_id: The ID of the maintenance window task.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MaintenanceWindowTaskState.__new__(_MaintenanceWindowTaskState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["cutoff_behavior"] = cutoff_behavior
        __props__.__dict__["description"] = description
        __props__.__dict__["max_concurrency"] = max_concurrency
        __props__.__dict__["max_errors"] = max_errors
        __props__.__dict__["name"] = name
        __props__.__dict__["priority"] = priority
        __props__.__dict__["service_role_arn"] = service_role_arn
        __props__.__dict__["targets"] = targets
        __props__.__dict__["task_arn"] = task_arn
        __props__.__dict__["task_invocation_parameters"] = task_invocation_parameters
        __props__.__dict__["task_type"] = task_type
        __props__.__dict__["window_id"] = window_id
        __props__.__dict__["window_task_id"] = window_task_id
        return MaintenanceWindowTask(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the maintenance window task.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="cutoffBehavior")
    def cutoff_behavior(self) -> pulumi.Output[Optional[str]]:
        """
        Indicates whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached. Valid values are `CONTINUE_TASK` and `CANCEL_TASK`.
        """
        return pulumi.get(self, "cutoff_behavior")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the maintenance window task.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> pulumi.Output[str]:
        """
        The maximum number of targets this task can be run for in parallel.
        """
        return pulumi.get(self, "max_concurrency")

    @property
    @pulumi.getter(name="maxErrors")
    def max_errors(self) -> pulumi.Output[str]:
        """
        The maximum number of errors allowed before this task stops being scheduled.
        """
        return pulumi.get(self, "max_errors")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the maintenance window task.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[int]]:
        """
        The priority of the task in the Maintenance Window, the lower the number the higher the priority. Tasks in a Maintenance Window are scheduled in priority order with tasks that have the same priority scheduled in parallel.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="serviceRoleArn")
    def service_role_arn(self) -> pulumi.Output[str]:
        """
        The role that should be assumed when executing the task. If a role is not provided, Systems Manager uses your account's service-linked role. If no service-linked role for Systems Manager exists in your account, it is created for you.
        """
        return pulumi.get(self, "service_role_arn")

    @property
    @pulumi.getter
    def targets(self) -> pulumi.Output[Optional[Sequence['outputs.MaintenanceWindowTaskTarget']]]:
        """
        The targets (either instances or window target ids). Instances are specified using Key=InstanceIds,Values=instanceid1,instanceid2. Window target ids are specified using Key=WindowTargetIds,Values=window target id1, window target id2.
        """
        return pulumi.get(self, "targets")

    @property
    @pulumi.getter(name="taskArn")
    def task_arn(self) -> pulumi.Output[str]:
        """
        The ARN of the task to execute.
        """
        return pulumi.get(self, "task_arn")

    @property
    @pulumi.getter(name="taskInvocationParameters")
    def task_invocation_parameters(self) -> pulumi.Output[Optional['outputs.MaintenanceWindowTaskTaskInvocationParameters']]:
        """
        Configuration block with parameters for task execution.
        """
        return pulumi.get(self, "task_invocation_parameters")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Output[str]:
        """
        The type of task being registered. Valid values: `AUTOMATION`, `LAMBDA`, `RUN_COMMAND` or `STEP_FUNCTIONS`.
        """
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter(name="windowId")
    def window_id(self) -> pulumi.Output[str]:
        """
        The Id of the maintenance window to register the task with.
        """
        return pulumi.get(self, "window_id")

    @property
    @pulumi.getter(name="windowTaskId")
    def window_task_id(self) -> pulumi.Output[str]:
        """
        The ID of the maintenance window task.
        """
        return pulumi.get(self, "window_task_id")

