# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ContactChannelDeliveryAddress',
    'PlanStage',
    'PlanStageTarget',
    'PlanStageTargetChannelTargetInfo',
    'PlanStageTargetContactTargetInfo',
    'GetContactChannelDeliveryAddressResult',
    'GetPlanStageResult',
    'GetPlanStageTargetResult',
    'GetPlanStageTargetChannelTargetInfoResult',
    'GetPlanStageTargetContactTargetInfoResult',
]

@pulumi.output_type
class ContactChannelDeliveryAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "simpleAddress":
            suggest = "simple_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactChannelDeliveryAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactChannelDeliveryAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactChannelDeliveryAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 simple_address: str):
        """
        :param str simple_address: Details to engage this contact channel. The expected format depends on the contact channel type and is described in the [`ContactChannelAddress` section of the SSM Contacts API Reference](https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_ContactChannelAddress.html).
        """
        pulumi.set(__self__, "simple_address", simple_address)

    @property
    @pulumi.getter(name="simpleAddress")
    def simple_address(self) -> str:
        """
        Details to engage this contact channel. The expected format depends on the contact channel type and is described in the [`ContactChannelAddress` section of the SSM Contacts API Reference](https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_ContactChannelAddress.html).
        """
        return pulumi.get(self, "simple_address")


@pulumi.output_type
class PlanStage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "durationInMinutes":
            suggest = "duration_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PlanStage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PlanStage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PlanStage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration_in_minutes: int,
                 targets: Optional[Sequence['outputs.PlanStageTarget']] = None):
        """
        :param int duration_in_minutes: The time to wait until beginning the next stage. The duration can only be set to 0 if a target is specified.
        :param Sequence['PlanStageTargetArgs'] targets: One or more configuration blocks for specifying the contacts or contact methods that the escalation plan or engagement plan is engaging. See Target below for more details.
        """
        pulumi.set(__self__, "duration_in_minutes", duration_in_minutes)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)

    @property
    @pulumi.getter(name="durationInMinutes")
    def duration_in_minutes(self) -> int:
        """
        The time to wait until beginning the next stage. The duration can only be set to 0 if a target is specified.
        """
        return pulumi.get(self, "duration_in_minutes")

    @property
    @pulumi.getter
    def targets(self) -> Optional[Sequence['outputs.PlanStageTarget']]:
        """
        One or more configuration blocks for specifying the contacts or contact methods that the escalation plan or engagement plan is engaging. See Target below for more details.
        """
        return pulumi.get(self, "targets")


@pulumi.output_type
class PlanStageTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelTargetInfo":
            suggest = "channel_target_info"
        elif key == "contactTargetInfo":
            suggest = "contact_target_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PlanStageTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PlanStageTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PlanStageTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_target_info: Optional['outputs.PlanStageTargetChannelTargetInfo'] = None,
                 contact_target_info: Optional['outputs.PlanStageTargetContactTargetInfo'] = None):
        """
        :param 'PlanStageTargetChannelTargetInfoArgs' channel_target_info: A configuration block for specifying information about the contact channel that Incident Manager engages. See Channel Target Info for more details.
        :param 'PlanStageTargetContactTargetInfoArgs' contact_target_info: A configuration block for specifying information about the contact that Incident Manager engages. See Contact Target Info for more details.
        """
        if channel_target_info is not None:
            pulumi.set(__self__, "channel_target_info", channel_target_info)
        if contact_target_info is not None:
            pulumi.set(__self__, "contact_target_info", contact_target_info)

    @property
    @pulumi.getter(name="channelTargetInfo")
    def channel_target_info(self) -> Optional['outputs.PlanStageTargetChannelTargetInfo']:
        """
        A configuration block for specifying information about the contact channel that Incident Manager engages. See Channel Target Info for more details.
        """
        return pulumi.get(self, "channel_target_info")

    @property
    @pulumi.getter(name="contactTargetInfo")
    def contact_target_info(self) -> Optional['outputs.PlanStageTargetContactTargetInfo']:
        """
        A configuration block for specifying information about the contact that Incident Manager engages. See Contact Target Info for more details.
        """
        return pulumi.get(self, "contact_target_info")


@pulumi.output_type
class PlanStageTargetChannelTargetInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contactChannelId":
            suggest = "contact_channel_id"
        elif key == "retryIntervalInMinutes":
            suggest = "retry_interval_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PlanStageTargetChannelTargetInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PlanStageTargetChannelTargetInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PlanStageTargetChannelTargetInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contact_channel_id: str,
                 retry_interval_in_minutes: Optional[int] = None):
        """
        :param str contact_channel_id: The Amazon Resource Name (ARN) of the contact channel.
        :param int retry_interval_in_minutes: The number of minutes to wait before retrying to send engagement if the engagement initially failed.
        """
        pulumi.set(__self__, "contact_channel_id", contact_channel_id)
        if retry_interval_in_minutes is not None:
            pulumi.set(__self__, "retry_interval_in_minutes", retry_interval_in_minutes)

    @property
    @pulumi.getter(name="contactChannelId")
    def contact_channel_id(self) -> str:
        """
        The Amazon Resource Name (ARN) of the contact channel.
        """
        return pulumi.get(self, "contact_channel_id")

    @property
    @pulumi.getter(name="retryIntervalInMinutes")
    def retry_interval_in_minutes(self) -> Optional[int]:
        """
        The number of minutes to wait before retrying to send engagement if the engagement initially failed.
        """
        return pulumi.get(self, "retry_interval_in_minutes")


@pulumi.output_type
class PlanStageTargetContactTargetInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEssential":
            suggest = "is_essential"
        elif key == "contactId":
            suggest = "contact_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PlanStageTargetContactTargetInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PlanStageTargetContactTargetInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PlanStageTargetContactTargetInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_essential: bool,
                 contact_id: Optional[str] = None):
        """
        :param bool is_essential: A Boolean value determining if the contact's acknowledgement stops the progress of stages in the plan.
        :param str contact_id: The Amazon Resource Name (ARN) of the contact.
        """
        pulumi.set(__self__, "is_essential", is_essential)
        if contact_id is not None:
            pulumi.set(__self__, "contact_id", contact_id)

    @property
    @pulumi.getter(name="isEssential")
    def is_essential(self) -> bool:
        """
        A Boolean value determining if the contact's acknowledgement stops the progress of stages in the plan.
        """
        return pulumi.get(self, "is_essential")

    @property
    @pulumi.getter(name="contactId")
    def contact_id(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the contact.
        """
        return pulumi.get(self, "contact_id")


@pulumi.output_type
class GetContactChannelDeliveryAddressResult(dict):
    def __init__(__self__, *,
                 simple_address: str):
        pulumi.set(__self__, "simple_address", simple_address)

    @property
    @pulumi.getter(name="simpleAddress")
    def simple_address(self) -> str:
        return pulumi.get(self, "simple_address")


@pulumi.output_type
class GetPlanStageResult(dict):
    def __init__(__self__, *,
                 duration_in_minutes: int,
                 targets: Sequence['outputs.GetPlanStageTargetResult']):
        pulumi.set(__self__, "duration_in_minutes", duration_in_minutes)
        pulumi.set(__self__, "targets", targets)

    @property
    @pulumi.getter(name="durationInMinutes")
    def duration_in_minutes(self) -> int:
        return pulumi.get(self, "duration_in_minutes")

    @property
    @pulumi.getter
    def targets(self) -> Sequence['outputs.GetPlanStageTargetResult']:
        return pulumi.get(self, "targets")


@pulumi.output_type
class GetPlanStageTargetResult(dict):
    def __init__(__self__, *,
                 channel_target_infos: Sequence['outputs.GetPlanStageTargetChannelTargetInfoResult'],
                 contact_target_infos: Sequence['outputs.GetPlanStageTargetContactTargetInfoResult']):
        pulumi.set(__self__, "channel_target_infos", channel_target_infos)
        pulumi.set(__self__, "contact_target_infos", contact_target_infos)

    @property
    @pulumi.getter(name="channelTargetInfos")
    def channel_target_infos(self) -> Sequence['outputs.GetPlanStageTargetChannelTargetInfoResult']:
        return pulumi.get(self, "channel_target_infos")

    @property
    @pulumi.getter(name="contactTargetInfos")
    def contact_target_infos(self) -> Sequence['outputs.GetPlanStageTargetContactTargetInfoResult']:
        return pulumi.get(self, "contact_target_infos")


@pulumi.output_type
class GetPlanStageTargetChannelTargetInfoResult(dict):
    def __init__(__self__, *,
                 contact_channel_id: str,
                 retry_interval_in_minutes: int):
        pulumi.set(__self__, "contact_channel_id", contact_channel_id)
        pulumi.set(__self__, "retry_interval_in_minutes", retry_interval_in_minutes)

    @property
    @pulumi.getter(name="contactChannelId")
    def contact_channel_id(self) -> str:
        return pulumi.get(self, "contact_channel_id")

    @property
    @pulumi.getter(name="retryIntervalInMinutes")
    def retry_interval_in_minutes(self) -> int:
        return pulumi.get(self, "retry_interval_in_minutes")


@pulumi.output_type
class GetPlanStageTargetContactTargetInfoResult(dict):
    def __init__(__self__, *,
                 contact_id: str,
                 is_essential: bool):
        """
        :param str contact_id: The Amazon Resource Name (ARN) of the contact or escalation plan.
        """
        pulumi.set(__self__, "contact_id", contact_id)
        pulumi.set(__self__, "is_essential", is_essential)

    @property
    @pulumi.getter(name="contactId")
    def contact_id(self) -> str:
        """
        The Amazon Resource Name (ARN) of the contact or escalation plan.
        """
        return pulumi.get(self, "contact_id")

    @property
    @pulumi.getter(name="isEssential")
    def is_essential(self) -> bool:
        return pulumi.get(self, "is_essential")


