# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ApplicationAssignmentConfigurationArgs', 'ApplicationAssignmentConfiguration']

@pulumi.input_type
class ApplicationAssignmentConfigurationArgs:
    def __init__(__self__, *,
                 application_arn: pulumi.Input[str],
                 assignment_required: pulumi.Input[bool]):
        """
        The set of arguments for constructing a ApplicationAssignmentConfiguration resource.
        :param pulumi.Input[str] application_arn: ARN of the application.
        :param pulumi.Input[bool] assignment_required: Indicates whether users must have an explicit assignment to access the application. If `false`, all users have access to the application.
        """
        pulumi.set(__self__, "application_arn", application_arn)
        pulumi.set(__self__, "assignment_required", assignment_required)

    @property
    @pulumi.getter(name="applicationArn")
    def application_arn(self) -> pulumi.Input[str]:
        """
        ARN of the application.
        """
        return pulumi.get(self, "application_arn")

    @application_arn.setter
    def application_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "application_arn", value)

    @property
    @pulumi.getter(name="assignmentRequired")
    def assignment_required(self) -> pulumi.Input[bool]:
        """
        Indicates whether users must have an explicit assignment to access the application. If `false`, all users have access to the application.
        """
        return pulumi.get(self, "assignment_required")

    @assignment_required.setter
    def assignment_required(self, value: pulumi.Input[bool]):
        pulumi.set(self, "assignment_required", value)


@pulumi.input_type
class _ApplicationAssignmentConfigurationState:
    def __init__(__self__, *,
                 application_arn: Optional[pulumi.Input[str]] = None,
                 assignment_required: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering ApplicationAssignmentConfiguration resources.
        :param pulumi.Input[str] application_arn: ARN of the application.
        :param pulumi.Input[bool] assignment_required: Indicates whether users must have an explicit assignment to access the application. If `false`, all users have access to the application.
        """
        if application_arn is not None:
            pulumi.set(__self__, "application_arn", application_arn)
        if assignment_required is not None:
            pulumi.set(__self__, "assignment_required", assignment_required)

    @property
    @pulumi.getter(name="applicationArn")
    def application_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the application.
        """
        return pulumi.get(self, "application_arn")

    @application_arn.setter
    def application_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_arn", value)

    @property
    @pulumi.getter(name="assignmentRequired")
    def assignment_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether users must have an explicit assignment to access the application. If `false`, all users have access to the application.
        """
        return pulumi.get(self, "assignment_required")

    @assignment_required.setter
    def assignment_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "assignment_required", value)


class ApplicationAssignmentConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_arn: Optional[pulumi.Input[str]] = None,
                 assignment_required: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Resource for managing an AWS SSO Admin Application Assignment Configuration.

        By default, applications will require users to have an explicit assignment in order to access an application.
        This resource can be used to adjust this default behavior if necessary.

        > Deleting this resource will return the assignment configuration for the application to the default AWS behavior (ie. `assignment_required = true`).

        ## Example Usage

        ### Basic Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssoadmin.ApplicationAssignmentConfiguration("example",
            application_arn=example_aws_ssoadmin_application["applicationArn"],
            assignment_required=True)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import SSO Admin Application Assignment Configuration using the `id`. For example:

        ```sh
        $ pulumi import aws:ssoadmin/applicationAssignmentConfiguration:ApplicationAssignmentConfiguration example arn:aws:sso::012345678901:application/id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_arn: ARN of the application.
        :param pulumi.Input[bool] assignment_required: Indicates whether users must have an explicit assignment to access the application. If `false`, all users have access to the application.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplicationAssignmentConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS SSO Admin Application Assignment Configuration.

        By default, applications will require users to have an explicit assignment in order to access an application.
        This resource can be used to adjust this default behavior if necessary.

        > Deleting this resource will return the assignment configuration for the application to the default AWS behavior (ie. `assignment_required = true`).

        ## Example Usage

        ### Basic Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ssoadmin.ApplicationAssignmentConfiguration("example",
            application_arn=example_aws_ssoadmin_application["applicationArn"],
            assignment_required=True)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import SSO Admin Application Assignment Configuration using the `id`. For example:

        ```sh
        $ pulumi import aws:ssoadmin/applicationAssignmentConfiguration:ApplicationAssignmentConfiguration example arn:aws:sso::012345678901:application/id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param ApplicationAssignmentConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationAssignmentConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_arn: Optional[pulumi.Input[str]] = None,
                 assignment_required: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationAssignmentConfigurationArgs.__new__(ApplicationAssignmentConfigurationArgs)

            if application_arn is None and not opts.urn:
                raise TypeError("Missing required property 'application_arn'")
            __props__.__dict__["application_arn"] = application_arn
            if assignment_required is None and not opts.urn:
                raise TypeError("Missing required property 'assignment_required'")
            __props__.__dict__["assignment_required"] = assignment_required
        super(ApplicationAssignmentConfiguration, __self__).__init__(
            'aws:ssoadmin/applicationAssignmentConfiguration:ApplicationAssignmentConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_arn: Optional[pulumi.Input[str]] = None,
            assignment_required: Optional[pulumi.Input[bool]] = None) -> 'ApplicationAssignmentConfiguration':
        """
        Get an existing ApplicationAssignmentConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_arn: ARN of the application.
        :param pulumi.Input[bool] assignment_required: Indicates whether users must have an explicit assignment to access the application. If `false`, all users have access to the application.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplicationAssignmentConfigurationState.__new__(_ApplicationAssignmentConfigurationState)

        __props__.__dict__["application_arn"] = application_arn
        __props__.__dict__["assignment_required"] = assignment_required
        return ApplicationAssignmentConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationArn")
    def application_arn(self) -> pulumi.Output[str]:
        """
        ARN of the application.
        """
        return pulumi.get(self, "application_arn")

    @property
    @pulumi.getter(name="assignmentRequired")
    def assignment_required(self) -> pulumi.Output[bool]:
        """
        Indicates whether users must have an explicit assignment to access the application. If `false`, all users have access to the application.
        """
        return pulumi.get(self, "assignment_required")

