# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GatewayArgs', 'Gateway']

@pulumi.input_type
class GatewayArgs:
    def __init__(__self__, *,
                 gateway_name: pulumi.Input[str],
                 gateway_timezone: pulumi.Input[str],
                 activation_key: Optional[pulumi.Input[str]] = None,
                 average_download_rate_limit_in_bits_per_sec: Optional[pulumi.Input[int]] = None,
                 average_upload_rate_limit_in_bits_per_sec: Optional[pulumi.Input[int]] = None,
                 cloudwatch_log_group_arn: Optional[pulumi.Input[str]] = None,
                 gateway_ip_address: Optional[pulumi.Input[str]] = None,
                 gateway_type: Optional[pulumi.Input[str]] = None,
                 gateway_vpc_endpoint: Optional[pulumi.Input[str]] = None,
                 maintenance_start_time: Optional[pulumi.Input['GatewayMaintenanceStartTimeArgs']] = None,
                 medium_changer_type: Optional[pulumi.Input[str]] = None,
                 smb_active_directory_settings: Optional[pulumi.Input['GatewaySmbActiveDirectorySettingsArgs']] = None,
                 smb_file_share_visibility: Optional[pulumi.Input[bool]] = None,
                 smb_guest_password: Optional[pulumi.Input[str]] = None,
                 smb_security_strategy: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tape_drive_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Gateway resource.
        :param pulumi.Input[str] gateway_name: Name of the gateway.
        :param pulumi.Input[str] gateway_timezone: Time zone for the gateway. The time zone is of the format "GMT", "GMT-hr:mm", or "GMT+hr:mm". For example, `GMT-4:00` indicates the time is 4 hours behind GMT. The time zone is used, for example, for scheduling snapshots and your gateway's maintenance schedule.
        :param pulumi.Input[str] activation_key: Gateway activation key during resource creation. Conflicts with `gateway_ip_address`. Additional information is available in the [Storage Gateway User Guide](https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html).
        :param pulumi.Input[int] average_download_rate_limit_in_bits_per_sec: The average download bandwidth rate limit in bits per second. This is supported for the `CACHED`, `STORED`, and `VTL` gateway types.
        :param pulumi.Input[int] average_upload_rate_limit_in_bits_per_sec: The average upload bandwidth rate limit in bits per second. This is supported for the `CACHED`, `STORED`, and `VTL` gateway types.
        :param pulumi.Input[str] cloudwatch_log_group_arn: The Amazon Resource Name (ARN) of the Amazon CloudWatch log group to use to monitor and log events in the gateway.
        :param pulumi.Input[str] gateway_ip_address: Gateway IP address to retrieve activation key during resource creation. Conflicts with `activation_key`. Gateway must be accessible on port 80 from where this provider is running. Additional information is available in the [Storage Gateway User Guide](https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html).
        :param pulumi.Input[str] gateway_type: Type of the gateway. The default value is `STORED`. Valid values: `CACHED`, `FILE_FSX_SMB`, `FILE_S3`, `STORED`, `VTL`.
        :param pulumi.Input[str] gateway_vpc_endpoint: VPC endpoint address to be used when activating your gateway. This should be used when your instance is in a private subnet. Requires HTTP access from client computer running this provider. More info on what ports are required by your VPC Endpoint Security group in [Activating a Gateway in a Virtual Private Cloud](https://docs.aws.amazon.com/storagegateway/latest/userguide/gateway-private-link.html).
        :param pulumi.Input['GatewayMaintenanceStartTimeArgs'] maintenance_start_time: The gateway's weekly maintenance start time information, including day and time of the week. The maintenance time is the time in your gateway's time zone. More details below.
        :param pulumi.Input[str] medium_changer_type: Type of medium changer to use for tape gateway. This provider cannot detect drift of this argument. Valid values: `STK-L700`, `AWS-Gateway-VTL`, `IBM-03584L32-0402`.
        :param pulumi.Input['GatewaySmbActiveDirectorySettingsArgs'] smb_active_directory_settings: Nested argument with Active Directory domain join information for Server Message Block (SMB) file shares. Only valid for `FILE_S3` and `FILE_FSX_SMB` gateway types. Must be set before creating `ActiveDirectory` authentication SMB file shares. More details below.
        :param pulumi.Input[bool] smb_file_share_visibility: Specifies whether the shares on this gateway appear when listing shares.
        :param pulumi.Input[str] smb_guest_password: Guest password for Server Message Block (SMB) file shares. Only valid for `FILE_S3` and `FILE_FSX_SMB` gateway types. Must be set before creating `GuestAccess` authentication SMB file shares. This provider can only detect drift of the existence of a guest password, not its actual value from the gateway. This provider can however update the password with changing the argument.
        :param pulumi.Input[str] smb_security_strategy: Specifies the type of security strategy. Valid values are: `ClientSpecified`, `MandatorySigning`, and `MandatoryEncryption`. See [Setting a Security Level for Your Gateway](https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-gateway-file.html#security-strategy) for more information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] tape_drive_type: Type of tape drive to use for tape gateway. This provider cannot detect drift of this argument. Valid values: `IBM-ULT3580-TD5`.
        """
        pulumi.set(__self__, "gateway_name", gateway_name)
        pulumi.set(__self__, "gateway_timezone", gateway_timezone)
        if activation_key is not None:
            pulumi.set(__self__, "activation_key", activation_key)
        if average_download_rate_limit_in_bits_per_sec is not None:
            pulumi.set(__self__, "average_download_rate_limit_in_bits_per_sec", average_download_rate_limit_in_bits_per_sec)
        if average_upload_rate_limit_in_bits_per_sec is not None:
            pulumi.set(__self__, "average_upload_rate_limit_in_bits_per_sec", average_upload_rate_limit_in_bits_per_sec)
        if cloudwatch_log_group_arn is not None:
            pulumi.set(__self__, "cloudwatch_log_group_arn", cloudwatch_log_group_arn)
        if gateway_ip_address is not None:
            pulumi.set(__self__, "gateway_ip_address", gateway_ip_address)
        if gateway_type is not None:
            pulumi.set(__self__, "gateway_type", gateway_type)
        if gateway_vpc_endpoint is not None:
            pulumi.set(__self__, "gateway_vpc_endpoint", gateway_vpc_endpoint)
        if maintenance_start_time is not None:
            pulumi.set(__self__, "maintenance_start_time", maintenance_start_time)
        if medium_changer_type is not None:
            pulumi.set(__self__, "medium_changer_type", medium_changer_type)
        if smb_active_directory_settings is not None:
            pulumi.set(__self__, "smb_active_directory_settings", smb_active_directory_settings)
        if smb_file_share_visibility is not None:
            pulumi.set(__self__, "smb_file_share_visibility", smb_file_share_visibility)
        if smb_guest_password is not None:
            pulumi.set(__self__, "smb_guest_password", smb_guest_password)
        if smb_security_strategy is not None:
            pulumi.set(__self__, "smb_security_strategy", smb_security_strategy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tape_drive_type is not None:
            pulumi.set(__self__, "tape_drive_type", tape_drive_type)

    @property
    @pulumi.getter(name="gatewayName")
    def gateway_name(self) -> pulumi.Input[str]:
        """
        Name of the gateway.
        """
        return pulumi.get(self, "gateway_name")

    @gateway_name.setter
    def gateway_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "gateway_name", value)

    @property
    @pulumi.getter(name="gatewayTimezone")
    def gateway_timezone(self) -> pulumi.Input[str]:
        """
        Time zone for the gateway. The time zone is of the format "GMT", "GMT-hr:mm", or "GMT+hr:mm". For example, `GMT-4:00` indicates the time is 4 hours behind GMT. The time zone is used, for example, for scheduling snapshots and your gateway's maintenance schedule.
        """
        return pulumi.get(self, "gateway_timezone")

    @gateway_timezone.setter
    def gateway_timezone(self, value: pulumi.Input[str]):
        pulumi.set(self, "gateway_timezone", value)

    @property
    @pulumi.getter(name="activationKey")
    def activation_key(self) -> Optional[pulumi.Input[str]]:
        """
        Gateway activation key during resource creation. Conflicts with `gateway_ip_address`. Additional information is available in the [Storage Gateway User Guide](https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html).
        """
        return pulumi.get(self, "activation_key")

    @activation_key.setter
    def activation_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "activation_key", value)

    @property
    @pulumi.getter(name="averageDownloadRateLimitInBitsPerSec")
    def average_download_rate_limit_in_bits_per_sec(self) -> Optional[pulumi.Input[int]]:
        """
        The average download bandwidth rate limit in bits per second. This is supported for the `CACHED`, `STORED`, and `VTL` gateway types.
        """
        return pulumi.get(self, "average_download_rate_limit_in_bits_per_sec")

    @average_download_rate_limit_in_bits_per_sec.setter
    def average_download_rate_limit_in_bits_per_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "average_download_rate_limit_in_bits_per_sec", value)

    @property
    @pulumi.getter(name="averageUploadRateLimitInBitsPerSec")
    def average_upload_rate_limit_in_bits_per_sec(self) -> Optional[pulumi.Input[int]]:
        """
        The average upload bandwidth rate limit in bits per second. This is supported for the `CACHED`, `STORED`, and `VTL` gateway types.
        """
        return pulumi.get(self, "average_upload_rate_limit_in_bits_per_sec")

    @average_upload_rate_limit_in_bits_per_sec.setter
    def average_upload_rate_limit_in_bits_per_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "average_upload_rate_limit_in_bits_per_sec", value)

    @property
    @pulumi.getter(name="cloudwatchLogGroupArn")
    def cloudwatch_log_group_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the Amazon CloudWatch log group to use to monitor and log events in the gateway.
        """
        return pulumi.get(self, "cloudwatch_log_group_arn")

    @cloudwatch_log_group_arn.setter
    def cloudwatch_log_group_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloudwatch_log_group_arn", value)

    @property
    @pulumi.getter(name="gatewayIpAddress")
    def gateway_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        Gateway IP address to retrieve activation key during resource creation. Conflicts with `activation_key`. Gateway must be accessible on port 80 from where this provider is running. Additional information is available in the [Storage Gateway User Guide](https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html).
        """
        return pulumi.get(self, "gateway_ip_address")

    @gateway_ip_address.setter
    def gateway_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_ip_address", value)

    @property
    @pulumi.getter(name="gatewayType")
    def gateway_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the gateway. The default value is `STORED`. Valid values: `CACHED`, `FILE_FSX_SMB`, `FILE_S3`, `STORED`, `VTL`.
        """
        return pulumi.get(self, "gateway_type")

    @gateway_type.setter
    def gateway_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_type", value)

    @property
    @pulumi.getter(name="gatewayVpcEndpoint")
    def gateway_vpc_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        VPC endpoint address to be used when activating your gateway. This should be used when your instance is in a private subnet. Requires HTTP access from client computer running this provider. More info on what ports are required by your VPC Endpoint Security group in [Activating a Gateway in a Virtual Private Cloud](https://docs.aws.amazon.com/storagegateway/latest/userguide/gateway-private-link.html).
        """
        return pulumi.get(self, "gateway_vpc_endpoint")

    @gateway_vpc_endpoint.setter
    def gateway_vpc_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_vpc_endpoint", value)

    @property
    @pulumi.getter(name="maintenanceStartTime")
    def maintenance_start_time(self) -> Optional[pulumi.Input['GatewayMaintenanceStartTimeArgs']]:
        """
        The gateway's weekly maintenance start time information, including day and time of the week. The maintenance time is the time in your gateway's time zone. More details below.
        """
        return pulumi.get(self, "maintenance_start_time")

    @maintenance_start_time.setter
    def maintenance_start_time(self, value: Optional[pulumi.Input['GatewayMaintenanceStartTimeArgs']]):
        pulumi.set(self, "maintenance_start_time", value)

    @property
    @pulumi.getter(name="mediumChangerType")
    def medium_changer_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of medium changer to use for tape gateway. This provider cannot detect drift of this argument. Valid values: `STK-L700`, `AWS-Gateway-VTL`, `IBM-03584L32-0402`.
        """
        return pulumi.get(self, "medium_changer_type")

    @medium_changer_type.setter
    def medium_changer_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "medium_changer_type", value)

    @property
    @pulumi.getter(name="smbActiveDirectorySettings")
    def smb_active_directory_settings(self) -> Optional[pulumi.Input['GatewaySmbActiveDirectorySettingsArgs']]:
        """
        Nested argument with Active Directory domain join information for Server Message Block (SMB) file shares. Only valid for `FILE_S3` and `FILE_FSX_SMB` gateway types. Must be set before creating `ActiveDirectory` authentication SMB file shares. More details below.
        """
        return pulumi.get(self, "smb_active_directory_settings")

    @smb_active_directory_settings.setter
    def smb_active_directory_settings(self, value: Optional[pulumi.Input['GatewaySmbActiveDirectorySettingsArgs']]):
        pulumi.set(self, "smb_active_directory_settings", value)

    @property
    @pulumi.getter(name="smbFileShareVisibility")
    def smb_file_share_visibility(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the shares on this gateway appear when listing shares.
        """
        return pulumi.get(self, "smb_file_share_visibility")

    @smb_file_share_visibility.setter
    def smb_file_share_visibility(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "smb_file_share_visibility", value)

    @property
    @pulumi.getter(name="smbGuestPassword")
    def smb_guest_password(self) -> Optional[pulumi.Input[str]]:
        """
        Guest password for Server Message Block (SMB) file shares. Only valid for `FILE_S3` and `FILE_FSX_SMB` gateway types. Must be set before creating `GuestAccess` authentication SMB file shares. This provider can only detect drift of the existence of a guest password, not its actual value from the gateway. This provider can however update the password with changing the argument.
        """
        return pulumi.get(self, "smb_guest_password")

    @smb_guest_password.setter
    def smb_guest_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "smb_guest_password", value)

    @property
    @pulumi.getter(name="smbSecurityStrategy")
    def smb_security_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of security strategy. Valid values are: `ClientSpecified`, `MandatorySigning`, and `MandatoryEncryption`. See [Setting a Security Level for Your Gateway](https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-gateway-file.html#security-strategy) for more information.
        """
        return pulumi.get(self, "smb_security_strategy")

    @smb_security_strategy.setter
    def smb_security_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "smb_security_strategy", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tapeDriveType")
    def tape_drive_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of tape drive to use for tape gateway. This provider cannot detect drift of this argument. Valid values: `IBM-ULT3580-TD5`.
        """
        return pulumi.get(self, "tape_drive_type")

    @tape_drive_type.setter
    def tape_drive_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tape_drive_type", value)


@pulumi.input_type
class _GatewayState:
    def __init__(__self__, *,
                 activation_key: Optional[pulumi.Input[str]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 average_download_rate_limit_in_bits_per_sec: Optional[pulumi.Input[int]] = None,
                 average_upload_rate_limit_in_bits_per_sec: Optional[pulumi.Input[int]] = None,
                 cloudwatch_log_group_arn: Optional[pulumi.Input[str]] = None,
                 ec2_instance_id: Optional[pulumi.Input[str]] = None,
                 endpoint_type: Optional[pulumi.Input[str]] = None,
                 gateway_id: Optional[pulumi.Input[str]] = None,
                 gateway_ip_address: Optional[pulumi.Input[str]] = None,
                 gateway_name: Optional[pulumi.Input[str]] = None,
                 gateway_network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayGatewayNetworkInterfaceArgs']]]] = None,
                 gateway_timezone: Optional[pulumi.Input[str]] = None,
                 gateway_type: Optional[pulumi.Input[str]] = None,
                 gateway_vpc_endpoint: Optional[pulumi.Input[str]] = None,
                 host_environment: Optional[pulumi.Input[str]] = None,
                 maintenance_start_time: Optional[pulumi.Input['GatewayMaintenanceStartTimeArgs']] = None,
                 medium_changer_type: Optional[pulumi.Input[str]] = None,
                 smb_active_directory_settings: Optional[pulumi.Input['GatewaySmbActiveDirectorySettingsArgs']] = None,
                 smb_file_share_visibility: Optional[pulumi.Input[bool]] = None,
                 smb_guest_password: Optional[pulumi.Input[str]] = None,
                 smb_security_strategy: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tape_drive_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Gateway resources.
        :param pulumi.Input[str] activation_key: Gateway activation key during resource creation. Conflicts with `gateway_ip_address`. Additional information is available in the [Storage Gateway User Guide](https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html).
        :param pulumi.Input[str] arn: Amazon Resource Name (ARN) of the gateway.
        :param pulumi.Input[int] average_download_rate_limit_in_bits_per_sec: The average download bandwidth rate limit in bits per second. This is supported for the `CACHED`, `STORED`, and `VTL` gateway types.
        :param pulumi.Input[int] average_upload_rate_limit_in_bits_per_sec: The average upload bandwidth rate limit in bits per second. This is supported for the `CACHED`, `STORED`, and `VTL` gateway types.
        :param pulumi.Input[str] cloudwatch_log_group_arn: The Amazon Resource Name (ARN) of the Amazon CloudWatch log group to use to monitor and log events in the gateway.
        :param pulumi.Input[str] ec2_instance_id: The ID of the Amazon EC2 instance that was used to launch the gateway.
        :param pulumi.Input[str] endpoint_type: The type of endpoint for your gateway.
        :param pulumi.Input[str] gateway_id: Identifier of the gateway.
        :param pulumi.Input[str] gateway_ip_address: Gateway IP address to retrieve activation key during resource creation. Conflicts with `activation_key`. Gateway must be accessible on port 80 from where this provider is running. Additional information is available in the [Storage Gateway User Guide](https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html).
        :param pulumi.Input[str] gateway_name: Name of the gateway.
        :param pulumi.Input[Sequence[pulumi.Input['GatewayGatewayNetworkInterfaceArgs']]] gateway_network_interfaces: An array that contains descriptions of the gateway network interfaces. See Gateway Network Interface.
        :param pulumi.Input[str] gateway_timezone: Time zone for the gateway. The time zone is of the format "GMT", "GMT-hr:mm", or "GMT+hr:mm". For example, `GMT-4:00` indicates the time is 4 hours behind GMT. The time zone is used, for example, for scheduling snapshots and your gateway's maintenance schedule.
        :param pulumi.Input[str] gateway_type: Type of the gateway. The default value is `STORED`. Valid values: `CACHED`, `FILE_FSX_SMB`, `FILE_S3`, `STORED`, `VTL`.
        :param pulumi.Input[str] gateway_vpc_endpoint: VPC endpoint address to be used when activating your gateway. This should be used when your instance is in a private subnet. Requires HTTP access from client computer running this provider. More info on what ports are required by your VPC Endpoint Security group in [Activating a Gateway in a Virtual Private Cloud](https://docs.aws.amazon.com/storagegateway/latest/userguide/gateway-private-link.html).
        :param pulumi.Input[str] host_environment: The type of hypervisor environment used by the host.
        :param pulumi.Input['GatewayMaintenanceStartTimeArgs'] maintenance_start_time: The gateway's weekly maintenance start time information, including day and time of the week. The maintenance time is the time in your gateway's time zone. More details below.
        :param pulumi.Input[str] medium_changer_type: Type of medium changer to use for tape gateway. This provider cannot detect drift of this argument. Valid values: `STK-L700`, `AWS-Gateway-VTL`, `IBM-03584L32-0402`.
        :param pulumi.Input['GatewaySmbActiveDirectorySettingsArgs'] smb_active_directory_settings: Nested argument with Active Directory domain join information for Server Message Block (SMB) file shares. Only valid for `FILE_S3` and `FILE_FSX_SMB` gateway types. Must be set before creating `ActiveDirectory` authentication SMB file shares. More details below.
        :param pulumi.Input[bool] smb_file_share_visibility: Specifies whether the shares on this gateway appear when listing shares.
        :param pulumi.Input[str] smb_guest_password: Guest password for Server Message Block (SMB) file shares. Only valid for `FILE_S3` and `FILE_FSX_SMB` gateway types. Must be set before creating `GuestAccess` authentication SMB file shares. This provider can only detect drift of the existence of a guest password, not its actual value from the gateway. This provider can however update the password with changing the argument.
        :param pulumi.Input[str] smb_security_strategy: Specifies the type of security strategy. Valid values are: `ClientSpecified`, `MandatorySigning`, and `MandatoryEncryption`. See [Setting a Security Level for Your Gateway](https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-gateway-file.html#security-strategy) for more information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] tape_drive_type: Type of tape drive to use for tape gateway. This provider cannot detect drift of this argument. Valid values: `IBM-ULT3580-TD5`.
        """
        if activation_key is not None:
            pulumi.set(__self__, "activation_key", activation_key)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if average_download_rate_limit_in_bits_per_sec is not None:
            pulumi.set(__self__, "average_download_rate_limit_in_bits_per_sec", average_download_rate_limit_in_bits_per_sec)
        if average_upload_rate_limit_in_bits_per_sec is not None:
            pulumi.set(__self__, "average_upload_rate_limit_in_bits_per_sec", average_upload_rate_limit_in_bits_per_sec)
        if cloudwatch_log_group_arn is not None:
            pulumi.set(__self__, "cloudwatch_log_group_arn", cloudwatch_log_group_arn)
        if ec2_instance_id is not None:
            pulumi.set(__self__, "ec2_instance_id", ec2_instance_id)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)
        if gateway_id is not None:
            pulumi.set(__self__, "gateway_id", gateway_id)
        if gateway_ip_address is not None:
            pulumi.set(__self__, "gateway_ip_address", gateway_ip_address)
        if gateway_name is not None:
            pulumi.set(__self__, "gateway_name", gateway_name)
        if gateway_network_interfaces is not None:
            pulumi.set(__self__, "gateway_network_interfaces", gateway_network_interfaces)
        if gateway_timezone is not None:
            pulumi.set(__self__, "gateway_timezone", gateway_timezone)
        if gateway_type is not None:
            pulumi.set(__self__, "gateway_type", gateway_type)
        if gateway_vpc_endpoint is not None:
            pulumi.set(__self__, "gateway_vpc_endpoint", gateway_vpc_endpoint)
        if host_environment is not None:
            pulumi.set(__self__, "host_environment", host_environment)
        if maintenance_start_time is not None:
            pulumi.set(__self__, "maintenance_start_time", maintenance_start_time)
        if medium_changer_type is not None:
            pulumi.set(__self__, "medium_changer_type", medium_changer_type)
        if smb_active_directory_settings is not None:
            pulumi.set(__self__, "smb_active_directory_settings", smb_active_directory_settings)
        if smb_file_share_visibility is not None:
            pulumi.set(__self__, "smb_file_share_visibility", smb_file_share_visibility)
        if smb_guest_password is not None:
            pulumi.set(__self__, "smb_guest_password", smb_guest_password)
        if smb_security_strategy is not None:
            pulumi.set(__self__, "smb_security_strategy", smb_security_strategy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if tape_drive_type is not None:
            pulumi.set(__self__, "tape_drive_type", tape_drive_type)

    @property
    @pulumi.getter(name="activationKey")
    def activation_key(self) -> Optional[pulumi.Input[str]]:
        """
        Gateway activation key during resource creation. Conflicts with `gateway_ip_address`. Additional information is available in the [Storage Gateway User Guide](https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html).
        """
        return pulumi.get(self, "activation_key")

    @activation_key.setter
    def activation_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "activation_key", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of the gateway.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="averageDownloadRateLimitInBitsPerSec")
    def average_download_rate_limit_in_bits_per_sec(self) -> Optional[pulumi.Input[int]]:
        """
        The average download bandwidth rate limit in bits per second. This is supported for the `CACHED`, `STORED`, and `VTL` gateway types.
        """
        return pulumi.get(self, "average_download_rate_limit_in_bits_per_sec")

    @average_download_rate_limit_in_bits_per_sec.setter
    def average_download_rate_limit_in_bits_per_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "average_download_rate_limit_in_bits_per_sec", value)

    @property
    @pulumi.getter(name="averageUploadRateLimitInBitsPerSec")
    def average_upload_rate_limit_in_bits_per_sec(self) -> Optional[pulumi.Input[int]]:
        """
        The average upload bandwidth rate limit in bits per second. This is supported for the `CACHED`, `STORED`, and `VTL` gateway types.
        """
        return pulumi.get(self, "average_upload_rate_limit_in_bits_per_sec")

    @average_upload_rate_limit_in_bits_per_sec.setter
    def average_upload_rate_limit_in_bits_per_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "average_upload_rate_limit_in_bits_per_sec", value)

    @property
    @pulumi.getter(name="cloudwatchLogGroupArn")
    def cloudwatch_log_group_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the Amazon CloudWatch log group to use to monitor and log events in the gateway.
        """
        return pulumi.get(self, "cloudwatch_log_group_arn")

    @cloudwatch_log_group_arn.setter
    def cloudwatch_log_group_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloudwatch_log_group_arn", value)

    @property
    @pulumi.getter(name="ec2InstanceId")
    def ec2_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Amazon EC2 instance that was used to launch the gateway.
        """
        return pulumi.get(self, "ec2_instance_id")

    @ec2_instance_id.setter
    def ec2_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ec2_instance_id", value)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of endpoint for your gateway.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the gateway.
        """
        return pulumi.get(self, "gateway_id")

    @gateway_id.setter
    def gateway_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_id", value)

    @property
    @pulumi.getter(name="gatewayIpAddress")
    def gateway_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        Gateway IP address to retrieve activation key during resource creation. Conflicts with `activation_key`. Gateway must be accessible on port 80 from where this provider is running. Additional information is available in the [Storage Gateway User Guide](https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html).
        """
        return pulumi.get(self, "gateway_ip_address")

    @gateway_ip_address.setter
    def gateway_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_ip_address", value)

    @property
    @pulumi.getter(name="gatewayName")
    def gateway_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the gateway.
        """
        return pulumi.get(self, "gateway_name")

    @gateway_name.setter
    def gateway_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_name", value)

    @property
    @pulumi.getter(name="gatewayNetworkInterfaces")
    def gateway_network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GatewayGatewayNetworkInterfaceArgs']]]]:
        """
        An array that contains descriptions of the gateway network interfaces. See Gateway Network Interface.
        """
        return pulumi.get(self, "gateway_network_interfaces")

    @gateway_network_interfaces.setter
    def gateway_network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GatewayGatewayNetworkInterfaceArgs']]]]):
        pulumi.set(self, "gateway_network_interfaces", value)

    @property
    @pulumi.getter(name="gatewayTimezone")
    def gateway_timezone(self) -> Optional[pulumi.Input[str]]:
        """
        Time zone for the gateway. The time zone is of the format "GMT", "GMT-hr:mm", or "GMT+hr:mm". For example, `GMT-4:00` indicates the time is 4 hours behind GMT. The time zone is used, for example, for scheduling snapshots and your gateway's maintenance schedule.
        """
        return pulumi.get(self, "gateway_timezone")

    @gateway_timezone.setter
    def gateway_timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_timezone", value)

    @property
    @pulumi.getter(name="gatewayType")
    def gateway_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the gateway. The default value is `STORED`. Valid values: `CACHED`, `FILE_FSX_SMB`, `FILE_S3`, `STORED`, `VTL`.
        """
        return pulumi.get(self, "gateway_type")

    @gateway_type.setter
    def gateway_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_type", value)

    @property
    @pulumi.getter(name="gatewayVpcEndpoint")
    def gateway_vpc_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        VPC endpoint address to be used when activating your gateway. This should be used when your instance is in a private subnet. Requires HTTP access from client computer running this provider. More info on what ports are required by your VPC Endpoint Security group in [Activating a Gateway in a Virtual Private Cloud](https://docs.aws.amazon.com/storagegateway/latest/userguide/gateway-private-link.html).
        """
        return pulumi.get(self, "gateway_vpc_endpoint")

    @gateway_vpc_endpoint.setter
    def gateway_vpc_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_vpc_endpoint", value)

    @property
    @pulumi.getter(name="hostEnvironment")
    def host_environment(self) -> Optional[pulumi.Input[str]]:
        """
        The type of hypervisor environment used by the host.
        """
        return pulumi.get(self, "host_environment")

    @host_environment.setter
    def host_environment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_environment", value)

    @property
    @pulumi.getter(name="maintenanceStartTime")
    def maintenance_start_time(self) -> Optional[pulumi.Input['GatewayMaintenanceStartTimeArgs']]:
        """
        The gateway's weekly maintenance start time information, including day and time of the week. The maintenance time is the time in your gateway's time zone. More details below.
        """
        return pulumi.get(self, "maintenance_start_time")

    @maintenance_start_time.setter
    def maintenance_start_time(self, value: Optional[pulumi.Input['GatewayMaintenanceStartTimeArgs']]):
        pulumi.set(self, "maintenance_start_time", value)

    @property
    @pulumi.getter(name="mediumChangerType")
    def medium_changer_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of medium changer to use for tape gateway. This provider cannot detect drift of this argument. Valid values: `STK-L700`, `AWS-Gateway-VTL`, `IBM-03584L32-0402`.
        """
        return pulumi.get(self, "medium_changer_type")

    @medium_changer_type.setter
    def medium_changer_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "medium_changer_type", value)

    @property
    @pulumi.getter(name="smbActiveDirectorySettings")
    def smb_active_directory_settings(self) -> Optional[pulumi.Input['GatewaySmbActiveDirectorySettingsArgs']]:
        """
        Nested argument with Active Directory domain join information for Server Message Block (SMB) file shares. Only valid for `FILE_S3` and `FILE_FSX_SMB` gateway types. Must be set before creating `ActiveDirectory` authentication SMB file shares. More details below.
        """
        return pulumi.get(self, "smb_active_directory_settings")

    @smb_active_directory_settings.setter
    def smb_active_directory_settings(self, value: Optional[pulumi.Input['GatewaySmbActiveDirectorySettingsArgs']]):
        pulumi.set(self, "smb_active_directory_settings", value)

    @property
    @pulumi.getter(name="smbFileShareVisibility")
    def smb_file_share_visibility(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the shares on this gateway appear when listing shares.
        """
        return pulumi.get(self, "smb_file_share_visibility")

    @smb_file_share_visibility.setter
    def smb_file_share_visibility(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "smb_file_share_visibility", value)

    @property
    @pulumi.getter(name="smbGuestPassword")
    def smb_guest_password(self) -> Optional[pulumi.Input[str]]:
        """
        Guest password for Server Message Block (SMB) file shares. Only valid for `FILE_S3` and `FILE_FSX_SMB` gateway types. Must be set before creating `GuestAccess` authentication SMB file shares. This provider can only detect drift of the existence of a guest password, not its actual value from the gateway. This provider can however update the password with changing the argument.
        """
        return pulumi.get(self, "smb_guest_password")

    @smb_guest_password.setter
    def smb_guest_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "smb_guest_password", value)

    @property
    @pulumi.getter(name="smbSecurityStrategy")
    def smb_security_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of security strategy. Valid values are: `ClientSpecified`, `MandatorySigning`, and `MandatoryEncryption`. See [Setting a Security Level for Your Gateway](https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-gateway-file.html#security-strategy) for more information.
        """
        return pulumi.get(self, "smb_security_strategy")

    @smb_security_strategy.setter
    def smb_security_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "smb_security_strategy", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="tapeDriveType")
    def tape_drive_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of tape drive to use for tape gateway. This provider cannot detect drift of this argument. Valid values: `IBM-ULT3580-TD5`.
        """
        return pulumi.get(self, "tape_drive_type")

    @tape_drive_type.setter
    def tape_drive_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tape_drive_type", value)


class Gateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activation_key: Optional[pulumi.Input[str]] = None,
                 average_download_rate_limit_in_bits_per_sec: Optional[pulumi.Input[int]] = None,
                 average_upload_rate_limit_in_bits_per_sec: Optional[pulumi.Input[int]] = None,
                 cloudwatch_log_group_arn: Optional[pulumi.Input[str]] = None,
                 gateway_ip_address: Optional[pulumi.Input[str]] = None,
                 gateway_name: Optional[pulumi.Input[str]] = None,
                 gateway_timezone: Optional[pulumi.Input[str]] = None,
                 gateway_type: Optional[pulumi.Input[str]] = None,
                 gateway_vpc_endpoint: Optional[pulumi.Input[str]] = None,
                 maintenance_start_time: Optional[pulumi.Input[pulumi.InputType['GatewayMaintenanceStartTimeArgs']]] = None,
                 medium_changer_type: Optional[pulumi.Input[str]] = None,
                 smb_active_directory_settings: Optional[pulumi.Input[pulumi.InputType['GatewaySmbActiveDirectorySettingsArgs']]] = None,
                 smb_file_share_visibility: Optional[pulumi.Input[bool]] = None,
                 smb_guest_password: Optional[pulumi.Input[str]] = None,
                 smb_security_strategy: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tape_drive_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages an AWS Storage Gateway file, tape, or volume gateway in the provider region.

        > **NOTE:** The Storage Gateway API requires the gateway to be connected to properly return information after activation. If you are receiving `The specified gateway is not connected` errors during resource creation (gateway activation), ensure your gateway instance meets the [Storage Gateway requirements](https://docs.aws.amazon.com/storagegateway/latest/userguide/Requirements.html).

        ## Example Usage

        ### Local Cache

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        test_volume_attachment = aws.ec2.VolumeAttachment("test",
            device_name="/dev/xvdb",
            volume_id=test_aws_ebs_volume["id"],
            instance_id=test_aws_instance["id"])
        test = aws.storagegateway.get_local_disk(disk_node=test_aws_volume_attachment["deviceName"],
            gateway_arn=test_aws_storagegateway_gateway["arn"])
        test_cache = aws.storagegateway.Cache("test",
            disk_id=test.disk_id,
            gateway_arn=test_aws_storagegateway_gateway["arn"])
        ```
        <!--End PulumiCodeChooser -->

        ### FSx File Gateway

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.storagegateway.Gateway("example",
            gateway_ip_address="1.2.3.4",
            gateway_name="example",
            gateway_timezone="GMT",
            gateway_type="FILE_FSX_SMB",
            smb_active_directory_settings=aws.storagegateway.GatewaySmbActiveDirectorySettingsArgs(
                domain_name="corp.example.com",
                password="avoid-plaintext-passwords",
                username="Admin",
            ))
        ```
        <!--End PulumiCodeChooser -->

        ### S3 File Gateway

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.storagegateway.Gateway("example",
            gateway_ip_address="1.2.3.4",
            gateway_name="example",
            gateway_timezone="GMT",
            gateway_type="FILE_S3")
        ```
        <!--End PulumiCodeChooser -->

        ### Tape Gateway

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.storagegateway.Gateway("example",
            gateway_ip_address="1.2.3.4",
            gateway_name="example",
            gateway_timezone="GMT",
            gateway_type="VTL",
            medium_changer_type="AWS-Gateway-VTL",
            tape_drive_type="IBM-ULT3580-TD5")
        ```
        <!--End PulumiCodeChooser -->

        ### Volume Gateway (Cached)

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.storagegateway.Gateway("example",
            gateway_ip_address="1.2.3.4",
            gateway_name="example",
            gateway_timezone="GMT",
            gateway_type="CACHED")
        ```
        <!--End PulumiCodeChooser -->

        ### Volume Gateway (Stored)

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.storagegateway.Gateway("example",
            gateway_ip_address="1.2.3.4",
            gateway_name="example",
            gateway_timezone="GMT",
            gateway_type="STORED")
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import `aws_storagegateway_gateway` using the gateway Amazon Resource Name (ARN). For example:

        ```sh
        $ pulumi import aws:storagegateway/gateway:Gateway example arn:aws:storagegateway:us-east-1:123456789012:gateway/sgw-12345678
        ```
        Certain resource arguments, like `gateway_ip_address` do not have a Storage Gateway API method for reading the information after creation, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] activation_key: Gateway activation key during resource creation. Conflicts with `gateway_ip_address`. Additional information is available in the [Storage Gateway User Guide](https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html).
        :param pulumi.Input[int] average_download_rate_limit_in_bits_per_sec: The average download bandwidth rate limit in bits per second. This is supported for the `CACHED`, `STORED`, and `VTL` gateway types.
        :param pulumi.Input[int] average_upload_rate_limit_in_bits_per_sec: The average upload bandwidth rate limit in bits per second. This is supported for the `CACHED`, `STORED`, and `VTL` gateway types.
        :param pulumi.Input[str] cloudwatch_log_group_arn: The Amazon Resource Name (ARN) of the Amazon CloudWatch log group to use to monitor and log events in the gateway.
        :param pulumi.Input[str] gateway_ip_address: Gateway IP address to retrieve activation key during resource creation. Conflicts with `activation_key`. Gateway must be accessible on port 80 from where this provider is running. Additional information is available in the [Storage Gateway User Guide](https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html).
        :param pulumi.Input[str] gateway_name: Name of the gateway.
        :param pulumi.Input[str] gateway_timezone: Time zone for the gateway. The time zone is of the format "GMT", "GMT-hr:mm", or "GMT+hr:mm". For example, `GMT-4:00` indicates the time is 4 hours behind GMT. The time zone is used, for example, for scheduling snapshots and your gateway's maintenance schedule.
        :param pulumi.Input[str] gateway_type: Type of the gateway. The default value is `STORED`. Valid values: `CACHED`, `FILE_FSX_SMB`, `FILE_S3`, `STORED`, `VTL`.
        :param pulumi.Input[str] gateway_vpc_endpoint: VPC endpoint address to be used when activating your gateway. This should be used when your instance is in a private subnet. Requires HTTP access from client computer running this provider. More info on what ports are required by your VPC Endpoint Security group in [Activating a Gateway in a Virtual Private Cloud](https://docs.aws.amazon.com/storagegateway/latest/userguide/gateway-private-link.html).
        :param pulumi.Input[pulumi.InputType['GatewayMaintenanceStartTimeArgs']] maintenance_start_time: The gateway's weekly maintenance start time information, including day and time of the week. The maintenance time is the time in your gateway's time zone. More details below.
        :param pulumi.Input[str] medium_changer_type: Type of medium changer to use for tape gateway. This provider cannot detect drift of this argument. Valid values: `STK-L700`, `AWS-Gateway-VTL`, `IBM-03584L32-0402`.
        :param pulumi.Input[pulumi.InputType['GatewaySmbActiveDirectorySettingsArgs']] smb_active_directory_settings: Nested argument with Active Directory domain join information for Server Message Block (SMB) file shares. Only valid for `FILE_S3` and `FILE_FSX_SMB` gateway types. Must be set before creating `ActiveDirectory` authentication SMB file shares. More details below.
        :param pulumi.Input[bool] smb_file_share_visibility: Specifies whether the shares on this gateway appear when listing shares.
        :param pulumi.Input[str] smb_guest_password: Guest password for Server Message Block (SMB) file shares. Only valid for `FILE_S3` and `FILE_FSX_SMB` gateway types. Must be set before creating `GuestAccess` authentication SMB file shares. This provider can only detect drift of the existence of a guest password, not its actual value from the gateway. This provider can however update the password with changing the argument.
        :param pulumi.Input[str] smb_security_strategy: Specifies the type of security strategy. Valid values are: `ClientSpecified`, `MandatorySigning`, and `MandatoryEncryption`. See [Setting a Security Level for Your Gateway](https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-gateway-file.html#security-strategy) for more information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] tape_drive_type: Type of tape drive to use for tape gateway. This provider cannot detect drift of this argument. Valid values: `IBM-ULT3580-TD5`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AWS Storage Gateway file, tape, or volume gateway in the provider region.

        > **NOTE:** The Storage Gateway API requires the gateway to be connected to properly return information after activation. If you are receiving `The specified gateway is not connected` errors during resource creation (gateway activation), ensure your gateway instance meets the [Storage Gateway requirements](https://docs.aws.amazon.com/storagegateway/latest/userguide/Requirements.html).

        ## Example Usage

        ### Local Cache

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        test_volume_attachment = aws.ec2.VolumeAttachment("test",
            device_name="/dev/xvdb",
            volume_id=test_aws_ebs_volume["id"],
            instance_id=test_aws_instance["id"])
        test = aws.storagegateway.get_local_disk(disk_node=test_aws_volume_attachment["deviceName"],
            gateway_arn=test_aws_storagegateway_gateway["arn"])
        test_cache = aws.storagegateway.Cache("test",
            disk_id=test.disk_id,
            gateway_arn=test_aws_storagegateway_gateway["arn"])
        ```
        <!--End PulumiCodeChooser -->

        ### FSx File Gateway

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.storagegateway.Gateway("example",
            gateway_ip_address="1.2.3.4",
            gateway_name="example",
            gateway_timezone="GMT",
            gateway_type="FILE_FSX_SMB",
            smb_active_directory_settings=aws.storagegateway.GatewaySmbActiveDirectorySettingsArgs(
                domain_name="corp.example.com",
                password="avoid-plaintext-passwords",
                username="Admin",
            ))
        ```
        <!--End PulumiCodeChooser -->

        ### S3 File Gateway

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.storagegateway.Gateway("example",
            gateway_ip_address="1.2.3.4",
            gateway_name="example",
            gateway_timezone="GMT",
            gateway_type="FILE_S3")
        ```
        <!--End PulumiCodeChooser -->

        ### Tape Gateway

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.storagegateway.Gateway("example",
            gateway_ip_address="1.2.3.4",
            gateway_name="example",
            gateway_timezone="GMT",
            gateway_type="VTL",
            medium_changer_type="AWS-Gateway-VTL",
            tape_drive_type="IBM-ULT3580-TD5")
        ```
        <!--End PulumiCodeChooser -->

        ### Volume Gateway (Cached)

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.storagegateway.Gateway("example",
            gateway_ip_address="1.2.3.4",
            gateway_name="example",
            gateway_timezone="GMT",
            gateway_type="CACHED")
        ```
        <!--End PulumiCodeChooser -->

        ### Volume Gateway (Stored)

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.storagegateway.Gateway("example",
            gateway_ip_address="1.2.3.4",
            gateway_name="example",
            gateway_timezone="GMT",
            gateway_type="STORED")
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import `aws_storagegateway_gateway` using the gateway Amazon Resource Name (ARN). For example:

        ```sh
        $ pulumi import aws:storagegateway/gateway:Gateway example arn:aws:storagegateway:us-east-1:123456789012:gateway/sgw-12345678
        ```
        Certain resource arguments, like `gateway_ip_address` do not have a Storage Gateway API method for reading the information after creation, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:

        :param str resource_name: The name of the resource.
        :param GatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activation_key: Optional[pulumi.Input[str]] = None,
                 average_download_rate_limit_in_bits_per_sec: Optional[pulumi.Input[int]] = None,
                 average_upload_rate_limit_in_bits_per_sec: Optional[pulumi.Input[int]] = None,
                 cloudwatch_log_group_arn: Optional[pulumi.Input[str]] = None,
                 gateway_ip_address: Optional[pulumi.Input[str]] = None,
                 gateway_name: Optional[pulumi.Input[str]] = None,
                 gateway_timezone: Optional[pulumi.Input[str]] = None,
                 gateway_type: Optional[pulumi.Input[str]] = None,
                 gateway_vpc_endpoint: Optional[pulumi.Input[str]] = None,
                 maintenance_start_time: Optional[pulumi.Input[pulumi.InputType['GatewayMaintenanceStartTimeArgs']]] = None,
                 medium_changer_type: Optional[pulumi.Input[str]] = None,
                 smb_active_directory_settings: Optional[pulumi.Input[pulumi.InputType['GatewaySmbActiveDirectorySettingsArgs']]] = None,
                 smb_file_share_visibility: Optional[pulumi.Input[bool]] = None,
                 smb_guest_password: Optional[pulumi.Input[str]] = None,
                 smb_security_strategy: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tape_drive_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GatewayArgs.__new__(GatewayArgs)

            __props__.__dict__["activation_key"] = activation_key
            __props__.__dict__["average_download_rate_limit_in_bits_per_sec"] = average_download_rate_limit_in_bits_per_sec
            __props__.__dict__["average_upload_rate_limit_in_bits_per_sec"] = average_upload_rate_limit_in_bits_per_sec
            __props__.__dict__["cloudwatch_log_group_arn"] = cloudwatch_log_group_arn
            __props__.__dict__["gateway_ip_address"] = gateway_ip_address
            if gateway_name is None and not opts.urn:
                raise TypeError("Missing required property 'gateway_name'")
            __props__.__dict__["gateway_name"] = gateway_name
            if gateway_timezone is None and not opts.urn:
                raise TypeError("Missing required property 'gateway_timezone'")
            __props__.__dict__["gateway_timezone"] = gateway_timezone
            __props__.__dict__["gateway_type"] = gateway_type
            __props__.__dict__["gateway_vpc_endpoint"] = gateway_vpc_endpoint
            __props__.__dict__["maintenance_start_time"] = maintenance_start_time
            __props__.__dict__["medium_changer_type"] = medium_changer_type
            __props__.__dict__["smb_active_directory_settings"] = smb_active_directory_settings
            __props__.__dict__["smb_file_share_visibility"] = smb_file_share_visibility
            __props__.__dict__["smb_guest_password"] = None if smb_guest_password is None else pulumi.Output.secret(smb_guest_password)
            __props__.__dict__["smb_security_strategy"] = smb_security_strategy
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tape_drive_type"] = tape_drive_type
            __props__.__dict__["arn"] = None
            __props__.__dict__["ec2_instance_id"] = None
            __props__.__dict__["endpoint_type"] = None
            __props__.__dict__["gateway_id"] = None
            __props__.__dict__["gateway_network_interfaces"] = None
            __props__.__dict__["host_environment"] = None
            __props__.__dict__["tags_all"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["smbGuestPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Gateway, __self__).__init__(
            'aws:storagegateway/gateway:Gateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activation_key: Optional[pulumi.Input[str]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            average_download_rate_limit_in_bits_per_sec: Optional[pulumi.Input[int]] = None,
            average_upload_rate_limit_in_bits_per_sec: Optional[pulumi.Input[int]] = None,
            cloudwatch_log_group_arn: Optional[pulumi.Input[str]] = None,
            ec2_instance_id: Optional[pulumi.Input[str]] = None,
            endpoint_type: Optional[pulumi.Input[str]] = None,
            gateway_id: Optional[pulumi.Input[str]] = None,
            gateway_ip_address: Optional[pulumi.Input[str]] = None,
            gateway_name: Optional[pulumi.Input[str]] = None,
            gateway_network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GatewayGatewayNetworkInterfaceArgs']]]]] = None,
            gateway_timezone: Optional[pulumi.Input[str]] = None,
            gateway_type: Optional[pulumi.Input[str]] = None,
            gateway_vpc_endpoint: Optional[pulumi.Input[str]] = None,
            host_environment: Optional[pulumi.Input[str]] = None,
            maintenance_start_time: Optional[pulumi.Input[pulumi.InputType['GatewayMaintenanceStartTimeArgs']]] = None,
            medium_changer_type: Optional[pulumi.Input[str]] = None,
            smb_active_directory_settings: Optional[pulumi.Input[pulumi.InputType['GatewaySmbActiveDirectorySettingsArgs']]] = None,
            smb_file_share_visibility: Optional[pulumi.Input[bool]] = None,
            smb_guest_password: Optional[pulumi.Input[str]] = None,
            smb_security_strategy: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tape_drive_type: Optional[pulumi.Input[str]] = None) -> 'Gateway':
        """
        Get an existing Gateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] activation_key: Gateway activation key during resource creation. Conflicts with `gateway_ip_address`. Additional information is available in the [Storage Gateway User Guide](https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html).
        :param pulumi.Input[str] arn: Amazon Resource Name (ARN) of the gateway.
        :param pulumi.Input[int] average_download_rate_limit_in_bits_per_sec: The average download bandwidth rate limit in bits per second. This is supported for the `CACHED`, `STORED`, and `VTL` gateway types.
        :param pulumi.Input[int] average_upload_rate_limit_in_bits_per_sec: The average upload bandwidth rate limit in bits per second. This is supported for the `CACHED`, `STORED`, and `VTL` gateway types.
        :param pulumi.Input[str] cloudwatch_log_group_arn: The Amazon Resource Name (ARN) of the Amazon CloudWatch log group to use to monitor and log events in the gateway.
        :param pulumi.Input[str] ec2_instance_id: The ID of the Amazon EC2 instance that was used to launch the gateway.
        :param pulumi.Input[str] endpoint_type: The type of endpoint for your gateway.
        :param pulumi.Input[str] gateway_id: Identifier of the gateway.
        :param pulumi.Input[str] gateway_ip_address: Gateway IP address to retrieve activation key during resource creation. Conflicts with `activation_key`. Gateway must be accessible on port 80 from where this provider is running. Additional information is available in the [Storage Gateway User Guide](https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html).
        :param pulumi.Input[str] gateway_name: Name of the gateway.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GatewayGatewayNetworkInterfaceArgs']]]] gateway_network_interfaces: An array that contains descriptions of the gateway network interfaces. See Gateway Network Interface.
        :param pulumi.Input[str] gateway_timezone: Time zone for the gateway. The time zone is of the format "GMT", "GMT-hr:mm", or "GMT+hr:mm". For example, `GMT-4:00` indicates the time is 4 hours behind GMT. The time zone is used, for example, for scheduling snapshots and your gateway's maintenance schedule.
        :param pulumi.Input[str] gateway_type: Type of the gateway. The default value is `STORED`. Valid values: `CACHED`, `FILE_FSX_SMB`, `FILE_S3`, `STORED`, `VTL`.
        :param pulumi.Input[str] gateway_vpc_endpoint: VPC endpoint address to be used when activating your gateway. This should be used when your instance is in a private subnet. Requires HTTP access from client computer running this provider. More info on what ports are required by your VPC Endpoint Security group in [Activating a Gateway in a Virtual Private Cloud](https://docs.aws.amazon.com/storagegateway/latest/userguide/gateway-private-link.html).
        :param pulumi.Input[str] host_environment: The type of hypervisor environment used by the host.
        :param pulumi.Input[pulumi.InputType['GatewayMaintenanceStartTimeArgs']] maintenance_start_time: The gateway's weekly maintenance start time information, including day and time of the week. The maintenance time is the time in your gateway's time zone. More details below.
        :param pulumi.Input[str] medium_changer_type: Type of medium changer to use for tape gateway. This provider cannot detect drift of this argument. Valid values: `STK-L700`, `AWS-Gateway-VTL`, `IBM-03584L32-0402`.
        :param pulumi.Input[pulumi.InputType['GatewaySmbActiveDirectorySettingsArgs']] smb_active_directory_settings: Nested argument with Active Directory domain join information for Server Message Block (SMB) file shares. Only valid for `FILE_S3` and `FILE_FSX_SMB` gateway types. Must be set before creating `ActiveDirectory` authentication SMB file shares. More details below.
        :param pulumi.Input[bool] smb_file_share_visibility: Specifies whether the shares on this gateway appear when listing shares.
        :param pulumi.Input[str] smb_guest_password: Guest password for Server Message Block (SMB) file shares. Only valid for `FILE_S3` and `FILE_FSX_SMB` gateway types. Must be set before creating `GuestAccess` authentication SMB file shares. This provider can only detect drift of the existence of a guest password, not its actual value from the gateway. This provider can however update the password with changing the argument.
        :param pulumi.Input[str] smb_security_strategy: Specifies the type of security strategy. Valid values are: `ClientSpecified`, `MandatorySigning`, and `MandatoryEncryption`. See [Setting a Security Level for Your Gateway](https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-gateway-file.html#security-strategy) for more information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] tape_drive_type: Type of tape drive to use for tape gateway. This provider cannot detect drift of this argument. Valid values: `IBM-ULT3580-TD5`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GatewayState.__new__(_GatewayState)

        __props__.__dict__["activation_key"] = activation_key
        __props__.__dict__["arn"] = arn
        __props__.__dict__["average_download_rate_limit_in_bits_per_sec"] = average_download_rate_limit_in_bits_per_sec
        __props__.__dict__["average_upload_rate_limit_in_bits_per_sec"] = average_upload_rate_limit_in_bits_per_sec
        __props__.__dict__["cloudwatch_log_group_arn"] = cloudwatch_log_group_arn
        __props__.__dict__["ec2_instance_id"] = ec2_instance_id
        __props__.__dict__["endpoint_type"] = endpoint_type
        __props__.__dict__["gateway_id"] = gateway_id
        __props__.__dict__["gateway_ip_address"] = gateway_ip_address
        __props__.__dict__["gateway_name"] = gateway_name
        __props__.__dict__["gateway_network_interfaces"] = gateway_network_interfaces
        __props__.__dict__["gateway_timezone"] = gateway_timezone
        __props__.__dict__["gateway_type"] = gateway_type
        __props__.__dict__["gateway_vpc_endpoint"] = gateway_vpc_endpoint
        __props__.__dict__["host_environment"] = host_environment
        __props__.__dict__["maintenance_start_time"] = maintenance_start_time
        __props__.__dict__["medium_changer_type"] = medium_changer_type
        __props__.__dict__["smb_active_directory_settings"] = smb_active_directory_settings
        __props__.__dict__["smb_file_share_visibility"] = smb_file_share_visibility
        __props__.__dict__["smb_guest_password"] = smb_guest_password
        __props__.__dict__["smb_security_strategy"] = smb_security_strategy
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["tape_drive_type"] = tape_drive_type
        return Gateway(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="activationKey")
    def activation_key(self) -> pulumi.Output[str]:
        """
        Gateway activation key during resource creation. Conflicts with `gateway_ip_address`. Additional information is available in the [Storage Gateway User Guide](https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html).
        """
        return pulumi.get(self, "activation_key")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        Amazon Resource Name (ARN) of the gateway.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="averageDownloadRateLimitInBitsPerSec")
    def average_download_rate_limit_in_bits_per_sec(self) -> pulumi.Output[Optional[int]]:
        """
        The average download bandwidth rate limit in bits per second. This is supported for the `CACHED`, `STORED`, and `VTL` gateway types.
        """
        return pulumi.get(self, "average_download_rate_limit_in_bits_per_sec")

    @property
    @pulumi.getter(name="averageUploadRateLimitInBitsPerSec")
    def average_upload_rate_limit_in_bits_per_sec(self) -> pulumi.Output[Optional[int]]:
        """
        The average upload bandwidth rate limit in bits per second. This is supported for the `CACHED`, `STORED`, and `VTL` gateway types.
        """
        return pulumi.get(self, "average_upload_rate_limit_in_bits_per_sec")

    @property
    @pulumi.getter(name="cloudwatchLogGroupArn")
    def cloudwatch_log_group_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon Resource Name (ARN) of the Amazon CloudWatch log group to use to monitor and log events in the gateway.
        """
        return pulumi.get(self, "cloudwatch_log_group_arn")

    @property
    @pulumi.getter(name="ec2InstanceId")
    def ec2_instance_id(self) -> pulumi.Output[str]:
        """
        The ID of the Amazon EC2 instance that was used to launch the gateway.
        """
        return pulumi.get(self, "ec2_instance_id")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Output[str]:
        """
        The type of endpoint for your gateway.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> pulumi.Output[str]:
        """
        Identifier of the gateway.
        """
        return pulumi.get(self, "gateway_id")

    @property
    @pulumi.getter(name="gatewayIpAddress")
    def gateway_ip_address(self) -> pulumi.Output[str]:
        """
        Gateway IP address to retrieve activation key during resource creation. Conflicts with `activation_key`. Gateway must be accessible on port 80 from where this provider is running. Additional information is available in the [Storage Gateway User Guide](https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html).
        """
        return pulumi.get(self, "gateway_ip_address")

    @property
    @pulumi.getter(name="gatewayName")
    def gateway_name(self) -> pulumi.Output[str]:
        """
        Name of the gateway.
        """
        return pulumi.get(self, "gateway_name")

    @property
    @pulumi.getter(name="gatewayNetworkInterfaces")
    def gateway_network_interfaces(self) -> pulumi.Output[Sequence['outputs.GatewayGatewayNetworkInterface']]:
        """
        An array that contains descriptions of the gateway network interfaces. See Gateway Network Interface.
        """
        return pulumi.get(self, "gateway_network_interfaces")

    @property
    @pulumi.getter(name="gatewayTimezone")
    def gateway_timezone(self) -> pulumi.Output[str]:
        """
        Time zone for the gateway. The time zone is of the format "GMT", "GMT-hr:mm", or "GMT+hr:mm". For example, `GMT-4:00` indicates the time is 4 hours behind GMT. The time zone is used, for example, for scheduling snapshots and your gateway's maintenance schedule.
        """
        return pulumi.get(self, "gateway_timezone")

    @property
    @pulumi.getter(name="gatewayType")
    def gateway_type(self) -> pulumi.Output[Optional[str]]:
        """
        Type of the gateway. The default value is `STORED`. Valid values: `CACHED`, `FILE_FSX_SMB`, `FILE_S3`, `STORED`, `VTL`.
        """
        return pulumi.get(self, "gateway_type")

    @property
    @pulumi.getter(name="gatewayVpcEndpoint")
    def gateway_vpc_endpoint(self) -> pulumi.Output[Optional[str]]:
        """
        VPC endpoint address to be used when activating your gateway. This should be used when your instance is in a private subnet. Requires HTTP access from client computer running this provider. More info on what ports are required by your VPC Endpoint Security group in [Activating a Gateway in a Virtual Private Cloud](https://docs.aws.amazon.com/storagegateway/latest/userguide/gateway-private-link.html).
        """
        return pulumi.get(self, "gateway_vpc_endpoint")

    @property
    @pulumi.getter(name="hostEnvironment")
    def host_environment(self) -> pulumi.Output[str]:
        """
        The type of hypervisor environment used by the host.
        """
        return pulumi.get(self, "host_environment")

    @property
    @pulumi.getter(name="maintenanceStartTime")
    def maintenance_start_time(self) -> pulumi.Output['outputs.GatewayMaintenanceStartTime']:
        """
        The gateway's weekly maintenance start time information, including day and time of the week. The maintenance time is the time in your gateway's time zone. More details below.
        """
        return pulumi.get(self, "maintenance_start_time")

    @property
    @pulumi.getter(name="mediumChangerType")
    def medium_changer_type(self) -> pulumi.Output[Optional[str]]:
        """
        Type of medium changer to use for tape gateway. This provider cannot detect drift of this argument. Valid values: `STK-L700`, `AWS-Gateway-VTL`, `IBM-03584L32-0402`.
        """
        return pulumi.get(self, "medium_changer_type")

    @property
    @pulumi.getter(name="smbActiveDirectorySettings")
    def smb_active_directory_settings(self) -> pulumi.Output[Optional['outputs.GatewaySmbActiveDirectorySettings']]:
        """
        Nested argument with Active Directory domain join information for Server Message Block (SMB) file shares. Only valid for `FILE_S3` and `FILE_FSX_SMB` gateway types. Must be set before creating `ActiveDirectory` authentication SMB file shares. More details below.
        """
        return pulumi.get(self, "smb_active_directory_settings")

    @property
    @pulumi.getter(name="smbFileShareVisibility")
    def smb_file_share_visibility(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether the shares on this gateway appear when listing shares.
        """
        return pulumi.get(self, "smb_file_share_visibility")

    @property
    @pulumi.getter(name="smbGuestPassword")
    def smb_guest_password(self) -> pulumi.Output[Optional[str]]:
        """
        Guest password for Server Message Block (SMB) file shares. Only valid for `FILE_S3` and `FILE_FSX_SMB` gateway types. Must be set before creating `GuestAccess` authentication SMB file shares. This provider can only detect drift of the existence of a guest password, not its actual value from the gateway. This provider can however update the password with changing the argument.
        """
        return pulumi.get(self, "smb_guest_password")

    @property
    @pulumi.getter(name="smbSecurityStrategy")
    def smb_security_strategy(self) -> pulumi.Output[str]:
        """
        Specifies the type of security strategy. Valid values are: `ClientSpecified`, `MandatorySigning`, and `MandatoryEncryption`. See [Setting a Security Level for Your Gateway](https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-gateway-file.html#security-strategy) for more information.
        """
        return pulumi.get(self, "smb_security_strategy")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="tapeDriveType")
    def tape_drive_type(self) -> pulumi.Output[Optional[str]]:
        """
        Type of tape drive to use for tape gateway. This provider cannot detect drift of this argument. Valid values: `IBM-ULT3580-TD5`.
        """
        return pulumi.get(self, "tape_drive_type")

