# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EndpointArgs', 'Endpoint']

@pulumi.input_type
class EndpointArgs:
    def __init__(__self__, *,
                 application_domain: pulumi.Input[str],
                 attachment_type: pulumi.Input[str],
                 domain_certificate_arn: pulumi.Input[str],
                 endpoint_domain_prefix: pulumi.Input[str],
                 endpoint_type: pulumi.Input[str],
                 verified_access_group_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 load_balancer_options: Optional[pulumi.Input['EndpointLoadBalancerOptionsArgs']] = None,
                 network_interface_options: Optional[pulumi.Input['EndpointNetworkInterfaceOptionsArgs']] = None,
                 policy_document: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sse_specification: Optional[pulumi.Input['EndpointSseSpecificationArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Endpoint resource.
        :param pulumi.Input[str] application_domain: The DNS name for users to reach your application.
        :param pulumi.Input[str] attachment_type: The type of attachment. Currently, only `vpc` is supported.
        :param pulumi.Input[str] domain_certificate_arn: The ARN of the public TLS/SSL certificate in AWS Certificate Manager to associate with the endpoint. The CN in the certificate must match the DNS name your end users will use to reach your application.
        :param pulumi.Input[str] endpoint_domain_prefix: A custom identifier that is prepended to the DNS name that is generated for the endpoint.
        :param pulumi.Input[str] endpoint_type: The type of Verified Access endpoint to create. Currently `load-balancer` or `network-interface` are supported.
        :param pulumi.Input[str] verified_access_group_id: The ID of the Verified Access group to associate the endpoint with.
               
               The following arguments are optional:
        :param pulumi.Input[str] description: A description for the Verified Access endpoint.
        :param pulumi.Input['EndpointLoadBalancerOptionsArgs'] load_balancer_options: The load balancer details. This parameter is required if the endpoint type is `load-balancer`.
        :param pulumi.Input['EndpointNetworkInterfaceOptionsArgs'] network_interface_options: The network interface details. This parameter is required if the endpoint type is `network-interface`.
        :param pulumi.Input[str] policy_document: The policy document that is associated with this resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: List of the the security groups IDs to associate with the Verified Access endpoint.
        :param pulumi.Input['EndpointSseSpecificationArgs'] sse_specification: The options in use for server side encryption.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value tags for the Verified Access Endpoint. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "application_domain", application_domain)
        pulumi.set(__self__, "attachment_type", attachment_type)
        pulumi.set(__self__, "domain_certificate_arn", domain_certificate_arn)
        pulumi.set(__self__, "endpoint_domain_prefix", endpoint_domain_prefix)
        pulumi.set(__self__, "endpoint_type", endpoint_type)
        pulumi.set(__self__, "verified_access_group_id", verified_access_group_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if load_balancer_options is not None:
            pulumi.set(__self__, "load_balancer_options", load_balancer_options)
        if network_interface_options is not None:
            pulumi.set(__self__, "network_interface_options", network_interface_options)
        if policy_document is not None:
            pulumi.set(__self__, "policy_document", policy_document)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if sse_specification is not None:
            pulumi.set(__self__, "sse_specification", sse_specification)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="applicationDomain")
    def application_domain(self) -> pulumi.Input[str]:
        """
        The DNS name for users to reach your application.
        """
        return pulumi.get(self, "application_domain")

    @application_domain.setter
    def application_domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "application_domain", value)

    @property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> pulumi.Input[str]:
        """
        The type of attachment. Currently, only `vpc` is supported.
        """
        return pulumi.get(self, "attachment_type")

    @attachment_type.setter
    def attachment_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "attachment_type", value)

    @property
    @pulumi.getter(name="domainCertificateArn")
    def domain_certificate_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the public TLS/SSL certificate in AWS Certificate Manager to associate with the endpoint. The CN in the certificate must match the DNS name your end users will use to reach your application.
        """
        return pulumi.get(self, "domain_certificate_arn")

    @domain_certificate_arn.setter
    def domain_certificate_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_certificate_arn", value)

    @property
    @pulumi.getter(name="endpointDomainPrefix")
    def endpoint_domain_prefix(self) -> pulumi.Input[str]:
        """
        A custom identifier that is prepended to the DNS name that is generated for the endpoint.
        """
        return pulumi.get(self, "endpoint_domain_prefix")

    @endpoint_domain_prefix.setter
    def endpoint_domain_prefix(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_domain_prefix", value)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Input[str]:
        """
        The type of Verified Access endpoint to create. Currently `load-balancer` or `network-interface` are supported.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="verifiedAccessGroupId")
    def verified_access_group_id(self) -> pulumi.Input[str]:
        """
        The ID of the Verified Access group to associate the endpoint with.

        The following arguments are optional:
        """
        return pulumi.get(self, "verified_access_group_id")

    @verified_access_group_id.setter
    def verified_access_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "verified_access_group_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description for the Verified Access endpoint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="loadBalancerOptions")
    def load_balancer_options(self) -> Optional[pulumi.Input['EndpointLoadBalancerOptionsArgs']]:
        """
        The load balancer details. This parameter is required if the endpoint type is `load-balancer`.
        """
        return pulumi.get(self, "load_balancer_options")

    @load_balancer_options.setter
    def load_balancer_options(self, value: Optional[pulumi.Input['EndpointLoadBalancerOptionsArgs']]):
        pulumi.set(self, "load_balancer_options", value)

    @property
    @pulumi.getter(name="networkInterfaceOptions")
    def network_interface_options(self) -> Optional[pulumi.Input['EndpointNetworkInterfaceOptionsArgs']]:
        """
        The network interface details. This parameter is required if the endpoint type is `network-interface`.
        """
        return pulumi.get(self, "network_interface_options")

    @network_interface_options.setter
    def network_interface_options(self, value: Optional[pulumi.Input['EndpointNetworkInterfaceOptionsArgs']]):
        pulumi.set(self, "network_interface_options", value)

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> Optional[pulumi.Input[str]]:
        """
        The policy document that is associated with this resource.
        """
        return pulumi.get(self, "policy_document")

    @policy_document.setter
    def policy_document(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_document", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of the the security groups IDs to associate with the Verified Access endpoint.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="sseSpecification")
    def sse_specification(self) -> Optional[pulumi.Input['EndpointSseSpecificationArgs']]:
        """
        The options in use for server side encryption.
        """
        return pulumi.get(self, "sse_specification")

    @sse_specification.setter
    def sse_specification(self, value: Optional[pulumi.Input['EndpointSseSpecificationArgs']]):
        pulumi.set(self, "sse_specification", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value tags for the Verified Access Endpoint. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _EndpointState:
    def __init__(__self__, *,
                 application_domain: Optional[pulumi.Input[str]] = None,
                 attachment_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_validation_domain: Optional[pulumi.Input[str]] = None,
                 domain_certificate_arn: Optional[pulumi.Input[str]] = None,
                 endpoint_domain: Optional[pulumi.Input[str]] = None,
                 endpoint_domain_prefix: Optional[pulumi.Input[str]] = None,
                 endpoint_type: Optional[pulumi.Input[str]] = None,
                 load_balancer_options: Optional[pulumi.Input['EndpointLoadBalancerOptionsArgs']] = None,
                 network_interface_options: Optional[pulumi.Input['EndpointNetworkInterfaceOptionsArgs']] = None,
                 policy_document: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sse_specification: Optional[pulumi.Input['EndpointSseSpecificationArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 verified_access_group_id: Optional[pulumi.Input[str]] = None,
                 verified_access_instance_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Endpoint resources.
        :param pulumi.Input[str] application_domain: The DNS name for users to reach your application.
        :param pulumi.Input[str] attachment_type: The type of attachment. Currently, only `vpc` is supported.
        :param pulumi.Input[str] description: A description for the Verified Access endpoint.
        :param pulumi.Input[str] device_validation_domain: Returned if endpoint has a device trust provider attached.
        :param pulumi.Input[str] domain_certificate_arn: The ARN of the public TLS/SSL certificate in AWS Certificate Manager to associate with the endpoint. The CN in the certificate must match the DNS name your end users will use to reach your application.
        :param pulumi.Input[str] endpoint_domain: A DNS name that is generated for the endpoint.
        :param pulumi.Input[str] endpoint_domain_prefix: A custom identifier that is prepended to the DNS name that is generated for the endpoint.
        :param pulumi.Input[str] endpoint_type: The type of Verified Access endpoint to create. Currently `load-balancer` or `network-interface` are supported.
        :param pulumi.Input['EndpointLoadBalancerOptionsArgs'] load_balancer_options: The load balancer details. This parameter is required if the endpoint type is `load-balancer`.
        :param pulumi.Input['EndpointNetworkInterfaceOptionsArgs'] network_interface_options: The network interface details. This parameter is required if the endpoint type is `network-interface`.
        :param pulumi.Input[str] policy_document: The policy document that is associated with this resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: List of the the security groups IDs to associate with the Verified Access endpoint.
        :param pulumi.Input['EndpointSseSpecificationArgs'] sse_specification: The options in use for server side encryption.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value tags for the Verified Access Endpoint. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] verified_access_group_id: The ID of the Verified Access group to associate the endpoint with.
               
               The following arguments are optional:
        """
        if application_domain is not None:
            pulumi.set(__self__, "application_domain", application_domain)
        if attachment_type is not None:
            pulumi.set(__self__, "attachment_type", attachment_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_validation_domain is not None:
            pulumi.set(__self__, "device_validation_domain", device_validation_domain)
        if domain_certificate_arn is not None:
            pulumi.set(__self__, "domain_certificate_arn", domain_certificate_arn)
        if endpoint_domain is not None:
            pulumi.set(__self__, "endpoint_domain", endpoint_domain)
        if endpoint_domain_prefix is not None:
            pulumi.set(__self__, "endpoint_domain_prefix", endpoint_domain_prefix)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)
        if load_balancer_options is not None:
            pulumi.set(__self__, "load_balancer_options", load_balancer_options)
        if network_interface_options is not None:
            pulumi.set(__self__, "network_interface_options", network_interface_options)
        if policy_document is not None:
            pulumi.set(__self__, "policy_document", policy_document)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if sse_specification is not None:
            pulumi.set(__self__, "sse_specification", sse_specification)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if verified_access_group_id is not None:
            pulumi.set(__self__, "verified_access_group_id", verified_access_group_id)
        if verified_access_instance_id is not None:
            pulumi.set(__self__, "verified_access_instance_id", verified_access_instance_id)

    @property
    @pulumi.getter(name="applicationDomain")
    def application_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The DNS name for users to reach your application.
        """
        return pulumi.get(self, "application_domain")

    @application_domain.setter
    def application_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_domain", value)

    @property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of attachment. Currently, only `vpc` is supported.
        """
        return pulumi.get(self, "attachment_type")

    @attachment_type.setter
    def attachment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attachment_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description for the Verified Access endpoint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceValidationDomain")
    def device_validation_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Returned if endpoint has a device trust provider attached.
        """
        return pulumi.get(self, "device_validation_domain")

    @device_validation_domain.setter
    def device_validation_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_validation_domain", value)

    @property
    @pulumi.getter(name="domainCertificateArn")
    def domain_certificate_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the public TLS/SSL certificate in AWS Certificate Manager to associate with the endpoint. The CN in the certificate must match the DNS name your end users will use to reach your application.
        """
        return pulumi.get(self, "domain_certificate_arn")

    @domain_certificate_arn.setter
    def domain_certificate_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_certificate_arn", value)

    @property
    @pulumi.getter(name="endpointDomain")
    def endpoint_domain(self) -> Optional[pulumi.Input[str]]:
        """
        A DNS name that is generated for the endpoint.
        """
        return pulumi.get(self, "endpoint_domain")

    @endpoint_domain.setter
    def endpoint_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_domain", value)

    @property
    @pulumi.getter(name="endpointDomainPrefix")
    def endpoint_domain_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        A custom identifier that is prepended to the DNS name that is generated for the endpoint.
        """
        return pulumi.get(self, "endpoint_domain_prefix")

    @endpoint_domain_prefix.setter
    def endpoint_domain_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_domain_prefix", value)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of Verified Access endpoint to create. Currently `load-balancer` or `network-interface` are supported.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="loadBalancerOptions")
    def load_balancer_options(self) -> Optional[pulumi.Input['EndpointLoadBalancerOptionsArgs']]:
        """
        The load balancer details. This parameter is required if the endpoint type is `load-balancer`.
        """
        return pulumi.get(self, "load_balancer_options")

    @load_balancer_options.setter
    def load_balancer_options(self, value: Optional[pulumi.Input['EndpointLoadBalancerOptionsArgs']]):
        pulumi.set(self, "load_balancer_options", value)

    @property
    @pulumi.getter(name="networkInterfaceOptions")
    def network_interface_options(self) -> Optional[pulumi.Input['EndpointNetworkInterfaceOptionsArgs']]:
        """
        The network interface details. This parameter is required if the endpoint type is `network-interface`.
        """
        return pulumi.get(self, "network_interface_options")

    @network_interface_options.setter
    def network_interface_options(self, value: Optional[pulumi.Input['EndpointNetworkInterfaceOptionsArgs']]):
        pulumi.set(self, "network_interface_options", value)

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> Optional[pulumi.Input[str]]:
        """
        The policy document that is associated with this resource.
        """
        return pulumi.get(self, "policy_document")

    @policy_document.setter
    def policy_document(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_document", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of the the security groups IDs to associate with the Verified Access endpoint.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="sseSpecification")
    def sse_specification(self) -> Optional[pulumi.Input['EndpointSseSpecificationArgs']]:
        """
        The options in use for server side encryption.
        """
        return pulumi.get(self, "sse_specification")

    @sse_specification.setter
    def sse_specification(self, value: Optional[pulumi.Input['EndpointSseSpecificationArgs']]):
        pulumi.set(self, "sse_specification", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value tags for the Verified Access Endpoint. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="verifiedAccessGroupId")
    def verified_access_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Verified Access group to associate the endpoint with.

        The following arguments are optional:
        """
        return pulumi.get(self, "verified_access_group_id")

    @verified_access_group_id.setter
    def verified_access_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "verified_access_group_id", value)

    @property
    @pulumi.getter(name="verifiedAccessInstanceId")
    def verified_access_instance_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "verified_access_instance_id")

    @verified_access_instance_id.setter
    def verified_access_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "verified_access_instance_id", value)


class Endpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_domain: Optional[pulumi.Input[str]] = None,
                 attachment_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 domain_certificate_arn: Optional[pulumi.Input[str]] = None,
                 endpoint_domain_prefix: Optional[pulumi.Input[str]] = None,
                 endpoint_type: Optional[pulumi.Input[str]] = None,
                 load_balancer_options: Optional[pulumi.Input[pulumi.InputType['EndpointLoadBalancerOptionsArgs']]] = None,
                 network_interface_options: Optional[pulumi.Input[pulumi.InputType['EndpointNetworkInterfaceOptionsArgs']]] = None,
                 policy_document: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sse_specification: Optional[pulumi.Input[pulumi.InputType['EndpointSseSpecificationArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 verified_access_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS EC2 (Elastic Compute Cloud) Verified Access Endpoint.

        ## Example Usage

        ### ALB Example

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.verifiedaccess.Endpoint("example",
            application_domain="example.com",
            attachment_type="vpc",
            description="example",
            domain_certificate_arn=example_aws_acm_certificate["arn"],
            endpoint_domain_prefix="example",
            endpoint_type="load-balancer",
            load_balancer_options=aws.verifiedaccess.EndpointLoadBalancerOptionsArgs(
                load_balancer_arn=example_aws_lb["arn"],
                port=443,
                protocol="https",
                subnet_ids=[subnet["id"] for subnet in public],
            ),
            security_group_ids=[example_aws_security_group["id"]],
            verified_access_group_id=example_aws_verifiedaccess_group["id"])
        ```
        <!--End PulumiCodeChooser -->

        ### Network Interface Example

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.verifiedaccess.Endpoint("example",
            application_domain="example.com",
            attachment_type="vpc",
            description="example",
            domain_certificate_arn=example_aws_acm_certificate["arn"],
            endpoint_domain_prefix="example",
            endpoint_type="network-interface",
            network_interface_options=aws.verifiedaccess.EndpointNetworkInterfaceOptionsArgs(
                network_interface_id=example_aws_network_interface["id"],
                port=443,
                protocol="https",
            ),
            security_group_ids=[example_aws_security_group["id"]],
            verified_access_group_id=example_aws_verifiedaccess_group["id"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Verified Access Instances using the  `id`. For example:

        ```sh
        $ pulumi import aws:verifiedaccess/endpoint:Endpoint example vae-8012925589
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_domain: The DNS name for users to reach your application.
        :param pulumi.Input[str] attachment_type: The type of attachment. Currently, only `vpc` is supported.
        :param pulumi.Input[str] description: A description for the Verified Access endpoint.
        :param pulumi.Input[str] domain_certificate_arn: The ARN of the public TLS/SSL certificate in AWS Certificate Manager to associate with the endpoint. The CN in the certificate must match the DNS name your end users will use to reach your application.
        :param pulumi.Input[str] endpoint_domain_prefix: A custom identifier that is prepended to the DNS name that is generated for the endpoint.
        :param pulumi.Input[str] endpoint_type: The type of Verified Access endpoint to create. Currently `load-balancer` or `network-interface` are supported.
        :param pulumi.Input[pulumi.InputType['EndpointLoadBalancerOptionsArgs']] load_balancer_options: The load balancer details. This parameter is required if the endpoint type is `load-balancer`.
        :param pulumi.Input[pulumi.InputType['EndpointNetworkInterfaceOptionsArgs']] network_interface_options: The network interface details. This parameter is required if the endpoint type is `network-interface`.
        :param pulumi.Input[str] policy_document: The policy document that is associated with this resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: List of the the security groups IDs to associate with the Verified Access endpoint.
        :param pulumi.Input[pulumi.InputType['EndpointSseSpecificationArgs']] sse_specification: The options in use for server side encryption.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value tags for the Verified Access Endpoint. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] verified_access_group_id: The ID of the Verified Access group to associate the endpoint with.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS EC2 (Elastic Compute Cloud) Verified Access Endpoint.

        ## Example Usage

        ### ALB Example

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.verifiedaccess.Endpoint("example",
            application_domain="example.com",
            attachment_type="vpc",
            description="example",
            domain_certificate_arn=example_aws_acm_certificate["arn"],
            endpoint_domain_prefix="example",
            endpoint_type="load-balancer",
            load_balancer_options=aws.verifiedaccess.EndpointLoadBalancerOptionsArgs(
                load_balancer_arn=example_aws_lb["arn"],
                port=443,
                protocol="https",
                subnet_ids=[subnet["id"] for subnet in public],
            ),
            security_group_ids=[example_aws_security_group["id"]],
            verified_access_group_id=example_aws_verifiedaccess_group["id"])
        ```
        <!--End PulumiCodeChooser -->

        ### Network Interface Example

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.verifiedaccess.Endpoint("example",
            application_domain="example.com",
            attachment_type="vpc",
            description="example",
            domain_certificate_arn=example_aws_acm_certificate["arn"],
            endpoint_domain_prefix="example",
            endpoint_type="network-interface",
            network_interface_options=aws.verifiedaccess.EndpointNetworkInterfaceOptionsArgs(
                network_interface_id=example_aws_network_interface["id"],
                port=443,
                protocol="https",
            ),
            security_group_ids=[example_aws_security_group["id"]],
            verified_access_group_id=example_aws_verifiedaccess_group["id"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Using `pulumi import`, import Verified Access Instances using the  `id`. For example:

        ```sh
        $ pulumi import aws:verifiedaccess/endpoint:Endpoint example vae-8012925589
        ```

        :param str resource_name: The name of the resource.
        :param EndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_domain: Optional[pulumi.Input[str]] = None,
                 attachment_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 domain_certificate_arn: Optional[pulumi.Input[str]] = None,
                 endpoint_domain_prefix: Optional[pulumi.Input[str]] = None,
                 endpoint_type: Optional[pulumi.Input[str]] = None,
                 load_balancer_options: Optional[pulumi.Input[pulumi.InputType['EndpointLoadBalancerOptionsArgs']]] = None,
                 network_interface_options: Optional[pulumi.Input[pulumi.InputType['EndpointNetworkInterfaceOptionsArgs']]] = None,
                 policy_document: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sse_specification: Optional[pulumi.Input[pulumi.InputType['EndpointSseSpecificationArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 verified_access_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EndpointArgs.__new__(EndpointArgs)

            if application_domain is None and not opts.urn:
                raise TypeError("Missing required property 'application_domain'")
            __props__.__dict__["application_domain"] = application_domain
            if attachment_type is None and not opts.urn:
                raise TypeError("Missing required property 'attachment_type'")
            __props__.__dict__["attachment_type"] = attachment_type
            __props__.__dict__["description"] = description
            if domain_certificate_arn is None and not opts.urn:
                raise TypeError("Missing required property 'domain_certificate_arn'")
            __props__.__dict__["domain_certificate_arn"] = domain_certificate_arn
            if endpoint_domain_prefix is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_domain_prefix'")
            __props__.__dict__["endpoint_domain_prefix"] = endpoint_domain_prefix
            if endpoint_type is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_type'")
            __props__.__dict__["endpoint_type"] = endpoint_type
            __props__.__dict__["load_balancer_options"] = load_balancer_options
            __props__.__dict__["network_interface_options"] = network_interface_options
            __props__.__dict__["policy_document"] = policy_document
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["sse_specification"] = sse_specification
            __props__.__dict__["tags"] = tags
            if verified_access_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'verified_access_group_id'")
            __props__.__dict__["verified_access_group_id"] = verified_access_group_id
            __props__.__dict__["device_validation_domain"] = None
            __props__.__dict__["endpoint_domain"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["verified_access_instance_id"] = None
        super(Endpoint, __self__).__init__(
            'aws:verifiedaccess/endpoint:Endpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_domain: Optional[pulumi.Input[str]] = None,
            attachment_type: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            device_validation_domain: Optional[pulumi.Input[str]] = None,
            domain_certificate_arn: Optional[pulumi.Input[str]] = None,
            endpoint_domain: Optional[pulumi.Input[str]] = None,
            endpoint_domain_prefix: Optional[pulumi.Input[str]] = None,
            endpoint_type: Optional[pulumi.Input[str]] = None,
            load_balancer_options: Optional[pulumi.Input[pulumi.InputType['EndpointLoadBalancerOptionsArgs']]] = None,
            network_interface_options: Optional[pulumi.Input[pulumi.InputType['EndpointNetworkInterfaceOptionsArgs']]] = None,
            policy_document: Optional[pulumi.Input[str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            sse_specification: Optional[pulumi.Input[pulumi.InputType['EndpointSseSpecificationArgs']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            verified_access_group_id: Optional[pulumi.Input[str]] = None,
            verified_access_instance_id: Optional[pulumi.Input[str]] = None) -> 'Endpoint':
        """
        Get an existing Endpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_domain: The DNS name for users to reach your application.
        :param pulumi.Input[str] attachment_type: The type of attachment. Currently, only `vpc` is supported.
        :param pulumi.Input[str] description: A description for the Verified Access endpoint.
        :param pulumi.Input[str] device_validation_domain: Returned if endpoint has a device trust provider attached.
        :param pulumi.Input[str] domain_certificate_arn: The ARN of the public TLS/SSL certificate in AWS Certificate Manager to associate with the endpoint. The CN in the certificate must match the DNS name your end users will use to reach your application.
        :param pulumi.Input[str] endpoint_domain: A DNS name that is generated for the endpoint.
        :param pulumi.Input[str] endpoint_domain_prefix: A custom identifier that is prepended to the DNS name that is generated for the endpoint.
        :param pulumi.Input[str] endpoint_type: The type of Verified Access endpoint to create. Currently `load-balancer` or `network-interface` are supported.
        :param pulumi.Input[pulumi.InputType['EndpointLoadBalancerOptionsArgs']] load_balancer_options: The load balancer details. This parameter is required if the endpoint type is `load-balancer`.
        :param pulumi.Input[pulumi.InputType['EndpointNetworkInterfaceOptionsArgs']] network_interface_options: The network interface details. This parameter is required if the endpoint type is `network-interface`.
        :param pulumi.Input[str] policy_document: The policy document that is associated with this resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: List of the the security groups IDs to associate with the Verified Access endpoint.
        :param pulumi.Input[pulumi.InputType['EndpointSseSpecificationArgs']] sse_specification: The options in use for server side encryption.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value tags for the Verified Access Endpoint. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] verified_access_group_id: The ID of the Verified Access group to associate the endpoint with.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EndpointState.__new__(_EndpointState)

        __props__.__dict__["application_domain"] = application_domain
        __props__.__dict__["attachment_type"] = attachment_type
        __props__.__dict__["description"] = description
        __props__.__dict__["device_validation_domain"] = device_validation_domain
        __props__.__dict__["domain_certificate_arn"] = domain_certificate_arn
        __props__.__dict__["endpoint_domain"] = endpoint_domain
        __props__.__dict__["endpoint_domain_prefix"] = endpoint_domain_prefix
        __props__.__dict__["endpoint_type"] = endpoint_type
        __props__.__dict__["load_balancer_options"] = load_balancer_options
        __props__.__dict__["network_interface_options"] = network_interface_options
        __props__.__dict__["policy_document"] = policy_document
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["sse_specification"] = sse_specification
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["verified_access_group_id"] = verified_access_group_id
        __props__.__dict__["verified_access_instance_id"] = verified_access_instance_id
        return Endpoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationDomain")
    def application_domain(self) -> pulumi.Output[str]:
        """
        The DNS name for users to reach your application.
        """
        return pulumi.get(self, "application_domain")

    @property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> pulumi.Output[str]:
        """
        The type of attachment. Currently, only `vpc` is supported.
        """
        return pulumi.get(self, "attachment_type")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description for the Verified Access endpoint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceValidationDomain")
    def device_validation_domain(self) -> pulumi.Output[str]:
        """
        Returned if endpoint has a device trust provider attached.
        """
        return pulumi.get(self, "device_validation_domain")

    @property
    @pulumi.getter(name="domainCertificateArn")
    def domain_certificate_arn(self) -> pulumi.Output[str]:
        """
        The ARN of the public TLS/SSL certificate in AWS Certificate Manager to associate with the endpoint. The CN in the certificate must match the DNS name your end users will use to reach your application.
        """
        return pulumi.get(self, "domain_certificate_arn")

    @property
    @pulumi.getter(name="endpointDomain")
    def endpoint_domain(self) -> pulumi.Output[str]:
        """
        A DNS name that is generated for the endpoint.
        """
        return pulumi.get(self, "endpoint_domain")

    @property
    @pulumi.getter(name="endpointDomainPrefix")
    def endpoint_domain_prefix(self) -> pulumi.Output[str]:
        """
        A custom identifier that is prepended to the DNS name that is generated for the endpoint.
        """
        return pulumi.get(self, "endpoint_domain_prefix")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Output[str]:
        """
        The type of Verified Access endpoint to create. Currently `load-balancer` or `network-interface` are supported.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="loadBalancerOptions")
    def load_balancer_options(self) -> pulumi.Output[Optional['outputs.EndpointLoadBalancerOptions']]:
        """
        The load balancer details. This parameter is required if the endpoint type is `load-balancer`.
        """
        return pulumi.get(self, "load_balancer_options")

    @property
    @pulumi.getter(name="networkInterfaceOptions")
    def network_interface_options(self) -> pulumi.Output[Optional['outputs.EndpointNetworkInterfaceOptions']]:
        """
        The network interface details. This parameter is required if the endpoint type is `network-interface`.
        """
        return pulumi.get(self, "network_interface_options")

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> pulumi.Output[Optional[str]]:
        """
        The policy document that is associated with this resource.
        """
        return pulumi.get(self, "policy_document")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of the the security groups IDs to associate with the Verified Access endpoint.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="sseSpecification")
    def sse_specification(self) -> pulumi.Output['outputs.EndpointSseSpecification']:
        """
        The options in use for server side encryption.
        """
        return pulumi.get(self, "sse_specification")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Key-value tags for the Verified Access Endpoint. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
        pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")

        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="verifiedAccessGroupId")
    def verified_access_group_id(self) -> pulumi.Output[str]:
        """
        The ID of the Verified Access group to associate the endpoint with.

        The following arguments are optional:
        """
        return pulumi.get(self, "verified_access_group_id")

    @property
    @pulumi.getter(name="verifiedAccessInstanceId")
    def verified_access_instance_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "verified_access_instance_id")

