# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TargetGroupAttachmentArgs', 'TargetGroupAttachment']

@pulumi.input_type
class TargetGroupAttachmentArgs:
    def __init__(__self__, *,
                 target: pulumi.Input['TargetGroupAttachmentTargetArgs'],
                 target_group_identifier: pulumi.Input[str]):
        """
        The set of arguments for constructing a TargetGroupAttachment resource.
        :param pulumi.Input['TargetGroupAttachmentTargetArgs'] target: The target.
        :param pulumi.Input[str] target_group_identifier: The ID or Amazon Resource Name (ARN) of the target group.
        """
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "target_group_identifier", target_group_identifier)

    @property
    @pulumi.getter
    def target(self) -> pulumi.Input['TargetGroupAttachmentTargetArgs']:
        """
        The target.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: pulumi.Input['TargetGroupAttachmentTargetArgs']):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter(name="targetGroupIdentifier")
    def target_group_identifier(self) -> pulumi.Input[str]:
        """
        The ID or Amazon Resource Name (ARN) of the target group.
        """
        return pulumi.get(self, "target_group_identifier")

    @target_group_identifier.setter
    def target_group_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_group_identifier", value)


@pulumi.input_type
class _TargetGroupAttachmentState:
    def __init__(__self__, *,
                 target: Optional[pulumi.Input['TargetGroupAttachmentTargetArgs']] = None,
                 target_group_identifier: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TargetGroupAttachment resources.
        :param pulumi.Input['TargetGroupAttachmentTargetArgs'] target: The target.
        :param pulumi.Input[str] target_group_identifier: The ID or Amazon Resource Name (ARN) of the target group.
        """
        if target is not None:
            pulumi.set(__self__, "target", target)
        if target_group_identifier is not None:
            pulumi.set(__self__, "target_group_identifier", target_group_identifier)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input['TargetGroupAttachmentTargetArgs']]:
        """
        The target.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input['TargetGroupAttachmentTargetArgs']]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter(name="targetGroupIdentifier")
    def target_group_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The ID or Amazon Resource Name (ARN) of the target group.
        """
        return pulumi.get(self, "target_group_identifier")

    @target_group_identifier.setter
    def target_group_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_group_identifier", value)


class TargetGroupAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 target: Optional[pulumi.Input[pulumi.InputType['TargetGroupAttachmentTargetArgs']]] = None,
                 target_group_identifier: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides the ability to register a target with an AWS VPC Lattice Target Group.

        ## Example Usage

        ### Basic Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.vpclattice.TargetGroupAttachment("example",
            target_group_identifier=example_aws_vpclattice_target_group["id"],
            target=aws.vpclattice.TargetGroupAttachmentTargetArgs(
                id=example_aws_lb["arn"],
                port=80,
            ))
        ```
        <!--End PulumiCodeChooser -->

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['TargetGroupAttachmentTargetArgs']] target: The target.
        :param pulumi.Input[str] target_group_identifier: The ID or Amazon Resource Name (ARN) of the target group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TargetGroupAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides the ability to register a target with an AWS VPC Lattice Target Group.

        ## Example Usage

        ### Basic Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.vpclattice.TargetGroupAttachment("example",
            target_group_identifier=example_aws_vpclattice_target_group["id"],
            target=aws.vpclattice.TargetGroupAttachmentTargetArgs(
                id=example_aws_lb["arn"],
                port=80,
            ))
        ```
        <!--End PulumiCodeChooser -->

        :param str resource_name: The name of the resource.
        :param TargetGroupAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TargetGroupAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 target: Optional[pulumi.Input[pulumi.InputType['TargetGroupAttachmentTargetArgs']]] = None,
                 target_group_identifier: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TargetGroupAttachmentArgs.__new__(TargetGroupAttachmentArgs)

            if target is None and not opts.urn:
                raise TypeError("Missing required property 'target'")
            __props__.__dict__["target"] = target
            if target_group_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'target_group_identifier'")
            __props__.__dict__["target_group_identifier"] = target_group_identifier
        super(TargetGroupAttachment, __self__).__init__(
            'aws:vpclattice/targetGroupAttachment:TargetGroupAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            target: Optional[pulumi.Input[pulumi.InputType['TargetGroupAttachmentTargetArgs']]] = None,
            target_group_identifier: Optional[pulumi.Input[str]] = None) -> 'TargetGroupAttachment':
        """
        Get an existing TargetGroupAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['TargetGroupAttachmentTargetArgs']] target: The target.
        :param pulumi.Input[str] target_group_identifier: The ID or Amazon Resource Name (ARN) of the target group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TargetGroupAttachmentState.__new__(_TargetGroupAttachmentState)

        __props__.__dict__["target"] = target
        __props__.__dict__["target_group_identifier"] = target_group_identifier
        return TargetGroupAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def target(self) -> pulumi.Output['outputs.TargetGroupAttachmentTarget']:
        """
        The target.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter(name="targetGroupIdentifier")
    def target_group_identifier(self) -> pulumi.Output[str]:
        """
        The ID or Amazon Resource Name (ARN) of the target group.
        """
        return pulumi.get(self, "target_group_identifier")

