"""
depth_search_graph_opeani example
"""
import os
from dotenv import load_dotenv
from scrapegraphai.graphs import DepthSearchGraph

load_dotenv()

together_key = os.getenv("TOGETHER_APIKEY")

graph_config = {
    "llm": {
        "model": "togetherai/meta-llama/Meta-Llama-3.1-8B-Instruct-Turbo",
        "api_key": together_key,
    },
    "verbose": True,
    "headless": False,
    "depth": 2,
    "only_inside_links": False,
}

search_graph = DepthSearchGraph(
    prompt="List me all the projects with their description",
    source="https://perinim.github.io",
    config=graph_config
)

result = search_graph.run()
print(result)
