# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc
import warnings

from . import operations_pb2 as operations__pb2

GRPC_GENERATED_VERSION = '1.74.0'
GRPC_VERSION = grpc.__version__
_version_not_supported = False

try:
    from grpc._utilities import first_version_is_lower
    _version_not_supported = first_version_is_lower(GRPC_VERSION, GRPC_GENERATED_VERSION)
except ImportError:
    _version_not_supported = True

if _version_not_supported:
    raise RuntimeError(
        f'The grpc package installed is at version {GRPC_VERSION},'
        + f' but the generated code in operations_pb2_grpc.py depends on'
        + f' grpcio>={GRPC_GENERATED_VERSION}.'
        + f' Please upgrade your grpc module to grpcio>={GRPC_GENERATED_VERSION}'
        + f' or downgrade your generated code using grpcio-tools<={GRPC_VERSION}.'
    )


class OperationServiceStub(object):
    """OperationService provides an interface for performing mutating git
    operations on a repository on behalf of a user. The user's operation is
    treated as untrusted. Any reference update is thus checked against GitLab's
    '/allowed' endpoint.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.UserCreateBranch = channel.unary_unary(
                '/gitaly.OperationService/UserCreateBranch',
                request_serializer=operations__pb2.UserCreateBranchRequest.SerializeToString,
                response_deserializer=operations__pb2.UserCreateBranchResponse.FromString,
                _registered_method=True)
        self.UserUpdateBranch = channel.unary_unary(
                '/gitaly.OperationService/UserUpdateBranch',
                request_serializer=operations__pb2.UserUpdateBranchRequest.SerializeToString,
                response_deserializer=operations__pb2.UserUpdateBranchResponse.FromString,
                _registered_method=True)
        self.UserDeleteBranch = channel.unary_unary(
                '/gitaly.OperationService/UserDeleteBranch',
                request_serializer=operations__pb2.UserDeleteBranchRequest.SerializeToString,
                response_deserializer=operations__pb2.UserDeleteBranchResponse.FromString,
                _registered_method=True)
        self.UserCreateTag = channel.unary_unary(
                '/gitaly.OperationService/UserCreateTag',
                request_serializer=operations__pb2.UserCreateTagRequest.SerializeToString,
                response_deserializer=operations__pb2.UserCreateTagResponse.FromString,
                _registered_method=True)
        self.UserDeleteTag = channel.unary_unary(
                '/gitaly.OperationService/UserDeleteTag',
                request_serializer=operations__pb2.UserDeleteTagRequest.SerializeToString,
                response_deserializer=operations__pb2.UserDeleteTagResponse.FromString,
                _registered_method=True)
        self.UserMergeToRef = channel.unary_unary(
                '/gitaly.OperationService/UserMergeToRef',
                request_serializer=operations__pb2.UserMergeToRefRequest.SerializeToString,
                response_deserializer=operations__pb2.UserMergeToRefResponse.FromString,
                _registered_method=True)
        self.UserRebaseToRef = channel.unary_unary(
                '/gitaly.OperationService/UserRebaseToRef',
                request_serializer=operations__pb2.UserRebaseToRefRequest.SerializeToString,
                response_deserializer=operations__pb2.UserRebaseToRefResponse.FromString,
                _registered_method=True)
        self.UserMergeBranch = channel.stream_stream(
                '/gitaly.OperationService/UserMergeBranch',
                request_serializer=operations__pb2.UserMergeBranchRequest.SerializeToString,
                response_deserializer=operations__pb2.UserMergeBranchResponse.FromString,
                _registered_method=True)
        self.UserFFBranch = channel.unary_unary(
                '/gitaly.OperationService/UserFFBranch',
                request_serializer=operations__pb2.UserFFBranchRequest.SerializeToString,
                response_deserializer=operations__pb2.UserFFBranchResponse.FromString,
                _registered_method=True)
        self.UserCherryPick = channel.unary_unary(
                '/gitaly.OperationService/UserCherryPick',
                request_serializer=operations__pb2.UserCherryPickRequest.SerializeToString,
                response_deserializer=operations__pb2.UserCherryPickResponse.FromString,
                _registered_method=True)
        self.UserCommitFiles = channel.stream_unary(
                '/gitaly.OperationService/UserCommitFiles',
                request_serializer=operations__pb2.UserCommitFilesRequest.SerializeToString,
                response_deserializer=operations__pb2.UserCommitFilesResponse.FromString,
                _registered_method=True)
        self.UserRebaseConfirmable = channel.stream_stream(
                '/gitaly.OperationService/UserRebaseConfirmable',
                request_serializer=operations__pb2.UserRebaseConfirmableRequest.SerializeToString,
                response_deserializer=operations__pb2.UserRebaseConfirmableResponse.FromString,
                _registered_method=True)
        self.UserRevert = channel.unary_unary(
                '/gitaly.OperationService/UserRevert',
                request_serializer=operations__pb2.UserRevertRequest.SerializeToString,
                response_deserializer=operations__pb2.UserRevertResponse.FromString,
                _registered_method=True)
        self.UserSquash = channel.unary_unary(
                '/gitaly.OperationService/UserSquash',
                request_serializer=operations__pb2.UserSquashRequest.SerializeToString,
                response_deserializer=operations__pb2.UserSquashResponse.FromString,
                _registered_method=True)
        self.UserApplyPatch = channel.stream_unary(
                '/gitaly.OperationService/UserApplyPatch',
                request_serializer=operations__pb2.UserApplyPatchRequest.SerializeToString,
                response_deserializer=operations__pb2.UserApplyPatchResponse.FromString,
                _registered_method=True)
        self.UserUpdateSubmodule = channel.unary_unary(
                '/gitaly.OperationService/UserUpdateSubmodule',
                request_serializer=operations__pb2.UserUpdateSubmoduleRequest.SerializeToString,
                response_deserializer=operations__pb2.UserUpdateSubmoduleResponse.FromString,
                _registered_method=True)


class OperationServiceServicer(object):
    """OperationService provides an interface for performing mutating git
    operations on a repository on behalf of a user. The user's operation is
    treated as untrusted. Any reference update is thus checked against GitLab's
    '/allowed' endpoint.
    """

    def UserCreateBranch(self, request, context):
        """UserCreateBranch creates a single branch in the context of a specific user. It executes
        hooks and contacts Rails to verify that the user is allowed to create the branch. The
        following known error conditions may happen:

        - `FailedPrecondition` if the Git revision provided in start_point can't be found or updated.
        - `InvalidArgument` if the commit ID resolved from the start_point can't be parsed.
        - `PermissionDenied` with an embedded `UserCreateBranchError` if any custom hooks return a
        non-zero exit code.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def UserUpdateBranch(self, request, context):
        """UserUpdateBranch updates a branch to point to a new revision. It executes hooks and
        contacts Rails to verify that the user is allowed to update the branch. The following
        known error conditions may happen:

        - `InvalidArgument` if any of the request fields can't be validated.
        - `Internal` if the newrev or oldrev are invalid in the context of the repository.
        - `UserUpdateBranchResponse` with the `PreReceiveError` field set, if any custom hooks
        return a non-zero exit code.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def UserDeleteBranch(self, request, context):
        """UserDeleteBranch force-deletes a single branch in the context of a specific user. It executes
        hooks and contacts Rails to verify that the user is indeed allowed to delete that branch. The
        following known error conditions may happen:

        - Returns `InvalidArgument` in case either the branch name or user are not set.
        - Returns `FailedPrecondition` in case the branch does not exist.
        - Returns `OK` with a `PreReceiveError` in case custom hooks refused the update. If the
        `gitaly_user_delete_branch_structured_errors` feature flag is enabled this error case will
        instead return `PermissionDenied` with either a `CustomHook` or AccessCheck` structured
        error.
        - Returns `FailedPrecondition` in case updating the reference fails because
        of a concurrent write to the same reference. If the
        `gitaly_user_delete_branch_structured_errors` feature flag is set this error case will
        instead return `FailedPrecondition` with a `ReferenceUpdate` structured error.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def UserCreateTag(self, request, context):
        """UserCreateTag creates a new tag. This RPC knows to create both lightweight and annotated tags
        depending on whether a message is set.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def UserDeleteTag(self, request, context):
        """UserDeleteTag deletes an existing tag. It executes hooks and contacts Rails to verify that
        the user is allowed to delete the tag. The following known error conditions may happen:

        - `InvalidArgument` if the repository, tag_name, user, or expected_old_oid (if provided)
        are invalid.
        - `FailedPrecondition` if the tag_name can't be found, or the ref couldn't be deleted due
        to a concurrent write to the same ref.
        - `Internal` if the tag_name can't be resolved or an unknown error occurs.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def UserMergeToRef(self, request, context):
        """UserMergeToRef creates a merge commit and updates target_ref to point to that
        new commit. The first parent of the merge commit (the main line) is taken
        from first_parent_ref. The second parent is specified by its commit ID in source_sha.
        If target_ref already exists it will be overwritten.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def UserRebaseToRef(self, request, context):
        """UserRebaseToRef rebases source_sha on top of first_parent_ref and updates
        target_ref to point to that new commit. If target_ref already exists, then
        it will be overwritten. This operation is intended to be used on internal
        refs (e.g. refs/merge-requests/*) and does not call hooks.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def UserMergeBranch(self, request_iterator, context):
        """UserMergeBranch tries to merge the given commit into the target branch.
        The merge commit is created with the given user as author/committer and
        the given message.

        This is a two-stage RPC that requires confirmation to make user-visible
        changes to the repository:
        - The first request contains details about the requested merge, which
        will result in a response with the created merge commit ID.
        - The second request should set `apply = true` to apply the merge.

        After the second request, it executes hooks and contacts Rails to verify
        that the user is allowed to update the branch. The following known error
        conditions may happen:

        - `InvalidArgument` if request fields can't be validated or resolved.
        - `NotFound` if the branch can't be found.
        - `FailedPrecondition` if there are merge conflicts, if the merge is
        aborted by setting `apply = false` in the second request, or if the
        merge fails due to a concurrent write to the same ref.
        - `PermissionDenied` if the user doesn't have permissions to merge a branch.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def UserFFBranch(self, request, context):
        """UserFFBranch tries to perform a fast-forward merge of a given commit into
        the given branch. If the merge is not a fast-forward merge, the request
        will fail. The RPC will return an empty response in case updating the
        reference fails e.g. because of a race.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def UserCherryPick(self, request, context):
        """UserCherryPick tries to perform a cherry-pick of a given commit onto a
        branch.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def UserCommitFiles(self, request_iterator, context):
        """UserCommitFiles builds a commit from a stream of actions and updates the target branch to point to it.
        userCommitFilesRequest with a UserCommitFilesRequestHeader must be sent as the first message of the stream.
        Following that, a variable number of actions can be sent to build a new commit. Each action consists of
        a header followed by content if used by the action.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def UserRebaseConfirmable(self, request_iterator, context):
        """UserRebaseConfirmable rebases the given remote branch onto a target
        branch. The remote branch may be part of another repository.

        This RPC requires confirmation to make any user-visible changes to the
        repository. The first request sent shall contains details about the
        requested rebase, which will result in a response with the created rebase
        commit ID. Only if a second message with `apply = true` is sent will the
        rebase be applied.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def UserRevert(self, request, context):
        """UserRevert tries to perform a revert of a given commit onto a branch.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def UserSquash(self, request, context):
        """UserSquash squashes a range of commits into a single commit. If
        successful, it returns the object ID of the newly created squash commit.
        On error, it returns a gRPC error. Some specific errors will have an
        embedded UserSquashError such that clients can deduce what exactly has
        failed.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def UserApplyPatch(self, request_iterator, context):
        """UserApplyPatch applies patches to a given branch.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def UserUpdateSubmodule(self, request, context):
        """UserUpdateSubmodule updates a submodule to point to a new commit.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_OperationServiceServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'UserCreateBranch': grpc.unary_unary_rpc_method_handler(
                    servicer.UserCreateBranch,
                    request_deserializer=operations__pb2.UserCreateBranchRequest.FromString,
                    response_serializer=operations__pb2.UserCreateBranchResponse.SerializeToString,
            ),
            'UserUpdateBranch': grpc.unary_unary_rpc_method_handler(
                    servicer.UserUpdateBranch,
                    request_deserializer=operations__pb2.UserUpdateBranchRequest.FromString,
                    response_serializer=operations__pb2.UserUpdateBranchResponse.SerializeToString,
            ),
            'UserDeleteBranch': grpc.unary_unary_rpc_method_handler(
                    servicer.UserDeleteBranch,
                    request_deserializer=operations__pb2.UserDeleteBranchRequest.FromString,
                    response_serializer=operations__pb2.UserDeleteBranchResponse.SerializeToString,
            ),
            'UserCreateTag': grpc.unary_unary_rpc_method_handler(
                    servicer.UserCreateTag,
                    request_deserializer=operations__pb2.UserCreateTagRequest.FromString,
                    response_serializer=operations__pb2.UserCreateTagResponse.SerializeToString,
            ),
            'UserDeleteTag': grpc.unary_unary_rpc_method_handler(
                    servicer.UserDeleteTag,
                    request_deserializer=operations__pb2.UserDeleteTagRequest.FromString,
                    response_serializer=operations__pb2.UserDeleteTagResponse.SerializeToString,
            ),
            'UserMergeToRef': grpc.unary_unary_rpc_method_handler(
                    servicer.UserMergeToRef,
                    request_deserializer=operations__pb2.UserMergeToRefRequest.FromString,
                    response_serializer=operations__pb2.UserMergeToRefResponse.SerializeToString,
            ),
            'UserRebaseToRef': grpc.unary_unary_rpc_method_handler(
                    servicer.UserRebaseToRef,
                    request_deserializer=operations__pb2.UserRebaseToRefRequest.FromString,
                    response_serializer=operations__pb2.UserRebaseToRefResponse.SerializeToString,
            ),
            'UserMergeBranch': grpc.stream_stream_rpc_method_handler(
                    servicer.UserMergeBranch,
                    request_deserializer=operations__pb2.UserMergeBranchRequest.FromString,
                    response_serializer=operations__pb2.UserMergeBranchResponse.SerializeToString,
            ),
            'UserFFBranch': grpc.unary_unary_rpc_method_handler(
                    servicer.UserFFBranch,
                    request_deserializer=operations__pb2.UserFFBranchRequest.FromString,
                    response_serializer=operations__pb2.UserFFBranchResponse.SerializeToString,
            ),
            'UserCherryPick': grpc.unary_unary_rpc_method_handler(
                    servicer.UserCherryPick,
                    request_deserializer=operations__pb2.UserCherryPickRequest.FromString,
                    response_serializer=operations__pb2.UserCherryPickResponse.SerializeToString,
            ),
            'UserCommitFiles': grpc.stream_unary_rpc_method_handler(
                    servicer.UserCommitFiles,
                    request_deserializer=operations__pb2.UserCommitFilesRequest.FromString,
                    response_serializer=operations__pb2.UserCommitFilesResponse.SerializeToString,
            ),
            'UserRebaseConfirmable': grpc.stream_stream_rpc_method_handler(
                    servicer.UserRebaseConfirmable,
                    request_deserializer=operations__pb2.UserRebaseConfirmableRequest.FromString,
                    response_serializer=operations__pb2.UserRebaseConfirmableResponse.SerializeToString,
            ),
            'UserRevert': grpc.unary_unary_rpc_method_handler(
                    servicer.UserRevert,
                    request_deserializer=operations__pb2.UserRevertRequest.FromString,
                    response_serializer=operations__pb2.UserRevertResponse.SerializeToString,
            ),
            'UserSquash': grpc.unary_unary_rpc_method_handler(
                    servicer.UserSquash,
                    request_deserializer=operations__pb2.UserSquashRequest.FromString,
                    response_serializer=operations__pb2.UserSquashResponse.SerializeToString,
            ),
            'UserApplyPatch': grpc.stream_unary_rpc_method_handler(
                    servicer.UserApplyPatch,
                    request_deserializer=operations__pb2.UserApplyPatchRequest.FromString,
                    response_serializer=operations__pb2.UserApplyPatchResponse.SerializeToString,
            ),
            'UserUpdateSubmodule': grpc.unary_unary_rpc_method_handler(
                    servicer.UserUpdateSubmodule,
                    request_deserializer=operations__pb2.UserUpdateSubmoduleRequest.FromString,
                    response_serializer=operations__pb2.UserUpdateSubmoduleResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'gitaly.OperationService', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))
    server.add_registered_method_handlers('gitaly.OperationService', rpc_method_handlers)


 # This class is part of an EXPERIMENTAL API.
class OperationService(object):
    """OperationService provides an interface for performing mutating git
    operations on a repository on behalf of a user. The user's operation is
    treated as untrusted. Any reference update is thus checked against GitLab's
    '/allowed' endpoint.
    """

    @staticmethod
    def UserCreateBranch(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.OperationService/UserCreateBranch',
            operations__pb2.UserCreateBranchRequest.SerializeToString,
            operations__pb2.UserCreateBranchResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def UserUpdateBranch(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.OperationService/UserUpdateBranch',
            operations__pb2.UserUpdateBranchRequest.SerializeToString,
            operations__pb2.UserUpdateBranchResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def UserDeleteBranch(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.OperationService/UserDeleteBranch',
            operations__pb2.UserDeleteBranchRequest.SerializeToString,
            operations__pb2.UserDeleteBranchResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def UserCreateTag(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.OperationService/UserCreateTag',
            operations__pb2.UserCreateTagRequest.SerializeToString,
            operations__pb2.UserCreateTagResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def UserDeleteTag(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.OperationService/UserDeleteTag',
            operations__pb2.UserDeleteTagRequest.SerializeToString,
            operations__pb2.UserDeleteTagResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def UserMergeToRef(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.OperationService/UserMergeToRef',
            operations__pb2.UserMergeToRefRequest.SerializeToString,
            operations__pb2.UserMergeToRefResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def UserRebaseToRef(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.OperationService/UserRebaseToRef',
            operations__pb2.UserRebaseToRefRequest.SerializeToString,
            operations__pb2.UserRebaseToRefResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def UserMergeBranch(request_iterator,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.stream_stream(
            request_iterator,
            target,
            '/gitaly.OperationService/UserMergeBranch',
            operations__pb2.UserMergeBranchRequest.SerializeToString,
            operations__pb2.UserMergeBranchResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def UserFFBranch(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.OperationService/UserFFBranch',
            operations__pb2.UserFFBranchRequest.SerializeToString,
            operations__pb2.UserFFBranchResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def UserCherryPick(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.OperationService/UserCherryPick',
            operations__pb2.UserCherryPickRequest.SerializeToString,
            operations__pb2.UserCherryPickResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def UserCommitFiles(request_iterator,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.stream_unary(
            request_iterator,
            target,
            '/gitaly.OperationService/UserCommitFiles',
            operations__pb2.UserCommitFilesRequest.SerializeToString,
            operations__pb2.UserCommitFilesResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def UserRebaseConfirmable(request_iterator,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.stream_stream(
            request_iterator,
            target,
            '/gitaly.OperationService/UserRebaseConfirmable',
            operations__pb2.UserRebaseConfirmableRequest.SerializeToString,
            operations__pb2.UserRebaseConfirmableResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def UserRevert(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.OperationService/UserRevert',
            operations__pb2.UserRevertRequest.SerializeToString,
            operations__pb2.UserRevertResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def UserSquash(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.OperationService/UserSquash',
            operations__pb2.UserSquashRequest.SerializeToString,
            operations__pb2.UserSquashResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def UserApplyPatch(request_iterator,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.stream_unary(
            request_iterator,
            target,
            '/gitaly.OperationService/UserApplyPatch',
            operations__pb2.UserApplyPatchRequest.SerializeToString,
            operations__pb2.UserApplyPatchResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def UserUpdateSubmodule(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.OperationService/UserUpdateSubmodule',
            operations__pb2.UserUpdateSubmoduleRequest.SerializeToString,
            operations__pb2.UserUpdateSubmoduleResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)
