# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc
import warnings

from . import ref_pb2 as ref__pb2

GRPC_GENERATED_VERSION = '1.74.0'
GRPC_VERSION = grpc.__version__
_version_not_supported = False

try:
    from grpc._utilities import first_version_is_lower
    _version_not_supported = first_version_is_lower(GRPC_VERSION, GRPC_GENERATED_VERSION)
except ImportError:
    _version_not_supported = True

if _version_not_supported:
    raise RuntimeError(
        f'The grpc package installed is at version {GRPC_VERSION},'
        + f' but the generated code in ref_pb2_grpc.py depends on'
        + f' grpcio>={GRPC_GENERATED_VERSION}.'
        + f' Please upgrade your grpc module to grpcio>={GRPC_GENERATED_VERSION}'
        + f' or downgrade your generated code using grpcio-tools<={GRPC_VERSION}.'
    )


class RefServiceStub(object):
    """RefService is a service that provides RPCs to list and modify Git references.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.FindDefaultBranchName = channel.unary_unary(
                '/gitaly.RefService/FindDefaultBranchName',
                request_serializer=ref__pb2.FindDefaultBranchNameRequest.SerializeToString,
                response_deserializer=ref__pb2.FindDefaultBranchNameResponse.FromString,
                _registered_method=True)
        self.FindLocalBranches = channel.unary_stream(
                '/gitaly.RefService/FindLocalBranches',
                request_serializer=ref__pb2.FindLocalBranchesRequest.SerializeToString,
                response_deserializer=ref__pb2.FindLocalBranchesResponse.FromString,
                _registered_method=True)
        self.FindAllBranches = channel.unary_stream(
                '/gitaly.RefService/FindAllBranches',
                request_serializer=ref__pb2.FindAllBranchesRequest.SerializeToString,
                response_deserializer=ref__pb2.FindAllBranchesResponse.FromString,
                _registered_method=True)
        self.FindAllTags = channel.unary_stream(
                '/gitaly.RefService/FindAllTags',
                request_serializer=ref__pb2.FindAllTagsRequest.SerializeToString,
                response_deserializer=ref__pb2.FindAllTagsResponse.FromString,
                _registered_method=True)
        self.FindTag = channel.unary_unary(
                '/gitaly.RefService/FindTag',
                request_serializer=ref__pb2.FindTagRequest.SerializeToString,
                response_deserializer=ref__pb2.FindTagResponse.FromString,
                _registered_method=True)
        self.FindAllRemoteBranches = channel.unary_stream(
                '/gitaly.RefService/FindAllRemoteBranches',
                request_serializer=ref__pb2.FindAllRemoteBranchesRequest.SerializeToString,
                response_deserializer=ref__pb2.FindAllRemoteBranchesResponse.FromString,
                _registered_method=True)
        self.RefExists = channel.unary_unary(
                '/gitaly.RefService/RefExists',
                request_serializer=ref__pb2.RefExistsRequest.SerializeToString,
                response_deserializer=ref__pb2.RefExistsResponse.FromString,
                _registered_method=True)
        self.FindBranch = channel.unary_unary(
                '/gitaly.RefService/FindBranch',
                request_serializer=ref__pb2.FindBranchRequest.SerializeToString,
                response_deserializer=ref__pb2.FindBranchResponse.FromString,
                _registered_method=True)
        self.UpdateReferences = channel.stream_unary(
                '/gitaly.RefService/UpdateReferences',
                request_serializer=ref__pb2.UpdateReferencesRequest.SerializeToString,
                response_deserializer=ref__pb2.UpdateReferencesResponse.FromString,
                _registered_method=True)
        self.DeleteRefs = channel.unary_unary(
                '/gitaly.RefService/DeleteRefs',
                request_serializer=ref__pb2.DeleteRefsRequest.SerializeToString,
                response_deserializer=ref__pb2.DeleteRefsResponse.FromString,
                _registered_method=True)
        self.ListBranchNamesContainingCommit = channel.unary_stream(
                '/gitaly.RefService/ListBranchNamesContainingCommit',
                request_serializer=ref__pb2.ListBranchNamesContainingCommitRequest.SerializeToString,
                response_deserializer=ref__pb2.ListBranchNamesContainingCommitResponse.FromString,
                _registered_method=True)
        self.ListTagNamesContainingCommit = channel.unary_stream(
                '/gitaly.RefService/ListTagNamesContainingCommit',
                request_serializer=ref__pb2.ListTagNamesContainingCommitRequest.SerializeToString,
                response_deserializer=ref__pb2.ListTagNamesContainingCommitResponse.FromString,
                _registered_method=True)
        self.GetTagSignatures = channel.unary_stream(
                '/gitaly.RefService/GetTagSignatures',
                request_serializer=ref__pb2.GetTagSignaturesRequest.SerializeToString,
                response_deserializer=ref__pb2.GetTagSignaturesResponse.FromString,
                _registered_method=True)
        self.GetTagMessages = channel.unary_stream(
                '/gitaly.RefService/GetTagMessages',
                request_serializer=ref__pb2.GetTagMessagesRequest.SerializeToString,
                response_deserializer=ref__pb2.GetTagMessagesResponse.FromString,
                _registered_method=True)
        self.ListRefs = channel.unary_stream(
                '/gitaly.RefService/ListRefs',
                request_serializer=ref__pb2.ListRefsRequest.SerializeToString,
                response_deserializer=ref__pb2.ListRefsResponse.FromString,
                _registered_method=True)
        self.FindRefsByOID = channel.unary_unary(
                '/gitaly.RefService/FindRefsByOID',
                request_serializer=ref__pb2.FindRefsByOIDRequest.SerializeToString,
                response_deserializer=ref__pb2.FindRefsByOIDResponse.FromString,
                _registered_method=True)


class RefServiceServicer(object):
    """RefService is a service that provides RPCs to list and modify Git references.
    """

    def FindDefaultBranchName(self, request, context):
        """FindDefaultBranchName looks up the default branch reference name. Unless
        otherwise specified the following heuristic is used:

        1. If there are no branches, return an empty string.
        2. If there is only one branch, return the only branch.
        3. If a branch exists that matches HEAD, return the HEAD reference name.
        4. If a branch exists named refs/heads/main, return refs/heads/main.
        5. If a branch exists named refs/heads/master, return refs/heads/master.
        6. Return the first branch (as per default ordering by git).
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def FindLocalBranches(self, request, context):
        """FindLocalBranches finds all the local branches under `refs/heads/` for the specified repository.
        The response is streamed back to the client to divide the list of branches into chunks.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def FindAllBranches(self, request, context):
        """FindAllBranches finds all branches under `refs/heads/` and `refs/remotes/` for the specified repository.
        The response is streamed back to the client to divide the list of branches into chunks.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def FindAllTags(self, request, context):
        """FindAllTags finds all tags under `refs/tags/` for the specified repository.
        The response is streamed back to the client to divide the list of tags into chunks.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def FindTag(self, request, context):
        """FindTag looks up a tag by its name and returns it to the caller if it exists. This RPC supports
        both lightweight and annotated tags. Note: this RPC returns an `Internal` error if the tag was
        not found.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def FindAllRemoteBranches(self, request, context):
        """FindAllRemoteBranches finds all the remote branches under `refs/remotes/` for the specified repository.
        The response is streamed back to the client to divide the list of branches into chunks.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def RefExists(self, request, context):
        """RefExists checks if the specified reference exists. The reference must be fully qualified.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def FindBranch(self, request, context):
        """FindBranch finds a branch by its unqualified name (like "master") and
        returns the commit it currently points to.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def UpdateReferences(self, request_iterator, context):
        """UpdateReferences atomically updates a set of references to a new state. This RPC allows creating
        new references, deleting old references and updating existing references in a raceless way.

        Updating symbolic references with this RPC is not allowed.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def DeleteRefs(self, request, context):
        """DeleteRefs deletes the specified references from its repository. Attempting to delete an
        non-existent reference does not result in an error. It is recommended to instead use the
        UpdateReferences RPC because it can delete references in a raceless manner via the expected old
        object ID.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListBranchNamesContainingCommit(self, request, context):
        """ListBranchNamesContainingCommit finds all branches under `refs/heads/` that contain the specified commit.
        The response is streamed back to the client to divide the list of branches into chunks.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListTagNamesContainingCommit(self, request, context):
        """ListTagNamesContainingCommit finds all tags under `refs/tags/` that contain the specified commit.
        The response is streamed back to the client to divide the list of tags into chunks.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetTagSignatures(self, request, context):
        """GetTagSignatures returns signatures for annotated tags resolved from a set of revisions. Revisions
        which don't resolve to an annotated tag are silently discarded. Revisions which cannot be resolved
        result in an error. Tags which are annotated but not signed will return a TagSignature response
        which has no signature, but its unsigned contents will still be returned.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetTagMessages(self, request, context):
        """GetTagMessages returns tag messages for the annotated tags identified via the given revisions.
        The response is streamed back to the client with a response message containing the tag ID
        always preceding one or more messages containing the tag message contents. This is repeated for
        all tags in the response.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListRefs(self, request, context):
        """ListRefs returns a stream of all references in the repository. By default, pseudo-revisions like HEAD
        will not be returned by this RPC. Any symbolic references will be resolved to the object ID it is
        pointing at.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def FindRefsByOID(self, request, context):
        """FindRefsByOID returns an array of fully qualified reference names that point to an object ID.
        It returns nothing if the object ID doesn't exist, or doesn't point to
        any branches or tags. Prefixes can be also be used as the object ID.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_RefServiceServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'FindDefaultBranchName': grpc.unary_unary_rpc_method_handler(
                    servicer.FindDefaultBranchName,
                    request_deserializer=ref__pb2.FindDefaultBranchNameRequest.FromString,
                    response_serializer=ref__pb2.FindDefaultBranchNameResponse.SerializeToString,
            ),
            'FindLocalBranches': grpc.unary_stream_rpc_method_handler(
                    servicer.FindLocalBranches,
                    request_deserializer=ref__pb2.FindLocalBranchesRequest.FromString,
                    response_serializer=ref__pb2.FindLocalBranchesResponse.SerializeToString,
            ),
            'FindAllBranches': grpc.unary_stream_rpc_method_handler(
                    servicer.FindAllBranches,
                    request_deserializer=ref__pb2.FindAllBranchesRequest.FromString,
                    response_serializer=ref__pb2.FindAllBranchesResponse.SerializeToString,
            ),
            'FindAllTags': grpc.unary_stream_rpc_method_handler(
                    servicer.FindAllTags,
                    request_deserializer=ref__pb2.FindAllTagsRequest.FromString,
                    response_serializer=ref__pb2.FindAllTagsResponse.SerializeToString,
            ),
            'FindTag': grpc.unary_unary_rpc_method_handler(
                    servicer.FindTag,
                    request_deserializer=ref__pb2.FindTagRequest.FromString,
                    response_serializer=ref__pb2.FindTagResponse.SerializeToString,
            ),
            'FindAllRemoteBranches': grpc.unary_stream_rpc_method_handler(
                    servicer.FindAllRemoteBranches,
                    request_deserializer=ref__pb2.FindAllRemoteBranchesRequest.FromString,
                    response_serializer=ref__pb2.FindAllRemoteBranchesResponse.SerializeToString,
            ),
            'RefExists': grpc.unary_unary_rpc_method_handler(
                    servicer.RefExists,
                    request_deserializer=ref__pb2.RefExistsRequest.FromString,
                    response_serializer=ref__pb2.RefExistsResponse.SerializeToString,
            ),
            'FindBranch': grpc.unary_unary_rpc_method_handler(
                    servicer.FindBranch,
                    request_deserializer=ref__pb2.FindBranchRequest.FromString,
                    response_serializer=ref__pb2.FindBranchResponse.SerializeToString,
            ),
            'UpdateReferences': grpc.stream_unary_rpc_method_handler(
                    servicer.UpdateReferences,
                    request_deserializer=ref__pb2.UpdateReferencesRequest.FromString,
                    response_serializer=ref__pb2.UpdateReferencesResponse.SerializeToString,
            ),
            'DeleteRefs': grpc.unary_unary_rpc_method_handler(
                    servicer.DeleteRefs,
                    request_deserializer=ref__pb2.DeleteRefsRequest.FromString,
                    response_serializer=ref__pb2.DeleteRefsResponse.SerializeToString,
            ),
            'ListBranchNamesContainingCommit': grpc.unary_stream_rpc_method_handler(
                    servicer.ListBranchNamesContainingCommit,
                    request_deserializer=ref__pb2.ListBranchNamesContainingCommitRequest.FromString,
                    response_serializer=ref__pb2.ListBranchNamesContainingCommitResponse.SerializeToString,
            ),
            'ListTagNamesContainingCommit': grpc.unary_stream_rpc_method_handler(
                    servicer.ListTagNamesContainingCommit,
                    request_deserializer=ref__pb2.ListTagNamesContainingCommitRequest.FromString,
                    response_serializer=ref__pb2.ListTagNamesContainingCommitResponse.SerializeToString,
            ),
            'GetTagSignatures': grpc.unary_stream_rpc_method_handler(
                    servicer.GetTagSignatures,
                    request_deserializer=ref__pb2.GetTagSignaturesRequest.FromString,
                    response_serializer=ref__pb2.GetTagSignaturesResponse.SerializeToString,
            ),
            'GetTagMessages': grpc.unary_stream_rpc_method_handler(
                    servicer.GetTagMessages,
                    request_deserializer=ref__pb2.GetTagMessagesRequest.FromString,
                    response_serializer=ref__pb2.GetTagMessagesResponse.SerializeToString,
            ),
            'ListRefs': grpc.unary_stream_rpc_method_handler(
                    servicer.ListRefs,
                    request_deserializer=ref__pb2.ListRefsRequest.FromString,
                    response_serializer=ref__pb2.ListRefsResponse.SerializeToString,
            ),
            'FindRefsByOID': grpc.unary_unary_rpc_method_handler(
                    servicer.FindRefsByOID,
                    request_deserializer=ref__pb2.FindRefsByOIDRequest.FromString,
                    response_serializer=ref__pb2.FindRefsByOIDResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'gitaly.RefService', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))
    server.add_registered_method_handlers('gitaly.RefService', rpc_method_handlers)


 # This class is part of an EXPERIMENTAL API.
class RefService(object):
    """RefService is a service that provides RPCs to list and modify Git references.
    """

    @staticmethod
    def FindDefaultBranchName(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RefService/FindDefaultBranchName',
            ref__pb2.FindDefaultBranchNameRequest.SerializeToString,
            ref__pb2.FindDefaultBranchNameResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def FindLocalBranches(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.RefService/FindLocalBranches',
            ref__pb2.FindLocalBranchesRequest.SerializeToString,
            ref__pb2.FindLocalBranchesResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def FindAllBranches(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.RefService/FindAllBranches',
            ref__pb2.FindAllBranchesRequest.SerializeToString,
            ref__pb2.FindAllBranchesResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def FindAllTags(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.RefService/FindAllTags',
            ref__pb2.FindAllTagsRequest.SerializeToString,
            ref__pb2.FindAllTagsResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def FindTag(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RefService/FindTag',
            ref__pb2.FindTagRequest.SerializeToString,
            ref__pb2.FindTagResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def FindAllRemoteBranches(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.RefService/FindAllRemoteBranches',
            ref__pb2.FindAllRemoteBranchesRequest.SerializeToString,
            ref__pb2.FindAllRemoteBranchesResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def RefExists(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RefService/RefExists',
            ref__pb2.RefExistsRequest.SerializeToString,
            ref__pb2.RefExistsResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def FindBranch(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RefService/FindBranch',
            ref__pb2.FindBranchRequest.SerializeToString,
            ref__pb2.FindBranchResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def UpdateReferences(request_iterator,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.stream_unary(
            request_iterator,
            target,
            '/gitaly.RefService/UpdateReferences',
            ref__pb2.UpdateReferencesRequest.SerializeToString,
            ref__pb2.UpdateReferencesResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def DeleteRefs(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RefService/DeleteRefs',
            ref__pb2.DeleteRefsRequest.SerializeToString,
            ref__pb2.DeleteRefsResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ListBranchNamesContainingCommit(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.RefService/ListBranchNamesContainingCommit',
            ref__pb2.ListBranchNamesContainingCommitRequest.SerializeToString,
            ref__pb2.ListBranchNamesContainingCommitResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ListTagNamesContainingCommit(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.RefService/ListTagNamesContainingCommit',
            ref__pb2.ListTagNamesContainingCommitRequest.SerializeToString,
            ref__pb2.ListTagNamesContainingCommitResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetTagSignatures(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.RefService/GetTagSignatures',
            ref__pb2.GetTagSignaturesRequest.SerializeToString,
            ref__pb2.GetTagSignaturesResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetTagMessages(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.RefService/GetTagMessages',
            ref__pb2.GetTagMessagesRequest.SerializeToString,
            ref__pb2.GetTagMessagesResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ListRefs(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.RefService/ListRefs',
            ref__pb2.ListRefsRequest.SerializeToString,
            ref__pb2.ListRefsResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def FindRefsByOID(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RefService/FindRefsByOID',
            ref__pb2.FindRefsByOIDRequest.SerializeToString,
            ref__pb2.FindRefsByOIDResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)
