# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc
import warnings

from . import repository_pb2 as repository__pb2

GRPC_GENERATED_VERSION = '1.74.0'
GRPC_VERSION = grpc.__version__
_version_not_supported = False

try:
    from grpc._utilities import first_version_is_lower
    _version_not_supported = first_version_is_lower(GRPC_VERSION, GRPC_GENERATED_VERSION)
except ImportError:
    _version_not_supported = True

if _version_not_supported:
    raise RuntimeError(
        f'The grpc package installed is at version {GRPC_VERSION},'
        + f' but the generated code in repository_pb2_grpc.py depends on'
        + f' grpcio>={GRPC_GENERATED_VERSION}.'
        + f' Please upgrade your grpc module to grpcio>={GRPC_GENERATED_VERSION}'
        + f' or downgrade your generated code using grpcio-tools<={GRPC_VERSION}.'
    )


class RepositoryServiceStub(object):
    """RepositoryService is a service providing RPCs accessing repositories as a whole.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.RepositoryExists = channel.unary_unary(
                '/gitaly.RepositoryService/RepositoryExists',
                request_serializer=repository__pb2.RepositoryExistsRequest.SerializeToString,
                response_deserializer=repository__pb2.RepositoryExistsResponse.FromString,
                _registered_method=True)
        self.RepositorySize = channel.unary_unary(
                '/gitaly.RepositoryService/RepositorySize',
                request_serializer=repository__pb2.RepositorySizeRequest.SerializeToString,
                response_deserializer=repository__pb2.RepositorySizeResponse.FromString,
                _registered_method=True)
        self.RepositoryInfo = channel.unary_unary(
                '/gitaly.RepositoryService/RepositoryInfo',
                request_serializer=repository__pb2.RepositoryInfoRequest.SerializeToString,
                response_deserializer=repository__pb2.RepositoryInfoResponse.FromString,
                _registered_method=True)
        self.ObjectsSize = channel.stream_unary(
                '/gitaly.RepositoryService/ObjectsSize',
                request_serializer=repository__pb2.ObjectsSizeRequest.SerializeToString,
                response_deserializer=repository__pb2.ObjectsSizeResponse.FromString,
                _registered_method=True)
        self.ObjectFormat = channel.unary_unary(
                '/gitaly.RepositoryService/ObjectFormat',
                request_serializer=repository__pb2.ObjectFormatRequest.SerializeToString,
                response_deserializer=repository__pb2.ObjectFormatResponse.FromString,
                _registered_method=True)
        self.FetchRemote = channel.unary_unary(
                '/gitaly.RepositoryService/FetchRemote',
                request_serializer=repository__pb2.FetchRemoteRequest.SerializeToString,
                response_deserializer=repository__pb2.FetchRemoteResponse.FromString,
                _registered_method=True)
        self.CreateRepository = channel.unary_unary(
                '/gitaly.RepositoryService/CreateRepository',
                request_serializer=repository__pb2.CreateRepositoryRequest.SerializeToString,
                response_deserializer=repository__pb2.CreateRepositoryResponse.FromString,
                _registered_method=True)
        self.GetArchive = channel.unary_stream(
                '/gitaly.RepositoryService/GetArchive',
                request_serializer=repository__pb2.GetArchiveRequest.SerializeToString,
                response_deserializer=repository__pb2.GetArchiveResponse.FromString,
                _registered_method=True)
        self.HasLocalBranches = channel.unary_unary(
                '/gitaly.RepositoryService/HasLocalBranches',
                request_serializer=repository__pb2.HasLocalBranchesRequest.SerializeToString,
                response_deserializer=repository__pb2.HasLocalBranchesResponse.FromString,
                _registered_method=True)
        self.FetchSourceBranch = channel.unary_unary(
                '/gitaly.RepositoryService/FetchSourceBranch',
                request_serializer=repository__pb2.FetchSourceBranchRequest.SerializeToString,
                response_deserializer=repository__pb2.FetchSourceBranchResponse.FromString,
                _registered_method=True)
        self.Fsck = channel.unary_unary(
                '/gitaly.RepositoryService/Fsck',
                request_serializer=repository__pb2.FsckRequest.SerializeToString,
                response_deserializer=repository__pb2.FsckResponse.FromString,
                _registered_method=True)
        self.WriteRef = channel.unary_unary(
                '/gitaly.RepositoryService/WriteRef',
                request_serializer=repository__pb2.WriteRefRequest.SerializeToString,
                response_deserializer=repository__pb2.WriteRefResponse.FromString,
                _registered_method=True)
        self.FindMergeBase = channel.unary_unary(
                '/gitaly.RepositoryService/FindMergeBase',
                request_serializer=repository__pb2.FindMergeBaseRequest.SerializeToString,
                response_deserializer=repository__pb2.FindMergeBaseResponse.FromString,
                _registered_method=True)
        self.CreateFork = channel.unary_unary(
                '/gitaly.RepositoryService/CreateFork',
                request_serializer=repository__pb2.CreateForkRequest.SerializeToString,
                response_deserializer=repository__pb2.CreateForkResponse.FromString,
                _registered_method=True)
        self.CreateRepositoryFromURL = channel.unary_unary(
                '/gitaly.RepositoryService/CreateRepositoryFromURL',
                request_serializer=repository__pb2.CreateRepositoryFromURLRequest.SerializeToString,
                response_deserializer=repository__pb2.CreateRepositoryFromURLResponse.FromString,
                _registered_method=True)
        self.CreateBundle = channel.unary_stream(
                '/gitaly.RepositoryService/CreateBundle',
                request_serializer=repository__pb2.CreateBundleRequest.SerializeToString,
                response_deserializer=repository__pb2.CreateBundleResponse.FromString,
                _registered_method=True)
        self.CreateBundleFromRefList = channel.stream_stream(
                '/gitaly.RepositoryService/CreateBundleFromRefList',
                request_serializer=repository__pb2.CreateBundleFromRefListRequest.SerializeToString,
                response_deserializer=repository__pb2.CreateBundleFromRefListResponse.FromString,
                _registered_method=True)
        self.GenerateBundleURI = channel.unary_unary(
                '/gitaly.RepositoryService/GenerateBundleURI',
                request_serializer=repository__pb2.GenerateBundleURIRequest.SerializeToString,
                response_deserializer=repository__pb2.GenerateBundleURIResponse.FromString,
                _registered_method=True)
        self.FetchBundle = channel.stream_unary(
                '/gitaly.RepositoryService/FetchBundle',
                request_serializer=repository__pb2.FetchBundleRequest.SerializeToString,
                response_deserializer=repository__pb2.FetchBundleResponse.FromString,
                _registered_method=True)
        self.CreateRepositoryFromBundle = channel.stream_unary(
                '/gitaly.RepositoryService/CreateRepositoryFromBundle',
                request_serializer=repository__pb2.CreateRepositoryFromBundleRequest.SerializeToString,
                response_deserializer=repository__pb2.CreateRepositoryFromBundleResponse.FromString,
                _registered_method=True)
        self.GetConfig = channel.unary_stream(
                '/gitaly.RepositoryService/GetConfig',
                request_serializer=repository__pb2.GetConfigRequest.SerializeToString,
                response_deserializer=repository__pb2.GetConfigResponse.FromString,
                _registered_method=True)
        self.FindLicense = channel.unary_unary(
                '/gitaly.RepositoryService/FindLicense',
                request_serializer=repository__pb2.FindLicenseRequest.SerializeToString,
                response_deserializer=repository__pb2.FindLicenseResponse.FromString,
                _registered_method=True)
        self.GetInfoAttributes = channel.unary_stream(
                '/gitaly.RepositoryService/GetInfoAttributes',
                request_serializer=repository__pb2.GetInfoAttributesRequest.SerializeToString,
                response_deserializer=repository__pb2.GetInfoAttributesResponse.FromString,
                _registered_method=True)
        self.CalculateChecksum = channel.unary_unary(
                '/gitaly.RepositoryService/CalculateChecksum',
                request_serializer=repository__pb2.CalculateChecksumRequest.SerializeToString,
                response_deserializer=repository__pb2.CalculateChecksumResponse.FromString,
                _registered_method=True)
        self.GetSnapshot = channel.unary_stream(
                '/gitaly.RepositoryService/GetSnapshot',
                request_serializer=repository__pb2.GetSnapshotRequest.SerializeToString,
                response_deserializer=repository__pb2.GetSnapshotResponse.FromString,
                _registered_method=True)
        self.CreateRepositoryFromSnapshot = channel.unary_unary(
                '/gitaly.RepositoryService/CreateRepositoryFromSnapshot',
                request_serializer=repository__pb2.CreateRepositoryFromSnapshotRequest.SerializeToString,
                response_deserializer=repository__pb2.CreateRepositoryFromSnapshotResponse.FromString,
                _registered_method=True)
        self.GetRawChanges = channel.unary_stream(
                '/gitaly.RepositoryService/GetRawChanges',
                request_serializer=repository__pb2.GetRawChangesRequest.SerializeToString,
                response_deserializer=repository__pb2.GetRawChangesResponse.FromString,
                _registered_method=True)
        self.SearchFilesByContent = channel.unary_stream(
                '/gitaly.RepositoryService/SearchFilesByContent',
                request_serializer=repository__pb2.SearchFilesByContentRequest.SerializeToString,
                response_deserializer=repository__pb2.SearchFilesByContentResponse.FromString,
                _registered_method=True)
        self.SearchFilesByName = channel.unary_stream(
                '/gitaly.RepositoryService/SearchFilesByName',
                request_serializer=repository__pb2.SearchFilesByNameRequest.SerializeToString,
                response_deserializer=repository__pb2.SearchFilesByNameResponse.FromString,
                _registered_method=True)
        self.RestoreCustomHooks = channel.stream_unary(
                '/gitaly.RepositoryService/RestoreCustomHooks',
                request_serializer=repository__pb2.RestoreCustomHooksRequest.SerializeToString,
                response_deserializer=repository__pb2.RestoreCustomHooksResponse.FromString,
                _registered_method=True)
        self.SetCustomHooks = channel.stream_unary(
                '/gitaly.RepositoryService/SetCustomHooks',
                request_serializer=repository__pb2.SetCustomHooksRequest.SerializeToString,
                response_deserializer=repository__pb2.SetCustomHooksResponse.FromString,
                _registered_method=True)
        self.BackupCustomHooks = channel.unary_stream(
                '/gitaly.RepositoryService/BackupCustomHooks',
                request_serializer=repository__pb2.BackupCustomHooksRequest.SerializeToString,
                response_deserializer=repository__pb2.BackupCustomHooksResponse.FromString,
                _registered_method=True)
        self.GetCustomHooks = channel.unary_stream(
                '/gitaly.RepositoryService/GetCustomHooks',
                request_serializer=repository__pb2.GetCustomHooksRequest.SerializeToString,
                response_deserializer=repository__pb2.GetCustomHooksResponse.FromString,
                _registered_method=True)
        self.GetObjectDirectorySize = channel.unary_unary(
                '/gitaly.RepositoryService/GetObjectDirectorySize',
                request_serializer=repository__pb2.GetObjectDirectorySizeRequest.SerializeToString,
                response_deserializer=repository__pb2.GetObjectDirectorySizeResponse.FromString,
                _registered_method=True)
        self.RemoveRepository = channel.unary_unary(
                '/gitaly.RepositoryService/RemoveRepository',
                request_serializer=repository__pb2.RemoveRepositoryRequest.SerializeToString,
                response_deserializer=repository__pb2.RemoveRepositoryResponse.FromString,
                _registered_method=True)
        self.ReplicateRepository = channel.unary_unary(
                '/gitaly.RepositoryService/ReplicateRepository',
                request_serializer=repository__pb2.ReplicateRepositoryRequest.SerializeToString,
                response_deserializer=repository__pb2.ReplicateRepositoryResponse.FromString,
                _registered_method=True)
        self.OptimizeRepository = channel.unary_unary(
                '/gitaly.RepositoryService/OptimizeRepository',
                request_serializer=repository__pb2.OptimizeRepositoryRequest.SerializeToString,
                response_deserializer=repository__pb2.OptimizeRepositoryResponse.FromString,
                _registered_method=True)
        self.PruneUnreachableObjects = channel.unary_unary(
                '/gitaly.RepositoryService/PruneUnreachableObjects',
                request_serializer=repository__pb2.PruneUnreachableObjectsRequest.SerializeToString,
                response_deserializer=repository__pb2.PruneUnreachableObjectsResponse.FromString,
                _registered_method=True)
        self.BackupRepository = channel.unary_unary(
                '/gitaly.RepositoryService/BackupRepository',
                request_serializer=repository__pb2.BackupRepositoryRequest.SerializeToString,
                response_deserializer=repository__pb2.BackupRepositoryResponse.FromString,
                _registered_method=True)
        self.RestoreRepository = channel.unary_unary(
                '/gitaly.RepositoryService/RestoreRepository',
                request_serializer=repository__pb2.RestoreRepositoryRequest.SerializeToString,
                response_deserializer=repository__pb2.RestoreRepositoryResponse.FromString,
                _registered_method=True)
        self.GetFileAttributes = channel.unary_unary(
                '/gitaly.RepositoryService/GetFileAttributes',
                request_serializer=repository__pb2.GetFileAttributesRequest.SerializeToString,
                response_deserializer=repository__pb2.GetFileAttributesResponse.FromString,
                _registered_method=True)
        self.FastExport = channel.unary_stream(
                '/gitaly.RepositoryService/FastExport',
                request_serializer=repository__pb2.FastExportRequest.SerializeToString,
                response_deserializer=repository__pb2.FastExportResponse.FromString,
                _registered_method=True)
        self.MigrateReferenceBackend = channel.unary_unary(
                '/gitaly.RepositoryService/MigrateReferenceBackend',
                request_serializer=repository__pb2.MigrateReferenceBackendRequest.SerializeToString,
                response_deserializer=repository__pb2.MigrateReferenceBackendResponse.FromString,
                _registered_method=True)


class RepositoryServiceServicer(object):
    """RepositoryService is a service providing RPCs accessing repositories as a whole.
    """

    def RepositoryExists(self, request, context):
        """RepositoryExists returns whether a given repository exists.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def RepositorySize(self, request, context):
        """RepositorySize returns information on the complete on-disk repository size. If you need more
        detailed information about the size of various sub-structures you should instead use the
        repositoryInfo RPC.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def RepositoryInfo(self, request, context):
        """RepositoryInfo returns detailed information about a repository and its data structures.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ObjectsSize(self, request_iterator, context):
        """ObjectsSize calculates the total on-disk object size of reachable objects in bytes. In contrast
        to RepositorySize and RepositoryInfo, this RPC performs a graph walk of the specified revisions
        and will thus return an accurate view of how large the accumulated on-disk size of reachable
        objects is.

        As this RPC needs to perform a revision walk, it is significantly more expensive than the RPCs
        which simply check the size of on-disk data structures. On the other hand, it allows the caller
        to accurately compute the size of objects in a way that is at least somewhat detached from the
        on-disk representation:

        - Objects which exist in multiple packfiles will not be double-counted.
        - Objects which aren't reachable will not be accounted for.
        - It is possible to only account for a subset of references, e.g. only those that an admin
        would have direct control over.

        It is thus recommended to use this RPC whenever you want to calculate sizes which will end up
        being shown to the user.

        Note that the size is still bound to change when repositories are getting repacked and thus
        cannot be considered to be stable. This is because the on-disk size of any object can change
        depending on how Git decides to deltify it in a packfile. Thus, when a repack would cause a
        different delta base to be picked, the actual on-disk size of any given object may change.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ObjectFormat(self, request, context):
        """ObjectFormat determines the object format that is being used by the repository.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def FetchRemote(self, request, context):
        """FetchRemote fetches references from a remote repository into the local
        repository. The remote can be fetched via HTTP or SSH depending on the
        request options provided.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def CreateRepository(self, request, context):
        """CreateRepository creates a new empty repository.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetArchive(self, request, context):
        """GetArchive produces and returns an archive of a repository.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def HasLocalBranches(self, request, context):
        """HasLocalBranches returns whether the given repo contains any branches.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def FetchSourceBranch(self, request, context):
        """FetchSourceBranch fetches a branch from a second (potentially remote)
        repository into the given repository.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Fsck(self, request, context):
        """Fsck checks the repository for consistency via git-fsck(1). This can be used to check for
        repository corruption.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def WriteRef(self, request, context):
        """WriteRef creates or updates a ref in a repository to point to a new value.
        If the request contains object revisions that do not exist in the repository, the RPC returns
        the NOT_FOUND code with the ReferenceNotFoundError detail.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def FindMergeBase(self, request, context):
        """FindMergeBase returns the best common ancestor between two or more commits. Consult the man
        pages of git-merge-base(1) for more information on how this is calculated.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def CreateFork(self, request, context):
        """CreateFork creates a new repository from a specific source repository. This new repository will
        have the same branches and tags as the source repository. Internal references will not be
        recreated in the forked repository.

        all objects of the source repository will be duplicated, that is there are no space savings by
        creating the repository like this. The newly created repository does not join the object pool
        of the source repository, if there is any.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def CreateRepositoryFromURL(self, request, context):
        """CreateRepositoryFromURL creates a new repo and seeds it with the contents of an existing Git repo
        reachable at the provided URL.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def CreateBundle(self, request, context):
        """CreateBundle creates a bundle from all refs
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def CreateBundleFromRefList(self, request_iterator, context):
        """CreateBundleFromRefList creates a bundle from a stream of ref patterns.
        When the bundle would be empty the FailedPrecondition error code is returned.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GenerateBundleURI(self, request, context):
        """GenerateBundleURI generates a bundle on the server for bundle-URI use.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def FetchBundle(self, request_iterator, context):
        """FetchBundle fetches references from a bundle into the local repository.
        refs will be mirrored to the target repository with the refspec
        "+refs/*:refs/*" and refs that do not exist in the bundle will be removed.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def CreateRepositoryFromBundle(self, request_iterator, context):
        """CreateRepositoryFromBundle creates a Git repository at the specified storage and path, if it
        does not already exist, from the provided Git bundle.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetConfig(self, request, context):
        """GetConfig reads the target repository's gitconfig and streams its contents
        back. Returns a NotFound error in case no gitconfig was found.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def FindLicense(self, request, context):
        """FindLicense looks in the given repository and attempts to detect all the
        details about the license used in the repository.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetInfoAttributes(self, request, context):
        """GetInfoAttributes reads the contents from info/attributes.
        This RPC will be removed in 17.0.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def CalculateChecksum(self, request, context):
        """CalculateChecksum returns a checksum of the repository by hashing its references. Refs
        outside of well-known namespaces are not considered when computing the checksum.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetSnapshot(self, request, context):
        """GetSnapshot returns a snapshot of the repository. A snapshot comprises all Git references
        and objects required to recreate the state of a repository at a point in time.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def CreateRepositoryFromSnapshot(self, request, context):
        """CreateRepositoryFromSnapshot creates a new repository based on a snapshot created with
        the GetSnapshot RPC. The snapshot is fetched via HTTP.

        Due to the inherent structure of the TAR format, it's challenging to definitively verify
        if a provided TAR file is complete or truncated/malformed. While basic integrity checks
        are performed, users should ensure the completeness and integrity of their TAR files.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetRawChanges(self, request, context):
        """GetRawChanges returns metadata in raw format on the changes between two revisions.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SearchFilesByContent(self, request, context):
        """SearchFilesByContent searches files in the repository using the provided grep pattern.
        For each result, the matched line is returned along with the two previous and next lines.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SearchFilesByName(self, request, context):
        """SearchFilesByName searches files in the repository based on its name and an
        optional filter.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def RestoreCustomHooks(self, request_iterator, context):
        """RestoreCustomHooks sets the git hooks for a repository. The hooks are sent
        in a tar archive containing a `custom_hooks` directory. This directory is
        ultimately extracted to the repository.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SetCustomHooks(self, request_iterator, context):
        """SetCustomHooks sets the git hooks for a repository. The hooks are sent in a
        tar archive containing a `custom_hooks` directory (i.e. the response from the
        GetCustomHooksResponse RPC. This directory will be extracted into the repository.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def BackupCustomHooks(self, request, context):
        """BackupCustomHooks fetches the git hooks for a repository. The hooks are
        sent in a tar archive containing a `custom_hooks` directory. If no hooks
        are present in the repository, the response will have no data.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetCustomHooks(self, request, context):
        """GetCustomHooks fetches the git hooks for a repository. The hooks are sent
        in a tar archive containing a `custom_hooks` directory. If no hooks are
        present in the repository, the response will have no data.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetObjectDirectorySize(self, request, context):
        """GetObjectDirectorySize returns the size in kibibytes of the object directory of a repository.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def RemoveRepository(self, request, context):
        """RemoveRepository will move the repository to `+gitaly/tmp/<relative_path>_removed` and
        eventually remove it. This ensures that even on networked filesystems the
        data is actually removed even if there's someone still handling the data.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ReplicateRepository(self, request, context):
        """ReplicateRepository replicates data from a source repository to target repository. On the
        target repository, this operation ensures synchronization of the following components:

        - Git config
        - Git attributes
        - Custom Git hooks,
        - References and objects
        - (Optional) Object deduplication network membership
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def OptimizeRepository(self, request, context):
        """OptimizeRepository performs all maintenance tasks in a repository to keep
        it in an efficient state. It cleans up stale data, repacks objects,
        updates auxiliary caches like commit-graphs and packs references. The
        optimizations performed are based on heuristics and will adapt to the
        repository's size. This RPC call is designed as a black-box such that
        Gitaly has complete control of the on-disk state of repositories.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def PruneUnreachableObjects(self, request, context):
        """PruneUnreachableObjects will prune all objects which aren't reachable from
        the repository's current set of references. Because pruning can only
        happen for objects which aren't packed, you are required to first run
        OptimizeRepository to explode any unreachable objects into loose objects.

        Furthermore, this RPC call has a grace period of 30 minutes: any
        unreachable loose objects must not have been accessed or modified in the
        last 30 minutes. This is a hard requirement to avoid repository corruption.

        to make proper use of this RPC you thus need to call OptimizeRepository,
        wait 30 minutes, and then call PruneUnreachableObjects.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def BackupRepository(self, request, context):
        """BackupRepository creates a full or incremental backup streamed directly to
        object-storage. The backup is created synchronously. The destination must
        be configured in config.backup.go_cloud_url
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def RestoreRepository(self, request, context):
        """RestoreRepository restores a backup streamed directly from object-storage.
        The repository is restored synchronously. The source object-storage must
        be configured in config.backup.go_cloud_url
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetFileAttributes(self, request, context):
        """GetFileAttributes queries given file attributes as specified in .gitattributes file
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def FastExport(self, request, context):
        """FastExport runs git-fast-export on the repository, streaming the data back through the response
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def MigrateReferenceBackend(self, request, context):
        """MigrateReferenceBackend allows migrating a repository between the different Git
        reference backends. Transactions must be enabled.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_RepositoryServiceServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'RepositoryExists': grpc.unary_unary_rpc_method_handler(
                    servicer.RepositoryExists,
                    request_deserializer=repository__pb2.RepositoryExistsRequest.FromString,
                    response_serializer=repository__pb2.RepositoryExistsResponse.SerializeToString,
            ),
            'RepositorySize': grpc.unary_unary_rpc_method_handler(
                    servicer.RepositorySize,
                    request_deserializer=repository__pb2.RepositorySizeRequest.FromString,
                    response_serializer=repository__pb2.RepositorySizeResponse.SerializeToString,
            ),
            'RepositoryInfo': grpc.unary_unary_rpc_method_handler(
                    servicer.RepositoryInfo,
                    request_deserializer=repository__pb2.RepositoryInfoRequest.FromString,
                    response_serializer=repository__pb2.RepositoryInfoResponse.SerializeToString,
            ),
            'ObjectsSize': grpc.stream_unary_rpc_method_handler(
                    servicer.ObjectsSize,
                    request_deserializer=repository__pb2.ObjectsSizeRequest.FromString,
                    response_serializer=repository__pb2.ObjectsSizeResponse.SerializeToString,
            ),
            'ObjectFormat': grpc.unary_unary_rpc_method_handler(
                    servicer.ObjectFormat,
                    request_deserializer=repository__pb2.ObjectFormatRequest.FromString,
                    response_serializer=repository__pb2.ObjectFormatResponse.SerializeToString,
            ),
            'FetchRemote': grpc.unary_unary_rpc_method_handler(
                    servicer.FetchRemote,
                    request_deserializer=repository__pb2.FetchRemoteRequest.FromString,
                    response_serializer=repository__pb2.FetchRemoteResponse.SerializeToString,
            ),
            'CreateRepository': grpc.unary_unary_rpc_method_handler(
                    servicer.CreateRepository,
                    request_deserializer=repository__pb2.CreateRepositoryRequest.FromString,
                    response_serializer=repository__pb2.CreateRepositoryResponse.SerializeToString,
            ),
            'GetArchive': grpc.unary_stream_rpc_method_handler(
                    servicer.GetArchive,
                    request_deserializer=repository__pb2.GetArchiveRequest.FromString,
                    response_serializer=repository__pb2.GetArchiveResponse.SerializeToString,
            ),
            'HasLocalBranches': grpc.unary_unary_rpc_method_handler(
                    servicer.HasLocalBranches,
                    request_deserializer=repository__pb2.HasLocalBranchesRequest.FromString,
                    response_serializer=repository__pb2.HasLocalBranchesResponse.SerializeToString,
            ),
            'FetchSourceBranch': grpc.unary_unary_rpc_method_handler(
                    servicer.FetchSourceBranch,
                    request_deserializer=repository__pb2.FetchSourceBranchRequest.FromString,
                    response_serializer=repository__pb2.FetchSourceBranchResponse.SerializeToString,
            ),
            'Fsck': grpc.unary_unary_rpc_method_handler(
                    servicer.Fsck,
                    request_deserializer=repository__pb2.FsckRequest.FromString,
                    response_serializer=repository__pb2.FsckResponse.SerializeToString,
            ),
            'WriteRef': grpc.unary_unary_rpc_method_handler(
                    servicer.WriteRef,
                    request_deserializer=repository__pb2.WriteRefRequest.FromString,
                    response_serializer=repository__pb2.WriteRefResponse.SerializeToString,
            ),
            'FindMergeBase': grpc.unary_unary_rpc_method_handler(
                    servicer.FindMergeBase,
                    request_deserializer=repository__pb2.FindMergeBaseRequest.FromString,
                    response_serializer=repository__pb2.FindMergeBaseResponse.SerializeToString,
            ),
            'CreateFork': grpc.unary_unary_rpc_method_handler(
                    servicer.CreateFork,
                    request_deserializer=repository__pb2.CreateForkRequest.FromString,
                    response_serializer=repository__pb2.CreateForkResponse.SerializeToString,
            ),
            'CreateRepositoryFromURL': grpc.unary_unary_rpc_method_handler(
                    servicer.CreateRepositoryFromURL,
                    request_deserializer=repository__pb2.CreateRepositoryFromURLRequest.FromString,
                    response_serializer=repository__pb2.CreateRepositoryFromURLResponse.SerializeToString,
            ),
            'CreateBundle': grpc.unary_stream_rpc_method_handler(
                    servicer.CreateBundle,
                    request_deserializer=repository__pb2.CreateBundleRequest.FromString,
                    response_serializer=repository__pb2.CreateBundleResponse.SerializeToString,
            ),
            'CreateBundleFromRefList': grpc.stream_stream_rpc_method_handler(
                    servicer.CreateBundleFromRefList,
                    request_deserializer=repository__pb2.CreateBundleFromRefListRequest.FromString,
                    response_serializer=repository__pb2.CreateBundleFromRefListResponse.SerializeToString,
            ),
            'GenerateBundleURI': grpc.unary_unary_rpc_method_handler(
                    servicer.GenerateBundleURI,
                    request_deserializer=repository__pb2.GenerateBundleURIRequest.FromString,
                    response_serializer=repository__pb2.GenerateBundleURIResponse.SerializeToString,
            ),
            'FetchBundle': grpc.stream_unary_rpc_method_handler(
                    servicer.FetchBundle,
                    request_deserializer=repository__pb2.FetchBundleRequest.FromString,
                    response_serializer=repository__pb2.FetchBundleResponse.SerializeToString,
            ),
            'CreateRepositoryFromBundle': grpc.stream_unary_rpc_method_handler(
                    servicer.CreateRepositoryFromBundle,
                    request_deserializer=repository__pb2.CreateRepositoryFromBundleRequest.FromString,
                    response_serializer=repository__pb2.CreateRepositoryFromBundleResponse.SerializeToString,
            ),
            'GetConfig': grpc.unary_stream_rpc_method_handler(
                    servicer.GetConfig,
                    request_deserializer=repository__pb2.GetConfigRequest.FromString,
                    response_serializer=repository__pb2.GetConfigResponse.SerializeToString,
            ),
            'FindLicense': grpc.unary_unary_rpc_method_handler(
                    servicer.FindLicense,
                    request_deserializer=repository__pb2.FindLicenseRequest.FromString,
                    response_serializer=repository__pb2.FindLicenseResponse.SerializeToString,
            ),
            'GetInfoAttributes': grpc.unary_stream_rpc_method_handler(
                    servicer.GetInfoAttributes,
                    request_deserializer=repository__pb2.GetInfoAttributesRequest.FromString,
                    response_serializer=repository__pb2.GetInfoAttributesResponse.SerializeToString,
            ),
            'CalculateChecksum': grpc.unary_unary_rpc_method_handler(
                    servicer.CalculateChecksum,
                    request_deserializer=repository__pb2.CalculateChecksumRequest.FromString,
                    response_serializer=repository__pb2.CalculateChecksumResponse.SerializeToString,
            ),
            'GetSnapshot': grpc.unary_stream_rpc_method_handler(
                    servicer.GetSnapshot,
                    request_deserializer=repository__pb2.GetSnapshotRequest.FromString,
                    response_serializer=repository__pb2.GetSnapshotResponse.SerializeToString,
            ),
            'CreateRepositoryFromSnapshot': grpc.unary_unary_rpc_method_handler(
                    servicer.CreateRepositoryFromSnapshot,
                    request_deserializer=repository__pb2.CreateRepositoryFromSnapshotRequest.FromString,
                    response_serializer=repository__pb2.CreateRepositoryFromSnapshotResponse.SerializeToString,
            ),
            'GetRawChanges': grpc.unary_stream_rpc_method_handler(
                    servicer.GetRawChanges,
                    request_deserializer=repository__pb2.GetRawChangesRequest.FromString,
                    response_serializer=repository__pb2.GetRawChangesResponse.SerializeToString,
            ),
            'SearchFilesByContent': grpc.unary_stream_rpc_method_handler(
                    servicer.SearchFilesByContent,
                    request_deserializer=repository__pb2.SearchFilesByContentRequest.FromString,
                    response_serializer=repository__pb2.SearchFilesByContentResponse.SerializeToString,
            ),
            'SearchFilesByName': grpc.unary_stream_rpc_method_handler(
                    servicer.SearchFilesByName,
                    request_deserializer=repository__pb2.SearchFilesByNameRequest.FromString,
                    response_serializer=repository__pb2.SearchFilesByNameResponse.SerializeToString,
            ),
            'RestoreCustomHooks': grpc.stream_unary_rpc_method_handler(
                    servicer.RestoreCustomHooks,
                    request_deserializer=repository__pb2.RestoreCustomHooksRequest.FromString,
                    response_serializer=repository__pb2.RestoreCustomHooksResponse.SerializeToString,
            ),
            'SetCustomHooks': grpc.stream_unary_rpc_method_handler(
                    servicer.SetCustomHooks,
                    request_deserializer=repository__pb2.SetCustomHooksRequest.FromString,
                    response_serializer=repository__pb2.SetCustomHooksResponse.SerializeToString,
            ),
            'BackupCustomHooks': grpc.unary_stream_rpc_method_handler(
                    servicer.BackupCustomHooks,
                    request_deserializer=repository__pb2.BackupCustomHooksRequest.FromString,
                    response_serializer=repository__pb2.BackupCustomHooksResponse.SerializeToString,
            ),
            'GetCustomHooks': grpc.unary_stream_rpc_method_handler(
                    servicer.GetCustomHooks,
                    request_deserializer=repository__pb2.GetCustomHooksRequest.FromString,
                    response_serializer=repository__pb2.GetCustomHooksResponse.SerializeToString,
            ),
            'GetObjectDirectorySize': grpc.unary_unary_rpc_method_handler(
                    servicer.GetObjectDirectorySize,
                    request_deserializer=repository__pb2.GetObjectDirectorySizeRequest.FromString,
                    response_serializer=repository__pb2.GetObjectDirectorySizeResponse.SerializeToString,
            ),
            'RemoveRepository': grpc.unary_unary_rpc_method_handler(
                    servicer.RemoveRepository,
                    request_deserializer=repository__pb2.RemoveRepositoryRequest.FromString,
                    response_serializer=repository__pb2.RemoveRepositoryResponse.SerializeToString,
            ),
            'ReplicateRepository': grpc.unary_unary_rpc_method_handler(
                    servicer.ReplicateRepository,
                    request_deserializer=repository__pb2.ReplicateRepositoryRequest.FromString,
                    response_serializer=repository__pb2.ReplicateRepositoryResponse.SerializeToString,
            ),
            'OptimizeRepository': grpc.unary_unary_rpc_method_handler(
                    servicer.OptimizeRepository,
                    request_deserializer=repository__pb2.OptimizeRepositoryRequest.FromString,
                    response_serializer=repository__pb2.OptimizeRepositoryResponse.SerializeToString,
            ),
            'PruneUnreachableObjects': grpc.unary_unary_rpc_method_handler(
                    servicer.PruneUnreachableObjects,
                    request_deserializer=repository__pb2.PruneUnreachableObjectsRequest.FromString,
                    response_serializer=repository__pb2.PruneUnreachableObjectsResponse.SerializeToString,
            ),
            'BackupRepository': grpc.unary_unary_rpc_method_handler(
                    servicer.BackupRepository,
                    request_deserializer=repository__pb2.BackupRepositoryRequest.FromString,
                    response_serializer=repository__pb2.BackupRepositoryResponse.SerializeToString,
            ),
            'RestoreRepository': grpc.unary_unary_rpc_method_handler(
                    servicer.RestoreRepository,
                    request_deserializer=repository__pb2.RestoreRepositoryRequest.FromString,
                    response_serializer=repository__pb2.RestoreRepositoryResponse.SerializeToString,
            ),
            'GetFileAttributes': grpc.unary_unary_rpc_method_handler(
                    servicer.GetFileAttributes,
                    request_deserializer=repository__pb2.GetFileAttributesRequest.FromString,
                    response_serializer=repository__pb2.GetFileAttributesResponse.SerializeToString,
            ),
            'FastExport': grpc.unary_stream_rpc_method_handler(
                    servicer.FastExport,
                    request_deserializer=repository__pb2.FastExportRequest.FromString,
                    response_serializer=repository__pb2.FastExportResponse.SerializeToString,
            ),
            'MigrateReferenceBackend': grpc.unary_unary_rpc_method_handler(
                    servicer.MigrateReferenceBackend,
                    request_deserializer=repository__pb2.MigrateReferenceBackendRequest.FromString,
                    response_serializer=repository__pb2.MigrateReferenceBackendResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'gitaly.RepositoryService', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))
    server.add_registered_method_handlers('gitaly.RepositoryService', rpc_method_handlers)


 # This class is part of an EXPERIMENTAL API.
class RepositoryService(object):
    """RepositoryService is a service providing RPCs accessing repositories as a whole.
    """

    @staticmethod
    def RepositoryExists(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RepositoryService/RepositoryExists',
            repository__pb2.RepositoryExistsRequest.SerializeToString,
            repository__pb2.RepositoryExistsResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def RepositorySize(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RepositoryService/RepositorySize',
            repository__pb2.RepositorySizeRequest.SerializeToString,
            repository__pb2.RepositorySizeResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def RepositoryInfo(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RepositoryService/RepositoryInfo',
            repository__pb2.RepositoryInfoRequest.SerializeToString,
            repository__pb2.RepositoryInfoResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ObjectsSize(request_iterator,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.stream_unary(
            request_iterator,
            target,
            '/gitaly.RepositoryService/ObjectsSize',
            repository__pb2.ObjectsSizeRequest.SerializeToString,
            repository__pb2.ObjectsSizeResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ObjectFormat(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RepositoryService/ObjectFormat',
            repository__pb2.ObjectFormatRequest.SerializeToString,
            repository__pb2.ObjectFormatResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def FetchRemote(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RepositoryService/FetchRemote',
            repository__pb2.FetchRemoteRequest.SerializeToString,
            repository__pb2.FetchRemoteResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def CreateRepository(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RepositoryService/CreateRepository',
            repository__pb2.CreateRepositoryRequest.SerializeToString,
            repository__pb2.CreateRepositoryResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetArchive(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.RepositoryService/GetArchive',
            repository__pb2.GetArchiveRequest.SerializeToString,
            repository__pb2.GetArchiveResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def HasLocalBranches(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RepositoryService/HasLocalBranches',
            repository__pb2.HasLocalBranchesRequest.SerializeToString,
            repository__pb2.HasLocalBranchesResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def FetchSourceBranch(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RepositoryService/FetchSourceBranch',
            repository__pb2.FetchSourceBranchRequest.SerializeToString,
            repository__pb2.FetchSourceBranchResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def Fsck(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RepositoryService/Fsck',
            repository__pb2.FsckRequest.SerializeToString,
            repository__pb2.FsckResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def WriteRef(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RepositoryService/WriteRef',
            repository__pb2.WriteRefRequest.SerializeToString,
            repository__pb2.WriteRefResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def FindMergeBase(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RepositoryService/FindMergeBase',
            repository__pb2.FindMergeBaseRequest.SerializeToString,
            repository__pb2.FindMergeBaseResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def CreateFork(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RepositoryService/CreateFork',
            repository__pb2.CreateForkRequest.SerializeToString,
            repository__pb2.CreateForkResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def CreateRepositoryFromURL(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RepositoryService/CreateRepositoryFromURL',
            repository__pb2.CreateRepositoryFromURLRequest.SerializeToString,
            repository__pb2.CreateRepositoryFromURLResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def CreateBundle(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.RepositoryService/CreateBundle',
            repository__pb2.CreateBundleRequest.SerializeToString,
            repository__pb2.CreateBundleResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def CreateBundleFromRefList(request_iterator,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.stream_stream(
            request_iterator,
            target,
            '/gitaly.RepositoryService/CreateBundleFromRefList',
            repository__pb2.CreateBundleFromRefListRequest.SerializeToString,
            repository__pb2.CreateBundleFromRefListResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GenerateBundleURI(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RepositoryService/GenerateBundleURI',
            repository__pb2.GenerateBundleURIRequest.SerializeToString,
            repository__pb2.GenerateBundleURIResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def FetchBundle(request_iterator,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.stream_unary(
            request_iterator,
            target,
            '/gitaly.RepositoryService/FetchBundle',
            repository__pb2.FetchBundleRequest.SerializeToString,
            repository__pb2.FetchBundleResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def CreateRepositoryFromBundle(request_iterator,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.stream_unary(
            request_iterator,
            target,
            '/gitaly.RepositoryService/CreateRepositoryFromBundle',
            repository__pb2.CreateRepositoryFromBundleRequest.SerializeToString,
            repository__pb2.CreateRepositoryFromBundleResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetConfig(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.RepositoryService/GetConfig',
            repository__pb2.GetConfigRequest.SerializeToString,
            repository__pb2.GetConfigResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def FindLicense(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RepositoryService/FindLicense',
            repository__pb2.FindLicenseRequest.SerializeToString,
            repository__pb2.FindLicenseResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetInfoAttributes(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.RepositoryService/GetInfoAttributes',
            repository__pb2.GetInfoAttributesRequest.SerializeToString,
            repository__pb2.GetInfoAttributesResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def CalculateChecksum(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RepositoryService/CalculateChecksum',
            repository__pb2.CalculateChecksumRequest.SerializeToString,
            repository__pb2.CalculateChecksumResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetSnapshot(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.RepositoryService/GetSnapshot',
            repository__pb2.GetSnapshotRequest.SerializeToString,
            repository__pb2.GetSnapshotResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def CreateRepositoryFromSnapshot(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RepositoryService/CreateRepositoryFromSnapshot',
            repository__pb2.CreateRepositoryFromSnapshotRequest.SerializeToString,
            repository__pb2.CreateRepositoryFromSnapshotResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetRawChanges(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.RepositoryService/GetRawChanges',
            repository__pb2.GetRawChangesRequest.SerializeToString,
            repository__pb2.GetRawChangesResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def SearchFilesByContent(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.RepositoryService/SearchFilesByContent',
            repository__pb2.SearchFilesByContentRequest.SerializeToString,
            repository__pb2.SearchFilesByContentResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def SearchFilesByName(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.RepositoryService/SearchFilesByName',
            repository__pb2.SearchFilesByNameRequest.SerializeToString,
            repository__pb2.SearchFilesByNameResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def RestoreCustomHooks(request_iterator,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.stream_unary(
            request_iterator,
            target,
            '/gitaly.RepositoryService/RestoreCustomHooks',
            repository__pb2.RestoreCustomHooksRequest.SerializeToString,
            repository__pb2.RestoreCustomHooksResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def SetCustomHooks(request_iterator,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.stream_unary(
            request_iterator,
            target,
            '/gitaly.RepositoryService/SetCustomHooks',
            repository__pb2.SetCustomHooksRequest.SerializeToString,
            repository__pb2.SetCustomHooksResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def BackupCustomHooks(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.RepositoryService/BackupCustomHooks',
            repository__pb2.BackupCustomHooksRequest.SerializeToString,
            repository__pb2.BackupCustomHooksResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetCustomHooks(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.RepositoryService/GetCustomHooks',
            repository__pb2.GetCustomHooksRequest.SerializeToString,
            repository__pb2.GetCustomHooksResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetObjectDirectorySize(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RepositoryService/GetObjectDirectorySize',
            repository__pb2.GetObjectDirectorySizeRequest.SerializeToString,
            repository__pb2.GetObjectDirectorySizeResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def RemoveRepository(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RepositoryService/RemoveRepository',
            repository__pb2.RemoveRepositoryRequest.SerializeToString,
            repository__pb2.RemoveRepositoryResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ReplicateRepository(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RepositoryService/ReplicateRepository',
            repository__pb2.ReplicateRepositoryRequest.SerializeToString,
            repository__pb2.ReplicateRepositoryResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def OptimizeRepository(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RepositoryService/OptimizeRepository',
            repository__pb2.OptimizeRepositoryRequest.SerializeToString,
            repository__pb2.OptimizeRepositoryResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def PruneUnreachableObjects(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RepositoryService/PruneUnreachableObjects',
            repository__pb2.PruneUnreachableObjectsRequest.SerializeToString,
            repository__pb2.PruneUnreachableObjectsResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def BackupRepository(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RepositoryService/BackupRepository',
            repository__pb2.BackupRepositoryRequest.SerializeToString,
            repository__pb2.BackupRepositoryResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def RestoreRepository(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RepositoryService/RestoreRepository',
            repository__pb2.RestoreRepositoryRequest.SerializeToString,
            repository__pb2.RestoreRepositoryResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetFileAttributes(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RepositoryService/GetFileAttributes',
            repository__pb2.GetFileAttributesRequest.SerializeToString,
            repository__pb2.GetFileAttributesResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def FastExport(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/gitaly.RepositoryService/FastExport',
            repository__pb2.FastExportRequest.SerializeToString,
            repository__pb2.FastExportResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def MigrateReferenceBackend(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/gitaly.RepositoryService/MigrateReferenceBackend',
            repository__pb2.MigrateReferenceBackendRequest.SerializeToString,
            repository__pb2.MigrateReferenceBackendResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)
