#!/usr/bin/env python
# -*- coding: utf-8 -*-
# @Project      : AI.  @by PyCharm
# @File         : image_to_image
# @Time         : 2024/8/23 17:04
# @Author       : betterme
# @WeChat       : meutils
# @Software     : PyCharm
# @Description  :

from meutils.pipe import *
from meutils.config_utils.lark_utils import get_spreadsheet_values, get_next_token_for_polling
from meutils.schemas.openai_types import ImageRequest, ImagesResponse
from meutils.apis.translator import deeplx
from meutils.schemas.translator_types import DeeplxRequest
from meutils.decorators.retry import retrying
from meutils.schemas.image_types import ASPECT_RATIOS
from meutils.schemas.oneapi import REDIRECT_MODEL

from meutils.io.image import image_to_base64

BASE_URL = "https://cloud.siliconflow.cn"
FEISHU_URL = "https://xchatllm.feishu.cn/sheets/Bmjtst2f6hfMqFttbhLcdfRJnNf?sheet=InxiCF"
FEISHU_URL_TOKEN = "https://xchatllm.feishu.cn/sheets/Bmjtst2f6hfMqFttbhLcdfRJnNf?sheet=xlvlrH"

url = "https://api.siliconflow.cn/v1/TencentARC/PhotoMaker/image-to-image"

PHOTOMAKER_STYLES = {
    "Photographic (Default)",
    "Cinematic",
    "Comic book",
    "Disney Character",
    "Disney Character",
    "Digital Art",
    "Fantasy Art",
    "Neopunk",
    "Enhance",
    "Lowpoly",
    "Line art",
    "(No style)",
}


@retrying(max_retries=3, title=__name__)
async def create(request: ImageRequest, api_key: Optional[str] = None):  # SD3
    api_key = api_key or await get_next_token_for_polling(feishu_url=FEISHU_URL)

    # logger.debug(request)

    prompt = (await deeplx.translate(DeeplxRequest(text=request.prompt, target_lang="EN"))).get("data")

    logger.debug(prompt)

    if request.url and request.url.startswith('http'):
        image_data = image_to_base64(request.url)
    else:
        image_data = request.url

    payload = {
        "prompt": prompt,
        "negative_prompt": request.negative_prompt,
        "image_size": request.size,
        "batch_size": request.n,
        "seed": 0,
        "num_inference_steps": request.num_inference_steps,
        "guidance_scale": request.guidance_scale,

        "image": image_data,
        "style_name": request.style if request.style in PHOTOMAKER_STYLES else "Photographic (Default)",
        "style_strengh_radio": 20
    }
    # payload = {
    #     "prompt": "a half-body portrait of a man img wearing the sunglasses in Iron man suit, best quality",
    #     "image": "data:image/webp;base64,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",
    #     "image_size": "1024x1024",
    #     "style_name": "Photographic (Default)",
    #     "batch_size": 1,
    #     "num_inference_steps": 20,
    #     "guidance_scale": 5,
    #     "style_strengh_radio": 20
    # }

    headers = {
        "Authorization": f"Bearer {api_key}",
    }
    base_url = "https://api.siliconflow.cn/v1"
    url = "https://api.siliconflow.cn/v1/TencentARC/PhotoMaker/image-to-image"

    async with httpx.AsyncClient(base_url=base_url, headers=headers, timeout=100) as client:
        response = await client.post(f"/{request.model}/image-to-image", json=payload)

        if response.is_success:
            data = response.json().get('images', [])
            return ImagesResponse(data=data)
        response.raise_for_status()  # 451


if __name__ == '__main__':
    url = "https://oss.ffire.cc/files/s.png"
    # url = "https://dss2.bdstatic.com/5bVYsj_p_tVS5dKfpU_Y_D3/res/r/image/2021-3-4/hao123%20logo.png"
    # url = "https://sf-maas-uat-prod.oss-cn-shanghai.aliyuncs.com/outputs/5618c93e-74f6-4177-9a33-ef8b361ab1e9_00001_.png"
    # url="https://s22-def.ap4r.com/bs2/upload-ylab-stunt-sgp/ai_portal/1724896538/Q1jrJ51ElR/z3dsfjwxkvipbczkzvbklc.png"
    model = "TencentARC/PhotoMaker"
    model = "ByteDance/SDXL-Lightning"
    # model = "stabilityai/stable-diffusion-xl-base-1.0"
    # model = "stabilityai/stable-diffusion-2-1"
    # model = "TencentARC/PhotoMaker"

    request = ImageRequest(
        prompt='a half-body portrait of a man img wearing the sunglasses in Iron man suit, best quality',
        # url=url,
        model=model,
        # url="data:image/webp;base64,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"
    )

    arun(create(request, api_key=os.getenv("SILICONFLOW_API_KEY")))
