'''
Pepper is a CLI front-end to salt-api
'''
try:
    from importlib.metadata import version as _get_version, PackageNotFoundError
except ImportError:
    # Python < 3.8
    try:
        from importlib_metadata import version as _get_version, PackageNotFoundError
    except ImportError:
        # Fallback to pkg_resources for very old Python versions
        import pkg_resources
        _get_version = lambda pkg: pkg_resources.get_distribution(pkg).version
        PackageNotFoundError = pkg_resources.DistributionNotFound

from upepper.libpepper import Pepper, PepperException

__all__ = ('__version__', 'Pepper', 'PepperException')

try:
    __version__ = _get_version('salt_pepper')
except PackageNotFoundError:
    # package is not installed
    __version__ = None

# For backwards compatibility
version = __version__
sha = None
