"""profile entities

Revision ID: 059af231c2b2
Revises: 5e011849ea76
Create Date: 2025-09-14 22:43:19.508532

"""

from typing import Sequence

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision: str = "059af231c2b2"
down_revision: str | Sequence[str] | None = "5e011849ea76"
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "agent",
        sa.Column("name", sa.String(length=255), nullable=False),
        sa.Column("description", sa.String(length=1024), nullable=True),
        sa.Column("instructions", sa.Text(), nullable=True),
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("created_at", sa.DateTime(timezone=True), server_default=sa.text("now()"), nullable=False),
        sa.Column("updated_at", sa.DateTime(timezone=True), server_default=sa.text("now()"), nullable=False),
        sa.Column("deleted_at", sa.DateTime(timezone=True), nullable=True),
        sa.PrimaryKeyConstraint("id", name=op.f("agent_pkey")),
        sa.UniqueConstraint("name", name="uq_agent_name"),
    )
    op.create_index(op.f("agent_id_idx"), "agent", ["id"], unique=False)
    op.create_index(op.f("agent_name_idx"), "agent", ["name"], unique=False)
    op.create_table(
        "profile",
        sa.Column("name", sa.String(length=255), nullable=False),
        sa.Column("description", sa.String(length=1024), nullable=True),
        sa.Column("is_active", sa.Boolean(), nullable=False),
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("created_at", sa.DateTime(timezone=True), server_default=sa.text("now()"), nullable=False),
        sa.Column("updated_at", sa.DateTime(timezone=True), server_default=sa.text("now()"), nullable=False),
        sa.Column("deleted_at", sa.DateTime(timezone=True), nullable=True),
        sa.PrimaryKeyConstraint("id", name=op.f("profile_pkey")),
        sa.UniqueConstraint("name", name="uq_profile_name"),
    )
    op.create_index(op.f("profile_id_idx"), "profile", ["id"], unique=False)
    op.create_index(op.f("profile_name_idx"), "profile", ["name"], unique=False)
    op.create_table(
        "agent_profile",
        sa.Column("agent_id", sa.Integer(), nullable=False),
        sa.Column("profile_id", sa.Integer(), nullable=False),
        sa.Column("version", sa.Integer(), nullable=False),
        sa.Column("status", sa.Enum("ACTIVE", "INACTIVE", "PREVIEW", name="agent_profile_status"), nullable=False),
        sa.Column("is_default", sa.Boolean(), nullable=False),
        sa.Column("prompt", sa.Text(), nullable=True),
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("created_at", sa.DateTime(timezone=True), server_default=sa.text("now()"), nullable=False),
        sa.Column("updated_at", sa.DateTime(timezone=True), server_default=sa.text("now()"), nullable=False),
        sa.Column("deleted_at", sa.DateTime(timezone=True), nullable=True),
        sa.ForeignKeyConstraint(["agent_id"], ["agent.id"], name=op.f("agent_profile_agent_id_fkey")),
        sa.ForeignKeyConstraint(["profile_id"], ["profile.id"], name=op.f("agent_profile_profile_id_fkey")),
        sa.PrimaryKeyConstraint("id", name=op.f("agent_profile_pkey")),
    )
    op.create_index(op.f("agent_profile_agent_id_idx"), "agent_profile", ["agent_id"], unique=False)
    op.create_index(op.f("agent_profile_id_idx"), "agent_profile", ["id"], unique=False)
    op.create_index(op.f("agent_profile_profile_id_idx"), "agent_profile", ["profile_id"], unique=False)
    op.create_table(
        "profile_collection_access",
        sa.Column("profile_id", sa.Integer(), nullable=False),
        sa.Column("collection_id", sa.Integer(), nullable=False),
        sa.Column("access_granted_at", sa.TIMESTAMP(timezone=True), server_default=sa.text("now()"), nullable=True),
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("created_at", sa.DateTime(timezone=True), server_default=sa.text("now()"), nullable=False),
        sa.Column("updated_at", sa.DateTime(timezone=True), server_default=sa.text("now()"), nullable=False),
        sa.Column("deleted_at", sa.DateTime(timezone=True), nullable=True),
        sa.ForeignKeyConstraint(["collection_id"], ["collection.id"], name=op.f("profile_collection_access_collection_id_fkey"), ondelete="CASCADE"),
        sa.ForeignKeyConstraint(["profile_id"], ["profile.id"], name=op.f("profile_collection_access_profile_id_fkey"), ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("id", name=op.f("profile_collection_access_pkey")),
        sa.UniqueConstraint("profile_id", "collection_id", name="uq_profile_collection"),
    )
    op.create_index(op.f("profile_collection_access_collection_id_idx"), "profile_collection_access", ["collection_id"], unique=False)
    op.create_index(op.f("profile_collection_access_id_idx"), "profile_collection_access", ["id"], unique=False)
    op.create_index(op.f("profile_collection_access_profile_id_idx"), "profile_collection_access", ["profile_id"], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("profile_collection_access_profile_id_idx"), table_name="profile_collection_access")
    op.drop_index(op.f("profile_collection_access_id_idx"), table_name="profile_collection_access")
    op.drop_index(op.f("profile_collection_access_collection_id_idx"), table_name="profile_collection_access")
    op.drop_table("profile_collection_access")
    op.drop_index(op.f("agent_profile_profile_id_idx"), table_name="agent_profile")
    op.drop_index(op.f("agent_profile_id_idx"), table_name="agent_profile")
    op.drop_index(op.f("agent_profile_agent_id_idx"), table_name="agent_profile")
    op.drop_table("agent_profile")
    op.drop_index(op.f("profile_name_idx"), table_name="profile")
    op.drop_index(op.f("profile_id_idx"), table_name="profile")
    op.drop_table("profile")
    op.drop_index(op.f("agent_name_idx"), table_name="agent")
    op.drop_index(op.f("agent_id_idx"), table_name="agent")
    op.drop_table("agent")
    # ### end Alembic commands ###
