"""add support for profile on create convo

Revision ID: b0bcb7ca1dc9
Revises: 327febbf555f
Create Date: 2025-09-18 11:06:41.548193

"""

from typing import Sequence

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision: str = "b0bcb7ca1dc9"
down_revision: str | Sequence[str] | None = "327febbf555f"
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("conversation", sa.Column("is_audio_analysis", sa.Boolean()))
    op.add_column("conversation", sa.Column("profile_id", sa.Integer(), nullable=True))
    op.create_foreign_key(op.f("conversation_profile_id_fkey"), "conversation", "profile", ["profile_id"], ["id"])

    #  set all is_audio_analysis to False
    op.execute("UPDATE conversation SET is_audio_analysis = FALSE")
    #  set to non nullable
    op.alter_column("conversation", "is_audio_analysis", nullable=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(op.f("conversation_profile_id_fkey"), "conversation", type_="foreignkey")
    op.drop_column("conversation", "profile_id")
    op.drop_column("conversation", "is_audio_analysis")
    # ### end Alembic commands ###
