"""Removed doc id from config table (previous revision didn't do this) and changed default values of chunk size and overlap

Revision ID: 6c0e63e0fef8
Revises: bf1472a9b021
Create Date: 2025-10-02 15:25:55.624896

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '6c0e63e0fef8'
down_revision: Union[str, Sequence[str], None] = 'bf1472a9b021'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(op.f('chunk_config_document_id_fkey'), 'chunk_config', type_='foreignkey')
    op.drop_column('chunk_config', 'document_id')
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('chunk_config', sa.Column('document_id', sa.INTEGER(), autoincrement=False, nullable=True))
    op.create_foreign_key(op.f('chunk_config_document_id_fkey'), 'chunk_config', 'document', ['document_id'], ['id'])
    # ### end Alembic commands ###
