"""1 to 1 relationship between collection and source

Revision ID: f9c750ec2a0b
Revises: 7d1cb343a63f
Create Date: 2025-10-03 14:52:06.699081

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = 'f9c750ec2a0b'
down_revision: Union[str, Sequence[str], None] = '7d1cb343a63f'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('source', sa.Column('type', sa.Enum('S3', 'SHARE_POINT', 'GRID', 'CRM', 'CONFLUENCE', 'CUSTOM', name='sourcename', native_enum=False), nullable=True))
    op.add_column('source', sa.Column('collection_id', sa.Integer(), nullable=False))
    op.alter_column('source', 'name',
               existing_type=sa.VARCHAR(length=23),
               type_=sa.String(length=255),
               existing_nullable=False)
    op.drop_index(op.f('source_name_idx'), table_name='source')
    op.create_index(op.f('source_name_idx'), 'source', ['name'], unique=True)
    op.create_index(op.f('source_collection_id_idx'), 'source', ['collection_id'], unique=True)
    op.create_index(op.f('source_type_idx'), 'source', ['type'], unique=False)
    op.create_foreign_key(op.f('source_collection_id_fkey'), 'source', 'collection', ['collection_id'], ['id'])
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(op.f('source_collection_id_fkey'), 'source', type_='foreignkey')
    op.drop_index(op.f('source_type_idx'), table_name='source')
    op.drop_index(op.f('source_collection_id_idx'), table_name='source')
    op.drop_index(op.f('source_name_idx'), table_name='source')
    op.create_index(op.f('source_name_idx'), 'source', ['name'], unique=False)
    op.alter_column('source', 'name',
               existing_type=sa.String(length=255),
               type_=sa.VARCHAR(length=23),
               existing_nullable=False)
    op.drop_column('source', 'collection_id')
    op.drop_column('source', 'type')
    # ### end Alembic commands ###
