"""AD Enum and field added

Revision ID: b789e61df26a
Revises: ff3be2c4311f
Create Date: 2025-10-28 13:33:30.377086

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = 'b789e61df26a'
down_revision: Union[str, Sequence[str], None] = 'ff3be2c4311f'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # Add new MICROSOFT_AD value to the existing contactsource enum type
    op.execute("ALTER TYPE contactsource ADD VALUE IF NOT EXISTS 'MICROSOFT_AD'")

    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('contact', sa.Column('azure_ad_object_id', sa.String(length=36), nullable=True))
    op.add_column('contact', sa.Column('azure_ad_tenant_id', sa.String(length=36), nullable=True))
    op.create_index(op.f('contact_azure_ad_object_id_idx'), 'contact', ['azure_ad_object_id'], unique=True)
    op.create_index(op.f('contact_azure_ad_tenant_id_idx'), 'contact', ['azure_ad_tenant_id'], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('contact_azure_ad_tenant_id_idx'), table_name='contact')
    op.drop_index(op.f('contact_azure_ad_object_id_idx'), table_name='contact')
    op.drop_column('contact', 'azure_ad_tenant_id')
    op.drop_column('contact', 'azure_ad_object_id')
    # ### end Alembic commands ###

    # NOTE: Removing enum values from PostgreSQL types is complex and risky.
    # The 'MICROSOFT_AD' value will remain in the contactsource type after downgrade.
    # If you need to remove it, you would need to recreate the enum type entirely,
    # which requires updating all dependent columns. Not recommended for production.
