"""added collection ids, sync enabled and default publish status to source table

Revision ID: 8a7e56260eba
Revises: b733b48d78b5
Create Date: 2025-11-06 14:50:51.787562

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision: str = '8a7e56260eba'
down_revision: Union[str, Sequence[str], None] = 'b733b48d78b5'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('source', sa.Column('target_collection_ids', postgresql.ARRAY(sa.Integer()), nullable=True))
    op.add_column('source', sa.Column('sync_enabled', sa.Boolean(), nullable=True))
    op.add_column('source', sa.Column('default_publish_status', sa.Enum('PREVIEW', 'ACTIVE', 'INACTIVE', name='documentpublishstatus', native_enum=False), nullable=True))
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('source', 'default_publish_status')
    op.drop_column('source', 'sync_enabled')
    op.drop_column('source', 'target_collection_ids')
    # ### end Alembic commands ###
