"""removed qna related columns from Augmentation and removed confidence score from feedback analysis

Revision ID: 4c4148ac2d21
Revises: 8a7e56260eba
Create Date: 2025-11-06 16:26:20.979418

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '4c4148ac2d21'
down_revision: Union[str, Sequence[str], None] = '8a7e56260eba'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(op.f('augmentation_original_qa_pair_id_fkey'), 'augmentation', type_='foreignkey')
    op.drop_constraint(op.f('augmentation_generated_qa_pair_id_fkey'), 'augmentation', type_='foreignkey')
    op.drop_column('augmentation', 'original_qa_pair_id')
    op.drop_column('augmentation', 'generated_qa_pair_id')
    op.drop_column('feedback_analysis', 'confidence_score')
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('feedback_analysis', sa.Column('confidence_score', sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True))
    op.add_column('augmentation', sa.Column('generated_qa_pair_id', sa.INTEGER(), autoincrement=False, nullable=True))
    op.add_column('augmentation', sa.Column('original_qa_pair_id', sa.INTEGER(), autoincrement=False, nullable=True))
    op.create_foreign_key(op.f('augmentation_generated_qa_pair_id_fkey'), 'augmentation', 'qa_pair', ['generated_qa_pair_id'], ['id'])
    op.create_foreign_key(op.f('augmentation_original_qa_pair_id_fkey'), 'augmentation', 'qa_pair', ['original_qa_pair_id'], ['id'])
    # ### end Alembic commands ###
