"""Removed un used fields from feedback

Revision ID: b9663951b5c1
Revises: 7d0982bae4db
Create Date: 2025-11-12 17:27:14.338546

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision: str = 'b9663951b5c1'
down_revision: Union[str, Sequence[str], None] = '7d0982bae4db'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('augmentation_status_idx'), table_name='augmentation')
    op.drop_column('augmentation', 'status')
    op.drop_column('augmentation', 'change_summary')
    op.drop_column('augmentation', 'action_type')
    op.drop_index(op.f('feedback_assigned_reviewer_id_idx'), table_name='feedback')
    op.drop_index(op.f('feedback_manager_id_idx'), table_name='feedback')
    op.drop_index(op.f('feedback_qa_pair_id_idx'), table_name='feedback')
    op.drop_constraint(op.f('feedback_assigned_reviewer_id_fkey'), 'feedback', type_='foreignkey')
    op.drop_constraint(op.f('feedback_manager_id_fkey'), 'feedback', type_='foreignkey')
    op.drop_constraint(op.f('feedback_qa_pair_id_fkey'), 'feedback', type_='foreignkey')
    op.drop_column('feedback', 'authority_domain')
    op.drop_column('feedback', 'assigned_reviewer_id')
    op.drop_column('feedback', 'routed')
    op.drop_column('feedback', 'requires_review')
    op.drop_column('feedback', 'qa_pair_id')
    op.drop_column('feedback', 'manager_id')
    op.drop_column('feedback', 'confidence_level')
    op.drop_column('feedback', 'reviewed_at')
    op.drop_column('feedback_analysis', 'analysis_type')
    op.drop_column('feedback_analysis', 'analyzed_at')
    op.drop_column('feedback_analysis', 'model_used')
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('feedback_analysis', sa.Column('model_used', sa.VARCHAR(length=255), autoincrement=False, nullable=True))
    op.add_column('feedback_analysis', sa.Column('analyzed_at', postgresql.TIMESTAMP(timezone=True), server_default=sa.text('now()'), autoincrement=False, nullable=False))
    op.add_column('feedback_analysis', sa.Column('analysis_type', sa.VARCHAR(length=50), autoincrement=False, nullable=False))
    op.add_column('feedback', sa.Column('reviewed_at', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True))
    op.add_column('feedback', sa.Column('confidence_level', sa.VARCHAR(length=50), autoincrement=False, nullable=True))
    op.add_column('feedback', sa.Column('manager_id', sa.INTEGER(), autoincrement=False, nullable=False))
    op.add_column('feedback', sa.Column('qa_pair_id', sa.INTEGER(), autoincrement=False, nullable=True))
    op.add_column('feedback', sa.Column('requires_review', sa.BOOLEAN(), autoincrement=False, nullable=False))
    op.add_column('feedback', sa.Column('routed', sa.BOOLEAN(), autoincrement=False, nullable=False))
    op.add_column('feedback', sa.Column('assigned_reviewer_id', sa.INTEGER(), autoincrement=False, nullable=True))
    op.add_column('feedback', sa.Column('authority_domain', sa.VARCHAR(length=255), autoincrement=False, nullable=True))
    op.create_foreign_key(op.f('feedback_qa_pair_id_fkey'), 'feedback', 'qa_pair', ['qa_pair_id'], ['id'])
    op.create_foreign_key(op.f('feedback_manager_id_fkey'), 'feedback', 'contact', ['manager_id'], ['id'])
    op.create_foreign_key(op.f('feedback_assigned_reviewer_id_fkey'), 'feedback', 'contact', ['assigned_reviewer_id'], ['id'])
    op.create_index(op.f('feedback_qa_pair_id_idx'), 'feedback', ['qa_pair_id'], unique=False)
    op.create_index(op.f('feedback_manager_id_idx'), 'feedback', ['manager_id'], unique=False)
    op.create_index(op.f('feedback_assigned_reviewer_id_idx'), 'feedback', ['assigned_reviewer_id'], unique=False)
    op.add_column('augmentation', sa.Column('action_type', sa.VARCHAR(length=50), autoincrement=False, nullable=False))
    op.add_column('augmentation', sa.Column('change_summary', postgresql.JSON(astext_type=sa.Text()), autoincrement=False, nullable=True))
    op.add_column('augmentation', sa.Column('status', sa.VARCHAR(length=50), autoincrement=False, nullable=False))
    op.create_index(op.f('augmentation_status_idx'), 'augmentation', ['status'], unique=False)
    # ### end Alembic commands ###
