"""add rerieved and created chunks and analysis type in feedback analysis

Revision ID: 2c62317520f9
Revises: fa00286fe6cd
Create Date: 2025-11-14 12:16:09.697833

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '2c62317520f9'
down_revision: Union[str, Sequence[str], None] = 'fa00286fe6cd'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('feedback_analysis', sa.Column('retrieved_chunks', sa.ARRAY(sa.Integer()), nullable=True))
    op.add_column('feedback_analysis', sa.Column('created_chunks', sa.ARRAY(sa.Integer()), nullable=True))
    op.add_column('feedback_analysis', sa.Column('analysis_type', sa.String(length=50), nullable=True))
    op.alter_column('feedback_analysis', 'approved',
               existing_type=sa.BOOLEAN(),
               nullable=True)
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column('feedback_analysis', 'approved',
               existing_type=sa.BOOLEAN(),
               nullable=False)
    op.drop_column('feedback_analysis', 'analysis_type')
    op.drop_column('feedback_analysis', 'created_chunks')
    op.drop_column('feedback_analysis', 'retrieved_chunks')
    # ### end Alembic commands ###
