"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Assert = exports.AssertProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ros_generated_1 = require("./ros.generated");
Object.defineProperty(exports, "AssertProperty", { enumerable: true, get: function () { return ros_generated_1.RosAssert; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::ROS::Assert`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosAssert`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ros-assert
 */
class Assert extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosAssert = new ros_generated_1.RosAssert(this, id, {
            values: props.values,
            operation: props.operation === undefined || props.operation === null ? 'Equal' : props.operation,
            errorMessage: props.errorMessage,
            abortCreation: props.abortCreation === undefined || props.abortCreation === null ? true : props.abortCreation,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosAssert;
        this.attrFailureCause = rosAssert.attrFailureCause;
        this.attrResult = rosAssert.attrResult;
    }
}
exports.Assert = Assert;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXNzZXJ0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYXNzZXJ0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLDhDQUE4QztBQUM5QyxtREFBNEM7QUFFdEIsK0ZBRmIseUJBQVMsT0FFa0I7QUFpRHBDOzs7O0dBSUc7QUFDSCxNQUFhLE1BQU8sU0FBUSxHQUFHLENBQUMsUUFBUTtJQWdCcEM7Ozs7T0FJRztJQUNILFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBa0IsRUFBRSxtQ0FBMkMsSUFBSTtRQUM3RyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ2pCLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO1FBQ25CLElBQUksQ0FBQyxFQUFFLEdBQUcsRUFBRSxDQUFDO1FBQ2IsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7UUFDbkIsSUFBSSxDQUFDLGdDQUFnQyxHQUFHLGdDQUFnQyxDQUFDO1FBRXpFLE1BQU0sU0FBUyxHQUFHLElBQUkseUJBQVMsQ0FBQyxJQUFJLEVBQUUsRUFBRSxFQUFHO1lBQ3ZDLE1BQU0sRUFBRSxLQUFLLENBQUMsTUFBTTtZQUNwQixTQUFTLEVBQUUsS0FBSyxDQUFDLFNBQVMsS0FBSyxTQUFTLElBQUksS0FBSyxDQUFDLFNBQVMsS0FBSyxJQUFJLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLFNBQVM7WUFDaEcsWUFBWSxFQUFFLEtBQUssQ0FBQyxZQUFZO1lBQ2hDLGFBQWEsRUFBRSxLQUFLLENBQUMsYUFBYSxLQUFLLFNBQVMsSUFBSSxLQUFLLENBQUMsYUFBYSxLQUFLLElBQUksQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsYUFBYTtTQUNoSCxFQUFFLGdDQUFnQyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztRQUNwRixJQUFJLENBQUMsUUFBUSxHQUFHLFNBQVMsQ0FBQztRQUMxQixJQUFJLENBQUMsZ0JBQWdCLEdBQUcsU0FBUyxDQUFDLGdCQUFnQixDQUFDO1FBQ25ELElBQUksQ0FBQyxVQUFVLEdBQUcsU0FBUyxDQUFDLFVBQVUsQ0FBQztJQUMzQyxDQUFDO0NBQ0o7QUF0Q0Qsd0JBc0NDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgcm9zIGZyb20gJ0BhbGljbG91ZC9yb3MtY2RrLWNvcmUnO1xuaW1wb3J0IHsgUm9zQXNzZXJ0IH0gZnJvbSAnLi9yb3MuZ2VuZXJhdGVkJztcbi8vIEdlbmVyYXRlZCBmcm9tIHRoZSBBbGlDbG91ZCBST1MgUmVzb3VyY2UgU3BlY2lmaWNhdGlvblxuZXhwb3J0IHsgUm9zQXNzZXJ0IGFzIEFzc2VydFByb3BlcnR5IH07XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYSBgQXNzZXJ0YC5cbiAqIFNlZSBodHRwczovL3d3dy5hbGliYWJhY2xvdWQuY29tL2hlbHAvcm9zL2RldmVsb3Blci1yZWZlcmVuY2UvYWxpeXVuLXJvcy1hc3NlcnRcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBBc3NlcnRQcm9wcyB7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSB2YWx1ZXM6IEEgbGlzdCBvZiB2YWx1ZXMgdG8gYXNzZXJ0LiBUaGUgaXRlbXMgaW4gdGhlIGxpc3QgYXJlIGNvbXBhcmVkIGluIG9yZGVyLiBUaGUgcmFuZ2Ugb2YgbGVuZ3RoIGlzIG9uZSB0byB0aHJlZS4gXG4gICAgICogLSBUaHJlZSB2YWx1ZXMgYXJlIHN1cHBvcnRlZCBvbmx5IGlmIHRoZSBvcGVyYXRpb24gaXMgRXF1YWwgb3IgTm90RXF1YWwuXG4gICAgICogLSBPbmUgdmFsdWUgaXMgc3VwcG9ydGVkIG9ubHkgaWYgdGhlIG9wZXJhdGlvbiBpcyBOb3QuXG4gICAgICovXG4gICAgcmVhZG9ubHkgdmFsdWVzOiBBcnJheTxhbnkgfCByb3MuSVJlc29sdmFibGU+IHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgYWJvcnRDcmVhdGlvbjogV2hldGhlciB0byBhYm9ydCBjcmVhdGlvbiB3aGVuIHRoZSBhc3NlcnQgZmFpbHMuIERlZmF1bHQgaXMgVHJ1ZS5cbiAgICAgKi9cbiAgICByZWFkb25seSBhYm9ydENyZWF0aW9uPzogYm9vbGVhbiB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGVycm9yTWVzc2FnZTogVGhlIGVycm9yIG1lc3NhZ2UgdG8gYmUgcmV0dXJuZWQgd2hlbiB0aGUgYXNzZXJ0IGZhaWxzLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGVycm9yTWVzc2FnZT86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IG9wZXJhdGlvbjogVGhlIHR5cGUgb2YgYXNzZXJ0aW9uIHRvIG1ha2UuIFRoZSBzdXBwb3J0ZWQgb3BlcmF0aW9ucyBhcmU6XG4gICAgICogRXF1YWwsIE5vdEVxdWFsLCBHcmVhdGVyLCBHcmVhdGVyT3JFcXVhbCwgTGVzcywgTGVzc09yRXF1YWwsIENvbnRhaW4sIE5vdENvbnRhaW4sIEFuZCwgT3IsIE5vdC5cbiAgICAgKiBEZWZhdWx0IGlzIEVxdWFsLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IG9wZXJhdGlvbj86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcbn1cblxuLyoqXG4gKiBSZXByZXNlbnRzIGEgYEFzc2VydGAuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSUFzc2VydCBleHRlbmRzIHJvcy5JUmVzb3VyY2Uge1xuICAgIHJlYWRvbmx5IHByb3BzOiBBc3NlcnRQcm9wcztcblxuICAgIC8qKlxuICAgICAqIEF0dHJpYnV0ZSBGYWlsdXJlQ2F1c2U6IFRoZSByZWFzb24gdGhlIGFzc2VydGlvbiBmYWlsZWRcbiAgICAgKi9cbiAgICByZWFkb25seSBhdHRyRmFpbHVyZUNhdXNlOiByb3MuSVJlc29sdmFibGUgfCBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgUmVzdWx0OiBUaGUgcmVzdWx0IG9mIHRoZSBhc3NlcnQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgYXR0clJlc3VsdDogcm9zLklSZXNvbHZhYmxlIHwgc3RyaW5nO1xufVxuLyoqXG4gKiBUaGlzIGNsYXNzIGVuY2Fwc3VsYXRlcyBhbmQgZXh0ZW5kcyB0aGUgUk9TIHJlc291cmNlIHR5cGUgYEFMSVlVTjo6Uk9TOjpBc3NlcnRgLlxuICogQE5vdGUgVGhpcyBjbGFzcyBtYXkgaGF2ZSBzb21lIG5ldyBmdW5jdGlvbnMgdG8gZmFjaWxpdGF0ZSBkZXZlbG9wbWVudCwgc28gaXQgaXMgcmVjb21tZW5kZWQgdG8gdXNlIHRoaXMgY2xhc3MgaW5zdGVhZCBvZiBgUm9zQXNzZXJ0YGZvciBhIG1vcmUgY29udmVuaWVudCBkZXZlbG9wbWVudCBleHBlcmllbmNlLlxuICogU2VlIGh0dHBzOi8vd3d3LmFsaWJhYmFjbG91ZC5jb20vaGVscC9yb3MvZGV2ZWxvcGVyLXJlZmVyZW5jZS9hbGl5dW4tcm9zLWFzc2VydFxuICovXG5leHBvcnQgY2xhc3MgQXNzZXJ0IGV4dGVuZHMgcm9zLlJlc291cmNlIGltcGxlbWVudHMgSUFzc2VydCB7XG4gICAgcHJvdGVjdGVkIHNjb3BlOiByb3MuQ29uc3RydWN0O1xuICAgIHByb3RlY3RlZCBpZDogc3RyaW5nO1xuICAgIHB1YmxpYyByZWFkb25seSBwcm9wczogQXNzZXJ0UHJvcHM7XG4gICAgcHJvdGVjdGVkIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50OiBib29sZWFuO1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIEZhaWx1cmVDYXVzZTogVGhlIHJlYXNvbiB0aGUgYXNzZXJ0aW9uIGZhaWxlZFxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyRmFpbHVyZUNhdXNlOiByb3MuSVJlc29sdmFibGUgfCBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgUmVzdWx0OiBUaGUgcmVzdWx0IG9mIHRoZSBhc3NlcnQuXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJSZXN1bHQ6IHJvcy5JUmVzb2x2YWJsZSB8IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFBhcmFtIHNjb3BlIC0gc2NvcGUgaW4gd2hpY2ggdGhpcyByZXNvdXJjZSBpcyBkZWZpbmVkXG4gICAgICogUGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXG4gICAgICogUGFyYW0gcHJvcHMgLSByZXNvdXJjZSBwcm9wZXJ0aWVzXG4gICAgICovXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IHJvcy5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBBc3NlcnRQcm9wcywgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6Ym9vbGVhbiA9IHRydWUpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICAgICAgdGhpcy5zY29wZSA9IHNjb3BlO1xuICAgICAgICB0aGlzLmlkID0gaWQ7XG4gICAgICAgIHRoaXMucHJvcHMgPSBwcm9wcztcbiAgICAgICAgdGhpcy5lbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCA9IGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50O1xuXG4gICAgICAgIGNvbnN0IHJvc0Fzc2VydCA9IG5ldyBSb3NBc3NlcnQodGhpcywgaWQsICB7XG4gICAgICAgICAgICB2YWx1ZXM6IHByb3BzLnZhbHVlcyxcbiAgICAgICAgICAgIG9wZXJhdGlvbjogcHJvcHMub3BlcmF0aW9uID09PSB1bmRlZmluZWQgfHwgcHJvcHMub3BlcmF0aW9uID09PSBudWxsID8gJ0VxdWFsJyA6IHByb3BzLm9wZXJhdGlvbixcbiAgICAgICAgICAgIGVycm9yTWVzc2FnZTogcHJvcHMuZXJyb3JNZXNzYWdlLFxuICAgICAgICAgICAgYWJvcnRDcmVhdGlvbjogcHJvcHMuYWJvcnRDcmVhdGlvbiA9PT0gdW5kZWZpbmVkIHx8IHByb3BzLmFib3J0Q3JlYXRpb24gPT09IG51bGwgPyB0cnVlIDogcHJvcHMuYWJvcnRDcmVhdGlvbixcbiAgICAgICAgfSwgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQgJiYgdGhpcy5zdGFjay5lbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCk7XG4gICAgICAgIHRoaXMucmVzb3VyY2UgPSByb3NBc3NlcnQ7XG4gICAgICAgIHRoaXMuYXR0ckZhaWx1cmVDYXVzZSA9IHJvc0Fzc2VydC5hdHRyRmFpbHVyZUNhdXNlO1xuICAgICAgICB0aGlzLmF0dHJSZXN1bHQgPSByb3NBc3NlcnQuYXR0clJlc3VsdDtcbiAgICB9XG59XG4iXX0=