"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoEnableService = exports.AutoEnableServiceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ros_generated_1 = require("./ros.generated");
Object.defineProperty(exports, "AutoEnableServiceProperty", { enumerable: true, get: function () { return ros_generated_1.RosAutoEnableService; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::ROS::AutoEnableService`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosAutoEnableService`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ros-autoenableservice
 */
class AutoEnableService extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosAutoEnableService = new ros_generated_1.RosAutoEnableService(this, id, {
            serviceName: props.serviceName,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosAutoEnableService;
    }
}
exports.AutoEnableService = AutoEnableService;
//# sourceMappingURL=data:application/json;base64,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