"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StackInstance = exports.StackInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ros_generated_1 = require("./ros.generated");
Object.defineProperty(exports, "StackInstanceProperty", { enumerable: true, get: function () { return ros_generated_1.RosStackInstance; } });
/**
 * This class encapsulates and extends the ROS resource type `DATASOURCE::ROS::StackInstance`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosStackInstance`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/datasource-ros-stackinstance
 */
class StackInstance extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosStackInstance = new ros_generated_1.RosStackInstance(this, id, {
            stackInstanceAccountId: props.stackInstanceAccountId,
            stackGroupName: props.stackGroupName,
            stackInstanceRegionId: props.stackInstanceRegionId,
            outputOption: props.outputOption,
            refreshOptions: props.refreshOptions === undefined || props.refreshOptions === null ? 'Never' : props.refreshOptions,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosStackInstance;
        this.attrAccountId = rosStackInstance.attrAccountId;
        this.attrDriftDetectionTime = rosStackInstance.attrDriftDetectionTime;
        this.attrOutputs = rosStackInstance.attrOutputs;
        this.attrParameterOverrides = rosStackInstance.attrParameterOverrides;
        this.attrRdFolderId = rosStackInstance.attrRdFolderId;
        this.attrRegionId = rosStackInstance.attrRegionId;
        this.attrStackDriftStatus = rosStackInstance.attrStackDriftStatus;
        this.attrStackGroupId = rosStackInstance.attrStackGroupId;
        this.attrStackGroupName = rosStackInstance.attrStackGroupName;
        this.attrStackId = rosStackInstance.attrStackId;
        this.attrStatus = rosStackInstance.attrStatus;
        this.attrStatusReason = rosStackInstance.attrStatusReason;
    }
}
exports.StackInstance = StackInstance;
//# sourceMappingURL=data:application/json;base64,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