"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosWaitConditionHandle = exports.RosWaitCondition = exports.RosStackInstances = exports.RosStackGroup = exports.RosStack = exports.RosSleep = exports.RosResourceCleaner = exports.RosCustomResource = exports.RosAutoEnableService = exports.RosAssert = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosAssertProps`
 *
 * @param properties - the TypeScript properties of a `RosAssertProps`
 *
 * @returns the result of the validation.
 */
function RosAssertPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('values', ros.requiredValidator)(properties.values));
    if (properties.values && (Array.isArray(properties.values) || (typeof properties.values) === 'string')) {
        errors.collect(ros.propertyValidator('values', ros.validateLength)({
            data: properties.values.length,
            min: 1,
            max: 3,
        }));
    }
    errors.collect(ros.propertyValidator('values', ros.listValidator(ros.validateAny))(properties.values));
    if (properties.operation && (typeof properties.operation) !== 'object') {
        errors.collect(ros.propertyValidator('operation', ros.validateAllowedValues)({
            data: properties.operation,
            allowedValues: ["Equal", "NotEqual", "Greater", "GreaterOrEqual", "Less", "LessOrEqual", "Contain", "NotContain", "And", "Or", "Not"],
        }));
    }
    errors.collect(ros.propertyValidator('operation', ros.validateString)(properties.operation));
    errors.collect(ros.propertyValidator('errorMessage', ros.validateString)(properties.errorMessage));
    errors.collect(ros.propertyValidator('abortCreation', ros.validateBoolean)(properties.abortCreation));
    return errors.wrap('supplied properties not correct for "RosAssertProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::ROS::Assert` resource
 *
 * @param properties - the TypeScript properties of a `RosAssertProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::ROS::Assert` resource.
 */
// @ts-ignore TS6133
function rosAssertPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosAssertPropsValidator(properties).assertSuccess();
    }
    return {
        'Values': ros.listMapper(ros.objectToRosTemplate)(properties.values),
        'AbortCreation': ros.booleanToRosTemplate(properties.abortCreation),
        'ErrorMessage': ros.stringToRosTemplate(properties.errorMessage),
        'Operation': ros.stringToRosTemplate(properties.operation),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::ROS::Assert`.
 * @Note This class does not contain additional functions, so it is recommended to use the `Assert` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ros-assert
 */
class RosAssert extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosAssert.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrFailureCause = this.getAtt('FailureCause');
        this.attrResult = this.getAtt('Result');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.values = props.values;
        this.abortCreation = props.abortCreation;
        this.errorMessage = props.errorMessage;
        this.operation = props.operation;
    }
    get rosProperties() {
        return {
            values: this.values,
            abortCreation: this.abortCreation,
            errorMessage: this.errorMessage,
            operation: this.operation,
        };
    }
    renderProperties(props) {
        return rosAssertPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosAssert = RosAssert;
/**
 * The resource type name for this resource class.
 */
RosAssert.ROS_RESOURCE_TYPE_NAME = "ALIYUN::ROS::Assert";
/**
 * Determine whether the given properties match those of a `RosAutoEnableServiceProps`
 *
 * @param properties - the TypeScript properties of a `RosAutoEnableServiceProps`
 *
 * @returns the result of the validation.
 */
function RosAutoEnableServicePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('serviceName', ros.requiredValidator)(properties.serviceName));
    if (properties.serviceName && (typeof properties.serviceName) !== 'object') {
        errors.collect(ros.propertyValidator('serviceName', ros.validateAllowedValues)({
            data: properties.serviceName,
            allowedValues: ["EMAS", "ARMS/SyntheticPost", "Xtrace", "DataWorks", "FNF", "FC", "KMS", "PAI", "Config", "HBR", "IOT", "ARMS", "SAE", "CloudStorageGateway", "BatchCompute", "BrainIndustrial", "ARMS/PrometheusMonitor", "IMM", "CS", "CR", "NAS", "CDN", "PrivateZone", "AHAS", "TrafficMirror", "CMS", "ApiGateway", "NLP", "OSS", "MNS", "CDT", "PrivateLink", "TransitRouter", "ARMS/Web", "MaxCompute", "SLS", "VS", "CloudSSO", "DataHub", "EDAS", "DSC", "RocketMQ", "ControlPolicy", "CDTCb", "ARMS/App", "DCDN", "OTS", "TrustedService/ROS"],
        }));
    }
    errors.collect(ros.propertyValidator('serviceName', ros.validateString)(properties.serviceName));
    return errors.wrap('supplied properties not correct for "RosAutoEnableServiceProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::ROS::AutoEnableService` resource
 *
 * @param properties - the TypeScript properties of a `RosAutoEnableServiceProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::ROS::AutoEnableService` resource.
 */
// @ts-ignore TS6133
function rosAutoEnableServicePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosAutoEnableServicePropsValidator(properties).assertSuccess();
    }
    return {
        'ServiceName': ros.stringToRosTemplate(properties.serviceName),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::ROS::AutoEnableService`.
 * @Note This class does not contain additional functions, so it is recommended to use the `AutoEnableService` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ros-autoenableservice
 */
class RosAutoEnableService extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosAutoEnableService.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.serviceName = props.serviceName;
    }
    get rosProperties() {
        return {
            serviceName: this.serviceName,
        };
    }
    renderProperties(props) {
        return rosAutoEnableServicePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosAutoEnableService = RosAutoEnableService;
/**
 * The resource type name for this resource class.
 */
RosAutoEnableService.ROS_RESOURCE_TYPE_NAME = "ALIYUN::ROS::AutoEnableService";
/**
 * Determine whether the given properties match those of a `RosCustomResourceProps`
 *
 * @param properties - the TypeScript properties of a `RosCustomResourceProps`
 *
 * @returns the result of the validation.
 */
function RosCustomResourcePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('serviceToken', ros.requiredValidator)(properties.serviceToken));
    if (properties.serviceToken && (Array.isArray(properties.serviceToken) || (typeof properties.serviceToken) === 'string')) {
        errors.collect(ros.propertyValidator('serviceToken', ros.validateLength)({
            data: properties.serviceToken.length,
            min: undefined,
            max: 512,
        }));
    }
    errors.collect(ros.propertyValidator('serviceToken', ros.validateString)(properties.serviceToken));
    errors.collect(ros.propertyValidator('parameters', ros.hashValidator(ros.validateAny))(properties.parameters));
    errors.collect(ros.propertyValidator('timeout', ros.requiredValidator)(properties.timeout));
    if (properties.timeout && (typeof properties.timeout) !== 'object') {
        errors.collect(ros.propertyValidator('timeout', ros.validateRange)({
            data: properties.timeout,
            min: 1,
            max: 43200,
        }));
    }
    errors.collect(ros.propertyValidator('timeout', ros.validateNumber)(properties.timeout));
    errors.collect(ros.propertyValidator('httpConfig', RosCustomResource_HttpConfigPropertyValidator)(properties.httpConfig));
    return errors.wrap('supplied properties not correct for "RosCustomResourceProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::ROS::CustomResource` resource
 *
 * @param properties - the TypeScript properties of a `RosCustomResourceProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::ROS::CustomResource` resource.
 */
// @ts-ignore TS6133
function rosCustomResourcePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosCustomResourcePropsValidator(properties).assertSuccess();
    }
    return {
        'ServiceToken': ros.stringToRosTemplate(properties.serviceToken),
        'Timeout': ros.numberToRosTemplate(properties.timeout),
        'HttpConfig': rosCustomResourceHttpConfigPropertyToRosTemplate(properties.httpConfig),
        'Parameters': ros.hashMapper(ros.objectToRosTemplate)(properties.parameters),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::ROS::CustomResource`.
 * @Note This class does not contain additional functions, so it is recommended to use the `CustomResource` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ros-customresource
 */
class RosCustomResource extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosCustomResource.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrOutputs = this.getAtt('Outputs');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.serviceToken = props.serviceToken;
        this.timeout = props.timeout;
        this.httpConfig = props.httpConfig;
        this.parameters = props.parameters;
    }
    get rosProperties() {
        return {
            serviceToken: this.serviceToken,
            timeout: this.timeout,
            httpConfig: this.httpConfig,
            parameters: this.parameters,
        };
    }
    renderProperties(props) {
        return rosCustomResourcePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosCustomResource = RosCustomResource;
/**
 * The resource type name for this resource class.
 */
RosCustomResource.ROS_RESOURCE_TYPE_NAME = "ALIYUN::ROS::CustomResource";
/**
 * Determine whether the given properties match those of a `HttpConfigProperty`
 *
 * @param properties - the TypeScript properties of a `HttpConfigProperty`
 *
 * @returns the result of the validation.
 */
function RosCustomResource_HttpConfigPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.signKey && (Array.isArray(properties.signKey) || (typeof properties.signKey) === 'string')) {
        errors.collect(ros.propertyValidator('signKey', ros.validateLength)({
            data: properties.signKey.length,
            min: 1,
            max: 128,
        }));
    }
    errors.collect(ros.propertyValidator('signKey', ros.validateString)(properties.signKey));
    if (properties.contentType && (typeof properties.contentType) !== 'object') {
        errors.collect(ros.propertyValidator('contentType', ros.validateAllowedValues)({
            data: properties.contentType,
            allowedValues: ["application/json", "application/x-www-form-urlencoded"],
        }));
    }
    errors.collect(ros.propertyValidator('contentType', ros.validateString)(properties.contentType));
    errors.collect(ros.propertyValidator('headers', ros.hashValidator(ros.validateAny))(properties.headers));
    return errors.wrap('supplied properties not correct for "HttpConfigProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::ROS::CustomResource.HttpConfig` resource
 *
 * @param properties - the TypeScript properties of a `HttpConfigProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::ROS::CustomResource.HttpConfig` resource.
 */
// @ts-ignore TS6133
function rosCustomResourceHttpConfigPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosCustomResource_HttpConfigPropertyValidator(properties).assertSuccess();
    return {
        'SignKey': ros.stringToRosTemplate(properties.signKey),
        'ContentType': ros.stringToRosTemplate(properties.contentType),
        'Headers': ros.hashMapper(ros.objectToRosTemplate)(properties.headers),
    };
}
/**
 * Determine whether the given properties match those of a `RosResourceCleanerProps`
 *
 * @param properties - the TypeScript properties of a `RosResourceCleanerProps`
 *
 * @returns the result of the validation.
 */
function RosResourceCleanerPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.failureOption && (typeof properties.failureOption) !== 'object') {
        errors.collect(ros.propertyValidator('failureOption', ros.validateAllowedValues)({
            data: properties.failureOption,
            allowedValues: ["Normal", "Fast"],
        }));
    }
    errors.collect(ros.propertyValidator('failureOption', ros.validateString)(properties.failureOption));
    if (properties.resourceFilters && (Array.isArray(properties.resourceFilters) || (typeof properties.resourceFilters) === 'string')) {
        errors.collect(ros.propertyValidator('resourceFilters', ros.validateLength)({
            data: properties.resourceFilters.length,
            min: 1,
            max: 100,
        }));
    }
    errors.collect(ros.propertyValidator('resourceFilters', ros.listValidator(RosResourceCleaner_ResourceFiltersPropertyValidator))(properties.resourceFilters));
    errors.collect(ros.propertyValidator('action', ros.requiredValidator)(properties.action));
    if (properties.action && (typeof properties.action) !== 'object') {
        errors.collect(ros.propertyValidator('action', ros.validateAllowedValues)({
            data: properties.action,
            allowedValues: ["Scan", "CleanUp", "Scan+CleanUp", "ScanWhenCreatingAndUpdating+CleanUpWhenDeleting"],
        }));
    }
    errors.collect(ros.propertyValidator('action', ros.validateString)(properties.action));
    if (properties.cleanUpAlgorithm && (typeof properties.cleanUpAlgorithm) !== 'object') {
        errors.collect(ros.propertyValidator('cleanUpAlgorithm', ros.validateAllowedValues)({
            data: properties.cleanUpAlgorithm,
            allowedValues: ["ResourceDependency", "ResourceTypeOrder"],
        }));
    }
    errors.collect(ros.propertyValidator('cleanUpAlgorithm', ros.validateString)(properties.cleanUpAlgorithm));
    if (properties.mode && (typeof properties.mode) !== 'object') {
        errors.collect(ros.propertyValidator('mode', ros.validateAllowedValues)({
            data: properties.mode,
            allowedValues: ["Strict", "Loose", "LooseWithResourceCleanerFailure"],
        }));
    }
    errors.collect(ros.propertyValidator('mode', ros.validateString)(properties.mode));
    if (properties.cleanUpRetryCount && (typeof properties.cleanUpRetryCount) !== 'object') {
        errors.collect(ros.propertyValidator('cleanUpRetryCount', ros.validateRange)({
            data: properties.cleanUpRetryCount,
            min: 1,
            max: 6,
        }));
    }
    errors.collect(ros.propertyValidator('cleanUpRetryCount', ros.validateNumber)(properties.cleanUpRetryCount));
    if (properties.resourceTypeOrder && (Array.isArray(properties.resourceTypeOrder) || (typeof properties.resourceTypeOrder) === 'string')) {
        errors.collect(ros.propertyValidator('resourceTypeOrder', ros.validateLength)({
            data: properties.resourceTypeOrder.length,
            min: 1,
            max: 1000,
        }));
    }
    errors.collect(ros.propertyValidator('resourceTypeOrder', ros.listValidator(ros.validateString))(properties.resourceTypeOrder));
    if (properties.resources && (Array.isArray(properties.resources) || (typeof properties.resources) === 'string')) {
        errors.collect(ros.propertyValidator('resources', ros.validateLength)({
            data: properties.resources.length,
            min: 1,
            max: 1000,
        }));
    }
    errors.collect(ros.propertyValidator('resources', ros.listValidator(RosResourceCleaner_ResourcesPropertyValidator))(properties.resources));
    if (properties.cleanUpTimeout && (typeof properties.cleanUpTimeout) !== 'object') {
        errors.collect(ros.propertyValidator('cleanUpTimeout', ros.validateRange)({
            data: properties.cleanUpTimeout,
            min: 60,
            max: 14400,
        }));
    }
    errors.collect(ros.propertyValidator('cleanUpTimeout', ros.validateNumber)(properties.cleanUpTimeout));
    if (properties.disabledSideEffects && (Array.isArray(properties.disabledSideEffects) || (typeof properties.disabledSideEffects) === 'string')) {
        errors.collect(ros.propertyValidator('disabledSideEffects', ros.validateLength)({
            data: properties.disabledSideEffects.length,
            min: undefined,
            max: 50,
        }));
    }
    errors.collect(ros.propertyValidator('disabledSideEffects', ros.listValidator(ros.validateString))(properties.disabledSideEffects));
    if (properties.excludedResources && (Array.isArray(properties.excludedResources) || (typeof properties.excludedResources) === 'string')) {
        errors.collect(ros.propertyValidator('excludedResources', ros.validateLength)({
            data: properties.excludedResources.length,
            min: undefined,
            max: 1000,
        }));
    }
    errors.collect(ros.propertyValidator('excludedResources', ros.listValidator(RosResourceCleaner_ExcludedResourcesPropertyValidator))(properties.excludedResources));
    return errors.wrap('supplied properties not correct for "RosResourceCleanerProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::ROS::ResourceCleaner` resource
 *
 * @param properties - the TypeScript properties of a `RosResourceCleanerProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::ROS::ResourceCleaner` resource.
 */
// @ts-ignore TS6133
function rosResourceCleanerPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosResourceCleanerPropsValidator(properties).assertSuccess();
    }
    return {
        'Action': ros.stringToRosTemplate(properties.action),
        'CleanUpAlgorithm': ros.stringToRosTemplate(properties.cleanUpAlgorithm),
        'CleanUpRetryCount': ros.numberToRosTemplate(properties.cleanUpRetryCount),
        'CleanUpTimeout': ros.numberToRosTemplate(properties.cleanUpTimeout),
        'DisabledSideEffects': ros.listMapper(ros.stringToRosTemplate)(properties.disabledSideEffects),
        'ExcludedResources': ros.listMapper(rosResourceCleanerExcludedResourcesPropertyToRosTemplate)(properties.excludedResources),
        'FailureOption': ros.stringToRosTemplate(properties.failureOption),
        'Mode': ros.stringToRosTemplate(properties.mode),
        'ResourceFilters': ros.listMapper(rosResourceCleanerResourceFiltersPropertyToRosTemplate)(properties.resourceFilters),
        'Resources': ros.listMapper(rosResourceCleanerResourcesPropertyToRosTemplate)(properties.resources),
        'ResourceTypeOrder': ros.listMapper(ros.stringToRosTemplate)(properties.resourceTypeOrder),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::ROS::ResourceCleaner`.
 * @Note This class does not contain additional functions, so it is recommended to use the `ResourceCleaner` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ros-resourcecleaner
 */
class RosResourceCleaner extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosResourceCleaner.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrCleanResult = this.getAtt('CleanResult');
        this.attrNoCleanupResourceDetails = this.getAtt('NoCleanupResourceDetails');
        this.attrNoCleanupResourcePartialDetails = this.getAtt('NoCleanupResourcePartialDetails');
        this.attrResourceDetails = this.getAtt('ResourceDetails');
        this.attrResourcePartialDetails = this.getAtt('ResourcePartialDetails');
        this.attrResourceSummary = this.getAtt('ResourceSummary');
        this.attrScanErrors = this.getAtt('ScanErrors');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.action = props.action;
        this.cleanUpAlgorithm = props.cleanUpAlgorithm;
        this.cleanUpRetryCount = props.cleanUpRetryCount;
        this.cleanUpTimeout = props.cleanUpTimeout;
        this.disabledSideEffects = props.disabledSideEffects;
        this.excludedResources = props.excludedResources;
        this.failureOption = props.failureOption;
        this.mode = props.mode;
        this.resourceFilters = props.resourceFilters;
        this.resources = props.resources;
        this.resourceTypeOrder = props.resourceTypeOrder;
    }
    get rosProperties() {
        return {
            action: this.action,
            cleanUpAlgorithm: this.cleanUpAlgorithm,
            cleanUpRetryCount: this.cleanUpRetryCount,
            cleanUpTimeout: this.cleanUpTimeout,
            disabledSideEffects: this.disabledSideEffects,
            excludedResources: this.excludedResources,
            failureOption: this.failureOption,
            mode: this.mode,
            resourceFilters: this.resourceFilters,
            resources: this.resources,
            resourceTypeOrder: this.resourceTypeOrder,
        };
    }
    renderProperties(props) {
        return rosResourceCleanerPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosResourceCleaner = RosResourceCleaner;
/**
 * The resource type name for this resource class.
 */
RosResourceCleaner.ROS_RESOURCE_TYPE_NAME = "ALIYUN::ROS::ResourceCleaner";
/**
 * Determine whether the given properties match those of a `ExcludedResourcesProperty`
 *
 * @param properties - the TypeScript properties of a `ExcludedResourcesProperty`
 *
 * @returns the result of the validation.
 */
function RosResourceCleaner_ExcludedResourcesPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('resourceId', ros.requiredValidator)(properties.resourceId));
    if (properties.resourceId && (Array.isArray(properties.resourceId) || (typeof properties.resourceId) === 'string')) {
        errors.collect(ros.propertyValidator('resourceId', ros.validateLength)({
            data: properties.resourceId.length,
            min: 1,
            max: 256,
        }));
    }
    errors.collect(ros.propertyValidator('resourceId', ros.validateString)(properties.resourceId));
    if (properties.resourceType && (typeof properties.resourceType) !== 'object') {
        errors.collect(ros.propertyValidator('resourceType', ros.validateAllowedValues)({
            data: properties.resourceType,
            allowedValues: ["ACM:Namespace", "ACTIONTRAIL:Trail", "ADB:DBCluster", "ALB:Acl", "ALB:HealthCheckTemplate", "ALB:LoadBalancer", "ALB:SecurityPolicy", "ALB:ServerGroup", "ARMS:AlertContact", "ARMS:AlertContactGroup", "ARMS:RetcodeApp", "ASM:ServiceMesh", "ApiGateway:App", "ApiGateway:Group", "ApiGateway:Instance", "ApiGateway:LogConfig", "ApiGateway:Plugin", "ApiGateway:Signature", "ApiGateway:TrafficControl", "CAS:Certificate", "CDDC:DedicatedHostGroup", "CDN:Domain", "CMS:Contact", "CMS:ContactGroup", "CMS:MetricRuleTemplate", "CMS:MonitorGroup", "CMS:Namespace", "CMS:SiteMonitor", "CR:Instance", "CS:Cluster", "ClickHouse:DBCluster", "CloudPhone:InstanceGroup", "DATAHUB:Project", "DCDN:Domain", "DFS:AccessGroup", "DFS:FileSystem", "DLF:Catalog", "DNS:Domain", "DNS:DomainGroup", "DRDS:DrdsInstance", "DTS:MigrationInstance", "DirectMail:Domain", "DirectMail:Ipfilter", "EAIS:Instance", "EBS:DiskReplicaGroup", "EBS:DiskReplicaPair", "ECD:Bundle", "ECD:Desktop", "ECD:SimpleOfficeSite", "ECI:ContainerGroup", "ECI:ImageCache", "ECS:AutoProvisioningGroup", "ECS:AutoSnapshotPolicy", "ECS:Command", "ECS:CustomImage", "ECS:DedicatedHost", "ECS:DeploymentSet", "ECS:Disk", "ECS:HpcCluster", "ECS:Instance", "ECS:LaunchTemplate", "ECS:NetworkInterface", "ECS:PrefixList", "ECS:SSHKeyPair", "ECS:SecurityGroup", "ECS:Snapshot", "ECS:SnapshotGroup", "EDAS:Application", "EDAS:Cluster", "EDAS:UserDefineRegion", "EHPC:Cluster", "EMR:Cluster", "EMR:Cluster2", "EMR:FlowProject", "ENS:Instance", "ESS:AlarmTask", "ESS:ScalingGroup", "ESS:ScheduledTask", "ElasticSearch:Instance", "FC:Service", "FNF:Flow", "GPDB:DBInstance", "HBR:DbVault", "KAFKA:Instance", "KMS:Key", "KMS:Secret", "MNS:Queue", "MNS:Topic", "MONGODB:Instance", "MSE:Cluster", "MSE:Gateway", "Memcache:Instance", "NAS:AccessGroup", "NAS:FileSystem", "NLB:LoadBalancer", "NLB:ServerGroup", "OOS:Execution", "OOS:Parameter", "OOS:PatchBaseline", "OOS:SecretParameter", "OOS:Template", "OSS:Bucket", "OTS:Instance", "POLARDB:DBCluster", "PVTZ:Zone", "PrivateLink:VpcEndpoint", "PrivateLink:VpcEndpointService", "RAM:Group", "RAM:ManagedPolicy", "RAM:Role", "RAM:SAMLProvider", "RAM:User", "RDS:DBInstance", "REDIS:Instance", "ROCKETMQ5:Instance", "ROCKETMQ:Instance", "ROS:ResourceType", "ROS:Stack", "ROS:StackGroup", "ROS:Template", "ROS:TemplateScratch", "SAE:Application", "SAE:Namespace", "SAG:ACL", "SAG:Qos", "SLB:AccessControl", "SLB:Certificate", "SLB:LoadBalancer", "SLS:Project", "SearchEngine:Instance", "TSDB:HiTSDBInstance", "VPC:AnycastEIP", "VPC:CommonBandwidthPackage", "VPC:DhcpOptionsSet", "VPC:EIP", "VPC:EIPSegment", "VPC:FlowLog", "VPC:HaVip", "VPC:Ipv6Gateway", "VPC:NatGateway", "VPC:NetworkAcl", "VPC:RouteTable", "VPC:VPC", "VPC:VSwitch", "WAF:Domain"],
        }));
    }
    errors.collect(ros.propertyValidator('resourceType', ros.validateString)(properties.resourceType));
    if (properties.regionId && (Array.isArray(properties.regionId) || (typeof properties.regionId) === 'string')) {
        errors.collect(ros.propertyValidator('regionId', ros.validateLength)({
            data: properties.regionId.length,
            min: 1,
            max: 64,
        }));
    }
    errors.collect(ros.propertyValidator('regionId', ros.validateString)(properties.regionId));
    return errors.wrap('supplied properties not correct for "ExcludedResourcesProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::ROS::ResourceCleaner.ExcludedResources` resource
 *
 * @param properties - the TypeScript properties of a `ExcludedResourcesProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::ROS::ResourceCleaner.ExcludedResources` resource.
 */
// @ts-ignore TS6133
function rosResourceCleanerExcludedResourcesPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosResourceCleaner_ExcludedResourcesPropertyValidator(properties).assertSuccess();
    return {
        'ResourceId': ros.stringToRosTemplate(properties.resourceId),
        'ResourceType': ros.stringToRosTemplate(properties.resourceType),
        'RegionId': ros.stringToRosTemplate(properties.regionId),
    };
}
/**
 * Determine whether the given properties match those of a `ResourceFiltersProperty`
 *
 * @param properties - the TypeScript properties of a `ResourceFiltersProperty`
 *
 * @returns the result of the validation.
 */
function RosResourceCleaner_ResourceFiltersPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('includeDeletionProtection', ros.validateBoolean)(properties.includeDeletionProtection));
    if (properties.resourceTypePatterns && (Array.isArray(properties.resourceTypePatterns) || (typeof properties.resourceTypePatterns) === 'string')) {
        errors.collect(ros.propertyValidator('resourceTypePatterns', ros.validateLength)({
            data: properties.resourceTypePatterns.length,
            min: undefined,
            max: 100,
        }));
    }
    errors.collect(ros.propertyValidator('resourceTypePatterns', ros.listValidator(ros.validateString))(properties.resourceTypePatterns));
    if (properties.resourceIds && (Array.isArray(properties.resourceIds) || (typeof properties.resourceIds) === 'string')) {
        errors.collect(ros.propertyValidator('resourceIds', ros.validateLength)({
            data: properties.resourceIds.length,
            min: undefined,
            max: 100,
        }));
    }
    errors.collect(ros.propertyValidator('resourceIds', ros.listValidator(ros.validateString))(properties.resourceIds));
    if (properties.regionIds && (Array.isArray(properties.regionIds) || (typeof properties.regionIds) === 'string')) {
        errors.collect(ros.propertyValidator('regionIds', ros.validateLength)({
            data: properties.regionIds.length,
            min: undefined,
            max: 100,
        }));
    }
    errors.collect(ros.propertyValidator('regionIds', ros.listValidator(ros.validateString))(properties.regionIds));
    if (properties.resourceGroupIds && (Array.isArray(properties.resourceGroupIds) || (typeof properties.resourceGroupIds) === 'string')) {
        errors.collect(ros.propertyValidator('resourceGroupIds', ros.validateLength)({
            data: properties.resourceGroupIds.length,
            min: undefined,
            max: 100,
        }));
    }
    errors.collect(ros.propertyValidator('resourceGroupIds', ros.listValidator(ros.validateString))(properties.resourceGroupIds));
    if (properties.effect && (typeof properties.effect) !== 'object') {
        errors.collect(ros.propertyValidator('effect', ros.validateAllowedValues)({
            data: properties.effect,
            allowedValues: ["Deny", "Allow"],
        }));
    }
    errors.collect(ros.propertyValidator('effect', ros.validateString)(properties.effect));
    if (properties.resourceNamePatterns && (Array.isArray(properties.resourceNamePatterns) || (typeof properties.resourceNamePatterns) === 'string')) {
        errors.collect(ros.propertyValidator('resourceNamePatterns', ros.validateLength)({
            data: properties.resourceNamePatterns.length,
            min: undefined,
            max: 100,
        }));
    }
    errors.collect(ros.propertyValidator('resourceNamePatterns', ros.listValidator(ros.validateString))(properties.resourceNamePatterns));
    if (properties.tags && (Array.isArray(properties.tags) || (typeof properties.tags) === 'string')) {
        errors.collect(ros.propertyValidator('tags', ros.validateLength)({
            data: properties.tags.length,
            min: undefined,
            max: 100,
        }));
    }
    errors.collect(ros.propertyValidator('tags', ros.listValidator(RosResourceCleaner_TagsPropertyValidator))(properties.tags));
    return errors.wrap('supplied properties not correct for "ResourceFiltersProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::ROS::ResourceCleaner.ResourceFilters` resource
 *
 * @param properties - the TypeScript properties of a `ResourceFiltersProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::ROS::ResourceCleaner.ResourceFilters` resource.
 */
// @ts-ignore TS6133
function rosResourceCleanerResourceFiltersPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosResourceCleaner_ResourceFiltersPropertyValidator(properties).assertSuccess();
    return {
        'IncludeDeletionProtection': ros.booleanToRosTemplate(properties.includeDeletionProtection),
        'ResourceTypePatterns': ros.listMapper(ros.stringToRosTemplate)(properties.resourceTypePatterns),
        'ResourceIds': ros.listMapper(ros.stringToRosTemplate)(properties.resourceIds),
        'RegionIds': ros.listMapper(ros.stringToRosTemplate)(properties.regionIds),
        'ResourceGroupIds': ros.listMapper(ros.stringToRosTemplate)(properties.resourceGroupIds),
        'Effect': ros.stringToRosTemplate(properties.effect),
        'ResourceNamePatterns': ros.listMapper(ros.stringToRosTemplate)(properties.resourceNamePatterns),
        'Tags': ros.listMapper(rosResourceCleanerTagsPropertyToRosTemplate)(properties.tags),
    };
}
/**
 * Determine whether the given properties match those of a `ResourcesProperty`
 *
 * @param properties - the TypeScript properties of a `ResourcesProperty`
 *
 * @returns the result of the validation.
 */
function RosResourceCleaner_ResourcesPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('resourceId', ros.requiredValidator)(properties.resourceId));
    if (properties.resourceId && (Array.isArray(properties.resourceId) || (typeof properties.resourceId) === 'string')) {
        errors.collect(ros.propertyValidator('resourceId', ros.validateLength)({
            data: properties.resourceId.length,
            min: 1,
            max: 256,
        }));
    }
    errors.collect(ros.propertyValidator('resourceId', ros.validateString)(properties.resourceId));
    errors.collect(ros.propertyValidator('resourceType', ros.requiredValidator)(properties.resourceType));
    if (properties.resourceType && (typeof properties.resourceType) !== 'object') {
        errors.collect(ros.propertyValidator('resourceType', ros.validateAllowedValues)({
            data: properties.resourceType,
            allowedValues: ["ACM:Namespace", "ACTIONTRAIL:Trail", "ADB:DBCluster", "ALB:Acl", "ALB:HealthCheckTemplate", "ALB:LoadBalancer", "ALB:SecurityPolicy", "ALB:ServerGroup", "ARMS:AlertContact", "ARMS:AlertContactGroup", "ARMS:RetcodeApp", "ASM:ServiceMesh", "ApiGateway:App", "ApiGateway:Group", "ApiGateway:Instance", "ApiGateway:LogConfig", "ApiGateway:Plugin", "ApiGateway:Signature", "ApiGateway:TrafficControl", "CAS:Certificate", "CDDC:DedicatedHostGroup", "CDN:Domain", "CMS:Contact", "CMS:ContactGroup", "CMS:MetricRuleTemplate", "CMS:MonitorGroup", "CMS:Namespace", "CMS:SiteMonitor", "CR:Instance", "CS:Cluster", "ClickHouse:DBCluster", "CloudPhone:InstanceGroup", "DATAHUB:Project", "DCDN:Domain", "DFS:AccessGroup", "DFS:FileSystem", "DLF:Catalog", "DNS:Domain", "DNS:DomainGroup", "DRDS:DrdsInstance", "DTS:MigrationInstance", "DirectMail:Domain", "DirectMail:Ipfilter", "EAIS:Instance", "EBS:DiskReplicaGroup", "EBS:DiskReplicaPair", "ECD:Bundle", "ECD:Desktop", "ECD:SimpleOfficeSite", "ECI:ContainerGroup", "ECI:ImageCache", "ECS:AutoProvisioningGroup", "ECS:AutoSnapshotPolicy", "ECS:Command", "ECS:CustomImage", "ECS:DedicatedHost", "ECS:DeploymentSet", "ECS:Disk", "ECS:HpcCluster", "ECS:Instance", "ECS:LaunchTemplate", "ECS:NetworkInterface", "ECS:PrefixList", "ECS:SSHKeyPair", "ECS:SecurityGroup", "ECS:Snapshot", "ECS:SnapshotGroup", "EDAS:Application", "EDAS:Cluster", "EDAS:UserDefineRegion", "EHPC:Cluster", "EMR:Cluster", "EMR:Cluster2", "EMR:FlowProject", "ENS:Instance", "ESS:AlarmTask", "ESS:ScalingGroup", "ESS:ScheduledTask", "ElasticSearch:Instance", "FC:Service", "FNF:Flow", "GPDB:DBInstance", "HBR:DbVault", "KAFKA:Instance", "KMS:Key", "KMS:Secret", "MNS:Queue", "MNS:Topic", "MONGODB:Instance", "MSE:Cluster", "MSE:Gateway", "Memcache:Instance", "NAS:AccessGroup", "NAS:FileSystem", "NLB:LoadBalancer", "NLB:ServerGroup", "OOS:Execution", "OOS:Parameter", "OOS:PatchBaseline", "OOS:SecretParameter", "OOS:Template", "OSS:Bucket", "OTS:Instance", "POLARDB:DBCluster", "PVTZ:Zone", "PrivateLink:VpcEndpoint", "PrivateLink:VpcEndpointService", "RAM:Group", "RAM:ManagedPolicy", "RAM:Role", "RAM:SAMLProvider", "RAM:User", "RDS:DBInstance", "REDIS:Instance", "ROCKETMQ5:Instance", "ROCKETMQ:Instance", "ROS:ResourceType", "ROS:Stack", "ROS:StackGroup", "ROS:Template", "ROS:TemplateScratch", "SAE:Application", "SAE:Namespace", "SAG:ACL", "SAG:Qos", "SLB:AccessControl", "SLB:Certificate", "SLB:LoadBalancer", "SLS:Project", "SearchEngine:Instance", "TSDB:HiTSDBInstance", "VPC:AnycastEIP", "VPC:CommonBandwidthPackage", "VPC:DhcpOptionsSet", "VPC:EIP", "VPC:EIPSegment", "VPC:FlowLog", "VPC:HaVip", "VPC:Ipv6Gateway", "VPC:NatGateway", "VPC:NetworkAcl", "VPC:RouteTable", "VPC:VPC", "VPC:VSwitch", "WAF:Domain"],
        }));
    }
    errors.collect(ros.propertyValidator('resourceType', ros.validateString)(properties.resourceType));
    errors.collect(ros.propertyValidator('regionId', ros.requiredValidator)(properties.regionId));
    if (properties.regionId && (Array.isArray(properties.regionId) || (typeof properties.regionId) === 'string')) {
        errors.collect(ros.propertyValidator('regionId', ros.validateLength)({
            data: properties.regionId.length,
            min: 1,
            max: 64,
        }));
    }
    errors.collect(ros.propertyValidator('regionId', ros.validateString)(properties.regionId));
    return errors.wrap('supplied properties not correct for "ResourcesProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::ROS::ResourceCleaner.Resources` resource
 *
 * @param properties - the TypeScript properties of a `ResourcesProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::ROS::ResourceCleaner.Resources` resource.
 */
// @ts-ignore TS6133
function rosResourceCleanerResourcesPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosResourceCleaner_ResourcesPropertyValidator(properties).assertSuccess();
    return {
        'ResourceId': ros.stringToRosTemplate(properties.resourceId),
        'ResourceType': ros.stringToRosTemplate(properties.resourceType),
        'RegionId': ros.stringToRosTemplate(properties.regionId),
    };
}
/**
 * Determine whether the given properties match those of a `TagsProperty`
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the result of the validation.
 */
function RosResourceCleaner_TagsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.value && (Array.isArray(properties.value) || (typeof properties.value) === 'string')) {
        errors.collect(ros.propertyValidator('value', ros.validateLength)({
            data: properties.value.length,
            min: undefined,
            max: 256,
        }));
    }
    errors.collect(ros.propertyValidator('value', ros.validateString)(properties.value));
    errors.collect(ros.propertyValidator('key', ros.requiredValidator)(properties.key));
    if (properties.key && (Array.isArray(properties.key) || (typeof properties.key) === 'string')) {
        errors.collect(ros.propertyValidator('key', ros.validateLength)({
            data: properties.key.length,
            min: 1,
            max: 256,
        }));
    }
    errors.collect(ros.propertyValidator('key', ros.validateString)(properties.key));
    return errors.wrap('supplied properties not correct for "TagsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::ROS::ResourceCleaner.Tags` resource
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::ROS::ResourceCleaner.Tags` resource.
 */
// @ts-ignore TS6133
function rosResourceCleanerTagsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosResourceCleaner_TagsPropertyValidator(properties).assertSuccess();
    return {
        'Value': ros.stringToRosTemplate(properties.value),
        'Key': ros.stringToRosTemplate(properties.key),
    };
}
/**
 * Determine whether the given properties match those of a `RosSleepProps`
 *
 * @param properties - the TypeScript properties of a `RosSleepProps`
 *
 * @returns the result of the validation.
 */
function RosSleepPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.deleteDuration && (typeof properties.deleteDuration) !== 'object') {
        errors.collect(ros.propertyValidator('deleteDuration', ros.validateRange)({
            data: properties.deleteDuration,
            min: 0,
            max: 1800,
        }));
    }
    errors.collect(ros.propertyValidator('deleteDuration', ros.validateNumber)(properties.deleteDuration));
    if (properties.updateRollbackDuration && (typeof properties.updateRollbackDuration) !== 'object') {
        errors.collect(ros.propertyValidator('updateRollbackDuration', ros.validateRange)({
            data: properties.updateRollbackDuration,
            min: 0,
            max: 1800,
        }));
    }
    errors.collect(ros.propertyValidator('updateRollbackDuration', ros.validateNumber)(properties.updateRollbackDuration));
    if (properties.updateDuration && (typeof properties.updateDuration) !== 'object') {
        errors.collect(ros.propertyValidator('updateDuration', ros.validateRange)({
            data: properties.updateDuration,
            min: 0,
            max: 1800,
        }));
    }
    errors.collect(ros.propertyValidator('updateDuration', ros.validateNumber)(properties.updateDuration));
    if (properties.createDuration && (typeof properties.createDuration) !== 'object') {
        errors.collect(ros.propertyValidator('createDuration', ros.validateRange)({
            data: properties.createDuration,
            min: 0,
            max: 1800,
        }));
    }
    errors.collect(ros.propertyValidator('createDuration', ros.validateNumber)(properties.createDuration));
    errors.collect(ros.propertyValidator('triggers', ros.hashValidator(ros.validateAny))(properties.triggers));
    return errors.wrap('supplied properties not correct for "RosSleepProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::ROS::Sleep` resource
 *
 * @param properties - the TypeScript properties of a `RosSleepProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::ROS::Sleep` resource.
 */
// @ts-ignore TS6133
function rosSleepPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosSleepPropsValidator(properties).assertSuccess();
    }
    return {
        'CreateDuration': ros.numberToRosTemplate(properties.createDuration),
        'DeleteDuration': ros.numberToRosTemplate(properties.deleteDuration),
        'Triggers': ros.hashMapper(ros.objectToRosTemplate)(properties.triggers),
        'UpdateDuration': ros.numberToRosTemplate(properties.updateDuration),
        'UpdateRollbackDuration': ros.numberToRosTemplate(properties.updateRollbackDuration),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::ROS::Sleep`.
 * @Note This class does not contain additional functions, so it is recommended to use the `Sleep` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ros-sleep
 */
class RosSleep extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosSleep.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.createDuration = props.createDuration;
        this.deleteDuration = props.deleteDuration;
        this.triggers = props.triggers;
        this.updateDuration = props.updateDuration;
        this.updateRollbackDuration = props.updateRollbackDuration;
    }
    get rosProperties() {
        return {
            createDuration: this.createDuration,
            deleteDuration: this.deleteDuration,
            triggers: this.triggers,
            updateDuration: this.updateDuration,
            updateRollbackDuration: this.updateRollbackDuration,
        };
    }
    renderProperties(props) {
        return rosSleepPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosSleep = RosSleep;
/**
 * The resource type name for this resource class.
 */
RosSleep.ROS_RESOURCE_TYPE_NAME = "ALIYUN::ROS::Sleep";
/**
 * Determine whether the given properties match those of a `RosStackProps`
 *
 * @param properties - the TypeScript properties of a `RosStackProps`
 *
 * @returns the result of the validation.
 */
function RosStackPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.templateUrl && (Array.isArray(properties.templateUrl) || (typeof properties.templateUrl) === 'string')) {
        errors.collect(ros.propertyValidator('templateUrl', ros.validateLength)({
            data: properties.templateUrl.length,
            min: undefined,
            max: 1024,
        }));
    }
    errors.collect(ros.propertyValidator('templateUrl', ros.validateString)(properties.templateUrl));
    errors.collect(ros.propertyValidator('parameters', ros.hashValidator(ros.validateAny))(properties.parameters));
    errors.collect(ros.propertyValidator('resourceGroupId', ros.validateString)(properties.resourceGroupId));
    errors.collect(ros.propertyValidator('timeoutMins', ros.validateNumber)(properties.timeoutMins));
    if (properties.templateVersion && (typeof properties.templateVersion) !== 'object') {
        errors.collect(ros.propertyValidator('templateVersion', ros.validateAllowedPattern)({
            data: properties.templateVersion,
            reg: /^v(([1-9])|([1-9][0-9])|([1-9][0-9][0-9]))$/
        }));
    }
    errors.collect(ros.propertyValidator('templateVersion', ros.validateString)(properties.templateVersion));
    errors.collect(ros.propertyValidator('templateBody', ros.hashValidator(ros.validateAny))(properties.templateBody));
    errors.collect(ros.propertyValidator('tags', ros.listValidator(RosStack_TagsPropertyValidator))(properties.tags));
    if (properties.templateId && (typeof properties.templateId) !== 'object') {
        errors.collect(ros.propertyValidator('templateId', ros.validateAllowedPattern)({
            data: properties.templateId,
            reg: /^([0-9a-f]{8}[-][0-9a-f]{4}[-a-z0-9][0-9a-f]{4}[-][0-9a-f]{4}[-][0-9a-f]{12})|(acs[:]ros[:][*][:]\d+[:]template\/[0-9a-f]{8}[-][0-9a-f]{4}[-a-z0-9][0-9a-f]{4}[-][0-9a-f]{4}[-][0-9a-f]{12})|(acs[:]ros[:]template[\/][-_a-zA-Z0-9]+[\/][-_a-zA-Z0-9]+)$|(acs[:]ros[:]public_template[\/][-_a-zA-Z0-9]+)$/
        }));
    }
    errors.collect(ros.propertyValidator('templateId', ros.validateString)(properties.templateId));
    return errors.wrap('supplied properties not correct for "RosStackProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::ROS::Stack` resource
 *
 * @param properties - the TypeScript properties of a `RosStackProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::ROS::Stack` resource.
 */
// @ts-ignore TS6133
function rosStackPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosStackPropsValidator(properties).assertSuccess();
    }
    return {
        'Parameters': ros.hashMapper(ros.objectToRosTemplate)(properties.parameters),
        'ResourceGroupId': ros.stringToRosTemplate(properties.resourceGroupId),
        'Tags': ros.listMapper(rosStackTagsPropertyToRosTemplate)(properties.tags),
        'TemplateBody': ros.hashMapper(ros.objectToRosTemplate)(properties.templateBody),
        'TemplateId': ros.stringToRosTemplate(properties.templateId),
        'TemplateURL': ros.stringToRosTemplate(properties.templateUrl),
        'TemplateVersion': ros.stringToRosTemplate(properties.templateVersion),
        'TimeoutMins': ros.numberToRosTemplate(properties.timeoutMins),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::ROS::Stack`.
 * @Note This class does not contain additional functions, so it is recommended to use the `Stack` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ros-stack
 */
class RosStack extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosStack.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.parameters = props.parameters;
        this.resourceGroupId = props.resourceGroupId;
        this.tags = props.tags;
        this.templateBody = props.templateBody;
        this.templateId = props.templateId;
        this.templateUrl = props.templateUrl;
        this.templateVersion = props.templateVersion;
        this.timeoutMins = props.timeoutMins;
    }
    get rosProperties() {
        return {
            parameters: this.parameters,
            resourceGroupId: this.resourceGroupId,
            tags: this.tags,
            templateBody: this.templateBody,
            templateId: this.templateId,
            templateUrl: this.templateUrl,
            templateVersion: this.templateVersion,
            timeoutMins: this.timeoutMins,
        };
    }
    renderProperties(props) {
        return rosStackPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosStack = RosStack;
/**
 * The resource type name for this resource class.
 */
RosStack.ROS_RESOURCE_TYPE_NAME = "ALIYUN::ROS::Stack";
/**
 * Determine whether the given properties match those of a `TagsProperty`
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the result of the validation.
 */
function RosStack_TagsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('value', ros.validateString)(properties.value));
    errors.collect(ros.propertyValidator('key', ros.requiredValidator)(properties.key));
    errors.collect(ros.propertyValidator('key', ros.validateString)(properties.key));
    return errors.wrap('supplied properties not correct for "TagsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::ROS::Stack.Tags` resource
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::ROS::Stack.Tags` resource.
 */
// @ts-ignore TS6133
function rosStackTagsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosStack_TagsPropertyValidator(properties).assertSuccess();
    return {
        'Value': ros.stringToRosTemplate(properties.value),
        'Key': ros.stringToRosTemplate(properties.key),
    };
}
/**
 * Determine whether the given properties match those of a `RosStackGroupProps`
 *
 * @param properties - the TypeScript properties of a `RosStackGroupProps`
 *
 * @returns the result of the validation.
 */
function RosStackGroupPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('description', ros.validateString)(properties.description));
    errors.collect(ros.propertyValidator('parameters', ros.hashValidator(ros.validateAny))(properties.parameters));
    errors.collect(ros.propertyValidator('resourceGroupId', ros.validateString)(properties.resourceGroupId));
    errors.collect(ros.propertyValidator('dynamicTemplateBody', ros.hashValidator(ros.validateAny))(properties.dynamicTemplateBody));
    errors.collect(ros.propertyValidator('stackGroupName', ros.requiredValidator)(properties.stackGroupName));
    errors.collect(ros.propertyValidator('stackGroupName', ros.validateString)(properties.stackGroupName));
    errors.collect(ros.propertyValidator('templateVersion', ros.validateString)(properties.templateVersion));
    errors.collect(ros.propertyValidator('administrationRoleName', ros.validateString)(properties.administrationRoleName));
    errors.collect(ros.propertyValidator('templateBody', ros.hashValidator(ros.validateAny))(properties.templateBody));
    errors.collect(ros.propertyValidator('templateUrl', ros.validateString)(properties.templateUrl));
    errors.collect(ros.propertyValidator('autoDeployment', RosStackGroup_AutoDeploymentPropertyValidator)(properties.autoDeployment));
    errors.collect(ros.propertyValidator('permissionModel', ros.validateString)(properties.permissionModel));
    errors.collect(ros.propertyValidator('executionRoleName', ros.validateString)(properties.executionRoleName));
    errors.collect(ros.propertyValidator('templateId', ros.validateString)(properties.templateId));
    return errors.wrap('supplied properties not correct for "RosStackGroupProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::ROS::StackGroup` resource
 *
 * @param properties - the TypeScript properties of a `RosStackGroupProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::ROS::StackGroup` resource.
 */
// @ts-ignore TS6133
function rosStackGroupPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosStackGroupPropsValidator(properties).assertSuccess();
    }
    return {
        'StackGroupName': ros.stringToRosTemplate(properties.stackGroupName),
        'AdministrationRoleName': ros.stringToRosTemplate(properties.administrationRoleName),
        'AutoDeployment': rosStackGroupAutoDeploymentPropertyToRosTemplate(properties.autoDeployment),
        'Description': ros.stringToRosTemplate(properties.description),
        'DynamicTemplateBody': ros.hashMapper(ros.objectToRosTemplate)(properties.dynamicTemplateBody),
        'ExecutionRoleName': ros.stringToRosTemplate(properties.executionRoleName),
        'Parameters': ros.hashMapper(ros.objectToRosTemplate)(properties.parameters),
        'PermissionModel': ros.stringToRosTemplate(properties.permissionModel),
        'ResourceGroupId': ros.stringToRosTemplate(properties.resourceGroupId),
        'TemplateBody': ros.hashMapper(ros.objectToRosTemplate)(properties.templateBody),
        'TemplateId': ros.stringToRosTemplate(properties.templateId),
        'TemplateURL': ros.stringToRosTemplate(properties.templateUrl),
        'TemplateVersion': ros.stringToRosTemplate(properties.templateVersion),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::ROS::StackGroup`.
 * @Note This class does not contain additional functions, so it is recommended to use the `StackGroup` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ros-stackgroup
 */
class RosStackGroup extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosStackGroup.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrStackGroupId = this.getAtt('StackGroupId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.stackGroupName = props.stackGroupName;
        this.administrationRoleName = props.administrationRoleName;
        this.autoDeployment = props.autoDeployment;
        this.description = props.description;
        this.dynamicTemplateBody = props.dynamicTemplateBody;
        this.executionRoleName = props.executionRoleName;
        this.parameters = props.parameters;
        this.permissionModel = props.permissionModel;
        this.resourceGroupId = props.resourceGroupId;
        this.templateBody = props.templateBody;
        this.templateId = props.templateId;
        this.templateUrl = props.templateUrl;
        this.templateVersion = props.templateVersion;
    }
    get rosProperties() {
        return {
            stackGroupName: this.stackGroupName,
            administrationRoleName: this.administrationRoleName,
            autoDeployment: this.autoDeployment,
            description: this.description,
            dynamicTemplateBody: this.dynamicTemplateBody,
            executionRoleName: this.executionRoleName,
            parameters: this.parameters,
            permissionModel: this.permissionModel,
            resourceGroupId: this.resourceGroupId,
            templateBody: this.templateBody,
            templateId: this.templateId,
            templateUrl: this.templateUrl,
            templateVersion: this.templateVersion,
        };
    }
    renderProperties(props) {
        return rosStackGroupPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosStackGroup = RosStackGroup;
/**
 * The resource type name for this resource class.
 */
RosStackGroup.ROS_RESOURCE_TYPE_NAME = "ALIYUN::ROS::StackGroup";
/**
 * Determine whether the given properties match those of a `AutoDeploymentProperty`
 *
 * @param properties - the TypeScript properties of a `AutoDeploymentProperty`
 *
 * @returns the result of the validation.
 */
function RosStackGroup_AutoDeploymentPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('enabled', ros.requiredValidator)(properties.enabled));
    errors.collect(ros.propertyValidator('enabled', ros.validateBoolean)(properties.enabled));
    errors.collect(ros.propertyValidator('retainStacksOnAccountRemoval', ros.validateBoolean)(properties.retainStacksOnAccountRemoval));
    return errors.wrap('supplied properties not correct for "AutoDeploymentProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::ROS::StackGroup.AutoDeployment` resource
 *
 * @param properties - the TypeScript properties of a `AutoDeploymentProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::ROS::StackGroup.AutoDeployment` resource.
 */
// @ts-ignore TS6133
function rosStackGroupAutoDeploymentPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosStackGroup_AutoDeploymentPropertyValidator(properties).assertSuccess();
    return {
        'Enabled': ros.booleanToRosTemplate(properties.enabled),
        'RetainStacksOnAccountRemoval': ros.booleanToRosTemplate(properties.retainStacksOnAccountRemoval),
    };
}
/**
 * Determine whether the given properties match those of a `RosStackInstancesProps`
 *
 * @param properties - the TypeScript properties of a `RosStackInstancesProps`
 *
 * @returns the result of the validation.
 */
function RosStackInstancesPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('operationPreferences', RosStackInstances_OperationPreferencesPropertyValidator)(properties.operationPreferences));
    errors.collect(ros.propertyValidator('retainStacks', ros.validateBoolean)(properties.retainStacks));
    errors.collect(ros.propertyValidator('regionIds', ros.requiredValidator)(properties.regionIds));
    errors.collect(ros.propertyValidator('regionIds', ros.listValidator(ros.validateString))(properties.regionIds));
    errors.collect(ros.propertyValidator('accountIds', ros.listValidator(ros.validateString))(properties.accountIds));
    errors.collect(ros.propertyValidator('parameterOverrides', ros.hashValidator(ros.validateAny))(properties.parameterOverrides));
    errors.collect(ros.propertyValidator('stackGroupName', ros.requiredValidator)(properties.stackGroupName));
    errors.collect(ros.propertyValidator('stackGroupName', ros.validateString)(properties.stackGroupName));
    errors.collect(ros.propertyValidator('deploymentTargets', RosStackInstances_DeploymentTargetsPropertyValidator)(properties.deploymentTargets));
    errors.collect(ros.propertyValidator('operationDescription', ros.validateString)(properties.operationDescription));
    errors.collect(ros.propertyValidator('disableRollback', ros.validateBoolean)(properties.disableRollback));
    errors.collect(ros.propertyValidator('timeoutInMinutes', ros.validateNumber)(properties.timeoutInMinutes));
    return errors.wrap('supplied properties not correct for "RosStackInstancesProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::ROS::StackInstances` resource
 *
 * @param properties - the TypeScript properties of a `RosStackInstancesProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::ROS::StackInstances` resource.
 */
// @ts-ignore TS6133
function rosStackInstancesPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosStackInstancesPropsValidator(properties).assertSuccess();
    }
    return {
        'RegionIds': ros.listMapper(ros.stringToRosTemplate)(properties.regionIds),
        'StackGroupName': ros.stringToRosTemplate(properties.stackGroupName),
        'AccountIds': ros.listMapper(ros.stringToRosTemplate)(properties.accountIds),
        'DeploymentTargets': rosStackInstancesDeploymentTargetsPropertyToRosTemplate(properties.deploymentTargets),
        'DisableRollback': ros.booleanToRosTemplate(properties.disableRollback),
        'OperationDescription': ros.stringToRosTemplate(properties.operationDescription),
        'OperationPreferences': rosStackInstancesOperationPreferencesPropertyToRosTemplate(properties.operationPreferences),
        'ParameterOverrides': ros.hashMapper(ros.objectToRosTemplate)(properties.parameterOverrides),
        'RetainStacks': ros.booleanToRosTemplate(properties.retainStacks),
        'TimeoutInMinutes': ros.numberToRosTemplate(properties.timeoutInMinutes),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::ROS::StackInstances`.
 * @Note This class does not contain additional functions, so it is recommended to use the `StackInstances` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ros-stackinstances
 */
class RosStackInstances extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosStackInstances.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrLastOperationId = this.getAtt('LastOperationId');
        this.attrStacks = this.getAtt('Stacks');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.regionIds = props.regionIds;
        this.stackGroupName = props.stackGroupName;
        this.accountIds = props.accountIds;
        this.deploymentTargets = props.deploymentTargets;
        this.disableRollback = props.disableRollback;
        this.operationDescription = props.operationDescription;
        this.operationPreferences = props.operationPreferences;
        this.parameterOverrides = props.parameterOverrides;
        this.retainStacks = props.retainStacks;
        this.timeoutInMinutes = props.timeoutInMinutes;
    }
    get rosProperties() {
        return {
            regionIds: this.regionIds,
            stackGroupName: this.stackGroupName,
            accountIds: this.accountIds,
            deploymentTargets: this.deploymentTargets,
            disableRollback: this.disableRollback,
            operationDescription: this.operationDescription,
            operationPreferences: this.operationPreferences,
            parameterOverrides: this.parameterOverrides,
            retainStacks: this.retainStacks,
            timeoutInMinutes: this.timeoutInMinutes,
        };
    }
    renderProperties(props) {
        return rosStackInstancesPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosStackInstances = RosStackInstances;
/**
 * The resource type name for this resource class.
 */
RosStackInstances.ROS_RESOURCE_TYPE_NAME = "ALIYUN::ROS::StackInstances";
/**
 * Determine whether the given properties match those of a `DeploymentTargetsProperty`
 *
 * @param properties - the TypeScript properties of a `DeploymentTargetsProperty`
 *
 * @returns the result of the validation.
 */
function RosStackInstances_DeploymentTargetsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('rdFolderIds', ros.listValidator(ros.validateString))(properties.rdFolderIds));
    return errors.wrap('supplied properties not correct for "DeploymentTargetsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::ROS::StackInstances.DeploymentTargets` resource
 *
 * @param properties - the TypeScript properties of a `DeploymentTargetsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::ROS::StackInstances.DeploymentTargets` resource.
 */
// @ts-ignore TS6133
function rosStackInstancesDeploymentTargetsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosStackInstances_DeploymentTargetsPropertyValidator(properties).assertSuccess();
    return {
        'RdFolderIds': ros.listMapper(ros.stringToRosTemplate)(properties.rdFolderIds),
    };
}
/**
 * Determine whether the given properties match those of a `OperationPreferencesProperty`
 *
 * @param properties - the TypeScript properties of a `OperationPreferencesProperty`
 *
 * @returns the result of the validation.
 */
function RosStackInstances_OperationPreferencesPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('maxConcurrentPercentage', ros.validateNumber)(properties.maxConcurrentPercentage));
    errors.collect(ros.propertyValidator('maxConcurrentCount', ros.validateNumber)(properties.maxConcurrentCount));
    errors.collect(ros.propertyValidator('failureTolerancePercentage', ros.validateNumber)(properties.failureTolerancePercentage));
    errors.collect(ros.propertyValidator('failureToleranceCount', ros.validateNumber)(properties.failureToleranceCount));
    return errors.wrap('supplied properties not correct for "OperationPreferencesProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::ROS::StackInstances.OperationPreferences` resource
 *
 * @param properties - the TypeScript properties of a `OperationPreferencesProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::ROS::StackInstances.OperationPreferences` resource.
 */
// @ts-ignore TS6133
function rosStackInstancesOperationPreferencesPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosStackInstances_OperationPreferencesPropertyValidator(properties).assertSuccess();
    return {
        'MaxConcurrentPercentage': ros.numberToRosTemplate(properties.maxConcurrentPercentage),
        'MaxConcurrentCount': ros.numberToRosTemplate(properties.maxConcurrentCount),
        'FailureTolerancePercentage': ros.numberToRosTemplate(properties.failureTolerancePercentage),
        'FailureToleranceCount': ros.numberToRosTemplate(properties.failureToleranceCount),
    };
}
/**
 * Determine whether the given properties match those of a `RosWaitConditionProps`
 *
 * @param properties - the TypeScript properties of a `RosWaitConditionProps`
 *
 * @returns the result of the validation.
 */
function RosWaitConditionPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.showProgressEvent && (typeof properties.showProgressEvent) !== 'object') {
        errors.collect(ros.propertyValidator('showProgressEvent', ros.validateAllowedValues)({
            data: properties.showProgressEvent,
            allowedValues: ["EnabledIfCreateStack", "Disabled", "Enabled"],
        }));
    }
    errors.collect(ros.propertyValidator('showProgressEvent', ros.validateString)(properties.showProgressEvent));
    errors.collect(ros.propertyValidator('timeout', ros.requiredValidator)(properties.timeout));
    if (properties.timeout && (typeof properties.timeout) !== 'object') {
        errors.collect(ros.propertyValidator('timeout', ros.validateRange)({
            data: properties.timeout,
            min: 1,
            max: 43200,
        }));
    }
    errors.collect(ros.propertyValidator('timeout', ros.validateNumber)(properties.timeout));
    errors.collect(ros.propertyValidator('count', ros.validateNumber)(properties.count));
    errors.collect(ros.propertyValidator('handle', ros.requiredValidator)(properties.handle));
    errors.collect(ros.propertyValidator('handle', ros.validateString)(properties.handle));
    return errors.wrap('supplied properties not correct for "RosWaitConditionProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::ROS::WaitCondition` resource
 *
 * @param properties - the TypeScript properties of a `RosWaitConditionProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::ROS::WaitCondition` resource.
 */
// @ts-ignore TS6133
function rosWaitConditionPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosWaitConditionPropsValidator(properties).assertSuccess();
    }
    return {
        'Handle': ros.stringToRosTemplate(properties.handle),
        'Timeout': ros.numberToRosTemplate(properties.timeout),
        'Count': ros.numberToRosTemplate(properties.count),
        'ShowProgressEvent': ros.stringToRosTemplate(properties.showProgressEvent),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::ROS::WaitCondition`.
 * @Note This class does not contain additional functions, so it is recommended to use the `WaitCondition` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ros-waitcondition
 */
class RosWaitCondition extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosWaitCondition.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrData = this.getAtt('Data');
        this.attrErrorData = this.getAtt('ErrorData');
        this.attrJoinedErrorData = this.getAtt('JoinedErrorData');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.handle = props.handle;
        this.timeout = props.timeout;
        this.count = props.count;
        this.showProgressEvent = props.showProgressEvent;
    }
    get rosProperties() {
        return {
            handle: this.handle,
            timeout: this.timeout,
            count: this.count,
            showProgressEvent: this.showProgressEvent,
        };
    }
    renderProperties(props) {
        return rosWaitConditionPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosWaitCondition = RosWaitCondition;
/**
 * The resource type name for this resource class.
 */
RosWaitCondition.ROS_RESOURCE_TYPE_NAME = "ALIYUN::ROS::WaitCondition";
/**
 * Determine whether the given properties match those of a `RosWaitConditionHandleProps`
 *
 * @param properties - the TypeScript properties of a `RosWaitConditionHandleProps`
 *
 * @returns the result of the validation.
 */
function RosWaitConditionHandlePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.mode && (typeof properties.mode) !== 'object') {
        errors.collect(ros.propertyValidator('mode', ros.validateAllowedValues)({
            data: properties.mode,
            allowedValues: ["Increment", "Full"],
        }));
    }
    errors.collect(ros.propertyValidator('mode', ros.validateString)(properties.mode));
    errors.collect(ros.propertyValidator('count', ros.validateNumber)(properties.count));
    return errors.wrap('supplied properties not correct for "RosWaitConditionHandleProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::ROS::WaitConditionHandle` resource
 *
 * @param properties - the TypeScript properties of a `RosWaitConditionHandleProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::ROS::WaitConditionHandle` resource.
 */
// @ts-ignore TS6133
function rosWaitConditionHandlePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosWaitConditionHandlePropsValidator(properties).assertSuccess();
    }
    return {
        'Count': ros.numberToRosTemplate(properties.count),
        'Mode': ros.stringToRosTemplate(properties.mode),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::ROS::WaitConditionHandle`.
 * @Note This class does not contain additional functions, so it is recommended to use the `WaitConditionHandle` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ros-waitconditionhandle
 */
class RosWaitConditionHandle extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosWaitConditionHandle.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrCurlCli = this.getAtt('CurlCli');
        this.attrHeaders = this.getAtt('Headers');
        this.attrPowerShellCurlCli = this.getAtt('PowerShellCurlCli');
        this.attrUrl = this.getAtt('URL');
        this.attrWindowsCurlCli = this.getAtt('WindowsCurlCli');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.count = props.count;
        this.mode = props.mode;
    }
    get rosProperties() {
        return {
            count: this.count,
            mode: this.mode,
        };
    }
    renderProperties(props) {
        return rosWaitConditionHandlePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosWaitConditionHandle = RosWaitConditionHandle;
/**
 * The resource type name for this resource class.
 */
RosWaitConditionHandle.ROS_RESOURCE_TYPE_NAME = "ALIYUN::ROS::WaitConditionHandle";
//# sourceMappingURL=data:application/json;base64,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