from ........Internal.Core import Core
from ........Internal.CommandsGroup import CommandsGroup


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class Absolute:
	"""Absolute commands group definition. 6 total commands, 1 Sub-groups, 0 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._base = CommandsGroup("absolute", core, parent)

	@property
	def y(self):
		"""y commands group. 6 Sub-classes, 0 commands."""
		if not hasattr(self, '_y'):
			from .Absolute_.Y import Y
			self._y = Y(self._core, self._base)
		return self._y

	def clone(self) -> 'Absolute':
		"""Clones the group by creating new object from it and its whole existing sub-groups
		Also copies all the existing default Repeated Capabilities setting,
		which you can change independently without affecting the original group"""
		new_group = Absolute(self._core, self._base.parent)
		self._base.synchronize_repcaps(new_group)
		return new_group
