from .....Internal.Core import Core
from .....Internal.CommandsGroup import CommandsGroup
from .....Internal import Conversions
from .....Internal.ArgSingleSuppressed import ArgSingleSuppressed
from .....Internal.Types import DataType
from ..... import enums


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class Current:
	"""Current commands group definition. 3 total commands, 0 Sub-groups, 3 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._base = CommandsGroup("current", core, parent)

	def read(self) -> float:
		"""SCPI: READ:WLAN:MEASurement<Instance>:MEValuation:PVTime:TERRor:CURRent \n
		Snippet: value: float = driver.multiEval.powerVsTime.terror.current.read() \n
		Return the current, average, minimum, maximum and standard deviation timing error single value results of the power vs.
		time measurement. The commands are only supported for OFDM standards. The values described below are returned by FETCh
		and READ commands. CALCulate commands return limit check results instead, one value for each result listed below. \n
		Use RsCmwWlanMeas.reliability.last_value to read the updated reliability indicator. \n
			:return: timing_error_curr: float Unit: s"""
		suppressed = ArgSingleSuppressed(0, DataType.Integer, False, 1, 'Reliability')
		response = self._core.io.query_str_suppressed(f'READ:WLAN:MEASurement<Instance>:MEValuation:PVTime:TERRor:CURRent?', suppressed)
		return Conversions.str_to_float(response)

	def fetch(self) -> float:
		"""SCPI: FETCh:WLAN:MEASurement<Instance>:MEValuation:PVTime:TERRor:CURRent \n
		Snippet: value: float = driver.multiEval.powerVsTime.terror.current.fetch() \n
		Return the current, average, minimum, maximum and standard deviation timing error single value results of the power vs.
		time measurement. The commands are only supported for OFDM standards. The values described below are returned by FETCh
		and READ commands. CALCulate commands return limit check results instead, one value for each result listed below. \n
		Use RsCmwWlanMeas.reliability.last_value to read the updated reliability indicator. \n
			:return: timing_error_curr: float Unit: s"""
		suppressed = ArgSingleSuppressed(0, DataType.Integer, False, 1, 'Reliability')
		response = self._core.io.query_str_suppressed(f'FETCh:WLAN:MEASurement<Instance>:MEValuation:PVTime:TERRor:CURRent?', suppressed)
		return Conversions.str_to_float(response)

	# noinspection PyTypeChecker
	def calculate(self) -> enums.ResultStatus2:
		"""SCPI: CALCulate:WLAN:MEASurement<Instance>:MEValuation:PVTime:TERRor:CURRent \n
		Snippet: value: enums.ResultStatus2 = driver.multiEval.powerVsTime.terror.current.calculate() \n
		Return the current, average, minimum, maximum and standard deviation timing error single value results of the power vs.
		time measurement. The commands are only supported for OFDM standards. The values described below are returned by FETCh
		and READ commands. CALCulate commands return limit check results instead, one value for each result listed below. \n
		Use RsCmwWlanMeas.reliability.last_value to read the updated reliability indicator. \n
			:return: timing_error_curr: float Unit: s"""
		suppressed = ArgSingleSuppressed(0, DataType.Integer, False, 1, 'Reliability')
		response = self._core.io.query_str_suppressed(f'CALCulate:WLAN:MEASurement<Instance>:MEValuation:PVTime:TERRor:CURRent?', suppressed)
		return Conversions.str_to_scalar_enum(response, enums.ResultStatus2)
