import * as ec2 from '@aws-cdk/aws-ec2';
import * as ecs from '@aws-cdk/aws-ecs';
import * as patterns from '@aws-cdk/aws-ecs-patterns';
import * as efs from '@aws-cdk/aws-efs';
import * as cdk from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface EfsFargateSiteProps {
    /**
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * @stability stable
     */
    readonly task: ecs.FargateTaskDefinition;
    /**
     * @stability stable
     */
    readonly accessPoint: efs.AccessPoint;
}
/**
 * @stability stable
 */
export declare class EfsFargateSite extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly task: ecs.FargateTaskDefinition;
    /**
     * @stability stable
     */
    readonly service: patterns.ApplicationLoadBalancedFargateService;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: EfsFargateSiteProps);
}
