"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EfsFargateSite = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const ecs = require("@aws-cdk/aws-ecs");
const patterns = require("@aws-cdk/aws-ecs-patterns");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
/**
 * @stability stable
 */
class EfsFargateSite extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.task = props.task;
        this.task.addVolume({
            name: 'efs-storage',
            efsVolumeConfiguration: {
                fileSystemId: props.accessPoint.fileSystem.fileSystemId,
                authorizationConfig: {
                    accessPointId: props.accessPoint.accessPointId,
                },
                transitEncryption: 'ENABLED',
            },
        });
        this.service = new patterns.ApplicationLoadBalancedFargateService(this, 'FargateService', {
            vpc: props.vpc,
            taskDefinition: this.task,
            platformVersion: ecs.FargatePlatformVersion.VERSION1_4,
        });
        // this.service.node.addDependency(props.accessPoint.fileSystem.mountTargetsAvailable)
        this.task.addToExecutionRolePolicy(new aws_iam_1.PolicyStatement({
            actions: [
                'elasticfilesystem:ClientMount',
                'elasticfilesystem:ClientWrite',
            ],
            resources: [
                cdk.Stack.of(this).formatArn({
                    service: 'elasticfilesystem',
                    resource: 'file-system',
                    sep: '/',
                    resourceName: props.accessPoint.fileSystem.fileSystemId,
                }),
            ],
        }));
        // allow fargate ingress to the efs filesystem
        props.accessPoint.fileSystem.connections.allowFrom(this.service.service, ec2.Port.tcp(2049));
    }
}
exports.EfsFargateSite = EfsFargateSite;
_a = JSII_RTTI_SYMBOL_1;
EfsFargateSite[_a] = { fqn: "cdk-efs-assets.EfsFargateSite", version: "0.3.93" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZWZzLWZhcmdhdGUtc2l0ZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9lZnMtZmFyZ2F0ZS1zaXRlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsd0NBQXdDO0FBQ3hDLHdDQUF3QztBQUN4QyxzREFBc0Q7QUFFdEQsOENBQW1EO0FBQ25ELHFDQUFxQzs7OztBQVNyQyxNQUFhLGNBQWUsU0FBUSxHQUFHLENBQUMsU0FBUzs7OztJQUcvQyxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQTBCO1FBQ3RFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsSUFBSSxDQUFDLElBQUksR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDO1FBRXZCLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDO1lBQ2xCLElBQUksRUFBRSxhQUFhO1lBQ25CLHNCQUFzQixFQUFFO2dCQUN0QixZQUFZLEVBQUUsS0FBSyxDQUFDLFdBQVcsQ0FBQyxVQUFVLENBQUMsWUFBWTtnQkFDdkQsbUJBQW1CLEVBQUU7b0JBQ25CLGFBQWEsRUFBRSxLQUFLLENBQUMsV0FBVyxDQUFDLGFBQWE7aUJBRS9DO2dCQUNELGlCQUFpQixFQUFFLFNBQVM7YUFFN0I7U0FDRixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsT0FBTyxHQUFHLElBQUksUUFBUSxDQUFDLHFDQUFxQyxDQUFDLElBQUksRUFBRSxnQkFBZ0IsRUFBRTtZQUN4RixHQUFHLEVBQUUsS0FBSyxDQUFDLEdBQUc7WUFDZCxjQUFjLEVBQUUsSUFBSSxDQUFDLElBQUk7WUFDekIsZUFBZSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVO1NBQ3ZELENBQUMsQ0FBQztRQUVILHNGQUFzRjtRQUV0RixJQUFJLENBQUMsSUFBSSxDQUFDLHdCQUF3QixDQUFDLElBQUkseUJBQWUsQ0FBQztZQUNyRCxPQUFPLEVBQUU7Z0JBQ1AsK0JBQStCO2dCQUMvQiwrQkFBK0I7YUFDaEM7WUFDRCxTQUFTLEVBQUU7Z0JBQ1QsR0FBRyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsU0FBUyxDQUFDO29CQUMzQixPQUFPLEVBQUUsbUJBQW1CO29CQUM1QixRQUFRLEVBQUUsYUFBYTtvQkFDdkIsR0FBRyxFQUFFLEdBQUc7b0JBQ1IsWUFBWSxFQUFFLEtBQUssQ0FBQyxXQUFXLENBQUMsVUFBVSxDQUFDLFlBQVk7aUJBQ3hELENBQUM7YUFDSDtTQUNGLENBQUMsQ0FBQyxDQUFDO1FBRUosOENBQThDO1FBQzlDLEtBQUssQ0FBQyxXQUFXLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxPQUFPLEVBQUUsR0FBRyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztJQUMvRixDQUFDOztBQTlDSCx3Q0ErQ0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBlYzIgZnJvbSAnQGF3cy1jZGsvYXdzLWVjMic7XG5pbXBvcnQgKiBhcyBlY3MgZnJvbSAnQGF3cy1jZGsvYXdzLWVjcyc7XG5pbXBvcnQgKiBhcyBwYXR0ZXJucyBmcm9tICdAYXdzLWNkay9hd3MtZWNzLXBhdHRlcm5zJztcbmltcG9ydCAqIGFzIGVmcyBmcm9tICdAYXdzLWNkay9hd3MtZWZzJztcbmltcG9ydCB7IFBvbGljeVN0YXRlbWVudCB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1pYW0nO1xuaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuXG5cbmV4cG9ydCBpbnRlcmZhY2UgRWZzRmFyZ2F0ZVNpdGVQcm9wcyB7XG4gIHJlYWRvbmx5IHZwYzogZWMyLklWcGM7XG4gIHJlYWRvbmx5IHRhc2s6IGVjcy5GYXJnYXRlVGFza0RlZmluaXRpb247XG4gIHJlYWRvbmx5IGFjY2Vzc1BvaW50OiBlZnMuQWNjZXNzUG9pbnQ7XG59XG5cbmV4cG9ydCBjbGFzcyBFZnNGYXJnYXRlU2l0ZSBleHRlbmRzIGNkay5Db25zdHJ1Y3Qge1xuICByZWFkb25seSB0YXNrOiBlY3MuRmFyZ2F0ZVRhc2tEZWZpbml0aW9uO1xuICByZWFkb25seSBzZXJ2aWNlOiBwYXR0ZXJucy5BcHBsaWNhdGlvbkxvYWRCYWxhbmNlZEZhcmdhdGVTZXJ2aWNlO1xuICBjb25zdHJ1Y3RvcihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEVmc0ZhcmdhdGVTaXRlUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgdGhpcy50YXNrID0gcHJvcHMudGFzaztcblxuICAgIHRoaXMudGFzay5hZGRWb2x1bWUoe1xuICAgICAgbmFtZTogJ2Vmcy1zdG9yYWdlJyxcbiAgICAgIGVmc1ZvbHVtZUNvbmZpZ3VyYXRpb246IHtcbiAgICAgICAgZmlsZVN5c3RlbUlkOiBwcm9wcy5hY2Nlc3NQb2ludC5maWxlU3lzdGVtLmZpbGVTeXN0ZW1JZCxcbiAgICAgICAgYXV0aG9yaXphdGlvbkNvbmZpZzoge1xuICAgICAgICAgIGFjY2Vzc1BvaW50SWQ6IHByb3BzLmFjY2Vzc1BvaW50LmFjY2Vzc1BvaW50SWQsXG4gICAgICAgICAgLy8gaWFtOiAnRU5BQkxFRCcsXG4gICAgICAgIH0sXG4gICAgICAgIHRyYW5zaXRFbmNyeXB0aW9uOiAnRU5BQkxFRCcsXG4gICAgICAgIC8vIHJvb3REaXJlY3Rvcnk6ICcvZGVtby1naXRodWInLFxuICAgICAgfSxcbiAgICB9KTtcblxuICAgIHRoaXMuc2VydmljZSA9IG5ldyBwYXR0ZXJucy5BcHBsaWNhdGlvbkxvYWRCYWxhbmNlZEZhcmdhdGVTZXJ2aWNlKHRoaXMsICdGYXJnYXRlU2VydmljZScsIHtcbiAgICAgIHZwYzogcHJvcHMudnBjLFxuICAgICAgdGFza0RlZmluaXRpb246IHRoaXMudGFzayxcbiAgICAgIHBsYXRmb3JtVmVyc2lvbjogZWNzLkZhcmdhdGVQbGF0Zm9ybVZlcnNpb24uVkVSU0lPTjFfNCxcbiAgICB9KTtcblxuICAgIC8vIHRoaXMuc2VydmljZS5ub2RlLmFkZERlcGVuZGVuY3kocHJvcHMuYWNjZXNzUG9pbnQuZmlsZVN5c3RlbS5tb3VudFRhcmdldHNBdmFpbGFibGUpXG5cbiAgICB0aGlzLnRhc2suYWRkVG9FeGVjdXRpb25Sb2xlUG9saWN5KG5ldyBQb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgYWN0aW9uczogW1xuICAgICAgICAnZWxhc3RpY2ZpbGVzeXN0ZW06Q2xpZW50TW91bnQnLFxuICAgICAgICAnZWxhc3RpY2ZpbGVzeXN0ZW06Q2xpZW50V3JpdGUnLFxuICAgICAgXSxcbiAgICAgIHJlc291cmNlczogW1xuICAgICAgICBjZGsuU3RhY2sub2YodGhpcykuZm9ybWF0QXJuKHtcbiAgICAgICAgICBzZXJ2aWNlOiAnZWxhc3RpY2ZpbGVzeXN0ZW0nLFxuICAgICAgICAgIHJlc291cmNlOiAnZmlsZS1zeXN0ZW0nLFxuICAgICAgICAgIHNlcDogJy8nLFxuICAgICAgICAgIHJlc291cmNlTmFtZTogcHJvcHMuYWNjZXNzUG9pbnQuZmlsZVN5c3RlbS5maWxlU3lzdGVtSWQsXG4gICAgICAgIH0pLFxuICAgICAgXSxcbiAgICB9KSk7XG5cbiAgICAvLyBhbGxvdyBmYXJnYXRlIGluZ3Jlc3MgdG8gdGhlIGVmcyBmaWxlc3lzdGVtXG4gICAgcHJvcHMuYWNjZXNzUG9pbnQuZmlsZVN5c3RlbS5jb25uZWN0aW9ucy5hbGxvd0Zyb20odGhpcy5zZXJ2aWNlLnNlcnZpY2UsIGVjMi5Qb3J0LnRjcCgyMDQ5KSk7XG4gIH1cbn1cbiJdfQ==