import * as ec2 from '@aws-cdk/aws-ec2';
import * as ecs from '@aws-cdk/aws-ecs';
import * as efs from '@aws-cdk/aws-efs';
import * as cdk from '@aws-cdk/core';
import { GithubSecret } from './synced-access-point';
/**
 * @stability stable
 */
export interface EfsFargateTaskProps {
    /**
     * @stability stable
     */
    readonly accessPoint: efs.AccessPoint;
    /**
     * @stability stable
     */
    readonly secret?: GithubSecret;
    /**
     * @stability stable
     */
    readonly syncContainer: ecs.ContainerDefinitionOptions;
    /**
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * EFS mount target in the container.
     *
     * @default /mnt/efsmount
     * @stability stable
     */
    readonly efsMountTarget?: string;
}
/**
 * Represents the AWS Fargate task with EFS and secret manager support.
 *
 * @stability stable
 */
export declare class EfsFargateTask extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly task: ecs.FargateTaskDefinition;
    /**
     * @stability stable
     */
    readonly securityGroup: ec2.SecurityGroup;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: EfsFargateTaskProps);
}
