"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NyanCatDemo = exports.IntegTesting = void 0;
const ec2 = require("@aws-cdk/aws-ec2");
const efs = require("@aws-cdk/aws-efs");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
const stateful_fargate_1 = require("./stateful-fargate");
const synced_access_point_1 = require("./synced-access-point");
class IntegTesting {
    constructor() {
        const app = new core_1.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION,
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new core_1.Stack(app, 'testing-stack', { env });
        const vpc = getOrCreateVpc(stack);
        const fs = new efs.FileSystem(stack, 'Filesystem', {
            vpc,
            removalPolicy: core_1.RemovalPolicy.DESTROY,
        });
        const bucketName = stack.node.tryGetContext('BUCKET_NAME') || 'mock';
        const bucket = aws_s3_1.Bucket.fromBucketName(stack, 'ImportedBucket', bucketName);
        // checkout the public github repo to efs filesystem
        new synced_access_point_1.SyncedAccessPoint(stack, 'GithubSyncedAccessPoint', {
            vpc,
            fileSystem: fs,
            path: '/demo-github',
            createAcl: {
                ownerGid: '1001',
                ownerUid: '1001',
                permissions: '0755',
            },
            posixUser: {
                uid: '1001',
                gid: '1001',
            },
            syncSource: new synced_access_point_1.GithubSyncSource({
                vpc,
                repository: 'https://github.com/pahud/cdk-efs-assets.git',
            }),
        });
        // checkout the private github repo to efs filesystem
        new synced_access_point_1.SyncedAccessPoint(stack, 'GithubSyncedAccessPointPrivate', {
            vpc,
            fileSystem: fs,
            path: '/demo-github-private',
            createAcl: {
                ownerGid: '1001',
                ownerUid: '1001',
                permissions: '0755',
            },
            posixUser: {
                uid: '1001',
                gid: '1001',
            },
            syncSource: new synced_access_point_1.GithubSyncSource({
                vpc,
                repository: 'https://github.com/pahud/private-repo.git',
                secret: {
                    id: 'github',
                    key: 'oauth_token',
                },
            }),
        });
        new synced_access_point_1.SyncedAccessPoint(stack, 'S3SyncedAccessPoint', {
            vpc,
            fileSystem: fs,
            path: '/demo-s3-archive',
            createAcl: {
                ownerGid: '1001',
                ownerUid: '1001',
                permissions: '0755',
            },
            posixUser: {
                uid: '1001',
                gid: '1001',
            },
            syncSource: new synced_access_point_1.S3ArchiveSyncSource({
                vpc,
                bucket,
                zipFilePath: 'folder/foo.zip',
            }),
        });
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
class NyanCatDemo {
    constructor() {
        const app = new core_1.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION,
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new core_1.Stack(app, 'testing-stack', { env });
        const vpc = getOrCreateVpc(stack);
        new stateful_fargate_1.StatefulFargateNginx(stack, 'NyanCat', {
            vpc,
            github: 'https://github.com/cristurm/nyan-cat.git',
        });
        this.stack = [stack];
    }
}
exports.NyanCatDemo = NyanCatDemo;
// run the integ testing
new IntegTesting();
// run Nyan Cat demo
// new NyanCatDemo();
function getOrCreateVpc(scope) {
    // use an existing vpc or create a new one
    return scope.node.tryGetContext('use_default_vpc') === '1' ?
        ec2.Vpc.fromLookup(scope, 'Vpc', { isDefault: true }) :
        scope.node.tryGetContext('use_vpc_id') ?
            ec2.Vpc.fromLookup(scope, 'Vpc', { vpcId: scope.node.tryGetContext('use_vpc_id') }) :
            new ec2.Vpc(scope, 'Vpc', { maxAzs: 3, natGateways: 1 });
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuZGVmYXVsdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9pbnRlZy5kZWZhdWx0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHdDQUF3QztBQUN4Qyx3Q0FBd0M7QUFDeEMsNENBQXlDO0FBQ3pDLHdDQUFxRTtBQUNyRSx5REFBMEQ7QUFDMUQsK0RBQWlHO0FBRWpHLE1BQWEsWUFBWTtJQUd2QjtRQUNFLE1BQU0sR0FBRyxHQUFHLElBQUksVUFBRyxFQUFFLENBQUM7UUFFdEIsTUFBTSxHQUFHLEdBQUc7WUFDVixNQUFNLEVBQUUsT0FBTyxDQUFDLEdBQUcsQ0FBQyxrQkFBa0I7WUFDdEMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxHQUFHLENBQUMsbUJBQW1CO1NBQ3pDLENBQUM7UUFFRixNQUFNLEtBQUssR0FBRyxJQUFJLFlBQUssQ0FBQyxHQUFHLEVBQUUsZUFBZSxFQUFFLEVBQUUsR0FBRyxFQUFFLENBQUMsQ0FBQztRQUV2RCxNQUFNLEdBQUcsR0FBRyxjQUFjLENBQUMsS0FBSyxDQUFDLENBQUM7UUFFbEMsTUFBTSxFQUFFLEdBQUcsSUFBSSxHQUFHLENBQUMsVUFBVSxDQUFDLEtBQUssRUFBRSxZQUFZLEVBQUU7WUFDakQsR0FBRztZQUNILGFBQWEsRUFBRSxvQkFBYSxDQUFDLE9BQU87U0FDckMsQ0FBQyxDQUFDO1FBRUgsTUFBTSxVQUFVLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsYUFBYSxDQUFDLElBQUksTUFBTSxDQUFDO1FBQ3JFLE1BQU0sTUFBTSxHQUFHLGVBQU0sQ0FBQyxjQUFjLENBQUMsS0FBSyxFQUFFLGdCQUFnQixFQUFFLFVBQVUsQ0FBQyxDQUFDO1FBRTFFLG9EQUFvRDtRQUNwRCxJQUFJLHVDQUFpQixDQUFDLEtBQUssRUFBRSx5QkFBeUIsRUFBRTtZQUN0RCxHQUFHO1lBQ0gsVUFBVSxFQUFFLEVBQUU7WUFDZCxJQUFJLEVBQUUsY0FBYztZQUNwQixTQUFTLEVBQUU7Z0JBQ1QsUUFBUSxFQUFFLE1BQU07Z0JBQ2hCLFFBQVEsRUFBRSxNQUFNO2dCQUNoQixXQUFXLEVBQUUsTUFBTTthQUNwQjtZQUNELFNBQVMsRUFBRTtnQkFDVCxHQUFHLEVBQUUsTUFBTTtnQkFDWCxHQUFHLEVBQUUsTUFBTTthQUNaO1lBQ0QsVUFBVSxFQUFFLElBQUksc0NBQWdCLENBQUM7Z0JBQy9CLEdBQUc7Z0JBQ0gsVUFBVSxFQUFFLDZDQUE2QzthQUMxRCxDQUFDO1NBQ0gsQ0FBQyxDQUFDO1FBRUgscURBQXFEO1FBQ3JELElBQUksdUNBQWlCLENBQUMsS0FBSyxFQUFFLGdDQUFnQyxFQUFFO1lBQzdELEdBQUc7WUFDSCxVQUFVLEVBQUUsRUFBRTtZQUNkLElBQUksRUFBRSxzQkFBc0I7WUFDNUIsU0FBUyxFQUFFO2dCQUNULFFBQVEsRUFBRSxNQUFNO2dCQUNoQixRQUFRLEVBQUUsTUFBTTtnQkFDaEIsV0FBVyxFQUFFLE1BQU07YUFDcEI7WUFDRCxTQUFTLEVBQUU7Z0JBQ1QsR0FBRyxFQUFFLE1BQU07Z0JBQ1gsR0FBRyxFQUFFLE1BQU07YUFDWjtZQUNELFVBQVUsRUFBRSxJQUFJLHNDQUFnQixDQUFDO2dCQUMvQixHQUFHO2dCQUNILFVBQVUsRUFBRSwyQ0FBMkM7Z0JBQ3ZELE1BQU0sRUFBRTtvQkFDTixFQUFFLEVBQUUsUUFBUTtvQkFDWixHQUFHLEVBQUUsYUFBYTtpQkFDbkI7YUFDRixDQUFDO1NBQ0gsQ0FBQyxDQUFDO1FBRUgsSUFBSSx1Q0FBaUIsQ0FBQyxLQUFLLEVBQUUscUJBQXFCLEVBQUU7WUFDbEQsR0FBRztZQUNILFVBQVUsRUFBRSxFQUFFO1lBQ2QsSUFBSSxFQUFFLGtCQUFrQjtZQUN4QixTQUFTLEVBQUU7Z0JBQ1QsUUFBUSxFQUFFLE1BQU07Z0JBQ2hCLFFBQVEsRUFBRSxNQUFNO2dCQUNoQixXQUFXLEVBQUUsTUFBTTthQUNwQjtZQUNELFNBQVMsRUFBRTtnQkFDVCxHQUFHLEVBQUUsTUFBTTtnQkFDWCxHQUFHLEVBQUUsTUFBTTthQUNaO1lBQ0QsVUFBVSxFQUFFLElBQUkseUNBQW1CLENBQUM7Z0JBQ2xDLEdBQUc7Z0JBQ0gsTUFBTTtnQkFDTixXQUFXLEVBQUUsZ0JBQWdCO2FBQzlCLENBQUM7U0FDSCxDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsS0FBSyxHQUFHLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDdkIsQ0FBQztDQUNGO0FBekZELG9DQXlGQztBQUdELE1BQWEsV0FBVztJQUV0QjtRQUNFLE1BQU0sR0FBRyxHQUFHLElBQUksVUFBRyxFQUFFLENBQUM7UUFFdEIsTUFBTSxHQUFHLEdBQUc7WUFDVixNQUFNLEVBQUUsT0FBTyxDQUFDLEdBQUcsQ0FBQyxrQkFBa0I7WUFDdEMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxHQUFHLENBQUMsbUJBQW1CO1NBQ3pDLENBQUM7UUFFRixNQUFNLEtBQUssR0FBRyxJQUFJLFlBQUssQ0FBQyxHQUFHLEVBQUUsZUFBZSxFQUFFLEVBQUUsR0FBRyxFQUFFLENBQUMsQ0FBQztRQUV2RCxNQUFNLEdBQUcsR0FBRyxjQUFjLENBQUMsS0FBSyxDQUFDLENBQUM7UUFFbEMsSUFBSSx1Q0FBb0IsQ0FBQyxLQUFLLEVBQUUsU0FBUyxFQUFFO1lBQ3pDLEdBQUc7WUFDSCxNQUFNLEVBQUUsMENBQTBDO1NBQ25ELENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxLQUFLLEdBQUcsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUN2QixDQUFDO0NBQ0Y7QUFyQkQsa0NBcUJDO0FBRUQsd0JBQXdCO0FBQ3hCLElBQUksWUFBWSxFQUFFLENBQUM7QUFFbkIsb0JBQW9CO0FBQ3BCLHFCQUFxQjtBQUdyQixTQUFTLGNBQWMsQ0FBQyxLQUFnQjtJQUN0QywwQ0FBMEM7SUFDMUMsT0FBTyxLQUFLLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEdBQUcsQ0FBQyxDQUFDO1FBQzFELEdBQUcsQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLEtBQUssRUFBRSxLQUFLLEVBQUUsRUFBRSxTQUFTLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQyxDQUFDO1FBQ3ZELEtBQUssQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUM7WUFDdEMsR0FBRyxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsS0FBSyxFQUFFLEtBQUssRUFBRSxFQUFFLEtBQUssRUFBRSxLQUFLLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxZQUFZLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztZQUNyRixJQUFJLEdBQUcsQ0FBQyxHQUFHLENBQUMsS0FBSyxFQUFFLEtBQUssRUFBRSxFQUFFLE1BQU0sRUFBRSxDQUFDLEVBQUUsV0FBVyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUM7QUFDL0QsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGVjMiBmcm9tICdAYXdzLWNkay9hd3MtZWMyJztcbmltcG9ydCAqIGFzIGVmcyBmcm9tICdAYXdzLWNkay9hd3MtZWZzJztcbmltcG9ydCB7IEJ1Y2tldCB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1zMyc7XG5pbXBvcnQgeyBBcHAsIFN0YWNrLCBSZW1vdmFsUG9saWN5LCBDb25zdHJ1Y3QgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IFN0YXRlZnVsRmFyZ2F0ZU5naW54IH0gZnJvbSAnLi9zdGF0ZWZ1bC1mYXJnYXRlJztcbmltcG9ydCB7IFN5bmNlZEFjY2Vzc1BvaW50LCBHaXRodWJTeW5jU291cmNlLCBTM0FyY2hpdmVTeW5jU291cmNlIH0gZnJvbSAnLi9zeW5jZWQtYWNjZXNzLXBvaW50JztcblxuZXhwb3J0IGNsYXNzIEludGVnVGVzdGluZyB7XG4gIHJlYWRvbmx5IHN0YWNrOiBTdGFja1tdO1xuXG4gIGNvbnN0cnVjdG9yKCkge1xuICAgIGNvbnN0IGFwcCA9IG5ldyBBcHAoKTtcblxuICAgIGNvbnN0IGVudiA9IHtcbiAgICAgIHJlZ2lvbjogcHJvY2Vzcy5lbnYuQ0RLX0RFRkFVTFRfUkVHSU9OLFxuICAgICAgYWNjb3VudDogcHJvY2Vzcy5lbnYuQ0RLX0RFRkFVTFRfQUNDT1VOVCxcbiAgICB9O1xuXG4gICAgY29uc3Qgc3RhY2sgPSBuZXcgU3RhY2soYXBwLCAndGVzdGluZy1zdGFjaycsIHsgZW52IH0pO1xuXG4gICAgY29uc3QgdnBjID0gZ2V0T3JDcmVhdGVWcGMoc3RhY2spO1xuXG4gICAgY29uc3QgZnMgPSBuZXcgZWZzLkZpbGVTeXN0ZW0oc3RhY2ssICdGaWxlc3lzdGVtJywge1xuICAgICAgdnBjLFxuICAgICAgcmVtb3ZhbFBvbGljeTogUmVtb3ZhbFBvbGljeS5ERVNUUk9ZLFxuICAgIH0pO1xuXG4gICAgY29uc3QgYnVja2V0TmFtZSA9IHN0YWNrLm5vZGUudHJ5R2V0Q29udGV4dCgnQlVDS0VUX05BTUUnKSB8fCAnbW9jayc7XG4gICAgY29uc3QgYnVja2V0ID0gQnVja2V0LmZyb21CdWNrZXROYW1lKHN0YWNrLCAnSW1wb3J0ZWRCdWNrZXQnLCBidWNrZXROYW1lKTtcblxuICAgIC8vIGNoZWNrb3V0IHRoZSBwdWJsaWMgZ2l0aHViIHJlcG8gdG8gZWZzIGZpbGVzeXN0ZW1cbiAgICBuZXcgU3luY2VkQWNjZXNzUG9pbnQoc3RhY2ssICdHaXRodWJTeW5jZWRBY2Nlc3NQb2ludCcsIHtcbiAgICAgIHZwYyxcbiAgICAgIGZpbGVTeXN0ZW06IGZzLFxuICAgICAgcGF0aDogJy9kZW1vLWdpdGh1YicsXG4gICAgICBjcmVhdGVBY2w6IHtcbiAgICAgICAgb3duZXJHaWQ6ICcxMDAxJyxcbiAgICAgICAgb3duZXJVaWQ6ICcxMDAxJyxcbiAgICAgICAgcGVybWlzc2lvbnM6ICcwNzU1JyxcbiAgICAgIH0sXG4gICAgICBwb3NpeFVzZXI6IHtcbiAgICAgICAgdWlkOiAnMTAwMScsXG4gICAgICAgIGdpZDogJzEwMDEnLFxuICAgICAgfSxcbiAgICAgIHN5bmNTb3VyY2U6IG5ldyBHaXRodWJTeW5jU291cmNlKHtcbiAgICAgICAgdnBjLFxuICAgICAgICByZXBvc2l0b3J5OiAnaHR0cHM6Ly9naXRodWIuY29tL3BhaHVkL2Nkay1lZnMtYXNzZXRzLmdpdCcsXG4gICAgICB9KSxcbiAgICB9KTtcblxuICAgIC8vIGNoZWNrb3V0IHRoZSBwcml2YXRlIGdpdGh1YiByZXBvIHRvIGVmcyBmaWxlc3lzdGVtXG4gICAgbmV3IFN5bmNlZEFjY2Vzc1BvaW50KHN0YWNrLCAnR2l0aHViU3luY2VkQWNjZXNzUG9pbnRQcml2YXRlJywge1xuICAgICAgdnBjLFxuICAgICAgZmlsZVN5c3RlbTogZnMsXG4gICAgICBwYXRoOiAnL2RlbW8tZ2l0aHViLXByaXZhdGUnLFxuICAgICAgY3JlYXRlQWNsOiB7XG4gICAgICAgIG93bmVyR2lkOiAnMTAwMScsXG4gICAgICAgIG93bmVyVWlkOiAnMTAwMScsXG4gICAgICAgIHBlcm1pc3Npb25zOiAnMDc1NScsXG4gICAgICB9LFxuICAgICAgcG9zaXhVc2VyOiB7XG4gICAgICAgIHVpZDogJzEwMDEnLFxuICAgICAgICBnaWQ6ICcxMDAxJyxcbiAgICAgIH0sXG4gICAgICBzeW5jU291cmNlOiBuZXcgR2l0aHViU3luY1NvdXJjZSh7XG4gICAgICAgIHZwYyxcbiAgICAgICAgcmVwb3NpdG9yeTogJ2h0dHBzOi8vZ2l0aHViLmNvbS9wYWh1ZC9wcml2YXRlLXJlcG8uZ2l0JyxcbiAgICAgICAgc2VjcmV0OiB7XG4gICAgICAgICAgaWQ6ICdnaXRodWInLFxuICAgICAgICAgIGtleTogJ29hdXRoX3Rva2VuJyxcbiAgICAgICAgfSxcbiAgICAgIH0pLFxuICAgIH0pO1xuXG4gICAgbmV3IFN5bmNlZEFjY2Vzc1BvaW50KHN0YWNrLCAnUzNTeW5jZWRBY2Nlc3NQb2ludCcsIHtcbiAgICAgIHZwYyxcbiAgICAgIGZpbGVTeXN0ZW06IGZzLFxuICAgICAgcGF0aDogJy9kZW1vLXMzLWFyY2hpdmUnLFxuICAgICAgY3JlYXRlQWNsOiB7XG4gICAgICAgIG93bmVyR2lkOiAnMTAwMScsXG4gICAgICAgIG93bmVyVWlkOiAnMTAwMScsXG4gICAgICAgIHBlcm1pc3Npb25zOiAnMDc1NScsXG4gICAgICB9LFxuICAgICAgcG9zaXhVc2VyOiB7XG4gICAgICAgIHVpZDogJzEwMDEnLFxuICAgICAgICBnaWQ6ICcxMDAxJyxcbiAgICAgIH0sXG4gICAgICBzeW5jU291cmNlOiBuZXcgUzNBcmNoaXZlU3luY1NvdXJjZSh7XG4gICAgICAgIHZwYyxcbiAgICAgICAgYnVja2V0LFxuICAgICAgICB6aXBGaWxlUGF0aDogJ2ZvbGRlci9mb28uemlwJyxcbiAgICAgIH0pLFxuICAgIH0pO1xuXG4gICAgdGhpcy5zdGFjayA9IFtzdGFja107XG4gIH1cbn1cblxuXG5leHBvcnQgY2xhc3MgTnlhbkNhdERlbW8ge1xuICByZWFkb25seSBzdGFjazogU3RhY2tbXTtcbiAgY29uc3RydWN0b3IoKSB7XG4gICAgY29uc3QgYXBwID0gbmV3IEFwcCgpO1xuXG4gICAgY29uc3QgZW52ID0ge1xuICAgICAgcmVnaW9uOiBwcm9jZXNzLmVudi5DREtfREVGQVVMVF9SRUdJT04sXG4gICAgICBhY2NvdW50OiBwcm9jZXNzLmVudi5DREtfREVGQVVMVF9BQ0NPVU5ULFxuICAgIH07XG5cbiAgICBjb25zdCBzdGFjayA9IG5ldyBTdGFjayhhcHAsICd0ZXN0aW5nLXN0YWNrJywgeyBlbnYgfSk7XG5cbiAgICBjb25zdCB2cGMgPSBnZXRPckNyZWF0ZVZwYyhzdGFjayk7XG5cbiAgICBuZXcgU3RhdGVmdWxGYXJnYXRlTmdpbngoc3RhY2ssICdOeWFuQ2F0Jywge1xuICAgICAgdnBjLFxuICAgICAgZ2l0aHViOiAnaHR0cHM6Ly9naXRodWIuY29tL2NyaXN0dXJtL255YW4tY2F0LmdpdCcsXG4gICAgfSk7XG5cbiAgICB0aGlzLnN0YWNrID0gW3N0YWNrXTtcbiAgfVxufVxuXG4vLyBydW4gdGhlIGludGVnIHRlc3Rpbmdcbm5ldyBJbnRlZ1Rlc3RpbmcoKTtcblxuLy8gcnVuIE55YW4gQ2F0IGRlbW9cbi8vIG5ldyBOeWFuQ2F0RGVtbygpO1xuXG5cbmZ1bmN0aW9uIGdldE9yQ3JlYXRlVnBjKHNjb3BlOiBDb25zdHJ1Y3QpOiBlYzIuSVZwYyB7XG4gIC8vIHVzZSBhbiBleGlzdGluZyB2cGMgb3IgY3JlYXRlIGEgbmV3IG9uZVxuICByZXR1cm4gc2NvcGUubm9kZS50cnlHZXRDb250ZXh0KCd1c2VfZGVmYXVsdF92cGMnKSA9PT0gJzEnID9cbiAgICBlYzIuVnBjLmZyb21Mb29rdXAoc2NvcGUsICdWcGMnLCB7IGlzRGVmYXVsdDogdHJ1ZSB9KSA6XG4gICAgc2NvcGUubm9kZS50cnlHZXRDb250ZXh0KCd1c2VfdnBjX2lkJykgP1xuICAgICAgZWMyLlZwYy5mcm9tTG9va3VwKHNjb3BlLCAnVnBjJywgeyB2cGNJZDogc2NvcGUubm9kZS50cnlHZXRDb250ZXh0KCd1c2VfdnBjX2lkJykgfSkgOlxuICAgICAgbmV3IGVjMi5WcGMoc2NvcGUsICdWcGMnLCB7IG1heEF6czogMywgbmF0R2F0ZXdheXM6IDEgfSk7XG59XG4iXX0=