import * as ec2 from '@aws-cdk/aws-ec2';
import * as efs from '@aws-cdk/aws-efs';
import { Construct } from '@aws-cdk/core';
import { SyncedAccessPoint } from './synced-access-point';
/**
 * @stability stable
 */
export interface StatefulFargateNginxProps {
    /**
     * The VPC for the fargate service.
     *
     * @default - create a new VPC
     * @stability stable
     */
    readonly vpc?: ec2.IVpc;
    /**
     * The github repository to clone as the doc root of the nginx.
     *
     * @default https://github.com/cristurm/nyan-cat.git
     * @stability stable
     */
    readonly github?: string;
    /**
     * The EFS FilesSystem as the stateful shared storage of the Fargate service.
     *
     * @default - create a new EFS FileSystem
     * @stability stable
     */
    readonly efsFileSystem?: efs.IFileSystem;
}
/**
 * @stability stable
 */
export declare class StatefulFargateNginx extends Construct {
    private props;
    private vpc;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: StatefulFargateNginxProps);
    private _createVpc;
    private _createEfsFileSystem;
    /**
     * @stability stable
     */
    createSyncedAccessPoint(): SyncedAccessPoint;
}
