"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StatefulFargateNginx = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const ecs = require("@aws-cdk/aws-ecs");
const efs = require("@aws-cdk/aws-efs");
const core_1 = require("@aws-cdk/core");
const efs_fargate_site_1 = require("./efs-fargate-site");
const synced_access_point_1 = require("./synced-access-point");
/**
 * @stability stable
 */
class StatefulFargateNginx extends core_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        this.props = props;
        this.vpc = (_b = this.props.vpc) !== null && _b !== void 0 ? _b : this._createVpc();
        const staticSiteTask = new ecs.FargateTaskDefinition(this, 'FargateStaticSiteTask', {
            cpu: 256,
            memoryLimitMiB: 512,
        });
        const nginx = staticSiteTask.addContainer('nginx', {
            image: ecs.ContainerImage.fromRegistry('public.ecr.aws/nginx/nginx:latest'),
            logging: new ecs.AwsLogDriver({ streamPrefix: 'nginx' }),
        });
        nginx.addPortMappings({ containerPort: 80 });
        nginx.addMountPoints({
            containerPath: '/usr/share/nginx/html',
            sourceVolume: 'efs-storage',
            readOnly: true,
        });
        new efs_fargate_site_1.EfsFargateSite(this, 'StatefulSite', {
            vpc: this.vpc,
            accessPoint: this.createSyncedAccessPoint(),
            task: staticSiteTask,
        });
    }
    _createVpc() {
        return new ec2.Vpc(this, 'Vpc', { maxAzs: 3, natGateways: 1 });
    }
    ;
    _createEfsFileSystem() {
        return new efs.FileSystem(this, 'Filesystem', {
            vpc: this.vpc,
            removalPolicy: core_1.RemovalPolicy.DESTROY,
        });
    }
    /**
     * @stability stable
     */
    createSyncedAccessPoint() {
        var _b, _c;
        const efsSyncedAccessPoint = new synced_access_point_1.SyncedAccessPoint(this, 'GithubSyncedAccessPoint', {
            vpc: this.vpc,
            fileSystem: (_b = this.props.efsFileSystem) !== null && _b !== void 0 ? _b : this._createEfsFileSystem(),
            path: '/demo-github',
            createAcl: {
                ownerGid: '1001',
                ownerUid: '1001',
                permissions: '0755',
            },
            posixUser: {
                uid: '1001',
                gid: '1001',
            },
            syncSource: new synced_access_point_1.GithubSyncSource({
                vpc: this.vpc,
                repository: (_c = this.props.github) !== null && _c !== void 0 ? _c : 'https://github.com/cristurm/nyan-cat.git',
                syncDirectoryPath: '/',
            }),
        });
        return efsSyncedAccessPoint;
    }
}
exports.StatefulFargateNginx = StatefulFargateNginx;
_a = JSII_RTTI_SYMBOL_1;
StatefulFargateNginx[_a] = { fqn: "cdk-efs-assets.StatefulFargateNginx", version: "0.3.93" };
//# sourceMappingURL=data:application/json;base64,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