import { aws_route53 as route53 } from 'aws-cdk-lib';
export interface LoadBalancerTargetAttributes {
    /**
     * The DNS name of the load balancer.
     */
    readonly dnsName: string;
    /**
     * The hosted zone ID of the load balancer.
     */
    readonly hostedZoneId: string;
}
export declare class LoadBalancerTargetFromAttributes implements route53.IAliasRecordTarget {
    private readonly loadBalancerTargetAttributes;
    constructor(loadBalancerTargetAttributes: LoadBalancerTargetAttributes);
    bind(_record: route53.IRecordSet, _zone?: route53.IHostedZone): route53.AliasRecordTargetConfig;
}
